/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.command;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.core.command.Command;
import org.jetlinks.core.command.CommandConstant;
import org.jetlinks.core.metadata.FunctionMetadata;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CommandUtils {
    private static final Map<Class<?>, ResolvableType> commandResponseType = new ConcurrentHashMap();

    public static String getCommandIdByType(Class<?> commandType) {
        String id = commandType.getSimpleName();
        if (id.endsWith("Command")) {
            id = id.substring(0, id.length() - 7);
        }
        return id;
    }

    public static Flux<Object> convertResponseToFlux(Object response) {
        if (response instanceof Publisher) {
            return Flux.from((Publisher)((Publisher)response));
        }
        return response == null ? Flux.empty() : Flux.just((Object)response);
    }

    public static Flux<Object> convertResponseToFlux(Object response, Command<?> cmd) {
        if (response instanceof Publisher) {
            return Flux.from((Publisher)((Publisher)response)).mapNotNull(cmd::createResponseData);
        }
        return response == null ? Flux.empty() : Flux.just((Object)cmd.createResponseData(response));
    }

    public static Mono<Object> convertResponseToMono(Object response) {
        if (response instanceof Mono) {
            return (Mono)response;
        }
        if (response instanceof Publisher) {
            return Flux.from((Publisher)((Publisher)response)).collectList();
        }
        return Mono.justOrEmpty((Object)response);
    }

    public static Mono<Object> convertResponseToMono(Object response, Command<?> cmd) {
        if (response instanceof Mono) {
            return ((Mono)response).map(cmd::createResponseData);
        }
        if (response instanceof Publisher) {
            return Flux.from((Publisher)((Publisher)response)).map(cmd::createResponseData).collectList();
        }
        return Mono.justOrEmpty((Object)cmd.createResponseData(response));
    }

    public static ResolvableType getCommandResponseType(Class<?> cmd) {
        return commandResponseType.computeIfAbsent(cmd, clazz -> ResolvableType.forClass(Command.class, (Class)clazz).getGeneric(new int[]{0}));
    }

    public static ResolvableType getCommandResponseDataType(Class<?> cmd) {
        return CommandUtils.getCommandResponseDataType(CommandUtils.getCommandResponseType(cmd));
    }

    public static ResolvableType getCommandResponseDataType(ResolvableType type) {
        Class typeClazz = type.toClass();
        if (Publisher.class.isAssignableFrom(typeClazz) || Collection.class.isAssignableFrom(typeClazz)) {
            return type.getGeneric(new int[]{0});
        }
        return type;
    }

    public static ResolvableType getCommandResponseType(Command<?> cmd) {
        return CommandUtils.getCommandResponseType(cmd.getClass());
    }

    public static ResolvableType getCommandResponseDataType(Command<?> cmd) {
        return CommandUtils.getCommandResponseDataType(cmd.getClass());
    }

    public static <T> Function<Object, T> createConverter(ResolvableType type) {
        if (type.isAssignableFrom(Void.class)) {
            return val -> val;
        }
        return value -> CommandUtils.convertData(type, value);
    }

    public static Object convertData(ResolvableType type, Object value) {
        Class[] genClazz;
        if (type.isInstance(value) || value == null || type.toClass() == Void.class) {
            return value;
        }
        ResolvableType[] genType = type.getGenerics();
        if (genType.length == 0) {
            genClazz = FastBeanCopier.EMPTY_CLASS_ARRAY;
        } else {
            genClazz = new Class[genType.length];
            for (int i = 0; i < genType.length; ++i) {
                genClazz[i] = genType[i].toClass();
            }
        }
        return FastBeanCopier.DEFAULT_CONVERT.convert(value, type.toClass(), genClazz);
    }

    public static boolean commandResponsePublisher(Command<?> command) {
        return Publisher.class.isAssignableFrom(CommandUtils.getCommandResponseType(command).toClass());
    }

    public static boolean commandResponseFlux(Command<?> command) {
        return Flux.class.isAssignableFrom(CommandUtils.getCommandResponseType(command).toClass());
    }

    public static boolean commandResponseMono(Command<?> command) {
        return Mono.class.isAssignableFrom(CommandUtils.getCommandResponseType(command).toClass());
    }

    public static FunctionMetadata wrapMetadata(Command<?> command, FunctionMetadata metadata) {
        if (metadata.getExpand(CommandConstant.responseFlux).isPresent()) {
            return metadata;
        }
        return metadata.expand(CommandConstant.responseFlux, (Object)CommandUtils.commandResponseFlux(command));
    }
}

