/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.command;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.jetlinks.core.command.Command;
import org.jetlinks.core.command.CommandSupport;
import org.jetlinks.core.command.LambdaCommandHandler;
import org.jetlinks.core.metadata.FunctionMetadata;
import reactor.core.publisher.Mono;

public interface CommandHandler<C extends Command<Response>, Response> {
    public Response handle(@Nonnull C var1, @Nonnull CommandSupport var2);

    @Nonnull
    public C createCommand();

    public FunctionMetadata getMetadata();

    default public Mono<FunctionMetadata> getMetadata(Command<?> cmd) {
        return Mono.just((Object)this.getMetadata());
    }

    public static <R, C extends Command<R>> CommandHandler<C, R> of(FunctionMetadata metadata, BiFunction<C, CommandSupport, R> executor, Supplier<C> commandBuilder) {
        return CommandHandler.of(() -> metadata, executor, commandBuilder);
    }

    public static <R, C extends Command<R>> CommandHandler<C, R> of(Supplier<FunctionMetadata> metadata, BiFunction<C, CommandSupport, R> executor, Supplier<C> commandBuilder) {
        return new LambdaCommandHandler<C, R>(metadata, executor, commandBuilder);
    }
}

