/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.codec.defaults;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetlinks.core.Payload;
import org.jetlinks.core.codec.Codec;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.MessageType;

public class DeviceMessageCodec
implements Codec<Message> {
    public static DeviceMessageCodec INSTANCE = new DeviceMessageCodec();

    @Override
    public Class<Message> forType() {
        return Message.class;
    }

    @Override
    @Nullable
    public Message decode(@Nonnull Payload payload) {
        JSONObject json = JSON.parseObject((String)payload.bodyToString(false));
        return (Message)MessageType.convertMessage((Map<String, Object>)json).orElseThrow(() -> new UnsupportedOperationException("unsupported message : " + json));
    }

    @Override
    public Payload encode(Message body) {
        return Payload.of(JSON.toJSONBytes((Object)body.toJson(), (SerializerFeature[])new SerializerFeature[0]));
    }

    private DeviceMessageCodec() {
    }
}

