/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.codec.defaults;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetlinks.core.Payload;
import org.jetlinks.core.codec.Codec;
import org.jetlinks.core.codec.CodecsSupport;
import org.jetlinks.core.codec.defaults.BooleanCodec;
import org.jetlinks.core.codec.defaults.ByteBufCodec;
import org.jetlinks.core.codec.defaults.ByteCodec;
import org.jetlinks.core.codec.defaults.BytesCodec;
import org.jetlinks.core.codec.defaults.DeviceMessageCodec;
import org.jetlinks.core.codec.defaults.DirectCodec;
import org.jetlinks.core.codec.defaults.DoubleCodec;
import org.jetlinks.core.codec.defaults.EnumCodec;
import org.jetlinks.core.codec.defaults.FastJsonArrayCodec;
import org.jetlinks.core.codec.defaults.FastJsonCodec;
import org.jetlinks.core.codec.defaults.FloatCodec;
import org.jetlinks.core.codec.defaults.IntegerCodec;
import org.jetlinks.core.codec.defaults.JsonArrayCodec;
import org.jetlinks.core.codec.defaults.JsonCodec;
import org.jetlinks.core.codec.defaults.LongCodec;
import org.jetlinks.core.codec.defaults.MessageCodec;
import org.jetlinks.core.codec.defaults.StringCodec;
import org.jetlinks.core.codec.defaults.SubscriptionCodec;
import org.jetlinks.core.codec.defaults.ThingPropertyCodec;
import org.jetlinks.core.codec.defaults.TopicPayloadCodec;
import org.jetlinks.core.codec.defaults.VoidCodec;
import org.jetlinks.core.event.Subscription;
import org.jetlinks.core.event.TopicPayload;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.things.ThingProperty;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;

public class DefaultCodecsSupport
implements CodecsSupport {
    private static Map<Class, Codec> staticCodec = new HashMap<Class, Codec>();

    @Override
    public <T> Optional<Codec<T>> lookup(ResolvableType type) {
        Class refType;
        Codec codec;
        ResolvableType ref = type;
        if (Publisher.class.isAssignableFrom(ref.toClass())) {
            ref = ref.getGeneric(new int[]{0});
        }
        if ((codec = staticCodec.get(refType = ref.toClass())) == null) {
            if (List.class.isAssignableFrom(refType)) {
                codec = JsonArrayCodec.of(ref.getGeneric(new int[]{0}).toClass());
            } else if (ref.toClass().isEnum()) {
                codec = EnumCodec.of((Enum[])((Enum[])ref.toClass().getEnumConstants()));
            } else if (Payload.class.isAssignableFrom(refType)) {
                codec = DirectCodec.INSTANCE;
            } else if (Set.class.isAssignableFrom(ref.toClass())) {
                codec = JsonArrayCodec.of(ref.getGeneric(new int[]{0}).toClass(), HashSet.class, HashSet::new);
            } else if (ByteBuf.class.isAssignableFrom(refType)) {
                codec = ByteBufCodec.INSTANCE;
            } else if (Message.class.isAssignableFrom(refType)) {
                codec = MessageCodec.INSTANCE;
            }
        }
        if (codec != null) {
            return Optional.of(codec);
        }
        if (refType.isInterface()) {
            return Optional.empty();
        }
        if (codec == null) {
            codec = JsonCodec.of(refType);
        }
        return Optional.of(codec);
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    static {
        staticCodec.put(Byte.TYPE, ByteCodec.INSTANCE);
        staticCodec.put(Byte.class, ByteCodec.INSTANCE);
        staticCodec.put(Integer.TYPE, IntegerCodec.INSTANCE);
        staticCodec.put(Integer.class, IntegerCodec.INSTANCE);
        staticCodec.put(Long.TYPE, LongCodec.INSTANCE);
        staticCodec.put(Long.class, LongCodec.INSTANCE);
        staticCodec.put(Double.TYPE, DoubleCodec.INSTANCE);
        staticCodec.put(Double.class, DoubleCodec.INSTANCE);
        staticCodec.put(Float.TYPE, FloatCodec.INSTANCE);
        staticCodec.put(Float.class, FloatCodec.INSTANCE);
        staticCodec.put(Boolean.TYPE, BooleanCodec.INSTANCE);
        staticCodec.put(Boolean.class, BooleanCodec.INSTANCE);
        staticCodec.put(String.class, StringCodec.UTF8);
        staticCodec.put(byte[].class, BytesCodec.INSTANCE);
        staticCodec.put(Void.class, VoidCodec.INSTANCE);
        staticCodec.put(Void.TYPE, VoidCodec.INSTANCE);
        staticCodec.put(DeviceMessage.class, DeviceMessageCodec.INSTANCE);
        staticCodec.put(Message.class, MessageCodec.INSTANCE);
        JsonCodec<Map> codec = JsonCodec.of(Map.class);
        staticCodec.put(Map.class, codec);
        staticCodec.put(HashMap.class, codec);
        staticCodec.put(LinkedHashMap.class, codec);
        staticCodec.put(TopicPayload.class, TopicPayloadCodec.INSTANCE);
        staticCodec.put(Subscription.class, SubscriptionCodec.INSTANCE);
        staticCodec.put(ByteBuf.class, ByteBufCodec.INSTANCE);
        staticCodec.put(JSONObject.class, FastJsonCodec.INSTANCE);
        staticCodec.put(JSONArray.class, FastJsonArrayCodec.INSTANCE);
        staticCodec.put(ThingProperty.class, ThingPropertyCodec.INSTANCE);
    }
}

