/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core;

import com.google.common.collect.Collections2;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.NonNull;
import org.jetlinks.core.Value;
import org.jetlinks.core.Values;
import org.jetlinks.core.utils.CompositeMap;
import org.jetlinks.core.utils.ConverterUtils;

class SimpleValues
implements Values {
    @NonNull
    private final Map<String, Object> values;

    @Override
    public Map<String, Object> getAllValues() {
        return this.values instanceof CompositeMap ? this.values : Collections.unmodifiableMap(this.values);
    }

    @Override
    public Optional<Value> getValue(String key) {
        if (key == null) {
            return Optional.empty();
        }
        Object value = this.values.get(key);
        if (null == value) {
            return Optional.empty();
        }
        return Optional.of(Value.simple(value));
    }

    @Override
    public Values merge(Values source) {
        Map<String, Object> sourceValues = source instanceof SimpleValues ? ((SimpleValues)source).values : source.getAllValues();
        CompositeMap<String, Object> values = new CompositeMap<String, Object>(sourceValues, this.values);
        return Values.of(values);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean isNoEmpty() {
        return !this.values.isEmpty();
    }

    @Override
    public Collection<String> getNonExistentKeys(Collection<String> keys) {
        return Collections2.filter(keys, key -> !this.values.containsKey(key));
    }

    @Override
    public String getString(String key, Supplier<String> defaultValue) {
        Object val = this.values.get(key);
        if (val == null) {
            return defaultValue.get();
        }
        return String.valueOf(val);
    }

    @Override
    public Number getNumber(String key, Supplier<Number> defaultValue) {
        Object val = this.values.get(key);
        if (val == null) {
            return defaultValue.get();
        }
        if (val instanceof Number) {
            return (Number)val;
        }
        if (val instanceof Date) {
            return ((Date)val).getTime();
        }
        return (Number)ConverterUtils.convert(val, BigDecimal.class);
    }

    public String toString() {
        return String.valueOf(this.values);
    }

    private SimpleValues(@NonNull Map<String, Object> values) {
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        this.values = values;
    }

    public static SimpleValues of(@NonNull Map<String, Object> values) {
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return new SimpleValues(values);
    }
}

