/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.acroform.signature;

import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.acroform.SignatureDictionary;
import org.icepdf.core.pobjects.acroform.SignatureFieldDictionary;
import org.icepdf.core.pobjects.acroform.signature.Pkcs1Validator;
import org.icepdf.core.pobjects.acroform.signature.Pkcs7Validator;
import org.icepdf.core.pobjects.acroform.signature.SignatureSigner;
import org.icepdf.core.pobjects.acroform.signature.SignatureValidator;
import org.icepdf.core.pobjects.acroform.signature.exceptions.SignatureIntegrityException;

public class DigitalSignatureFactory {
    public static final Name DSS_SUB_FILTER_PKCS7_DETACHED = new Name("adbe.pkcs7.detached");
    public static final Name DSS_SUB_FILTER_PKCS7_SHA1 = new Name("adbe.pkcs7.sha1");
    public static final Name DSS_SUB_FILTER_PKCS7__SHA1 = new Name("adbe.x509.rsa_sha1");
    public static final Name DSS_SUB_FILTER_RSA_SHA1 = new Name("adbe.x509.rsa.sha1");
    private static DigitalSignatureFactory digitalSignatureFactory;

    private DigitalSignatureFactory() {
    }

    public static DigitalSignatureFactory getInstance() {
        if (digitalSignatureFactory == null) {
            digitalSignatureFactory = new DigitalSignatureFactory();
        }
        return digitalSignatureFactory;
    }

    public SignatureSigner getSignerInstance(SignatureFieldDictionary signatureFieldDictionary) {
        return null;
    }

    public SignatureValidator getValidatorInstance(SignatureFieldDictionary signatureFieldDictionary) throws SignatureIntegrityException {
        SignatureDictionary signatureDictionary = signatureFieldDictionary.getSignatureDictionary();
        if (signatureDictionary.getSubFilter().equals(DSS_SUB_FILTER_PKCS7_DETACHED) || signatureDictionary.getSubFilter().equals(DSS_SUB_FILTER_PKCS7_SHA1)) {
            return new Pkcs7Validator(signatureFieldDictionary);
        }
        if (signatureDictionary.getSubFilter().equals(DSS_SUB_FILTER_RSA_SHA1) || signatureDictionary.getSubFilter().equals(DSS_SUB_FILTER_PKCS7__SHA1)) {
            return new Pkcs1Validator(signatureFieldDictionary);
        }
        return null;
    }
}

