/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.datasource.service;

import java.sql.SQLException;
import java.util.concurrent.CountDownLatch;
import javax.sql.DataSource;
import org.hswebframework.web.datasource.DynamicDataSource;
import org.hswebframework.web.datasource.DynamicDataSourceProxy;
import org.hswebframework.web.datasource.config.DynamicDataSourceConfigRepository;
import org.hswebframework.web.datasource.config.InSpringDynamicDataSourceConfig;
import org.hswebframework.web.datasource.service.AbstractDynamicDataSourceService;
import org.hswebframework.web.datasource.service.DataSourceCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class InSpringContextDynamicDataSourceService
extends AbstractDynamicDataSourceService<InSpringDynamicDataSourceConfig> {
    private ApplicationContext applicationContext;

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public InSpringContextDynamicDataSourceService(DynamicDataSourceConfigRepository<InSpringDynamicDataSourceConfig> repository, DynamicDataSource defaultDataSource) {
        super(repository, defaultDataSource);
    }

    public InSpringContextDynamicDataSourceService(DynamicDataSourceConfigRepository<InSpringDynamicDataSourceConfig> repository, DataSource dataSource) throws SQLException {
        super(repository, dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DataSourceCache createCache(InSpringDynamicDataSourceConfig config) {
        DataSource dataSource = (DataSource)this.applicationContext.getBean(config.getBeanName(), DataSource.class);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        try {
            DataSourceCache dataSourceCache = new DataSourceCache(config.hashCode(), new DynamicDataSourceProxy(config.getId(), dataSource), countDownLatch, config);
            return dataSourceCache;
        }
        finally {
            countDownLatch.countDown();
        }
    }
}

