/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.datasource.service;

import java.util.concurrent.CountDownLatch;
import org.hswebframework.web.datasource.DynamicDataSource;
import org.hswebframework.web.datasource.config.DynamicDataSourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceCache {
    private static final Logger log = LoggerFactory.getLogger(DataSourceCache.class);
    private long hash;
    private volatile boolean closed;
    private DynamicDataSource dataSource;
    private volatile CountDownLatch initLatch;
    private DynamicDataSourceConfig config;

    public long getHash() {
        return this.hash;
    }

    public DynamicDataSource getDataSource() {
        if (this.initLatch != null) {
            try {
                this.initLatch.await();
            }
            catch (Exception ignored) {
                log.warn(ignored.getMessage(), (Throwable)ignored);
            }
            finally {
                this.initLatch = null;
            }
        }
        return this.dataSource;
    }

    public DataSourceCache(long hash, DynamicDataSource dataSource, CountDownLatch initLatch, DynamicDataSourceConfig config) {
        this.hash = hash;
        this.dataSource = dataSource;
        this.initLatch = initLatch;
        this.config = config;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void closeDataSource() {
        this.closed = true;
    }

    public DynamicDataSourceConfig getConfig() {
        return this.config;
    }
}

