/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.datasource.service;

import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import org.hswebframework.web.datasource.DynamicDataSource;
import org.hswebframework.web.datasource.DynamicDataSourceProxy;
import org.hswebframework.web.datasource.DynamicDataSourceService;
import org.hswebframework.web.datasource.config.DynamicDataSourceConfig;
import org.hswebframework.web.datasource.config.DynamicDataSourceConfigRepository;
import org.hswebframework.web.datasource.exception.DataSourceNotFoundException;
import org.hswebframework.web.datasource.service.DataSourceCache;

public abstract class AbstractDynamicDataSourceService<C extends DynamicDataSourceConfig>
implements DynamicDataSourceService {
    protected final Map<String, DataSourceCache> dataSourceStore = new ConcurrentHashMap<String, DataSourceCache>(32);
    private final DynamicDataSource defaultDataSource;
    private DynamicDataSourceConfigRepository<C> repository;

    public void setRepository(DynamicDataSourceConfigRepository<C> repository) {
        this.repository = repository;
    }

    public AbstractDynamicDataSourceService(DynamicDataSourceConfigRepository<C> repository, DynamicDataSource defaultDataSource) {
        this.defaultDataSource = defaultDataSource;
        this.repository = repository;
    }

    public AbstractDynamicDataSourceService(DynamicDataSourceConfigRepository<C> repository, DataSource dataSource) throws SQLException {
        this(repository, new DynamicDataSourceProxy(null, dataSource));
    }

    @PreDestroy
    public void destroy() {
        this.dataSourceStore.values().forEach(DataSourceCache::closeDataSource);
    }

    @Override
    public DynamicDataSource getDataSource(String dataSourceId) {
        C config = this.repository.findById(dataSourceId);
        if (config == null) {
            throw new DataSourceNotFoundException(dataSourceId, "\u6570\u636e\u6e90" + dataSourceId + "\u4e0d\u5b58\u5728");
        }
        DataSourceCache cache = this.dataSourceStore.get(dataSourceId);
        if (cache == null) {
            cache = this.createCache(config);
            this.dataSourceStore.put(dataSourceId, cache);
            return cache.getDataSource();
        }
        if (cache.getHash() != (long)((DynamicDataSourceConfig)config).hashCode()) {
            this.dataSourceStore.remove(dataSourceId);
            cache.closeDataSource();
            return this.getDataSource(dataSourceId);
        }
        return cache.getDataSource();
    }

    @Override
    public DynamicDataSource getDefaultDataSource() {
        return this.defaultDataSource;
    }

    @Deprecated
    protected int getHash(String id) {
        return -1;
    }

    protected abstract DataSourceCache createCache(C var1);

    @Deprecated
    protected DataSourceCache createCache(String id) {
        return null;
    }

    public DataSourceCache removeCache(String id) {
        return this.dataSourceStore.remove(id);
    }
}

