/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.datasource;

import java.sql.Connection;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import org.hswebframework.web.datasource.DatabaseType;
import org.hswebframework.web.datasource.DynamicDataSource;

public class DynamicDataSourceProxy
implements DynamicDataSource {
    private String id;
    private volatile DatabaseType databaseType;
    private DataSource proxy;
    private Lock lock = new ReentrantLock();

    public DynamicDataSourceProxy(String id, DatabaseType databaseType, DataSource proxy) {
        this.id = id;
        this.databaseType = databaseType;
        this.proxy = proxy;
    }

    public DynamicDataSourceProxy(String id, DataSource proxy) {
        this.id = id;
        this.proxy = proxy;
    }

    @Override
    public DataSource getNative() {
        return this.proxy;
    }

    @Override
    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DatabaseType getType() {
        if (this.databaseType != null) return this.databaseType;
        this.lock.lock();
        try {
            if (this.databaseType != null) {
                DatabaseType databaseType = this.databaseType;
                return databaseType;
            }
            try (Connection connection = this.proxy.getConnection();){
                this.databaseType = DatabaseType.fromJdbcUrl(connection.getMetaData().getURL());
                return this.databaseType;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setDatabaseType(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }
}

