/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive;

import java.io.Writer;
import java.util.ArrayList;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.directive.MacroParseException;
import org.apache.velocity.runtime.directive.Scope;
import org.apache.velocity.runtime.directive.StopCommand;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.util.StringUtils;

public class Break
extends Directive {
    private boolean scoped = false;

    @Override
    public String getName() {
        return "break";
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public boolean isScopeProvided() {
        return false;
    }

    @Override
    public void init(RuntimeServices rs, InternalContextAdapter context, Node node) {
        super.init(rs, context, node);
        this.scoped = node.jjtGetNumChildren() == 1;
    }

    @Override
    public boolean render(InternalContextAdapter context, Writer writer, Node node) {
        if (!this.scoped) {
            throw new StopCommand();
        }
        Object argument = node.jjtGetChild(0).value(context);
        if (argument instanceof Scope) {
            ((Scope)argument).stop();
            throw new IllegalStateException("Scope.stop() failed to throw a StopCommand");
        }
        throw new VelocityException(node.jjtGetChild(0).literal() + " is not a valid " + Scope.class.getName() + " instance at " + StringUtils.formatFileString(this));
    }

    @Override
    public void checkArgs(ArrayList<Integer> argtypes, Token t, String templateName) throws ParseException {
        if (argtypes.size() > 1) {
            throw new MacroParseException("The #break directive takes only a single, optional Scope argument", templateName, t);
        }
    }
}

