/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.web.rest.agent;

import java.util.ArrayList;
import java.util.List;
import org.apache.slider.server.appmaster.web.rest.agent.DiskInfo;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class HostInfo {
    private String architecture;
    private String domain;
    private String fqdn;
    private String hardwareisa;
    private String hardwaremodel;
    private String hostname;
    private String id;
    private String interfaces;
    private String ipaddress;
    private String kernel;
    private String kernelmajversion;
    private String kernelrelease;
    private String kernelversion;
    private String macaddress;
    private long memoryfree;
    private long memorysize;
    private List<DiskInfo> mounts = new ArrayList<DiskInfo>();
    private long memorytotal;
    private String netmask;
    private String operatingsystem;
    private String operatingsystemrelease;
    private String osfamily;
    private int physicalprocessorcount;
    private int processorcount;
    private boolean selinux;
    private String swapfree;
    private String swapsize;
    private String timezone;
    private String uptime;
    private long uptime_days;
    private long uptime_hours;

    @JsonProperty(value="architecture")
    public String getArchitecture() {
        return this.architecture;
    }

    @JsonProperty(value="architecture")
    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    @JsonProperty(value="domain")
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @JsonProperty(value="fqdn")
    public String getFQDN() {
        return this.fqdn;
    }

    @JsonProperty(value="fqdn")
    public void setFQDN(String fqdn) {
        this.fqdn = fqdn;
    }

    @JsonProperty(value="hardwareisa")
    public String getHardwareIsa() {
        return this.hardwareisa;
    }

    @JsonProperty(value="hardwareisa")
    public void setHardwareIsa(String hardwareisa) {
        this.hardwareisa = hardwareisa;
    }

    @JsonProperty(value="hardwaremodel")
    public String getHardwareModel() {
        return this.hardwaremodel;
    }

    @JsonProperty(value="hardwaremodel")
    public void setHardwareModel(String hardwaremodel) {
        this.hardwaremodel = hardwaremodel;
    }

    @JsonProperty(value="hostname")
    public String getHostName() {
        return this.hostname;
    }

    @JsonProperty(value="hostname")
    public void setHostName(String hostname) {
        this.hostname = hostname;
    }

    @JsonProperty(value="id")
    public String getAgentUserId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setAgentUserId(String id) {
        this.id = id;
    }

    @JsonProperty(value="interfaces")
    public String getInterfaces() {
        return this.interfaces;
    }

    @JsonProperty(value="interfaces")
    public void setInterfaces(String interfaces) {
        this.interfaces = interfaces;
    }

    @JsonProperty(value="ipaddress")
    public String getIPAddress() {
        return this.ipaddress;
    }

    @JsonProperty(value="ipaddress")
    public void setIPAddress(String ipaddress) {
        this.ipaddress = ipaddress;
    }

    @JsonProperty(value="kernel")
    public String getKernel() {
        return this.kernel;
    }

    @JsonProperty(value="kernel")
    public void setKernel(String kernel) {
        this.kernel = kernel;
    }

    @JsonProperty(value="kernelmajversion")
    public String getKernelMajVersion() {
        return this.kernelmajversion;
    }

    @JsonProperty(value="kernelmajversion")
    public void setKernelMajVersion(String kernelmajversion) {
        this.kernelmajversion = kernelmajversion;
    }

    @JsonProperty(value="kernelrelease")
    public String getKernelRelease() {
        return this.kernelrelease;
    }

    @JsonProperty(value="kernelrelease")
    public void setKernelRelease(String kernelrelease) {
        this.kernelrelease = kernelrelease;
    }

    @JsonProperty(value="kernelversion")
    public String getKernelVersion() {
        return this.kernelversion;
    }

    @JsonProperty(value="kernelversion")
    public void setKernelVersion(String kernelversion) {
        this.kernelversion = kernelversion;
    }

    @JsonProperty(value="macaddress")
    public String getMacAddress() {
        return this.macaddress;
    }

    @JsonProperty(value="macaddress")
    public void setMacAddress(String macaddress) {
        this.macaddress = macaddress;
    }

    @JsonProperty(value="memoryfree")
    public long getFreeMemory() {
        return this.memoryfree;
    }

    @JsonProperty(value="memoryfree")
    public void setFreeMemory(long memoryfree) {
        this.memoryfree = memoryfree;
    }

    @JsonProperty(value="memorysize")
    public long getMemorySize() {
        return this.memorysize;
    }

    @JsonProperty(value="memorysize")
    public void setMemorySize(long memorysize) {
        this.memorysize = memorysize;
    }

    @JsonProperty(value="mounts")
    public List<DiskInfo> getMounts() {
        return this.mounts;
    }

    @JsonProperty(value="mounts")
    public void setMounts(List<DiskInfo> mounts) {
        this.mounts = mounts;
    }

    @JsonProperty(value="memorytotal")
    public long getMemoryTotal() {
        return this.memorytotal;
    }

    @JsonProperty(value="memorytotal")
    public void setMemoryTotal(long memorytotal) {
        this.memorytotal = memorytotal;
    }

    @JsonProperty(value="netmask")
    public String getNetMask() {
        return this.netmask;
    }

    @JsonProperty(value="netmask")
    public void setNetMask(String netmask) {
        this.netmask = netmask;
    }

    @JsonProperty(value="operatingsystem")
    public String getOS() {
        return this.operatingsystem;
    }

    @JsonProperty(value="operatingsystem")
    public void setOS(String operatingsystem) {
        this.operatingsystem = operatingsystem;
    }

    @JsonProperty(value="operatingsystemrelease")
    public String getOSRelease() {
        return this.operatingsystemrelease;
    }

    @JsonProperty(value="operatingsystemrelease")
    public void setOSRelease(String operatingsystemrelease) {
        this.operatingsystemrelease = operatingsystemrelease;
    }

    @JsonProperty(value="osfamily")
    public String getOSFamily() {
        return this.osfamily;
    }

    @JsonProperty(value="osfamily")
    public void setOSFamily(String osfamily) {
        this.osfamily = osfamily;
    }

    @JsonProperty(value="physicalprocessorcount")
    public int getPhysicalProcessorCount() {
        return this.physicalprocessorcount;
    }

    @JsonProperty(value="physicalprocessorcount")
    public void setPhysicalProcessorCount(int physicalprocessorcount) {
        this.physicalprocessorcount = physicalprocessorcount;
    }

    @JsonProperty(value="processorcount")
    public int getProcessorCount() {
        return this.processorcount;
    }

    @JsonProperty(value="processorcount")
    public void setProcessorCount(int processorcount) {
        this.processorcount = processorcount;
    }

    @JsonProperty(value="selinux")
    public boolean getSeLinux() {
        return this.selinux;
    }

    @JsonProperty(value="selinux")
    public void setSeLinux(boolean selinux) {
        this.selinux = selinux;
    }

    @JsonProperty(value="swapfree")
    public String getSwapFree() {
        return this.swapfree;
    }

    @JsonProperty(value="swapfree")
    public void setSwapFree(String swapfree) {
        this.swapfree = swapfree;
    }

    @JsonProperty(value="swapsize")
    public String getSwapSize() {
        return this.swapsize;
    }

    @JsonProperty(value="swapsize")
    public void setSwapSize(String swapsize) {
        this.swapsize = swapsize;
    }

    @JsonProperty(value="timezone")
    public String getTimeZone() {
        return this.timezone;
    }

    @JsonProperty(value="timezone")
    public void setTimeZone(String timezone) {
        this.timezone = timezone;
    }

    @JsonProperty(value="uptime")
    public String getUptime() {
        return this.uptime;
    }

    @JsonProperty(value="uptime")
    public void setUpTime(String uptime) {
        this.uptime = uptime;
    }

    @JsonProperty(value="uptime_hours")
    public long getUptimeHours() {
        return this.uptime_hours;
    }

    @JsonProperty(value="uptime_hours")
    public void setUpTimeHours(long uptime_hours) {
        this.uptime_hours = uptime_hours;
    }

    @JsonProperty(value="uptime_days")
    public long getUpTimeDays() {
        return this.uptime_days;
    }

    @JsonProperty(value="uptime_days")
    public void setUpTimeDays(long uptime_days) {
        this.uptime_days = uptime_days;
    }

    private String getDiskString() {
        if (this.mounts == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        for (DiskInfo diskInfo : this.mounts) {
            ret.append("(").append(diskInfo.toString()).append(")");
        }
        return ret.toString();
    }

    public String toString() {
        return "[hostname=" + this.hostname + "," + "fqdn=" + this.fqdn + "," + "domain=" + this.domain + "," + "architecture=" + this.architecture + "," + "processorcount=" + this.processorcount + "," + "physicalprocessorcount=" + this.physicalprocessorcount + "," + "osname=" + this.operatingsystem + "," + "osversion=" + this.operatingsystemrelease + "," + "osfamily=" + this.osfamily + "," + "memory=" + this.memorytotal + "," + "uptime_hours=" + this.uptime_hours + "," + "mounts=" + this.getDiskString() + "]\n";
    }
}

