/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.actions;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.server.appmaster.SliderAppMaster;
import org.apache.slider.server.appmaster.actions.QueueAccess;
import org.apache.slider.server.appmaster.state.AppState;

public abstract class AsyncAction
implements Delayed {
    private static final AtomicLong sequencer = new AtomicLong(0L);
    public final String name;
    private long nanos;
    public final int attrs;
    private final long sequenceNumber = sequencer.incrementAndGet();
    public static final int ATTR_CHANGES_APP_SIZE = 1;
    public static final int ATTR_HALTS_APP = 2;
    public static final int ATTR_REVIEWS_APP_SIZE = 4;

    protected AsyncAction(String name) {
        this(name, 0L);
    }

    protected AsyncAction(String name, long delayMillis) {
        this(name, delayMillis, TimeUnit.MILLISECONDS);
    }

    protected AsyncAction(String name, long delay, TimeUnit timeUnit) {
        this(name, delay, timeUnit, 0);
    }

    protected AsyncAction(String name, long delay, TimeUnit timeUnit, int attrs) {
        this.name = name;
        this.setNanos(this.convertAndOffset(delay, timeUnit));
        this.attrs = attrs;
    }

    protected long convertAndOffset(long delay, TimeUnit timeUnit) {
        return this.now() + TimeUnit.NANOSECONDS.convert(delay, timeUnit);
    }

    protected long now() {
        return System.nanoTime();
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.getNanos() - this.now(), TimeUnit.NANOSECONDS);
    }

    @Override
    public int compareTo(Delayed that) {
        if (this == that) {
            return 0;
        }
        return SliderUtils.compareTo(this.getDelay(TimeUnit.NANOSECONDS), that.getDelay(TimeUnit.NANOSECONDS));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" name='").append(this.name).append('\'');
        sb.append(", delay=").append(this.getDelay(TimeUnit.SECONDS));
        sb.append(", attrs=").append(this.attrs);
        sb.append(", sequenceNumber=").append(this.sequenceNumber);
        sb.append('}');
        return sb.toString();
    }

    protected int getAttrs() {
        return this.attrs;
    }

    public boolean hasAttr(int attr) {
        return (this.attrs & attr) != 0;
    }

    public abstract void execute(SliderAppMaster var1, QueueAccess var2, AppState var3) throws Exception;

    public long getNanos() {
        return this.nanos;
    }

    public void setNanos(long nanos) {
        this.nanos = nanos;
    }
}

