/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.providers.agent.application.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.providers.agent.application.metadata.AbstractMetainfoSchema;
import org.apache.slider.providers.agent.application.metadata.ComponentsInAddonPackage;

public class ApplicationPackage
extends AbstractMetainfoSchema {
    private List<ComponentsInAddonPackage> components = new ArrayList<ComponentsInAddonPackage>();

    public void addComponent(ComponentsInAddonPackage component) {
        this.components.add(component);
    }

    public List<ComponentsInAddonPackage> getComponents() {
        return this.components;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\n\"name\": ").append(this.name);
        sb.append(",\n\"comment\": ").append(this.comment);
        sb.append(",\n\"version\" :").append(this.version);
        sb.append(",\n\"components\" : {");
        for (ComponentsInAddonPackage component : this.components) {
            sb.append("\n").append(component);
        }
        sb.append("\n},");
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void validate(String version) throws SliderException {
        if (this.name == null || this.name.isEmpty()) {
            throw new SliderException("Missing name in metainfo.json for add on packages");
        }
        if (this.components.isEmpty()) {
            throw new SliderException("Missing components in metainfo.json for add on packages");
        }
        for (ComponentsInAddonPackage component : this.components) {
            if (component.name != null && !component.name.isEmpty()) continue;
            throw new SliderException("Missing name of components in metainfo.json for add on packages");
        }
    }
}

