/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.ManagerFactory;

public class OutputStreamManager
extends AbstractManager {
    private volatile OutputStream os;
    protected final Layout<?> layout;

    protected OutputStreamManager(OutputStream os, String streamName, Layout<?> layout, boolean writeHeader) {
        super(streamName);
        byte[] header;
        this.os = os;
        this.layout = layout;
        if (writeHeader && layout != null && (header = layout.getHeader()) != null) {
            try {
                this.os.write(header, 0, header.length);
            }
            catch (IOException e) {
                this.logError("unable to write header", e);
            }
        }
    }

    public static <T> OutputStreamManager getManager(String name, T data, ManagerFactory<? extends OutputStreamManager, T> factory) {
        return AbstractManager.getManager(name, factory, data);
    }

    @Override
    public void releaseSub() {
        this.writeFooter();
        this.close();
    }

    protected void writeFooter() {
        if (this.layout == null) {
            return;
        }
        byte[] footer = this.layout.getFooter();
        if (footer != null) {
            this.write(footer);
        }
    }

    public boolean isOpen() {
        return this.getCount() > 0;
    }

    protected OutputStream getOutputStream() {
        return this.os;
    }

    protected void setOutputStream(OutputStream os) {
        byte[] header = this.layout.getHeader();
        if (header != null) {
            try {
                os.write(header, 0, header.length);
                this.os = os;
            }
            catch (IOException ioe) {
                this.logError("unable to write header", ioe);
            }
        } else {
            this.os = os;
        }
    }

    protected synchronized void write(byte[] bytes, int offset, int length) {
        try {
            this.os.write(bytes, offset, length);
        }
        catch (IOException ex) {
            String msg = "Error writing to stream " + this.getName();
            throw new AppenderLoggingException(msg, ex);
        }
    }

    protected void write(byte[] bytes) {
        this.write(bytes, 0, bytes.length);
    }

    protected synchronized void close() {
        OutputStream stream = this.os;
        if (stream == System.out || stream == System.err) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException ex) {
            this.logError("unable to close stream", ex);
        }
    }

    public synchronized void flush() {
        try {
            this.os.flush();
        }
        catch (IOException ex) {
            String msg = "Error flushing stream " + this.getName();
            throw new AppenderLoggingException(msg, ex);
        }
    }
}

