/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.utils;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.service.api.records.Artifact;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.Configuration;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.conf.RestApiConstants;
import org.apache.hadoop.yarn.service.monitor.probe.MonitorUtils;
import org.apache.hadoop.yarn.service.provider.AbstractClientProvider;
import org.apache.hadoop.yarn.service.provider.ProviderFactory;
import org.apache.hadoop.yarn.service.utils.JsonSerDeser;
import org.apache.hadoop.yarn.service.utils.PatternValidator;
import org.apache.hadoop.yarn.service.utils.ServiceUtils;
import org.apache.hadoop.yarn.service.utils.SliderFileSystem;
import org.codehaus.jackson.map.PropertyNamingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceApiUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceApiUtil.class);
    public static JsonSerDeser<Service> jsonSerDeser = new JsonSerDeser<Service>(Service.class, PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
    private static final PatternValidator namePattern = new PatternValidator("[a-z][a-z0-9-]*");
    private static final PatternValidator userNamePattern = new PatternValidator("[a-z][a-z0-9-.]*");

    @VisibleForTesting
    public static void setJsonSerDeser(JsonSerDeser jsd) {
        jsonSerDeser = jsd;
    }

    @VisibleForTesting
    public static void validateAndResolveService(Service service, SliderFileSystem fs, org.apache.hadoop.conf.Configuration conf) throws IOException {
        boolean dnsEnabled = conf.getBoolean("hadoop.registry.dns.enabled", false);
        if (dnsEnabled) {
            if (RegistryUtils.currentUser().length() > 63) {
                throw new IllegalArgumentException("User name must be no more than 63 characters");
            }
            userNamePattern.validate(RegistryUtils.currentUser());
        }
        if (StringUtils.isEmpty((String)service.getName())) {
            throw new IllegalArgumentException("Service name is either empty or not provided");
        }
        if (StringUtils.isEmpty((String)service.getVersion())) {
            throw new IllegalArgumentException(String.format("Version of service %s is either empty or not provided", service.getName()));
        }
        ServiceApiUtil.validateNameFormat(service.getName(), conf);
        if (!ServiceApiUtil.hasComponent(service)) {
            throw new IllegalArgumentException("No component specified for " + service.getName());
        }
        if (UserGroupInformation.isSecurityEnabled() && !StringUtils.isEmpty((String)service.getKerberosPrincipal().getKeytab())) {
            try {
                new URI(service.getKerberosPrincipal().getKeytab());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        Configuration globalConf = service.getConfiguration();
        HashSet<String> componentNames = new HashSet<String>();
        ArrayList<Component> componentsToRemove = new ArrayList<Component>();
        ArrayList<Component> componentsToAdd = new ArrayList<Component>();
        for (Component comp : service.getComponents()) {
            int maxCompLength = 63;
            if (dnsEnabled && comp.getName().length() > (maxCompLength -= Long.toString(Long.MAX_VALUE).length())) {
                throw new IllegalArgumentException(String.format("Component name must be no more than %s characters: %s", maxCompLength, comp.getName()));
            }
            if (componentNames.contains(comp.getName())) {
                throw new IllegalArgumentException("Component name collision: " + comp.getName());
            }
            if (comp.getArtifact() != null && comp.getArtifact().getType() == Artifact.TypeEnum.SERVICE) {
                if (StringUtils.isEmpty((String)comp.getArtifact().getId())) {
                    throw new IllegalArgumentException("Artifact id (like docker image name) is either empty or not provided");
                }
                LOG.info("Marking {} for removal", (Object)comp.getName());
                componentsToRemove.add(comp);
                List<Component> externalComponents = ServiceApiUtil.getComponents(fs, comp.getArtifact().getId());
                for (Component c : externalComponents) {
                    Component override = service.getComponent(c.getName());
                    if (override != null && override.getArtifact() == null) {
                        override.mergeFrom(c);
                        LOG.info("Merging external component {} from external {}", (Object)c.getName(), (Object)comp.getName());
                        continue;
                    }
                    if (componentNames.contains(c.getName())) {
                        throw new IllegalArgumentException("Component name collision: " + c.getName());
                    }
                    componentNames.add(c.getName());
                    componentsToAdd.add(c);
                    LOG.info("Adding component {} from external {}", (Object)c.getName(), (Object)comp.getName());
                }
                continue;
            }
            componentNames.add(comp.getName());
            comp.getConfiguration().mergeFrom(globalConf);
        }
        service.getComponents().removeAll(componentsToRemove);
        service.getComponents().addAll(componentsToAdd);
        Artifact globalArtifact = service.getArtifact();
        org.apache.hadoop.yarn.service.api.records.Resource globalResource = service.getResource();
        for (Component comp : service.getComponents()) {
            if (comp.getArtifact() == null && service.getArtifact() != null && service.getArtifact().getType() != Artifact.TypeEnum.SERVICE) {
                comp.setArtifact(globalArtifact);
            }
            if (comp.getResource() == null) {
                comp.setResource(globalResource);
            }
            if (comp.getDependencies() != null) {
                for (String dependency : comp.getDependencies()) {
                    if (componentNames.contains(dependency)) continue;
                    throw new IllegalArgumentException(String.format("Dependency %s for component %s is invalid, does not exist as a component", dependency, comp.getName()));
                }
            }
            ServiceApiUtil.validateComponent(comp, fs.getFileSystem(), conf);
        }
        ServiceApiUtil.sortByDependencies(service.getComponents());
        if (service.getLifetime() == null) {
            service.setLifetime(RestApiConstants.DEFAULT_UNLIMITED_LIFETIME);
        }
    }

    private static void validateComponent(Component comp, FileSystem fs, org.apache.hadoop.conf.Configuration conf) throws IOException {
        ServiceApiUtil.validateNameFormat(comp.getName(), conf);
        AbstractClientProvider compClientProvider = ProviderFactory.getClientProvider(comp.getArtifact());
        compClientProvider.validateArtifact(comp.getArtifact(), fs);
        if (comp.getLaunchCommand() == null && (comp.getArtifact() == null || comp.getArtifact().getType() != Artifact.TypeEnum.DOCKER)) {
            throw new IllegalArgumentException("Launch_command is required when type is not DOCKER");
        }
        ServiceApiUtil.validateServiceResource(comp.getResource(), comp);
        if (comp.getNumberOfContainers() == null || comp.getNumberOfContainers() < 0L) {
            throw new IllegalArgumentException(String.format("Invalid no of containers specified for component %s (nor at the global level): " + comp.getNumberOfContainers(), comp.getName()));
        }
        compClientProvider.validateConfigFiles(comp.getConfiguration().getFiles(), fs);
        MonitorUtils.getProbe(comp.getReadinessCheck());
    }

    public static void validateNameFormat(String name, org.apache.hadoop.conf.Configuration conf) {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("Name can not be empty!");
        }
        if (name.contains("_")) {
            throw new IllegalArgumentException("Invalid format: " + name + ", can not use '_', as DNS hostname does not allow '_'. Use '-' Instead. ");
        }
        boolean dnsEnabled = conf.getBoolean("hadoop.registry.dns.enabled", false);
        if (dnsEnabled && name.length() > 63) {
            throw new IllegalArgumentException(String.format("Invalid format %s, must be no more than 63 characters ", name));
        }
        namePattern.validate(name);
    }

    @VisibleForTesting
    public static List<Component> getComponents(SliderFileSystem fs, String serviceName) throws IOException {
        return ServiceApiUtil.loadService(fs, serviceName).getComponents();
    }

    public static Service loadService(SliderFileSystem fs, String serviceName) throws IOException {
        Path serviceJson = ServiceApiUtil.getServiceJsonPath(fs, serviceName);
        LOG.info("Loading service definition from " + serviceJson);
        return jsonSerDeser.load(fs.getFileSystem(), serviceJson);
    }

    public static Service loadServiceFrom(SliderFileSystem fs, Path appDefPath) throws IOException {
        LOG.info("Loading service definition from " + appDefPath);
        return jsonSerDeser.load(fs.getFileSystem(), appDefPath);
    }

    public static Path getServiceJsonPath(SliderFileSystem fs, String serviceName) {
        Path serviceDir = fs.buildClusterDirPath(serviceName);
        return new Path(serviceDir, serviceName + ".json");
    }

    private static void validateServiceResource(org.apache.hadoop.yarn.service.api.records.Resource resource, Component comp) {
        if (resource == null) {
            throw new IllegalArgumentException(comp == null ? "Resource is not provided" : String.format("Resource is not provided for component %s (nor at the global level)", comp.getName()));
        }
        if (StringUtils.isNotEmpty((String)resource.getProfile()) && (resource.getCpus() != null || StringUtils.isNotEmpty((String)resource.getMemory()))) {
            throw new IllegalArgumentException(comp == null ? "Cannot specify cpus/memory along with profile" : String.format("Cannot specify cpus/memory along with profile for component %s", comp.getName()));
        }
        if (StringUtils.isNotEmpty((String)resource.getProfile())) {
            throw new IllegalArgumentException("Resource profile is not supported yet. Please specify cpus/memory.");
        }
        String memory = resource.getMemory();
        Integer cpus = resource.getCpus();
        if (StringUtils.isEmpty((String)memory)) {
            throw new IllegalArgumentException(comp == null ? "Service resource or memory not provided" : String.format("Service resource or memory not provided for component %s (nor at the global level)", comp.getName()));
        }
        if (cpus == null) {
            throw new IllegalArgumentException(comp == null ? "Service resource or cpus not provided" : String.format("Service resource or cpus not provided for component %s (nor at the global level)", comp.getName()));
        }
        if (cpus <= 0) {
            throw new IllegalArgumentException(comp == null ? "Unacceptable no of cpus specified, either zero or negative" : String.format("Unacceptable no of cpus specified, either zero or negative for component %s (or at the global level)", comp.getName()));
        }
    }

    public static void validateCompResourceSize(Resource maxResource, Service service) throws YarnException {
        for (Component component : service.getComponents()) {
            long mem = Long.parseLong(component.getResource().getMemory());
            if (mem > maxResource.getMemorySize()) {
                throw new YarnException("Component " + component.getName() + ": specified memory size (" + mem + ") is larger than configured max container memory size (" + maxResource.getMemorySize() + ")");
            }
            int cpu = component.getResource().getCpus();
            if (cpu <= maxResource.getVirtualCores()) continue;
            throw new YarnException("Component " + component.getName() + ": specified number of virtual core (" + cpu + ") is larger than configured max virtual core size (" + maxResource.getVirtualCores() + ")");
        }
    }

    private static boolean hasComponent(Service service) {
        return service.getComponents() != null && !service.getComponents().isEmpty();
    }

    public static Collection<Component> sortByDependencies(List<Component> components) {
        Map<String, Component> sortedComponents = ServiceApiUtil.sortByDependencies(components, null);
        return sortedComponents.values();
    }

    private static Map<String, Component> sortByDependencies(List<Component> components, Map<String, Component> sortedComponents) {
        if (sortedComponents == null) {
            sortedComponents = new LinkedHashMap<String, Component>();
        }
        LinkedHashMap<String, Component> componentsToAdd = new LinkedHashMap<String, Component>();
        ArrayList<Component> componentsSkipped = new ArrayList<Component>();
        for (Component component : components) {
            String name = component.getName();
            if (sortedComponents.containsKey(name)) continue;
            boolean dependenciesAlreadySorted = true;
            if (!ServiceUtils.isEmpty(component.getDependencies())) {
                for (String dependency : component.getDependencies()) {
                    if (sortedComponents.containsKey(dependency)) continue;
                    dependenciesAlreadySorted = false;
                    break;
                }
            }
            if (dependenciesAlreadySorted) {
                componentsToAdd.put(name, component);
                continue;
            }
            componentsSkipped.add(component);
        }
        if (componentsToAdd.size() == 0) {
            throw new IllegalArgumentException(String.format("Invalid dependencies, a cycle may exist: %s", componentsSkipped));
        }
        sortedComponents.putAll(componentsToAdd);
        if (sortedComponents.size() == components.size()) {
            return sortedComponents;
        }
        return ServiceApiUtil.sortByDependencies(components, sortedComponents);
    }

    public static String $(String s) {
        return "${" + s + "}";
    }
}

