/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.provider.tarball;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;
import org.apache.hadoop.yarn.service.containerlaunch.AbstractLauncher;
import org.apache.hadoop.yarn.service.provider.AbstractProviderService;
import org.apache.hadoop.yarn.service.utils.SliderFileSystem;

public class TarballProviderService
extends AbstractProviderService {
    @Override
    public void processArtifact(AbstractLauncher launcher, ComponentInstance instance, SliderFileSystem fileSystem, Service service) throws IOException {
        Path artifact = new Path(instance.getCompSpec().getArtifact().getId());
        if (!fileSystem.isFile(artifact)) {
            throw new IOException("Package doesn't exist as a resource: " + artifact);
        }
        log.info("Adding resource {}", (Object)artifact);
        LocalResourceType type = LocalResourceType.ARCHIVE;
        LocalResource packageResource = fileSystem.createAmResource(artifact, type);
        launcher.addLocalResource("lib", packageResource);
    }
}

