/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.provider.tarball;

import java.io.IOException;
import java.nio.file.Paths;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.service.api.records.Artifact;
import org.apache.hadoop.yarn.service.api.records.ConfigFile;
import org.apache.hadoop.yarn.service.conf.YarnServiceConstants;
import org.apache.hadoop.yarn.service.provider.AbstractClientProvider;

public class TarballClientProvider
extends AbstractClientProvider
implements YarnServiceConstants {
    @Override
    public void validateArtifact(Artifact artifact, FileSystem fs) throws IOException {
        if (artifact == null) {
            throw new IllegalArgumentException("Artifact is not provided");
        }
        if (StringUtils.isEmpty((String)artifact.getId())) {
            throw new IllegalArgumentException("Artifact id (like docker image name) is either empty or not provided");
        }
        Path p = new Path(artifact.getId());
        if (!fs.exists(p)) {
            throw new IllegalArgumentException("Artifact tarball does not exist " + artifact.getId());
        }
    }

    @Override
    protected void validateConfigFile(ConfigFile configFile, FileSystem fileSystem) throws IOException {
        if (Paths.get(configFile.getDestFile(), new String[0]).isAbsolute()) {
            throw new IllegalArgumentException("Dest_file must not be absolute path: " + configFile.getDestFile());
        }
    }
}

