/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.provider.docker;

import java.io.IOException;
import java.text.MessageFormat;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;
import org.apache.hadoop.yarn.service.containerlaunch.AbstractLauncher;
import org.apache.hadoop.yarn.service.provider.AbstractProviderService;
import org.apache.hadoop.yarn.service.provider.docker.DockerKeys;
import org.apache.hadoop.yarn.service.utils.SliderFileSystem;

public class DockerProviderService
extends AbstractProviderService
implements DockerKeys {
    @Override
    public void processArtifact(AbstractLauncher launcher, ComponentInstance compInstance, SliderFileSystem fileSystem, Service service) throws IOException {
        launcher.setYarnDockerMode(true);
        launcher.setDockerImage(compInstance.getCompSpec().getArtifact().getId());
        launcher.setDockerNetwork(compInstance.getCompSpec().getConfiguration().getProperty("docker.network"));
        String domain = compInstance.getComponent().getScheduler().getConfig().get("hadoop.registry.dns.domain-name");
        String hostname = domain == null || domain.isEmpty() ? MessageFormat.format("{0}.{1}.{2}", compInstance.getCompInstanceName(), service.getName(), RegistryUtils.currentUser()) : MessageFormat.format("{0}.{1}.{2}.{3}", compInstance.getCompInstanceName(), service.getName(), RegistryUtils.currentUser(), domain);
        launcher.setDockerHostname(hostname);
        launcher.setRunPrivilegedContainer(compInstance.getCompSpec().getRunPrivilegedContainer());
    }
}

