/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.provider;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.api.ServiceApiConstants;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.ConfigFile;
import org.apache.hadoop.yarn.service.api.records.ConfigFormat;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;
import org.apache.hadoop.yarn.service.conf.YarnServiceConstants;
import org.apache.hadoop.yarn.service.containerlaunch.AbstractLauncher;
import org.apache.hadoop.yarn.service.exceptions.BadCommandArgumentsException;
import org.apache.hadoop.yarn.service.exceptions.SliderException;
import org.apache.hadoop.yarn.service.utils.PublishedConfiguration;
import org.apache.hadoop.yarn.service.utils.PublishedConfigurationOutputter;
import org.apache.hadoop.yarn.service.utils.ServiceUtils;
import org.apache.hadoop.yarn.service.utils.SliderFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderUtils
implements YarnServiceConstants {
    protected static final Logger log = LoggerFactory.getLogger(ProviderUtils.class);

    public static boolean addProviderJar(Map<String, LocalResource> providerResources, Class providerClass, String jarName, SliderFileSystem sliderFileSystem, Path tempPath, String libdir, boolean miniClusterTestRun) throws IOException, SliderException {
        try {
            ServiceUtils.putJar(providerResources, sliderFileSystem, providerClass, tempPath, libdir, jarName);
            return true;
        }
        catch (FileNotFoundException e) {
            if (miniClusterTestRun) {
                return false;
            }
            throw e;
        }
    }

    public static void addAllDependencyJars(Map<String, LocalResource> providerResources, SliderFileSystem sliderFileSystem, Path tempPath, String libDir, String libLocalSrcDir) throws IOException, SliderException {
        File file;
        if (!(!ServiceUtils.isSet(libLocalSrcDir) || (file = new File(libLocalSrcDir)).exists() && file.isDirectory())) {
            throw new BadCommandArgumentsException("Supplied lib src dir %s is not valid", libLocalSrcDir);
        }
        ServiceUtils.putAllJars(providerResources, sliderFileSystem, tempPath, libDir, libLocalSrcDir);
    }

    public static String substituteStrWithTokens(String content, Map<String, String> tokensForSubstitution) {
        for (Map.Entry<String, String> token : tokensForSubstitution.entrySet()) {
            content = content.replaceAll(Pattern.quote(token.getKey()), token.getValue());
        }
        return content;
    }

    public static void substituteMapWithTokens(Map<String, String> configs, Map<String, String> tokenMap) {
        for (Map.Entry<String, String> entry : configs.entrySet()) {
            String value = entry.getValue();
            if (tokenMap != null) {
                for (Map.Entry<String, String> token : tokenMap.entrySet()) {
                    value = value.replaceAll(Pattern.quote(token.getKey()), token.getValue());
                }
            }
            entry.setValue(value);
        }
    }

    public static Path initCompInstanceDir(SliderFileSystem fs, ComponentInstance instance) {
        Path compDir = new Path(new Path(fs.getAppDir(), "components"), instance.getCompName());
        Path compInstanceDir = new Path(compDir, instance.getCompInstanceName());
        instance.setCompInstanceDir(compInstanceDir);
        return compInstanceDir;
    }

    public static synchronized void createConfigFileAndAddLocalResource(AbstractLauncher launcher, SliderFileSystem fs, Component component, Map<String, String> tokensForSubstitution, ComponentInstance instance, ServiceContext context) throws IOException {
        Path compInstanceDir = ProviderUtils.initCompInstanceDir(fs, instance);
        if (!fs.getFileSystem().exists(compInstanceDir)) {
            log.info(instance.getCompInstanceId() + ": Creating dir on hdfs: " + compInstanceDir);
            fs.getFileSystem().mkdirs(compInstanceDir, new FsPermission(FsAction.ALL, FsAction.NONE, FsAction.NONE));
        } else {
            log.info("Component instance conf dir already exists: " + compInstanceDir);
        }
        if (log.isDebugEnabled()) {
            log.debug("Tokens substitution for component instance: " + instance.getCompInstanceName() + System.lineSeparator() + tokensForSubstitution);
        }
        for (ConfigFile originalFile : component.getConfiguration().getFiles()) {
            ConfigFile configFile = originalFile.copy();
            String fileName = new Path(configFile.getDestFile()).getName();
            for (Map.Entry<String, String> token : tokensForSubstitution.entrySet()) {
                configFile.setDestFile(configFile.getDestFile().replaceAll(Pattern.quote(token.getKey()), token.getValue()));
            }
            Path remoteFile = new Path(compInstanceDir, fileName);
            if (!fs.getFileSystem().exists(remoteFile)) {
                log.info("Saving config file on hdfs for component " + instance.getCompInstanceName() + ": " + configFile);
                if (configFile.getSrcFile() != null) {
                    switch (configFile.getType()) {
                        case HADOOP_XML: {
                            ProviderUtils.resolveHadoopXmlTemplateAndSaveOnHdfs(fs.getFileSystem(), tokensForSubstitution, configFile, remoteFile, context);
                            break;
                        }
                        case TEMPLATE: {
                            ProviderUtils.resolvePlainTemplateAndSaveOnHdfs(fs.getFileSystem(), tokensForSubstitution, configFile, remoteFile, context);
                            break;
                        }
                        default: {
                            log.info("Not supporting loading src_file for " + configFile);
                            break;
                        }
                    }
                } else {
                    ProviderUtils.resolvePropsInConfigFileAndSaveOnHdfs(fs, tokensForSubstitution, instance, configFile, fileName, remoteFile);
                }
            }
            LocalResource configResource = fs.createAmResource(remoteFile, LocalResourceType.FILE);
            File destFile = new File(configFile.getDestFile());
            String symlink = "conf/" + fileName;
            if (destFile.isAbsolute()) {
                launcher.addLocalResource(symlink, configResource, configFile.getDestFile());
                log.info("Add config file for localization: " + symlink + " -> " + configResource.getResource().getFile() + ", dest mount path: " + configFile.getDestFile());
                continue;
            }
            launcher.addLocalResource(symlink, configResource);
            log.info("Add config file for localization: " + symlink + " -> " + configResource.getResource().getFile());
        }
    }

    private static void resolvePropsInConfigFileAndSaveOnHdfs(SliderFileSystem fs, Map<String, String> tokensForSubstitution, ComponentInstance instance, ConfigFile configFile, String fileName, Path remoteFile) throws IOException {
        ProviderUtils.substituteMapWithTokens(configFile.getProperties(), tokensForSubstitution);
        PublishedConfiguration publishedConfiguration = new PublishedConfiguration(fileName, configFile.getProperties().entrySet());
        if (!fs.getFileSystem().exists(remoteFile)) {
            PublishedConfigurationOutputter configurationOutputter = PublishedConfigurationOutputter.createOutputter(ConfigFormat.resolve(configFile.getType().toString()), publishedConfiguration);
            try (FSDataOutputStream os = fs.getFileSystem().create(remoteFile);){
                configurationOutputter.save((OutputStream)os);
                os.flush();
            }
        } else {
            log.info("Component instance = " + instance.getCompInstanceName() + ", config file already exists: " + remoteFile);
        }
    }

    private static void resolveHadoopXmlTemplateAndSaveOnHdfs(FileSystem fs, Map<String, String> tokensForSubstitution, ConfigFile configFile, Path remoteFile, ServiceContext context) throws IOException {
        Map conf;
        try {
            conf = (Map)context.configCache.get((Object)configFile);
        }
        catch (ExecutionException e) {
            log.info("Failed to load config file: " + configFile, (Throwable)e);
            return;
        }
        Configuration confCopy = new Configuration(false);
        for (Map.Entry entry : conf.entrySet()) {
            confCopy.set((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : configFile.getProperties().entrySet()) {
            confCopy.set((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : confCopy) {
            String val = (String)entry.getValue();
            if (val == null) continue;
            for (Map.Entry<String, String> token : tokensForSubstitution.entrySet()) {
                val = val.replaceAll(Pattern.quote(token.getKey()), token.getValue());
                confCopy.set((String)entry.getKey(), val);
            }
        }
        Throwable throwable = null;
        try (FSDataOutputStream output = fs.create(remoteFile);){
            confCopy.writeXml((OutputStream)output);
            log.info("Reading config from: " + configFile.getSrcFile() + ", writing to: " + remoteFile);
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
    }

    private static void resolvePlainTemplateAndSaveOnHdfs(FileSystem fs, Map<String, String> tokensForSubstitution, ConfigFile configFile, Path remoteFile, ServiceContext context) {
        String content;
        try {
            content = (String)context.configCache.get((Object)configFile);
        }
        catch (ExecutionException e) {
            log.info("Failed to load config file: " + configFile, (Throwable)e);
            return;
        }
        content = ProviderUtils.substituteStrWithTokens(content, tokensForSubstitution);
        try (FSDataOutputStream output = fs.create(remoteFile);){
            IOUtils.write((String)content, (OutputStream)output);
        }
        catch (IOException e) {
            log.info("Failed to create " + remoteFile);
        }
    }

    public static Map<String, String> initCompTokensForSubstitute(ComponentInstance instance, Container container) {
        HashMap<String, String> tokens = new HashMap<String, String>();
        tokens.put(ServiceApiConstants.COMPONENT_NAME, instance.getCompSpec().getName());
        tokens.put(ServiceApiConstants.COMPONENT_NAME_LC, instance.getCompSpec().getName().toLowerCase());
        tokens.put(ServiceApiConstants.COMPONENT_INSTANCE_NAME, instance.getCompInstanceName());
        tokens.put(ServiceApiConstants.CONTAINER_ID, container.getId().toString());
        tokens.put(ServiceApiConstants.COMPONENT_ID, String.valueOf(instance.getCompInstanceId().getId()));
        tokens.putAll(instance.getComponent().getDependencyHostIpTokens());
        return tokens;
    }
}

