/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.provider;

import org.apache.hadoop.yarn.service.api.records.Artifact;
import org.apache.hadoop.yarn.service.provider.AbstractClientProvider;
import org.apache.hadoop.yarn.service.provider.ProviderService;
import org.apache.hadoop.yarn.service.provider.defaultImpl.DefaultProviderFactory;
import org.apache.hadoop.yarn.service.provider.docker.DockerProviderFactory;
import org.apache.hadoop.yarn.service.provider.tarball.TarballProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProviderFactory {
    protected static final Logger LOG = LoggerFactory.getLogger(ProviderFactory.class);

    protected ProviderFactory() {
    }

    public abstract AbstractClientProvider createClientProvider();

    public abstract ProviderService createServerProvider();

    public static synchronized ProviderService getProviderService(Artifact artifact) {
        return ProviderFactory.createServiceProviderFactory(artifact).createServerProvider();
    }

    public static synchronized AbstractClientProvider getClientProvider(Artifact artifact) {
        return ProviderFactory.createServiceProviderFactory(artifact).createClientProvider();
    }

    public static synchronized ProviderFactory createServiceProviderFactory(Artifact artifact) {
        if (artifact == null || artifact.getType() == null) {
            LOG.debug("Loading service provider type default");
            return DefaultProviderFactory.getInstance();
        }
        LOG.debug("Loading service provider type {}", (Object)artifact.getType());
        switch (artifact.getType()) {
            case DOCKER: {
                return DockerProviderFactory.getInstance();
            }
            case TARBALL: {
                return TarballProviderFactory.getInstance();
            }
        }
        throw new IllegalArgumentException(String.format("Resolution error, %s should not be passed to createServiceProviderFactory", new Object[]{artifact.getType()}));
    }
}

