/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.provider;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;
import org.apache.hadoop.yarn.service.conf.YarnServiceConf;
import org.apache.hadoop.yarn.service.conf.YarnServiceConstants;
import org.apache.hadoop.yarn.service.containerlaunch.AbstractLauncher;
import org.apache.hadoop.yarn.service.containerlaunch.CommandLineBuilder;
import org.apache.hadoop.yarn.service.exceptions.SliderException;
import org.apache.hadoop.yarn.service.provider.ProviderService;
import org.apache.hadoop.yarn.service.provider.ProviderUtils;
import org.apache.hadoop.yarn.service.utils.ServiceApiUtil;
import org.apache.hadoop.yarn.service.utils.ServiceUtils;
import org.apache.hadoop.yarn.service.utils.SliderFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProviderService
implements ProviderService,
YarnServiceConstants {
    protected static final Logger log = LoggerFactory.getLogger(AbstractProviderService.class);

    public abstract void processArtifact(AbstractLauncher var1, ComponentInstance var2, SliderFileSystem var3, Service var4) throws IOException;

    @Override
    public void buildContainerLaunchContext(AbstractLauncher launcher, Service service, ComponentInstance instance, SliderFileSystem fileSystem, Configuration yarnConf, Container container) throws IOException, SliderException {
        Component component = instance.getComponent().getComponentSpec();
        this.processArtifact(launcher, instance, fileSystem, service);
        ServiceContext context = instance.getComponent().getScheduler().getContext();
        Map<String, String> globalTokens = instance.getComponent().getScheduler().globalTokens;
        Map<String, String> tokensForSubstitution = ProviderUtils.initCompTokensForSubstitute(instance, container);
        tokensForSubstitution.putAll(globalTokens);
        launcher.putEnv(ServiceUtils.buildEnvMap(component.getConfiguration(), tokensForSubstitution));
        launcher.setEnv("WORK_DIR", ApplicationConstants.Environment.PWD.$());
        launcher.setEnv("LOG_DIR", "<LOG_DIR>");
        if (System.getenv("HADOOP_USER_NAME") != null) {
            launcher.setEnv("HADOOP_USER_NAME", System.getenv("HADOOP_USER_NAME"));
        }
        launcher.setEnv("LANG", "en_US.UTF-8");
        launcher.setEnv("LC_ALL", "en_US.UTF-8");
        launcher.setEnv("LANGUAGE", "en_US.UTF-8");
        for (Map.Entry<String, String> entry : launcher.getEnv().entrySet()) {
            tokensForSubstitution.put(ServiceApiUtil.$(entry.getKey()), entry.getValue());
        }
        ProviderUtils.createConfigFileAndAddLocalResource(launcher, fileSystem, component, tokensForSubstitution, instance, context);
        String launchCommand = component.getLaunchCommand();
        if (!StringUtils.isEmpty((String)launchCommand)) {
            launchCommand = ProviderUtils.substituteStrWithTokens(launchCommand, tokensForSubstitution);
            CommandLineBuilder operation = new CommandLineBuilder();
            operation.add(launchCommand);
            operation.addOutAndErrFiles("stdout.txt", "stderr.txt");
            launcher.addCommand(operation.build());
        }
        launcher.setRetryContext(YarnServiceConf.getInt("yarn.service.container-failure.retry.max", -1, service.getConfiguration(), yarnConf), YarnServiceConf.getInt("yarn.service.container-failure.retry-interval-ms", 30000, service.getConfiguration(), yarnConf));
    }
}

