/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.provider;

import java.io.IOException;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.service.api.records.Artifact;
import org.apache.hadoop.yarn.service.api.records.ConfigFile;
import org.apache.hadoop.yarn.service.utils.ServiceUtils;

public abstract class AbstractClientProvider {
    public static final Set<String> createApplicationTags(String appName, String appVersion, String appDescription) {
        HashSet<String> tags = new HashSet<String>();
        tags.add(ServiceUtils.createNameTag(appName));
        if (appVersion != null) {
            tags.add(ServiceUtils.createVersionTag(appVersion));
        }
        if (appDescription != null) {
            tags.add(ServiceUtils.createDescriptionTag(appDescription));
        }
        return tags;
    }

    public abstract void validateArtifact(Artifact var1, FileSystem var2) throws IOException;

    protected abstract void validateConfigFile(ConfigFile var1, FileSystem var2) throws IOException;

    public void validateConfigFiles(List<ConfigFile> configFiles, FileSystem fs) throws IOException {
        HashSet<String> destFileSet = new HashSet<String>();
        for (ConfigFile file : configFiles) {
            Path p;
            if (file.getType() == null) {
                throw new IllegalArgumentException("File type is empty");
            }
            if (file.getType().equals((Object)ConfigFile.TypeEnum.TEMPLATE) && StringUtils.isEmpty((String)file.getSrcFile()) && !file.getProperties().containsKey("content")) {
                throw new IllegalArgumentException(MessageFormat.format("For {0} format, either src_file must be specified in ConfigFile, or the \"{1}\" key must be specified in the 'properties' field of ConfigFile. ", new Object[]{ConfigFile.TypeEnum.TEMPLATE, "content"}));
            }
            if (!StringUtils.isEmpty((String)file.getSrcFile()) && !fs.exists(p = new Path(file.getSrcFile()))) {
                throw new IllegalArgumentException("Specified src_file does not exist on " + fs.getScheme() + ": " + file.getSrcFile());
            }
            if (StringUtils.isEmpty((String)file.getDestFile())) {
                throw new IllegalArgumentException("Dest_file is empty.");
            }
            if (destFileSet.contains(file.getDestFile())) {
                throw new IllegalArgumentException("Duplicated ConfigFile exists: " + file.getDestFile());
            }
            destFileSet.add(file.getDestFile());
            java.nio.file.Path destPath = Paths.get(file.getDestFile(), new String[0]);
            if (!destPath.isAbsolute() && destPath.getNameCount() > 1) {
                throw new IllegalArgumentException("Non-absolute dest_file has more than one path element");
            }
            this.validateConfigFile(file, fs);
        }
    }
}

