/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.monitor.probe;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;
import org.apache.hadoop.yarn.service.monitor.probe.MonitorKeys;
import org.apache.hadoop.yarn.service.monitor.probe.ProbeStatus;

public abstract class Probe
implements MonitorKeys {
    protected final Configuration conf;
    private String name;

    public Probe(String name, Configuration conf) {
        this.name = name;
        this.conf = conf;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public static String getProperty(Map<String, String> props, String name, String defaultValue) throws IOException {
        String value = props.get(name);
        if (StringUtils.isEmpty((String)value)) {
            if (defaultValue == null) {
                throw new IOException(name + " not specified");
            }
            return defaultValue;
        }
        return value;
    }

    public static int getPropertyInt(Map<String, String> props, String name, Integer defaultValue) throws IOException {
        String value = props.get(name);
        if (StringUtils.isEmpty((String)value)) {
            if (defaultValue == null) {
                throw new IOException(name + " not specified");
            }
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public void init() throws IOException {
    }

    public abstract ProbeStatus ping(ComponentInstance var1);
}

