/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.monitor.probe;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;
import org.apache.hadoop.yarn.service.monitor.probe.Probe;
import org.apache.hadoop.yarn.service.monitor.probe.ProbeStatus;
import org.apache.hadoop.yarn.service.utils.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProbe
extends Probe {
    protected static final Logger log = LoggerFactory.getLogger(HttpProbe.class);
    private static final String HOST_TOKEN = "${THIS_HOST}";
    private final String urlString;
    private final int timeout;
    private final int min;
    private final int max;

    public HttpProbe(String url, int timeout, int min, int max, Configuration conf) {
        super("Http probe of " + url + " [" + min + "-" + max + "]", conf);
        this.urlString = url;
        this.timeout = timeout;
        this.min = min;
        this.max = max;
    }

    public static HttpProbe create(Map<String, String> props) throws IOException {
        String urlString = HttpProbe.getProperty(props, "url", null);
        new URL(urlString);
        int timeout = HttpProbe.getPropertyInt(props, "timeout", 1000);
        int minSuccess = HttpProbe.getPropertyInt(props, "min.success", 200);
        int maxSuccess = HttpProbe.getPropertyInt(props, "max.success", 299);
        return new HttpProbe(urlString, timeout, minSuccess, maxSuccess, null);
    }

    private static HttpURLConnection getConnection(URL url, int timeout) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setInstanceFollowRedirects(true);
        connection.setConnectTimeout(timeout);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProbeStatus ping(ComponentInstance instance) {
        ProbeStatus status = new ProbeStatus();
        ContainerStatus containerStatus = instance.getContainerStatus();
        if (containerStatus == null || ServiceUtils.isEmpty(containerStatus.getIPs()) || StringUtils.isEmpty((String)containerStatus.getHost())) {
            status.fail(this, new IOException("IP is not available yet"));
            return status;
        }
        String ip = (String)containerStatus.getIPs().get(0);
        HttpURLConnection connection = null;
        try {
            URL url = new URL(this.urlString.replace(HOST_TOKEN, ip));
            connection = HttpProbe.getConnection(url, this.timeout);
            int rc = connection.getResponseCode();
            if (rc < this.min || rc > this.max) {
                String error = "Probe " + url + " error code: " + rc;
                log.info(error);
                status.fail(this, new IOException(error));
            } else {
                status.succeed(this);
            }
        }
        catch (Throwable e) {
            String error = "Probe " + this.urlString + " failed for IP " + ip + ": " + e;
            log.info(error, e);
            status.fail(this, new IOException(error, e));
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return status;
    }
}

