/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.containerlaunch;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;
import org.apache.hadoop.yarn.service.containerlaunch.AbstractLauncher;
import org.apache.hadoop.yarn.service.provider.ProviderFactory;
import org.apache.hadoop.yarn.service.provider.ProviderService;
import org.apache.hadoop.yarn.service.utils.SliderFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerLaunchService
extends AbstractService {
    protected static final Logger LOG = LoggerFactory.getLogger(ContainerLaunchService.class);
    private ExecutorService executorService;
    private SliderFileSystem fs;
    private ServiceContext context;

    public ContainerLaunchService(ServiceContext context) {
        super(ContainerLaunchService.class.getName());
        this.fs = context.fs;
        this.context = context;
    }

    public void serviceInit(Configuration conf) throws Exception {
        this.executorService = Executors.newCachedThreadPool();
        super.serviceInit(conf);
    }

    protected void serviceStop() throws Exception {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        super.serviceStop();
    }

    public void launchCompInstance(Service service, ComponentInstance instance, Container container) {
        ContainerLauncher launcher = new ContainerLauncher(service, instance, container);
        this.executorService.execute(launcher);
    }

    private class ContainerLauncher
    implements Runnable {
        public final Container container;
        public final Service service;
        public ComponentInstance instance;

        public ContainerLauncher(Service service, ComponentInstance instance, Container container) {
            this.container = container;
            this.service = service;
            this.instance = instance;
        }

        @Override
        public void run() {
            Component compSpec = this.instance.getCompSpec();
            ProviderService provider = ProviderFactory.getProviderService(compSpec.getArtifact());
            AbstractLauncher launcher = new AbstractLauncher(ContainerLaunchService.this.context);
            try {
                provider.buildContainerLaunchContext(launcher, this.service, this.instance, ContainerLaunchService.this.fs, ContainerLaunchService.this.getConfig(), this.container);
                this.instance.getComponent().getScheduler().getNmClient().startContainerAsync(this.container, launcher.completeContainerLaunch());
            }
            catch (Exception e) {
                LOG.error(this.instance.getCompInstanceId() + ": Failed to launch container. ", (Throwable)e);
            }
        }
    }
}

