/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.containerlaunch;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.yarn.service.utils.ServiceUtils;

public class CommandLineBuilder {
    protected final List<String> argumentList = new ArrayList<String>(20);

    public void add(Object ... args) {
        for (Object arg : args) {
            this.argumentList.add(arg.toString());
        }
    }

    public int size() {
        return this.argumentList.size();
    }

    public void addOutAndErrFiles(String stdout, String stderr) {
        Preconditions.checkNotNull((Object)stdout, (Object)"Null output file");
        Preconditions.checkState((!stdout.isEmpty() ? 1 : 0) != 0, (Object)"output filename invalid");
        this.argumentList.add("1><LOG_DIR>/" + stdout);
        if (stderr != null) {
            this.argumentList.add("2><LOG_DIR>/" + stderr);
        } else {
            this.argumentList.add("2>&1");
        }
    }

    public String toString() {
        return this.build();
    }

    public String build() {
        return ServiceUtils.join(this.argumentList, " ");
    }
}

