/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.component.instance;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.registry.client.binding.RegistryPathUtils;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.service.ServiceScheduler;
import org.apache.hadoop.yarn.service.api.records.Container;
import org.apache.hadoop.yarn.service.api.records.ContainerState;
import org.apache.hadoop.yarn.service.component.Component;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceEvent;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceEventType;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceId;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceState;
import org.apache.hadoop.yarn.service.monitor.probe.ProbeStatus;
import org.apache.hadoop.yarn.service.registry.YarnRegistryViewForProviders;
import org.apache.hadoop.yarn.service.timelineservice.ServiceTimelinePublisher;
import org.apache.hadoop.yarn.service.utils.ServiceUtils;
import org.apache.hadoop.yarn.state.InvalidStateTransitionException;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.BoundedAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentInstance
implements EventHandler<ComponentInstanceEvent>,
Comparable<ComponentInstance> {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentInstance.class);
    private StateMachine<ComponentInstanceState, ComponentInstanceEventType, ComponentInstanceEvent> stateMachine;
    private Component component;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private ComponentInstanceId compInstanceId = null;
    private Path compInstanceDir;
    private org.apache.hadoop.yarn.api.records.Container container;
    private YarnRegistryViewForProviders yarnRegistryOperations;
    private FileSystem fs;
    private boolean timelineServiceEnabled = false;
    private ServiceTimelinePublisher serviceTimelinePublisher;
    private ServiceScheduler scheduler;
    private BoundedAppender diagnostics = new BoundedAppender(65536);
    private volatile ScheduledFuture containerStatusFuture;
    private volatile ContainerStatus status;
    private long containerStartedTime = 0L;
    private Container containerSpec;
    private static final StateMachineFactory<ComponentInstance, ComponentInstanceState, ComponentInstanceEventType, ComponentInstanceEvent> stateMachineFactory = new StateMachineFactory((Enum)ComponentInstanceState.INIT).addTransition((Enum)ComponentInstanceState.INIT, (Enum)ComponentInstanceState.STARTED, (Enum)ComponentInstanceEventType.START, (SingleArcTransition)new ContainerStartedTransition()).addTransition((Enum)ComponentInstanceState.INIT, (Enum)ComponentInstanceState.INIT, (Enum)ComponentInstanceEventType.STOP, (SingleArcTransition)new ContainerStoppedTransition(true)).addTransition((Enum)ComponentInstanceState.STARTED, (Enum)ComponentInstanceState.INIT, (Enum)ComponentInstanceEventType.STOP, (SingleArcTransition)new ContainerStoppedTransition()).addTransition((Enum)ComponentInstanceState.STARTED, (Enum)ComponentInstanceState.READY, (Enum)ComponentInstanceEventType.BECOME_READY, (SingleArcTransition)new ContainerBecomeReadyTransition()).addTransition((Enum)ComponentInstanceState.READY, (Enum)ComponentInstanceState.STARTED, (Enum)ComponentInstanceEventType.BECOME_NOT_READY, (SingleArcTransition)new ContainerBecomeNotReadyTransition()).addTransition((Enum)ComponentInstanceState.READY, (Enum)ComponentInstanceState.INIT, (Enum)ComponentInstanceEventType.STOP, (SingleArcTransition)new ContainerStoppedTransition()).installTopology();

    public ComponentInstance(Component component, ComponentInstanceId compInstanceId) {
        this.stateMachine = stateMachineFactory.make((Object)this);
        this.component = component;
        this.compInstanceId = compInstanceId;
        this.scheduler = component.getScheduler();
        this.yarnRegistryOperations = component.getScheduler().getYarnRegistryOperations();
        this.serviceTimelinePublisher = component.getScheduler().getServiceTimelinePublisher();
        if (YarnConfiguration.timelineServiceV2Enabled((Configuration)component.getScheduler().getConfig())) {
            this.timelineServiceEnabled = true;
        }
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.fs = this.scheduler.getContext().fs.getFileSystem();
    }

    public ComponentInstanceState getState() {
        this.readLock.lock();
        try {
            ComponentInstanceState componentInstanceState = (ComponentInstanceState)this.stateMachine.getCurrentState();
            return componentInstanceState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ComponentInstanceEvent event) {
        try {
            this.writeLock.lock();
            ComponentInstanceState oldState = this.getState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitionException e) {
                LOG.error(this.getCompInstanceId() + ": Invalid event " + event.getType() + " at " + (Object)((Object)oldState), (Throwable)e);
            }
            if (oldState != this.getState()) {
                LOG.info(this.getCompInstanceId() + " Transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getState()) + " on " + event.getType() + " event");
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setContainer(org.apache.hadoop.yarn.api.records.Container container) {
        this.container = container;
        this.compInstanceId.setContainerId(container.getId());
    }

    public String getCompInstanceName() {
        return this.compInstanceId.getCompInstanceName();
    }

    public ContainerStatus getContainerStatus() {
        return this.status;
    }

    public void updateContainerStatus(ContainerStatus status) {
        this.status = status;
        Container container = this.getCompSpec().getContainer(status.getContainerId().toString());
        if (container != null) {
            container.setIp(StringUtils.join((CharSequence)",", (Iterable)status.getIPs()));
            container.setHostname(status.getHost());
            if (this.timelineServiceEnabled) {
                this.serviceTimelinePublisher.componentInstanceIPHostUpdated(container);
            }
        }
        this.updateServiceRecord(this.yarnRegistryOperations, status);
    }

    public String getCompName() {
        return this.compInstanceId.getCompName();
    }

    public void setCompInstanceDir(Path dir) {
        this.compInstanceDir = dir;
    }

    public Component getComponent() {
        return this.component;
    }

    public org.apache.hadoop.yarn.api.records.Container getContainer() {
        return this.container;
    }

    public ComponentInstanceId getCompInstanceId() {
        return this.compInstanceId;
    }

    public NodeId getNodeId() {
        return this.container.getNodeId();
    }

    public org.apache.hadoop.yarn.service.api.records.Component getCompSpec() {
        return this.component.getComponentSpec();
    }

    public ProbeStatus ping() {
        if (this.component.getProbe() == null) {
            ProbeStatus status = new ProbeStatus();
            status.setSuccess(true);
            return status;
        }
        return this.component.getProbe().ping(this);
    }

    private void updateServiceRecord(YarnRegistryViewForProviders yarnRegistry, ContainerStatus status) {
        ServiceRecord record = new ServiceRecord();
        String containerId = status.getContainerId().toString();
        record.set("yarn:id", (Object)containerId);
        record.description = this.getCompInstanceName();
        record.set("yarn:persistence", (Object)"container");
        record.set("yarn:ip", status.getIPs().get(0));
        record.set("yarn:hostname", (Object)status.getHost());
        record.set("yarn:component", (Object)this.component.getName());
        try {
            yarnRegistry.putComponent(RegistryPathUtils.encodeYarnID((String)containerId), record);
        }
        catch (IOException e) {
            LOG.error("Failed to update service record in registry: " + containerId + "");
        }
    }

    public void destroy() {
        LOG.info(this.getCompInstanceId() + ": Flexed down by user, destroying.");
        this.diagnostics.append((CharSequence)(this.getCompInstanceId() + ": Flexed down by user"));
        if (this.getState() == ComponentInstanceState.STARTED) {
            this.component.decRunningContainers();
        }
        if (this.getState() == ComponentInstanceState.READY) {
            this.component.decContainersReady();
            this.component.decRunningContainers();
        }
        this.getCompSpec().removeContainer(this.containerSpec);
        if (this.container == null) {
            LOG.info(this.getCompInstanceId() + " no container is assigned when destroying");
            return;
        }
        ContainerId containerId = this.container.getId();
        this.scheduler.removeLiveCompInstance(containerId);
        this.component.getScheduler().getAmRMClient().releaseAssignedContainer(containerId);
        if (this.timelineServiceEnabled) {
            this.serviceTimelinePublisher.componentInstanceFinished(containerId, -105, this.diagnostics.toString());
        }
        this.cancelContainerStatusRetriever();
        this.scheduler.executorService.submit(() -> this.cleanupRegistryAndCompHdfsDir(containerId));
    }

    private void cleanupRegistry(ContainerId containerId) {
        String cid = RegistryPathUtils.encodeYarnID((String)containerId.toString());
        try {
            this.yarnRegistryOperations.deleteComponent(this.getCompInstanceId(), cid);
        }
        catch (IOException e) {
            LOG.error(this.getCompInstanceId() + ": Failed to delete registry", (Throwable)e);
        }
    }

    public void cleanupRegistryAndCompHdfsDir(ContainerId containerId) {
        this.cleanupRegistry(containerId);
        try {
            if (this.compInstanceDir != null && this.fs.exists(this.compInstanceDir)) {
                boolean deleted = this.fs.delete(this.compInstanceDir, true);
                if (!deleted) {
                    LOG.error(this.getCompInstanceId() + ": Failed to delete component instance dir: " + this.compInstanceDir);
                } else {
                    LOG.info(this.getCompInstanceId() + ": Deleted component instance dir: " + this.compInstanceDir);
                }
            }
        }
        catch (IOException e) {
            LOG.warn(this.getCompInstanceId() + ": Failed to delete directory", (Throwable)e);
        }
    }

    private void cancelContainerStatusRetriever() {
        if (this.containerStatusFuture != null && !this.containerStatusFuture.isDone()) {
            this.containerStatusFuture.cancel(true);
        }
    }

    @Override
    public int compareTo(ComponentInstance to) {
        long delta = this.containerStartedTime - to.containerStartedTime;
        if (delta == 0L) {
            return this.getCompInstanceId().compareTo(to.getCompInstanceId());
        }
        if (delta < 0L) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentInstance instance = (ComponentInstance)o;
        if (this.containerStartedTime != instance.containerStartedTime) {
            return false;
        }
        return this.compInstanceId.equals(instance.compInstanceId);
    }

    public int hashCode() {
        int result = this.compInstanceId.hashCode();
        result = 31 * result + (int)(this.containerStartedTime ^ this.containerStartedTime >>> 32);
        return result;
    }

    private static class ContainerStatusRetriever
    implements Runnable {
        private ContainerId containerId;
        private NodeId nodeId;
        private NMClient nmClient;
        private ComponentInstance instance;

        ContainerStatusRetriever(ServiceScheduler scheduler, ContainerId containerId, ComponentInstance instance) {
            this.containerId = containerId;
            this.nodeId = instance.getNodeId();
            this.nmClient = scheduler.getNmClient().getClient();
            this.instance = instance;
        }

        @Override
        public void run() {
            ContainerStatus status = null;
            try {
                status = this.nmClient.getContainerStatus(this.containerId, this.nodeId);
            }
            catch (Exception e) {
                if (e instanceof YarnException) {
                    throw new YarnRuntimeException(this.instance.compInstanceId + " Failed to get container status on " + this.nodeId + " , cancelling.", (Throwable)e);
                }
                LOG.error(this.instance.compInstanceId + " Failed to get container status on " + this.nodeId + ", will try again", (Throwable)e);
                return;
            }
            if (ServiceUtils.isEmpty(status.getIPs()) || ServiceUtils.isUnset(status.getHost())) {
                return;
            }
            this.instance.updateContainerStatus(status);
            LOG.info(this.instance.compInstanceId + " IP = " + status.getIPs() + ", host = " + status.getHost() + ", cancel container status retriever");
            this.instance.containerStatusFuture.cancel(false);
        }
    }

    private static class BaseTransition
    implements SingleArcTransition<ComponentInstance, ComponentInstanceEvent> {
        private BaseTransition() {
        }

        public void transition(ComponentInstance compInstance, ComponentInstanceEvent event) {
        }
    }

    private static class ContainerStoppedTransition
    extends BaseTransition {
        boolean failedBeforeLaunching = false;

        public ContainerStoppedTransition(boolean failedBeforeLaunching) {
            this.failedBeforeLaunching = failedBeforeLaunching;
        }

        public ContainerStoppedTransition() {
            this(false);
        }

        @Override
        public void transition(ComponentInstance compInstance, ComponentInstanceEvent event) {
            Component comp = compInstance.component;
            comp.requestContainers(1L);
            String containerDiag = compInstance.getCompInstanceId() + ": " + event.getStatus().getDiagnostics();
            compInstance.diagnostics.append((CharSequence)(containerDiag + System.lineSeparator()));
            compInstance.cancelContainerStatusRetriever();
            if (compInstance.getState().equals((Object)ComponentInstanceState.READY)) {
                compInstance.component.decContainersReady();
            }
            compInstance.component.decRunningContainers();
            boolean shouldExit = false;
            if (comp.currentContainerFailure.get() > comp.maxContainerFailurePerComp) {
                String exitDiag = MessageFormat.format("[COMPONENT {0}]: Failed {1} times, exceeded the limit - {2}. Shutting down now... " + System.lineSeparator(), comp.getName(), comp.currentContainerFailure.get(), comp.maxContainerFailurePerComp);
                compInstance.diagnostics.append((CharSequence)exitDiag);
                comp.getScheduler().getDiagnostics().append((CharSequence)containerDiag);
                comp.getScheduler().getDiagnostics().append((CharSequence)exitDiag);
                LOG.warn(exitDiag);
                shouldExit = true;
            }
            if (!this.failedBeforeLaunching) {
                ((ComponentInstance)compInstance).scheduler.executorService.submit(() -> compInstance.cleanupRegistry(event.getContainerId()));
                if (compInstance.timelineServiceEnabled) {
                    compInstance.serviceTimelinePublisher.componentInstanceFinished(event.getContainerId(), event.getStatus().getExitStatus(), containerDiag);
                }
                compInstance.containerSpec.setState(ContainerState.STOPPED);
            }
            comp.getScheduler().removeLiveCompInstance(event.getContainerId());
            comp.reInsertPendingInstance(compInstance);
            LOG.info(compInstance.getCompInstanceId() + ": {} completed. Reinsert back to pending list and requested a new container." + System.lineSeparator() + " exitStatus={}, diagnostics={}.", new Object[]{event.getContainerId(), event.getStatus().getExitStatus(), event.getStatus().getDiagnostics()});
            if (shouldExit) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    LOG.error("Interrupted on sleep while exiting.", (Throwable)e);
                }
                ExitUtil.terminate((int)-1);
            }
        }
    }

    private static class ContainerBecomeNotReadyTransition
    extends BaseTransition {
        private ContainerBecomeNotReadyTransition() {
        }

        @Override
        public void transition(ComponentInstance compInstance, ComponentInstanceEvent event) {
            compInstance.containerSpec.setState(ContainerState.RUNNING_BUT_UNREADY);
            compInstance.component.decContainersReady();
        }
    }

    private static class ContainerBecomeReadyTransition
    extends BaseTransition {
        private ContainerBecomeReadyTransition() {
        }

        @Override
        public void transition(ComponentInstance compInstance, ComponentInstanceEvent event) {
            compInstance.containerSpec.setState(ContainerState.READY);
            compInstance.component.incContainersReady();
            if (compInstance.timelineServiceEnabled) {
                compInstance.serviceTimelinePublisher.componentInstanceBecomeReady(compInstance.containerSpec);
            }
        }
    }

    private static class ContainerStartedTransition
    extends BaseTransition {
        private ContainerStartedTransition() {
        }

        @Override
        public void transition(ComponentInstance compInstance, ComponentInstanceEvent event) {
            compInstance.containerStatusFuture = ((ComponentInstance)compInstance).scheduler.executorService.scheduleAtFixedRate(new ContainerStatusRetriever(compInstance.scheduler, event.getContainerId(), compInstance), 0L, 1L, TimeUnit.SECONDS);
            long containerStartTime = System.currentTimeMillis();
            try {
                ContainerTokenIdentifier containerTokenIdentifier = BuilderUtils.newContainerTokenIdentifier((Token)compInstance.getContainer().getContainerToken());
                containerStartTime = containerTokenIdentifier.getCreationTime();
            }
            catch (Exception e) {
                LOG.info("Could not get container creation time, using current time");
            }
            Container container = new Container();
            container.setId(event.getContainerId().toString());
            container.setLaunchTime(new Date(containerStartTime));
            container.setState(ContainerState.RUNNING_BUT_UNREADY);
            container.setBareHost(compInstance.getNodeId().getHost());
            container.setComponentInstanceName(compInstance.getCompInstanceName());
            if (compInstance.containerSpec != null) {
                compInstance.getCompSpec().removeContainer(compInstance.containerSpec);
            }
            compInstance.containerSpec = container;
            compInstance.getCompSpec().addContainer(container);
            compInstance.containerStartedTime = containerStartTime;
            compInstance.component.incRunningContainers();
            if (compInstance.timelineServiceEnabled) {
                compInstance.serviceTimelinePublisher.componentInstanceStarted(container, compInstance);
            }
        }
    }
}

