/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.component;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.service.ContainerFailureTracker;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.ServiceMaster;
import org.apache.hadoop.yarn.service.ServiceMetrics;
import org.apache.hadoop.yarn.service.ServiceScheduler;
import org.apache.hadoop.yarn.service.api.ServiceApiConstants;
import org.apache.hadoop.yarn.service.api.records.Resource;
import org.apache.hadoop.yarn.service.api.records.ResourceInformation;
import org.apache.hadoop.yarn.service.api.records.ServiceState;
import org.apache.hadoop.yarn.service.component.ComponentEvent;
import org.apache.hadoop.yarn.service.component.ComponentEventType;
import org.apache.hadoop.yarn.service.component.ComponentState;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceEvent;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceEventType;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceId;
import org.apache.hadoop.yarn.service.monitor.probe.MonitorUtils;
import org.apache.hadoop.yarn.service.monitor.probe.Probe;
import org.apache.hadoop.yarn.service.provider.ProviderUtils;
import org.apache.hadoop.yarn.service.utils.ServiceUtils;
import org.apache.hadoop.yarn.state.InvalidStateTransitionException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.Apps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Component
implements EventHandler<ComponentEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(Component.class);
    private org.apache.hadoop.yarn.service.api.records.Component componentSpec;
    private long allocateId;
    private Priority priority;
    private ServiceMetrics componentMetrics;
    private ServiceScheduler scheduler;
    private ServiceContext context;
    private AMRMClientAsync<AMRMClient.ContainerRequest> amrmClient;
    private AtomicLong instanceIdCounter = new AtomicLong();
    private Map<String, ComponentInstance> compInstances = new ConcurrentHashMap<String, ComponentInstance>();
    private List<ComponentInstance> pendingInstances = Collections.synchronizedList(new LinkedList());
    private ContainerFailureTracker failureTracker;
    private Probe probe;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    public int maxContainerFailurePerComp;
    public AtomicInteger currentContainerFailure = new AtomicInteger(0);
    private StateMachine<ComponentState, ComponentEventType, ComponentEvent> stateMachine;
    private AsyncDispatcher dispatcher;
    private static final StateMachineFactory<Component, ComponentState, ComponentEventType, ComponentEvent> stateMachineFactory = new StateMachineFactory((Enum)ComponentState.INIT).addTransition((Enum)ComponentState.INIT, EnumSet.of(ComponentState.STABLE, ComponentState.FLEXING, ComponentState.INIT), (Enum)ComponentEventType.FLEX, (MultipleArcTransition)new FlexComponentTransition()).addTransition((Enum)ComponentState.INIT, (Enum)ComponentState.INIT, (Enum)ComponentEventType.CONTAINER_RECOVERED, (SingleArcTransition)new ContainerRecoveredTransition()).addTransition((Enum)ComponentState.FLEXING, (Enum)ComponentState.FLEXING, (Enum)ComponentEventType.CONTAINER_RECOVERED, (SingleArcTransition)new ContainerRecoveredTransition()).addTransition((Enum)ComponentState.FLEXING, (Enum)ComponentState.FLEXING, (Enum)ComponentEventType.CONTAINER_ALLOCATED, (SingleArcTransition)new ContainerAllocatedTransition()).addTransition((Enum)ComponentState.FLEXING, EnumSet.of(ComponentState.STABLE, ComponentState.FLEXING), (Enum)ComponentEventType.CONTAINER_STARTED, (MultipleArcTransition)new ContainerStartedTransition()).addTransition((Enum)ComponentState.FLEXING, (Enum)ComponentState.FLEXING, (Enum)ComponentEventType.CONTAINER_COMPLETED, (SingleArcTransition)new ContainerCompletedTransition()).addTransition((Enum)ComponentState.FLEXING, EnumSet.of(ComponentState.FLEXING, ComponentState.STABLE), (Enum)ComponentEventType.FLEX, (MultipleArcTransition)new FlexComponentTransition()).addTransition((Enum)ComponentState.STABLE, (Enum)ComponentState.FLEXING, (Enum)ComponentEventType.CONTAINER_COMPLETED, (SingleArcTransition)new ContainerCompletedTransition()).addTransition((Enum)ComponentState.STABLE, (Enum)ComponentState.STABLE, (Enum)ComponentEventType.CONTAINER_ALLOCATED, (SingleArcTransition)new ContainerAllocatedTransition()).addTransition((Enum)ComponentState.STABLE, EnumSet.of(ComponentState.STABLE, ComponentState.FLEXING), (Enum)ComponentEventType.FLEX, (MultipleArcTransition)new FlexComponentTransition()).installTopology();

    public Component(org.apache.hadoop.yarn.service.api.records.Component component, long allocateId, ServiceContext context) {
        this.allocateId = allocateId;
        this.priority = Priority.newInstance((int)((int)allocateId));
        this.componentSpec = component;
        this.componentMetrics = ServiceMetrics.register(component.getName(), "Metrics for component " + component.getName());
        this.componentMetrics.tag("type", "Metrics type [component or service]", "component");
        this.scheduler = context.scheduler;
        this.context = context;
        this.amrmClient = this.scheduler.getAmRMClient();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.stateMachine = stateMachineFactory.make((Object)this);
        this.dispatcher = this.scheduler.getDispatcher();
        this.failureTracker = new ContainerFailureTracker(context, this);
        this.probe = MonitorUtils.getProbe(this.componentSpec.getReadinessCheck());
        this.maxContainerFailurePerComp = this.componentSpec.getConfiguration().getPropertyInt("yarn.service.container-failure-per-component.threshold", 10);
        this.createNumCompInstances(component.getNumberOfContainers());
    }

    private void createNumCompInstances(long count) {
        int i = 0;
        while ((long)i < count) {
            this.createOneCompInstance();
            ++i;
        }
    }

    private void createOneCompInstance() {
        ComponentInstanceId id = new ComponentInstanceId(this.instanceIdCounter.getAndIncrement(), this.componentSpec.getName());
        ComponentInstance instance = new ComponentInstance(this, id);
        this.compInstances.put(instance.getCompInstanceName(), instance);
        this.pendingInstances.add(instance);
    }

    private static ComponentState checkIfStable(Component component) {
        if ((long)component.componentMetrics.containersReady.value() == component.getComponentSpec().getNumberOfContainers()) {
            component.componentSpec.setState(org.apache.hadoop.yarn.service.api.records.ComponentState.STABLE);
            return ComponentState.STABLE;
        }
        component.componentSpec.setState(org.apache.hadoop.yarn.service.api.records.ComponentState.FLEXING);
        return ComponentState.FLEXING;
    }

    public static synchronized void checkAndUpdateComponentState(Component component, boolean isIncrement) {
        org.apache.hadoop.yarn.service.api.records.ComponentState curState = component.componentSpec.getState();
        if (isIncrement) {
            if (component.componentMetrics.containersReady.value() == component.componentMetrics.containersDesired.value()) {
                component.componentSpec.setState(org.apache.hadoop.yarn.service.api.records.ComponentState.STABLE);
                if (curState != component.componentSpec.getState()) {
                    LOG.info("[COMPONENT {}] state changed from {} -> {}", new Object[]{component.componentSpec.getName(), curState, component.componentSpec.getState()});
                }
                ServiceMaster.checkAndUpdateServiceState(component.scheduler, isIncrement);
            }
        } else if (component.componentMetrics.containersReady.value() < component.componentMetrics.containersDesired.value()) {
            component.componentSpec.setState(org.apache.hadoop.yarn.service.api.records.ComponentState.FLEXING);
            if (curState != component.componentSpec.getState()) {
                LOG.info("[COMPONENT {}] state changed from {} -> {}", new Object[]{component.componentSpec.getName(), curState, component.componentSpec.getState()});
            }
            ServiceMaster.checkAndUpdateServiceState(component.scheduler, isIncrement);
        }
    }

    public void removePendingInstance(ComponentInstance instance) {
        this.pendingInstances.remove(instance);
    }

    public void reInsertPendingInstance(ComponentInstance instance) {
        this.pendingInstances.add(instance);
    }

    private void releaseContainer(Container container) {
        this.scheduler.getAmRMClient().releaseAssignedContainer(container.getId());
        this.componentMetrics.surplusContainers.incr();
        this.scheduler.getServiceMetrics().surplusContainers.incr();
    }

    private void assignContainerToCompInstance(Container container) {
        if (this.pendingInstances.size() == 0) {
            LOG.info("[COMPONENT {}]: No pending component instance left, release surplus container {}", (Object)this.getName(), (Object)container.getId());
            this.releaseContainer(container);
            return;
        }
        ComponentInstance instance = this.pendingInstances.remove(0);
        LOG.info("[COMPONENT {}]: {} allocated, num pending component instances reduced to {}", new Object[]{this.getName(), container.getId(), this.pendingInstances.size()});
        instance.setContainer(container);
        this.scheduler.addLiveCompInstance(container.getId(), instance);
        LOG.info("[COMPONENT {}]: Assigned {} to component instance {} and launch on host {} ", new Object[]{this.getName(), container.getId(), instance.getCompInstanceName(), container.getNodeId()});
        this.scheduler.getContainerLaunchService().launchCompInstance(this.scheduler.getApp(), instance, container);
    }

    public void requestContainers(long count) {
        Resource componentResource = this.componentSpec.getResource();
        org.apache.hadoop.yarn.api.records.Resource resource = org.apache.hadoop.yarn.api.records.Resource.newInstance((long)componentResource.calcMemoryMB(), (int)componentResource.getCpus());
        if (componentResource.getAdditional() != null) {
            for (Map.Entry<String, ResourceInformation> entry : componentResource.getAdditional().entrySet()) {
                String resourceName = entry.getKey();
                if (resourceName.equals("memory-mb") || resourceName.equals("vcores")) {
                    LOG.warn("Please set memory/vcore in the main section of resource, ignoring this entry=" + resourceName);
                    continue;
                }
                ResourceInformation specInfo = entry.getValue();
                org.apache.hadoop.yarn.api.records.ResourceInformation ri = org.apache.hadoop.yarn.api.records.ResourceInformation.newInstance((String)entry.getKey(), (String)specInfo.getUnit(), (long)specInfo.getValue());
                resource.setResourceInformation(resourceName, ri);
            }
        }
        int i = 0;
        while ((long)i < count) {
            AMRMClient.ContainerRequest request = AMRMClient.ContainerRequest.newBuilder().capability(resource).priority(this.priority).allocationRequestId(this.allocateId).relaxLocality(true).build();
            this.amrmClient.addContainerRequest(request);
            ++i;
        }
    }

    private void setDesiredContainers(int n) {
        int delta = n - this.scheduler.getServiceMetrics().containersDesired.value();
        if (delta > 0) {
            this.scheduler.getServiceMetrics().containersDesired.incr(delta);
        } else {
            this.scheduler.getServiceMetrics().containersDesired.decr(delta);
        }
        this.componentMetrics.containersDesired.set(n);
    }

    private void updateMetrics(ContainerStatus status) {
        switch (status.getExitStatus()) {
            case 0: {
                this.componentMetrics.containersSucceeded.incr();
                this.scheduler.getServiceMetrics().containersSucceeded.incr();
                return;
            }
            case -102: {
                this.componentMetrics.containersPreempted.incr();
                this.scheduler.getServiceMetrics().containersPreempted.incr();
                break;
            }
            case -101: {
                this.componentMetrics.containersDiskFailure.incr();
                this.scheduler.getServiceMetrics().containersDiskFailure.incr();
                break;
            }
        }
        this.componentMetrics.containersFailed.incr();
        this.scheduler.getServiceMetrics().containersFailed.incr();
        if (Apps.shouldCountTowardsNodeBlacklisting((int)status.getExitStatus())) {
            String host = this.scheduler.getLiveInstances().get(status.getContainerId()).getNodeId().getHost();
            this.failureTracker.incNodeFailure(host);
            this.currentContainerFailure.getAndIncrement();
        }
    }

    public boolean areDependenciesReady() {
        List<String> dependencies = this.componentSpec.getDependencies();
        if (ServiceUtils.isEmpty(dependencies)) {
            return true;
        }
        for (String dependency : dependencies) {
            Component dependentComponent = this.scheduler.getAllComponents().get(dependency);
            if (dependentComponent == null) {
                LOG.error("Couldn't find dependency {} for {} (should never happen)", (Object)dependency, (Object)this.getName());
                continue;
            }
            if (dependentComponent.getNumReadyInstances() >= dependentComponent.getNumDesiredInstances()) continue;
            LOG.info("[COMPONENT {}]: Dependency {} not satisfied, only {} of {} instances are ready.", new Object[]{this.getName(), dependency, dependentComponent.getNumReadyInstances(), dependentComponent.getNumDesiredInstances()});
            return false;
        }
        return true;
    }

    public Map<String, String> getDependencyHostIpTokens() {
        HashMap<String, String> tokens = new HashMap<String, String>();
        List<String> dependencies = this.componentSpec.getDependencies();
        if (ServiceUtils.isEmpty(dependencies)) {
            return tokens;
        }
        for (String dependency : dependencies) {
            Collection<ComponentInstance> instances = this.scheduler.getAllComponents().get(dependency).getAllComponentInstances();
            for (ComponentInstance instance : instances) {
                if (instance.getContainerStatus() == null || ServiceUtils.isEmpty(instance.getContainerStatus().getIPs()) || ServiceUtils.isUnset(instance.getContainerStatus().getHost())) continue;
                String ip = (String)instance.getContainerStatus().getIPs().get(0);
                String host = instance.getContainerStatus().getHost();
                tokens.put(String.format(ServiceApiConstants.COMPONENT_INSTANCE_IP, instance.getCompInstanceName().toUpperCase()), ip);
                tokens.put(String.format(ServiceApiConstants.COMPONENT_INSTANCE_HOST, instance.getCompInstanceName().toUpperCase()), host);
            }
        }
        return tokens;
    }

    public void incRunningContainers() {
        this.componentMetrics.containersRunning.incr();
        this.scheduler.getServiceMetrics().containersRunning.incr();
    }

    public void decRunningContainers() {
        this.componentMetrics.containersRunning.decr();
        this.scheduler.getServiceMetrics().containersRunning.decr();
    }

    public void incContainersReady() {
        this.componentMetrics.containersReady.incr();
        this.scheduler.getServiceMetrics().containersReady.incr();
        Component.checkAndUpdateComponentState(this, true);
    }

    public void decContainersReady() {
        this.componentMetrics.containersReady.decr();
        this.scheduler.getServiceMetrics().containersReady.decr();
        Component.checkAndUpdateComponentState(this, false);
    }

    public int getNumReadyInstances() {
        return this.componentMetrics.containersReady.value();
    }

    public int getNumRunningInstances() {
        return this.componentMetrics.containersRunning.value();
    }

    public int getNumDesiredInstances() {
        return this.componentMetrics.containersDesired.value();
    }

    public ComponentInstance getComponentInstance(String componentInstanceName) {
        return this.compInstances.get(componentInstanceName);
    }

    public Collection<ComponentInstance> getAllComponentInstances() {
        return this.compInstances.values();
    }

    public org.apache.hadoop.yarn.service.api.records.Component getComponentSpec() {
        return this.componentSpec;
    }

    public void resetCompFailureCount() {
        LOG.info("[COMPONENT {}]: Reset container failure count from {} to 0.", (Object)this.getName(), (Object)this.currentContainerFailure.get());
        this.currentContainerFailure.set(0);
        this.failureTracker.resetContainerFailures();
    }

    public Probe getProbe() {
        return this.probe;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public long getAllocateId() {
        return this.allocateId;
    }

    public String getName() {
        return this.componentSpec.getName();
    }

    public ComponentState getState() {
        this.readLock.lock();
        try {
            ComponentState componentState = (ComponentState)this.stateMachine.getCurrentState();
            return componentState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public ServiceScheduler getScheduler() {
        return this.scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ComponentEvent event) {
        try {
            this.writeLock.lock();
            ComponentState oldState = this.getState();
            try {
                this.stateMachine.doTransition((Enum)event.getType(), (Object)event);
            }
            catch (InvalidStateTransitionException e) {
                LOG.error(MessageFormat.format("[COMPONENT {0}]: Invalid event {1} at {2}", new Object[]{this.componentSpec.getName(), event.getType(), oldState}), (Throwable)e);
            }
            if (oldState != this.getState()) {
                LOG.info("[COMPONENT {}] Transitioned from {} to {} on {} event.", new Object[]{this.componentSpec.getName(), oldState, this.getState(), event.getType()});
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ServiceContext getContext() {
        return this.context;
    }

    public List<ComponentInstance> getPendingInstances() {
        return this.pendingInstances;
    }

    private static class BaseTransition
    implements SingleArcTransition<Component, ComponentEvent> {
        private BaseTransition() {
        }

        public void transition(Component component, ComponentEvent event) {
        }
    }

    private static class ContainerCompletedTransition
    extends BaseTransition {
        private ContainerCompletedTransition() {
        }

        @Override
        public void transition(Component component, ComponentEvent event) {
            component.updateMetrics(event.getStatus());
            component.dispatcher.getEventHandler().handle((Event)new ComponentInstanceEvent(event.getStatus().getContainerId(), ComponentInstanceEventType.STOP).setStatus(event.getStatus()));
            component.componentSpec.setState(org.apache.hadoop.yarn.service.api.records.ComponentState.FLEXING);
            component.getScheduler().getApp().setState(ServiceState.STARTED);
        }
    }

    private static class ContainerStartedTransition
    implements MultipleArcTransition<Component, ComponentEvent, ComponentState> {
        private ContainerStartedTransition() {
        }

        public ComponentState transition(Component component, ComponentEvent event) {
            component.dispatcher.getEventHandler().handle((Event)new ComponentInstanceEvent(event.getContainerId(), ComponentInstanceEventType.START));
            return Component.checkIfStable(component);
        }
    }

    private static class ContainerRecoveredTransition
    extends BaseTransition {
        private ContainerRecoveredTransition() {
        }

        @Override
        public void transition(Component component, ComponentEvent event) {
            ComponentInstance instance = event.getInstance();
            Container container = event.getContainer();
            if (instance == null) {
                LOG.info("[COMPONENT {}]: Trying to recover {} but event did not specify component instance", (Object)component.getName(), (Object)container.getId());
                component.releaseContainer(container);
                return;
            }
            component.pendingInstances.remove(instance);
            instance.setContainer(container);
            ProviderUtils.initCompInstanceDir(component.getContext().fs, instance);
            component.getScheduler().addLiveCompInstance(container.getId(), instance);
            LOG.info("[COMPONENT {}]: Recovered {} for component instance {} on host {}, num pending component instances reduced to {} ", new Object[]{component.getName(), container.getId(), instance.getCompInstanceName(), container.getNodeId(), component.pendingInstances.size()});
            component.dispatcher.getEventHandler().handle((Event)new ComponentInstanceEvent(container.getId(), ComponentInstanceEventType.START));
        }
    }

    private static class ContainerAllocatedTransition
    extends BaseTransition {
        private ContainerAllocatedTransition() {
        }

        @Override
        public void transition(Component component, ComponentEvent event) {
            component.assignContainerToCompInstance(event.getContainer());
        }
    }

    private static class FlexComponentTransition
    implements MultipleArcTransition<Component, ComponentEvent, ComponentState> {
        private FlexComponentTransition() {
        }

        public ComponentState transition(Component component, ComponentEvent event) {
            component.setDesiredContainers((int)event.getDesired());
            if (!component.areDependenciesReady()) {
                LOG.info("[FLEX COMPONENT {}]: Flex deferred because dependencies not satisfied.", (Object)component.getName());
                return component.getState();
            }
            if (component.getState() == ComponentState.INIT) {
                LOG.info("[INIT COMPONENT " + component.getName() + "]: " + event.getDesired() + " instances.");
                component.requestContainers(component.pendingInstances.size());
                return Component.checkIfStable(component);
            }
            long before = component.getComponentSpec().getNumberOfContainers();
            long delta = event.getDesired() - before;
            component.getComponentSpec().setNumberOfContainers(event.getDesired());
            if (delta > 0L) {
                LOG.info("[FLEX UP COMPONENT " + component.getName() + "]: scaling up from " + before + " to " + event.getDesired());
                component.requestContainers(delta);
                component.createNumCompInstances(delta);
                component.componentSpec.setState(org.apache.hadoop.yarn.service.api.records.ComponentState.FLEXING);
                component.getScheduler().getApp().setState(ServiceState.STARTED);
                return ComponentState.FLEXING;
            }
            if (delta < 0L) {
                delta = 0L - delta;
                LOG.info("[FLEX DOWN COMPONENT " + component.getName() + "]: scaling down from " + before + " to " + event.getDesired());
                ArrayList<ComponentInstance> list = new ArrayList<ComponentInstance>(component.getAllComponentInstances());
                list.sort(Collections.reverseOrder());
                int i = 0;
                while ((long)i < delta) {
                    ComponentInstance instance = (ComponentInstance)list.get(i);
                    component.compInstances.remove(instance.getCompInstanceName());
                    component.pendingInstances.remove(instance);
                    component.instanceIdCounter.decrementAndGet();
                    instance.destroy();
                    ++i;
                }
                Component.checkAndUpdateComponentState(component, false);
                return ComponentState.STABLE;
            }
            LOG.info("[FLEX COMPONENT " + component.getName() + "]: already has " + event.getDesired() + " instances, ignoring");
            return ComponentState.STABLE;
        }
    }
}

