/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.api.records;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Unstable
@ApiModel(description="Placement policy of an instance of an service. This feature is in the works in YARN-4902.")
public class PlacementPolicy
implements Serializable {
    private static final long serialVersionUID = 4341110649551172231L;
    private String label = null;

    public PlacementPolicy label(String label) {
        this.label = label;
        return this;
    }

    @ApiModelProperty(example="null", value="Assigns a service to a named partition of the cluster where the service desires to run (optional). If not specified all services are submitted to a default label of the service owner. One or more labels can be setup for each service owner account with required constraints like no-preemption, sla-99999, preemption-ok, etc.")
    @JsonProperty(value="label")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlacementPolicy placementPolicy = (PlacementPolicy)o;
        return Objects.equals(this.label, placementPolicy.label);
    }

    public int hashCode() {
        return Objects.hash(this.label);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PlacementPolicy {\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

