/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.security.client.ClientToAMTokenSecretManager;
import org.apache.hadoop.yarn.service.ClientAMService;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.ServiceScheduler;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.ComponentState;
import org.apache.hadoop.yarn.service.api.records.ServiceState;
import org.apache.hadoop.yarn.service.exceptions.BadClusterStateException;
import org.apache.hadoop.yarn.service.monitor.ServiceMonitor;
import org.apache.hadoop.yarn.service.utils.ServiceApiUtil;
import org.apache.hadoop.yarn.service.utils.ServiceUtils;
import org.apache.hadoop.yarn.service.utils.SliderFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceMaster
extends CompositeService {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceMaster.class);
    public static final String YARNFILE_OPTION = "yarnfile";
    private static String serviceDefPath;
    protected ServiceContext context;

    public ServiceMaster(String name) {
        super(name);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        ClientAMService clientAMService;
        SliderFileSystem fs;
        this.printSystemEnv();
        this.context = new ServiceContext();
        Path appDir = this.getAppDir();
        this.context.serviceHdfsDir = appDir.toString();
        this.context.fs = fs = new SliderFileSystem(conf);
        fs.setAppDir(appDir);
        this.loadApplicationJson(this.context, fs);
        if (UserGroupInformation.isSecurityEnabled()) {
            this.context.tokens = this.recordTokensForContainers();
            this.doSecureLogin();
        }
        for (Map.Entry<String, String> entry : this.context.service.getConfiguration().getProperties().entrySet()) {
            conf.set(entry.getKey(), entry.getValue());
        }
        ContainerId amContainerId = this.getAMContainerId();
        ApplicationAttemptId attemptId = amContainerId.getApplicationAttemptId();
        LOG.info("Service AppAttemptId: " + attemptId);
        this.context.attemptId = attemptId;
        conf.setLong("yarn.resourcemanager.connect.max-wait.ms", -1L);
        conf.unset("yarn.client.failover-max-attempts");
        DefaultMetricsSystem.initialize((String)"ServiceAppMaster");
        this.context.secretManager = new ClientToAMTokenSecretManager(attemptId, null);
        this.context.clientAMService = clientAMService = new ClientAMService(this.context);
        this.addService((Service)clientAMService);
        ServiceScheduler scheduler = this.createServiceScheduler(this.context);
        this.addService((Service)scheduler);
        this.context.scheduler = scheduler;
        ServiceMonitor monitor = new ServiceMonitor("Service Monitor", this.context);
        this.addService((Service)monitor);
        super.serviceInit(conf);
    }

    private ByteBuffer recordTokensForContainers() throws IOException {
        Credentials copy = new Credentials(UserGroupInformation.getCurrentUser().getCredentials());
        try (DataOutputBuffer dob = new DataOutputBuffer();){
            copy.writeTokenStorageToStream((DataOutputStream)dob);
        }
        Iterator iter = copy.getAllTokens().iterator();
        while (iter.hasNext()) {
            Token token = (Token)iter.next();
            LOG.info(token.toString());
            if (!token.getKind().equals((Object)AMRMTokenIdentifier.KIND_NAME)) continue;
            iter.remove();
        }
        return ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
    }

    private void doSecureLogin() throws IOException, URISyntaxException {
        File keytab = new File(String.format("keytabs/%s.keytab", this.context.service.getName()));
        if (!keytab.exists()) {
            URI uri;
            LOG.info("No keytab localized at " + keytab);
            String preInstalledKeytab = this.context.service.getKerberosPrincipal().getKeytab();
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)preInstalledKeytab) && (uri = new URI(preInstalledKeytab)).getScheme().equals("file")) {
                keytab = new File(uri);
                LOG.info("Using pre-installed keytab from localhost: " + preInstalledKeytab);
            }
        }
        if (!keytab.exists()) {
            LOG.info("No keytab exists: " + keytab);
            return;
        }
        String principal = this.context.service.getKerberosPrincipal().getPrincipalName();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)principal)) {
            principal = UserGroupInformation.getLoginUser().getShortUserName();
            LOG.info("No principal name specified.  Will use AM login identity {} to attempt keytab-based login", (Object)principal);
        }
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        LOG.info("User before logged in is: " + UserGroupInformation.getCurrentUser());
        String principalName = SecurityUtil.getServerPrincipal((String)principal, (String)ServiceUtils.getLocalHostName(this.getConfig()));
        UserGroupInformation.loginUserFromKeytab((String)principalName, (String)keytab.getAbsolutePath());
        UserGroupInformation.getCurrentUser().addCredentials(credentials);
        LOG.info("User after logged in is: " + UserGroupInformation.getCurrentUser());
        this.context.principal = principalName;
        this.context.keytab = keytab.getAbsolutePath();
        ServiceMaster.removeHdfsDelegationToken(UserGroupInformation.getLoginUser());
    }

    private static void removeHdfsDelegationToken(UserGroupInformation user) {
        if (!user.isFromKeytab()) {
            LOG.error("AM is not holding on a keytab in a secure deployment: service will fail when tokens expire");
        }
        Credentials credentials = user.getCredentials();
        Iterator iter = credentials.getAllTokens().iterator();
        while (iter.hasNext()) {
            Token token = (Token)iter.next();
            if (!token.getKind().equals((Object)DelegationTokenIdentifier.HDFS_DELEGATION_KIND)) continue;
            LOG.info("Remove HDFS delegation token {}.", (Object)token);
            iter.remove();
        }
    }

    protected ContainerId getAMContainerId() throws BadClusterStateException {
        return ContainerId.fromString((String)ServiceUtils.mandatoryEnvVariable(ApplicationConstants.Environment.CONTAINER_ID.name()));
    }

    protected Path getAppDir() {
        return new Path(serviceDefPath).getParent();
    }

    protected ServiceScheduler createServiceScheduler(ServiceContext context) throws IOException, YarnException {
        return new ServiceScheduler(context);
    }

    protected void loadApplicationJson(ServiceContext context, SliderFileSystem fs) throws IOException {
        context.service = ServiceApiUtil.loadServiceFrom(fs, new Path(serviceDefPath));
        context.service.setState(ServiceState.ACCEPTED);
        LOG.info(context.service.toString());
    }

    protected void serviceStart() throws Exception {
        LOG.info("Starting service as user " + UserGroupInformation.getCurrentUser());
        UserGroupInformation.getLoginUser().doAs(() -> {
            super.serviceStart();
            return null;
        });
    }

    protected void serviceStop() throws Exception {
        LOG.info("Stopping app master");
        super.serviceStop();
    }

    public static synchronized void checkAndUpdateServiceState(ServiceScheduler scheduler, boolean isIncrement) {
        ServiceState curState = scheduler.getApp().getState();
        if (!isIncrement) {
            scheduler.getApp().setState(ServiceState.STARTED);
        } else {
            boolean isStable = true;
            for (Component comp : scheduler.getApp().getComponents()) {
                if (comp.getState() == ComponentState.STABLE) continue;
                isStable = false;
                break;
            }
            if (isStable) {
                scheduler.getApp().setState(ServiceState.STABLE);
            } else if (curState == ServiceState.STABLE) {
                scheduler.getApp().setState(ServiceState.STARTED);
            }
        }
        if (curState != scheduler.getApp().getState()) {
            LOG.info("Service state changed from {} -> {}", (Object)curState, (Object)scheduler.getApp().getState());
        }
    }

    private void printSystemEnv() {
        for (Map.Entry<String, String> envs : System.getenv().entrySet()) {
            LOG.info("{} = {}", (Object)envs.getKey(), (Object)envs.getValue());
        }
    }

    public static void main(String[] args) throws Exception {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
        StringUtils.startupShutdownMessage(ServiceMaster.class, (String[])args, (Logger)LOG);
        try {
            ServiceMaster serviceMaster = new ServiceMaster("Service Master");
            ShutdownHookManager.get().addShutdownHook((Runnable)new CompositeService.CompositeServiceShutdownHook((CompositeService)serviceMaster), 30);
            YarnConfiguration conf = new YarnConfiguration();
            Options opts = new Options();
            opts.addOption(YARNFILE_OPTION, true, "HDFS path to JSON service specification");
            opts.getOption(YARNFILE_OPTION).setRequired(true);
            GenericOptionsParser parser = new GenericOptionsParser((Configuration)conf, opts, args);
            CommandLine cmdLine = parser.getCommandLine();
            serviceDefPath = cmdLine.getOptionValue(YARNFILE_OPTION);
            serviceMaster.init((Configuration)conf);
            serviceMaster.start();
        }
        catch (Throwable t) {
            LOG.error("Error starting service master", t);
            ExitUtil.terminate((int)1, (String)"Error starting service master");
        }
    }
}

