/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.proto.ClientAMProtocol;
import org.apache.hadoop.yarn.service.ClientAMPolicyProvider;
import org.apache.hadoop.yarn.service.ClientAMProtocol;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.component.ComponentEvent;
import org.apache.hadoop.yarn.service.component.ComponentEventType;
import org.apache.hadoop.yarn.service.utils.ServiceApiUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientAMService
extends AbstractService
implements ClientAMProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(ClientAMService.class);
    private ServiceContext context;
    private Server server;
    private InetSocketAddress bindAddress;

    public ClientAMService(ServiceContext context) {
        super("Client AM Service");
        this.context = context;
    }

    protected void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress address = new InetSocketAddress(0);
        this.server = rpc.getServer(ClientAMProtocol.class, (Object)this, address, conf, (SecretManager)this.context.secretManager, 1);
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.server.refreshServiceAcl(this.getConfig(), (PolicyProvider)new ClientAMPolicyProvider());
        }
        this.server.start();
        String nodeHostString = System.getenv(ApplicationConstants.Environment.NM_HOST.name());
        this.bindAddress = NetUtils.createSocketAddrForHost((String)nodeHostString, (int)this.server.getListenerAddress().getPort());
        LOG.info("Instantiated ClientAMService at " + this.bindAddress);
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        super.serviceStop();
    }

    @Override
    public ClientAMProtocol.FlexComponentsResponseProto flexComponents(ClientAMProtocol.FlexComponentsRequestProto request) throws IOException {
        if (!request.getComponentsList().isEmpty()) {
            for (ClientAMProtocol.ComponentCountProto component : request.getComponentsList()) {
                ComponentEvent event = new ComponentEvent(component.getName(), ComponentEventType.FLEX).setDesired(component.getNumberOfContainers());
                this.context.scheduler.getDispatcher().getEventHandler().handle((Event)event);
                LOG.info("Flexing component {} to {}", (Object)component.getName(), (Object)component.getNumberOfContainers());
            }
        }
        return ClientAMProtocol.FlexComponentsResponseProto.newBuilder().build();
    }

    @Override
    public ClientAMProtocol.GetStatusResponseProto getStatus(ClientAMProtocol.GetStatusRequestProto request) throws IOException, YarnException {
        String stat = ServiceApiUtil.jsonSerDeser.toJson(this.context.service);
        return ClientAMProtocol.GetStatusResponseProto.newBuilder().setStatus(stat).build();
    }

    @Override
    public ClientAMProtocol.StopResponseProto stop(ClientAMProtocol.StopRequestProto requestProto) throws IOException, YarnException {
        LOG.info("Stop the service by {}", (Object)UserGroupInformation.getCurrentUser());
        this.context.scheduler.getDiagnostics().append((CharSequence)("Stopped by user " + UserGroupInformation.getCurrentUser()));
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                    ExitUtil.terminate((int)0);
                }
                catch (InterruptedException e) {
                    LOG.error("Interrupted while stopping", (Throwable)e);
                }
            }
        };
        thread.start();
        return ClientAMProtocol.StopResponseProto.newBuilder().build();
    }

    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }
}

