/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.AccessControlException;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewReservationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewReservationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationPriorityRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.ReservationRequestInterpreter;
import org.apache.hadoop.yarn.api.records.ReservationRequests;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NodeLabelsUtils;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.NodeIDsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppAttemptsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppPriority;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppQueue;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppState;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ApplicationStatisticsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ApplicationSubmissionContextInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterMetricsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CredentialsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.DelegationToken;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.FairSchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.FifoSchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.LabelsToNodesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.LocalResourceInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NewApplication;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NewReservation;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeLabelInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeLabelsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeToLabelsEntry;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeToLabelsEntryList;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeToLabelsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationDefinitionInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationDeleteRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationDeleteResponseInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationListInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationRequestsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationSubmissionRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationUpdateRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationUpdateResponseInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.SchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.SchedulerTypeInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.StatisticsItemInfo;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.AdHocLogDumper;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.apache.hadoop.yarn.webapp.ForbiddenException;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

@Singleton
@Path(value="/ws/v1/cluster")
public class RMWebServices {
    private static final Log LOG = LogFactory.getLog((String)RMWebServices.class.getName());
    private static final String EMPTY = "";
    private static final String ANY = "*";
    private final ResourceManager rm;
    private static RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final Configuration conf;
    @Context
    private HttpServletResponse response;
    @VisibleForTesting
    boolean isCentralizedNodeLabelConfiguration = true;
    public static final String DELEGATION_TOKEN_HEADER = "Hadoop-YARN-RM-Delegation-Token";

    @Inject
    public RMWebServices(ResourceManager rm, Configuration conf) {
        this.rm = rm;
        this.conf = conf;
        this.isCentralizedNodeLabelConfiguration = YarnConfiguration.isCentralizedNodeLabelConfiguration((Configuration)conf);
    }

    RMWebServices(ResourceManager rm, Configuration conf, HttpServletResponse response) {
        this(rm, conf);
        this.response = response;
    }

    protected Boolean hasAccess(RMApp app, HttpServletRequest hsr) {
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        if (callerUGI != null && !this.rm.getApplicationACLsManager().checkAccess(callerUGI, ApplicationAccessType.VIEW_APP, app.getUser(), app.getApplicationId()) && !this.rm.getQueueACLsManager().checkAccess(callerUGI, QueueACL.ADMINISTER_QUEUE, app.getQueue())) {
            return false;
        }
        return true;
    }

    private void init() {
        this.response.setContentType(null);
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public ClusterInfo get() {
        return this.getClusterInfo();
    }

    @GET
    @Path(value="/info")
    @Produces(value={"application/json", "application/xml"})
    public ClusterInfo getClusterInfo() {
        this.init();
        return new ClusterInfo(this.rm);
    }

    @GET
    @Path(value="/metrics")
    @Produces(value={"application/json", "application/xml"})
    public ClusterMetricsInfo getClusterMetricsInfo() {
        this.init();
        return new ClusterMetricsInfo(this.rm);
    }

    @GET
    @Path(value="/scheduler")
    @Produces(value={"application/json", "application/xml"})
    public SchedulerTypeInfo getSchedulerInfo() {
        SchedulerInfo sinfo;
        this.init();
        ResourceScheduler rs = this.rm.getResourceScheduler();
        if (rs instanceof CapacityScheduler) {
            CapacityScheduler cs = (CapacityScheduler)rs;
            CSQueue root = cs.getRootQueue();
            sinfo = new CapacitySchedulerInfo(root, cs);
        } else if (rs instanceof FairScheduler) {
            FairScheduler fs = (FairScheduler)rs;
            sinfo = new FairSchedulerInfo(fs);
        } else if (rs instanceof FifoScheduler) {
            sinfo = new FifoSchedulerInfo(this.rm);
        } else {
            throw new NotFoundException("Unknown scheduler configured");
        }
        return new SchedulerTypeInfo(sinfo);
    }

    @POST
    @Path(value="/scheduler/logs")
    @Produces(value={"application/json", "application/xml"})
    public String dumpSchedulerLogs(@FormParam(value="time") String time, @Context HttpServletRequest hsr) throws IOException {
        this.init();
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        ApplicationACLsManager aclsManager = this.rm.getApplicationACLsManager();
        if (aclsManager.areACLsEnabled() && (callerUGI == null || !aclsManager.isAdmin(callerUGI))) {
            String msg = "Only admins can carry out this operation.";
            throw new ForbiddenException(msg);
        }
        ResourceScheduler rs = this.rm.getResourceScheduler();
        int period = Integer.parseInt(time);
        if (period <= 0) {
            throw new BadRequestException("Period must be greater than 0");
        }
        String logHierarchy = "org.apache.hadoop.yarn.server.resourcemanager.scheduler";
        String logfile = "yarn-scheduler-debug.log";
        if (rs instanceof CapacityScheduler) {
            logfile = "yarn-capacity-scheduler-debug.log";
        } else if (rs instanceof FairScheduler) {
            logfile = "yarn-fair-scheduler-debug.log";
        }
        AdHocLogDumper dumper = new AdHocLogDumper("org.apache.hadoop.yarn.server.resourcemanager.scheduler", logfile);
        dumper.dumpLogs("DEBUG", period * 1000);
        return "Capacity scheduler logs are being created.";
    }

    @GET
    @Path(value="/nodes")
    @Produces(value={"application/json", "application/xml"})
    public NodesInfo getNodes(@QueryParam(value="states") String states) {
        EnumSet<NodeState> acceptedStates;
        this.init();
        ResourceScheduler sched = this.rm.getResourceScheduler();
        if (sched == null) {
            throw new NotFoundException("Null ResourceScheduler instance");
        }
        if (states == null) {
            acceptedStates = EnumSet.allOf(NodeState.class);
        } else {
            acceptedStates = EnumSet.noneOf(NodeState.class);
            for (String stateStr : states.split(",")) {
                acceptedStates.add(NodeState.valueOf((String)StringUtils.toUpperCase((String)stateStr)));
            }
        }
        List<RMNode> rmNodes = RMServerUtils.queryRMNodes(this.rm.getRMContext(), acceptedStates);
        NodesInfo nodesInfo = new NodesInfo();
        for (RMNode rmNode : rmNodes) {
            NodeInfo nodeInfo = new NodeInfo(rmNode, sched);
            if (EnumSet.of(NodeState.LOST, NodeState.DECOMMISSIONED, NodeState.REBOOTED).contains(rmNode.getState())) {
                nodeInfo.setNodeHTTPAddress(EMPTY);
            }
            nodesInfo.add(nodeInfo);
        }
        return nodesInfo;
    }

    @GET
    @Path(value="/nodes/{nodeId}")
    @Produces(value={"application/json", "application/xml"})
    public NodeInfo getNode(@PathParam(value="nodeId") String nodeId) {
        this.init();
        if (nodeId == null || nodeId.isEmpty()) {
            throw new NotFoundException("nodeId, " + nodeId + ", is empty or null");
        }
        ResourceScheduler sched = this.rm.getResourceScheduler();
        if (sched == null) {
            throw new NotFoundException("Null ResourceScheduler instance");
        }
        NodeId nid = NodeId.fromString((String)nodeId);
        RMNode ni = (RMNode)this.rm.getRMContext().getRMNodes().get(nid);
        boolean isInactive = false;
        if (ni == null) {
            ni = (RMNode)this.rm.getRMContext().getInactiveRMNodes().get(nid);
            if (ni == null) {
                throw new NotFoundException("nodeId, " + nodeId + ", is not found");
            }
            isInactive = true;
        }
        NodeInfo nodeInfo = new NodeInfo(ni, sched);
        if (isInactive) {
            nodeInfo.setNodeHTTPAddress(EMPTY);
        }
        return nodeInfo;
    }

    @GET
    @Path(value="/apps")
    @Produces(value={"application/json", "application/xml"})
    public AppsInfo getApps(@Context HttpServletRequest hsr, @QueryParam(value="state") String stateQuery, @QueryParam(value="states") Set<String> statesQuery, @QueryParam(value="finalStatus") String finalStatusQuery, @QueryParam(value="user") String userQuery, @QueryParam(value="queue") String queueQuery, @QueryParam(value="limit") String count, @QueryParam(value="startedTimeBegin") String startedBegin, @QueryParam(value="startedTimeEnd") String startedEnd, @QueryParam(value="finishedTimeBegin") String finishBegin, @QueryParam(value="finishedTimeEnd") String finishEnd, @QueryParam(value="applicationTypes") Set<String> applicationTypes, @QueryParam(value="applicationTags") Set<String> applicationTags) {
        Set<String> appStates;
        Set<String> appTags;
        boolean checkCount = false;
        boolean checkStart = false;
        boolean checkEnd = false;
        boolean checkAppTypes = false;
        boolean checkAppStates = false;
        boolean checkAppTags = false;
        long countNum = 0L;
        long sBegin = 0L;
        long sEnd = Long.MAX_VALUE;
        long fBegin = 0L;
        long fEnd = Long.MAX_VALUE;
        this.init();
        if (count != null && !count.isEmpty()) {
            checkCount = true;
            countNum = Long.parseLong(count);
            if (countNum <= 0L) {
                throw new BadRequestException("limit value must be greater then 0");
            }
        }
        if (startedBegin != null && !startedBegin.isEmpty()) {
            checkStart = true;
            sBegin = Long.parseLong(startedBegin);
            if (sBegin < 0L) {
                throw new BadRequestException("startedTimeBegin must be greater than 0");
            }
        }
        if (startedEnd != null && !startedEnd.isEmpty()) {
            checkStart = true;
            sEnd = Long.parseLong(startedEnd);
            if (sEnd < 0L) {
                throw new BadRequestException("startedTimeEnd must be greater than 0");
            }
        }
        if (sBegin > sEnd) {
            throw new BadRequestException("startedTimeEnd must be greater than startTimeBegin");
        }
        if (finishBegin != null && !finishBegin.isEmpty()) {
            checkEnd = true;
            fBegin = Long.parseLong(finishBegin);
            if (fBegin < 0L) {
                throw new BadRequestException("finishTimeBegin must be greater than 0");
            }
        }
        if (finishEnd != null && !finishEnd.isEmpty()) {
            checkEnd = true;
            fEnd = Long.parseLong(finishEnd);
            if (fEnd < 0L) {
                throw new BadRequestException("finishTimeEnd must be greater than 0");
            }
        }
        if (fBegin > fEnd) {
            throw new BadRequestException("finishTimeEnd must be greater than finishTimeBegin");
        }
        Set<String> appTypes = RMWebServices.parseQueries(applicationTypes, false);
        if (!appTypes.isEmpty()) {
            checkAppTypes = true;
        }
        if (!(appTags = RMWebServices.parseQueries(applicationTags, false)).isEmpty()) {
            checkAppTags = true;
        }
        if (stateQuery != null && !stateQuery.isEmpty()) {
            statesQuery.add(stateQuery);
        }
        if (!(appStates = RMWebServices.parseQueries(statesQuery, true)).isEmpty()) {
            checkAppStates = true;
        }
        GetApplicationsRequest request = GetApplicationsRequest.newInstance();
        if (checkStart) {
            request.setStartRange(sBegin, sEnd);
        }
        if (checkEnd) {
            request.setFinishRange(fBegin, fEnd);
        }
        if (checkCount) {
            request.setLimit(countNum);
        }
        if (checkAppTypes) {
            request.setApplicationTypes(appTypes);
        }
        if (checkAppTags) {
            request.setApplicationTags(appTags);
        }
        if (checkAppStates) {
            request.setApplicationStates(appStates);
        }
        if (queueQuery != null && !queueQuery.isEmpty()) {
            ResourceScheduler rs = this.rm.getResourceScheduler();
            if (rs instanceof CapacityScheduler) {
                CapacityScheduler cs = (CapacityScheduler)rs;
                try {
                    cs.getQueueInfo(queueQuery, false, false);
                }
                catch (IOException e) {
                    throw new BadRequestException(e.getMessage());
                }
            }
            HashSet<String> queues = new HashSet<String>(1);
            queues.add(queueQuery);
            request.setQueues(queues);
        }
        if (userQuery != null && !userQuery.isEmpty()) {
            HashSet<String> users = new HashSet<String>(1);
            users.add(userQuery);
            request.setUsers(users);
        }
        List appReports = null;
        try {
            appReports = this.rm.getClientRMService().getApplications(request, false).getApplicationList();
        }
        catch (YarnException e) {
            LOG.error((Object)"Unable to retrieve apps from ClientRMService", (Throwable)e);
            throw new YarnRuntimeException("Unable to retrieve apps from ClientRMService", (Throwable)e);
        }
        ConcurrentMap<ApplicationId, RMApp> apps = this.rm.getRMContext().getRMApps();
        AppsInfo allApps = new AppsInfo();
        for (ApplicationReport report : appReports) {
            RMApp rmapp = (RMApp)apps.get(report.getApplicationId());
            if (rmapp == null) continue;
            if (finalStatusQuery != null && !finalStatusQuery.isEmpty()) {
                FinalApplicationStatus.valueOf((String)finalStatusQuery);
                if (!rmapp.getFinalApplicationStatus().toString().equalsIgnoreCase(finalStatusQuery)) continue;
            }
            AppInfo app = new AppInfo(this.rm, rmapp, this.hasAccess(rmapp, hsr), WebAppUtils.getHttpSchemePrefix((Configuration)this.conf));
            allApps.add(app);
        }
        return allApps;
    }

    @GET
    @Path(value="/appstatistics")
    @Produces(value={"application/json", "application/xml"})
    public ApplicationStatisticsInfo getAppStatistics(@Context HttpServletRequest hsr, @QueryParam(value="states") Set<String> stateQueries, @QueryParam(value="applicationTypes") Set<String> typeQueries) {
        this.init();
        Set<String> states = RMWebServices.parseQueries(stateQueries, true);
        Set<String> types = RMWebServices.parseQueries(typeQueries, false);
        if (types.size() == 0) {
            types.add(ANY);
        } else if (types.size() != 1) {
            throw new BadRequestException("# of applicationTypes = " + types.size() + ", we temporarily support at most one applicationType");
        }
        if (states.size() == 0) {
            for (YarnApplicationState state : YarnApplicationState.values()) {
                states.add(StringUtils.toLowerCase((String)state.toString()));
            }
        }
        Map<YarnApplicationState, Map<String, Long>> scoreboard = RMWebServices.buildScoreboard(states, types);
        ConcurrentMap<ApplicationId, RMApp> apps = this.rm.getRMContext().getRMApps();
        for (RMApp rmapp : apps.values()) {
            YarnApplicationState state = rmapp.createApplicationState();
            String type = StringUtils.toLowerCase((String)rmapp.getApplicationType().trim());
            if (!states.contains(StringUtils.toLowerCase((String)state.toString()))) continue;
            if (types.contains(ANY)) {
                RMWebServices.countApp(scoreboard, state, ANY);
                continue;
            }
            if (!types.contains(type)) continue;
            RMWebServices.countApp(scoreboard, state, type);
        }
        ApplicationStatisticsInfo appStatInfo = new ApplicationStatisticsInfo();
        for (Map.Entry<YarnApplicationState, Map<String, Long>> partScoreboard : scoreboard.entrySet()) {
            for (Map.Entry<String, Long> statEntry : partScoreboard.getValue().entrySet()) {
                StatisticsItemInfo statItem = new StatisticsItemInfo(partScoreboard.getKey(), statEntry.getKey(), statEntry.getValue());
                appStatInfo.add(statItem);
            }
        }
        return appStatInfo;
    }

    private static Set<String> parseQueries(Set<String> queries, boolean isState) {
        HashSet<String> params = new HashSet<String>();
        if (!queries.isEmpty()) {
            for (String query : queries) {
                String[] paramStrs;
                if (query == null || query.trim().isEmpty()) continue;
                for (String paramStr : paramStrs = query.split(",")) {
                    if (paramStr == null || paramStr.trim().isEmpty()) continue;
                    if (isState) {
                        try {
                            YarnApplicationState.valueOf((String)StringUtils.toUpperCase((String)paramStr.trim()));
                        }
                        catch (RuntimeException e) {
                            Object[] stateArray = YarnApplicationState.values();
                            String allAppStates = Arrays.toString(stateArray);
                            throw new BadRequestException("Invalid application-state " + paramStr.trim() + " specified. It should be one of " + allAppStates);
                        }
                    }
                    params.add(StringUtils.toLowerCase((String)paramStr.trim()));
                }
            }
        }
        return params;
    }

    private static Map<YarnApplicationState, Map<String, Long>> buildScoreboard(Set<String> states, Set<String> types) {
        HashMap<YarnApplicationState, Map<String, Long>> scoreboard = new HashMap<YarnApplicationState, Map<String, Long>>();
        assert (!states.isEmpty());
        for (String state : states) {
            HashMap<String, Long> partScoreboard = new HashMap<String, Long>();
            scoreboard.put(YarnApplicationState.valueOf((String)StringUtils.toUpperCase((String)state)), partScoreboard);
            for (String type : types) {
                partScoreboard.put(type, 0L);
            }
        }
        return scoreboard;
    }

    private static void countApp(Map<YarnApplicationState, Map<String, Long>> scoreboard, YarnApplicationState state, String type) {
        Map<String, Long> partScoreboard = scoreboard.get(state);
        Long count = partScoreboard.get(type);
        partScoreboard.put(type, count + 1L);
    }

    @GET
    @Path(value="/apps/{appid}")
    @Produces(value={"application/json", "application/xml"})
    public AppInfo getApp(@Context HttpServletRequest hsr, @PathParam(value="appid") String appId) {
        this.init();
        ApplicationId id = WebAppUtils.parseApplicationId((RecordFactory)recordFactory, (String)appId);
        RMApp app = (RMApp)this.rm.getRMContext().getRMApps().get(id);
        if (app == null) {
            throw new NotFoundException("app with id: " + appId + " not found");
        }
        return new AppInfo(this.rm, app, this.hasAccess(app, hsr), hsr.getScheme() + "://");
    }

    @GET
    @Path(value="/apps/{appid}/appattempts")
    @Produces(value={"application/json", "application/xml"})
    public AppAttemptsInfo getAppAttempts(@Context HttpServletRequest hsr, @PathParam(value="appid") String appId) {
        this.init();
        ApplicationId id = WebAppUtils.parseApplicationId((RecordFactory)recordFactory, (String)appId);
        RMApp app = (RMApp)this.rm.getRMContext().getRMApps().get(id);
        if (app == null) {
            throw new NotFoundException("app with id: " + appId + " not found");
        }
        AppAttemptsInfo appAttemptsInfo = new AppAttemptsInfo();
        for (RMAppAttempt attempt : app.getAppAttempts().values()) {
            AppAttemptInfo attemptInfo = new AppAttemptInfo(this.rm, attempt, app.getUser(), hsr.getScheme() + "://");
            appAttemptsInfo.add(attemptInfo);
        }
        return appAttemptsInfo;
    }

    @GET
    @Path(value="/apps/{appid}/state")
    @Produces(value={"application/json", "application/xml"})
    public AppState getAppState(@Context HttpServletRequest hsr, @PathParam(value="appid") String appId) throws AuthorizationException {
        this.init();
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        String userName = EMPTY;
        if (callerUGI != null) {
            userName = callerUGI.getUserName();
        }
        RMApp app = null;
        try {
            app = this.getRMAppForAppId(appId);
        }
        catch (NotFoundException e) {
            RMAuditLogger.logFailure(userName, "Get Application State", "UNKNOWN", "RMWebService", "Trying to get state of an absent application " + appId);
            throw e;
        }
        AppState ret = new AppState();
        ret.setState(app.getState().toString());
        return ret;
    }

    @PUT
    @Path(value="/apps/{appid}/state")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    public Response updateAppState(AppState targetState, @Context HttpServletRequest hsr, @PathParam(value="appid") String appId) throws AuthorizationException, YarnException, InterruptedException, IOException {
        this.init();
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        if (callerUGI == null) {
            String msg = "Unable to obtain user name, user not authenticated";
            throw new AuthorizationException(msg);
        }
        if (UserGroupInformation.isSecurityEnabled() && this.isStaticUser(callerUGI)) {
            String msg = "The default static user cannot carry out this operation.";
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)msg).build();
        }
        String userName = callerUGI.getUserName();
        RMApp app = null;
        try {
            app = this.getRMAppForAppId(appId);
        }
        catch (NotFoundException e) {
            RMAuditLogger.logFailure(userName, "Kill Application Request", "UNKNOWN", "RMWebService", "Trying to kill an absent application " + appId);
            throw e;
        }
        if (!app.getState().toString().equals(targetState.getState())) {
            if (targetState.getState().equals(YarnApplicationState.KILLED.toString())) {
                return this.killApp(app, callerUGI, hsr, targetState.getDiagnostics());
            }
            throw new BadRequestException("Only '" + YarnApplicationState.KILLED.toString() + "' is allowed as a target state.");
        }
        AppState ret = new AppState();
        ret.setState(app.getState().toString());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)ret).build();
    }

    @GET
    @Path(value="/get-node-to-labels")
    @Produces(value={"application/json", "application/xml"})
    public NodeToLabelsInfo getNodeToLabels(@Context HttpServletRequest hsr) throws IOException {
        this.init();
        NodeToLabelsInfo ntl = new NodeToLabelsInfo();
        HashMap<String, NodeLabelsInfo> ntlMap = ntl.getNodeToLabels();
        Map nodeIdToLabels = this.rm.getRMContext().getNodeLabelManager().getNodeLabelsInfo();
        for (Map.Entry nitle : nodeIdToLabels.entrySet()) {
            ArrayList<NodeLabel> labels = new ArrayList<NodeLabel>((Collection)nitle.getValue());
            ntlMap.put(((NodeId)nitle.getKey()).toString(), new NodeLabelsInfo((List<NodeLabel>)labels));
        }
        return ntl;
    }

    @GET
    @Path(value="/label-mappings")
    @Produces(value={"application/json", "application/xml"})
    public LabelsToNodesInfo getLabelsToNodes(@QueryParam(value="labels") Set<String> labels) throws IOException {
        this.init();
        LabelsToNodesInfo lts = new LabelsToNodesInfo();
        Map<NodeLabelInfo, NodeIDsInfo> ltsMap = lts.getLabelsToNodes();
        Map labelsToNodeId = null;
        labelsToNodeId = labels == null || labels.size() == 0 ? this.rm.getRMContext().getNodeLabelManager().getLabelsInfoToNodes() : this.rm.getRMContext().getNodeLabelManager().getLabelsInfoToNodes(labels);
        for (Map.Entry entry : labelsToNodeId.entrySet()) {
            ArrayList<String> nodeIdStrList = new ArrayList<String>();
            for (NodeId nodeId : (Set)entry.getValue()) {
                nodeIdStrList.add(nodeId.toString());
            }
            ltsMap.put(new NodeLabelInfo((NodeLabel)entry.getKey()), new NodeIDsInfo(nodeIdStrList));
        }
        return lts;
    }

    @POST
    @Path(value="/replace-node-to-labels")
    @Produces(value={"application/json", "application/xml"})
    public Response replaceLabelsOnNodes(NodeToLabelsEntryList newNodeToLabels, @Context HttpServletRequest hsr) throws IOException {
        HashMap<NodeId, Set<String>> nodeIdToLabels = new HashMap<NodeId, Set<String>>();
        for (NodeToLabelsEntry nitle : newNodeToLabels.getNodeToLabels()) {
            nodeIdToLabels.put(ConverterUtils.toNodeIdWithDefaultPort((String)nitle.getNodeId()), new HashSet<String>(nitle.getNodeLabels()));
        }
        return this.replaceLabelsOnNode(nodeIdToLabels, hsr, "/replace-node-to-labels");
    }

    @POST
    @Path(value="/nodes/{nodeId}/replace-labels")
    @Produces(value={"application/json", "application/xml"})
    public Response replaceLabelsOnNode(@QueryParam(value="labels") Set<String> newNodeLabelsName, @Context HttpServletRequest hsr, @PathParam(value="nodeId") String nodeId) throws Exception {
        NodeId nid = ConverterUtils.toNodeIdWithDefaultPort((String)nodeId);
        HashMap<NodeId, Set<String>> newLabelsForNode = new HashMap<NodeId, Set<String>>();
        newLabelsForNode.put(nid, new HashSet<String>(newNodeLabelsName));
        return this.replaceLabelsOnNode(newLabelsForNode, hsr, "/nodes/nodeid/replace-labels");
    }

    private Response replaceLabelsOnNode(Map<NodeId, Set<String>> newLabelsForNode, HttpServletRequest hsr, String operation) throws IOException {
        this.init();
        NodeLabelsUtils.verifyCentralizedNodeLabelConfEnabled("replaceLabelsOnNode", this.isCentralizedNodeLabelConfiguration);
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        if (callerUGI == null) {
            String msg = "Unable to obtain user name, user not authenticated for post to ..." + operation;
            throw new AuthorizationException(msg);
        }
        if (!this.rm.getRMContext().getNodeLabelManager().checkAccess(callerUGI)) {
            String msg = "User " + callerUGI.getShortUserName() + " not authorized" + " for post to ..." + operation;
            throw new AuthorizationException(msg);
        }
        try {
            this.rm.getRMContext().getNodeLabelManager().replaceLabelsOnNode(newLabelsForNode);
        }
        catch (IOException e) {
            throw new BadRequestException((Throwable)e);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/get-node-labels")
    @Produces(value={"application/json", "application/xml"})
    public NodeLabelsInfo getClusterNodeLabels(@Context HttpServletRequest hsr) throws IOException {
        this.init();
        List nodeLabels = this.rm.getRMContext().getNodeLabelManager().getClusterNodeLabels();
        NodeLabelsInfo ret = new NodeLabelsInfo(nodeLabels);
        return ret;
    }

    @POST
    @Path(value="/add-node-labels")
    @Produces(value={"application/json", "application/xml"})
    public Response addToClusterNodeLabels(NodeLabelsInfo newNodeLabels, @Context HttpServletRequest hsr) throws Exception {
        this.init();
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        if (callerUGI == null) {
            String msg = "Unable to obtain user name, user not authenticated for post to .../add-node-labels";
            throw new AuthorizationException(msg);
        }
        if (!this.rm.getRMContext().getNodeLabelManager().checkAccess(callerUGI)) {
            String msg = "User " + callerUGI.getShortUserName() + " not authorized" + " for post to .../add-node-labels ";
            throw new AuthorizationException(msg);
        }
        try {
            this.rm.getRMContext().getNodeLabelManager().addToCluserNodeLabels(newNodeLabels.getNodeLabels());
        }
        catch (IOException e) {
            throw new BadRequestException((Throwable)e);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="/remove-node-labels")
    @Produces(value={"application/json", "application/xml"})
    public Response removeFromCluserNodeLabels(@QueryParam(value="labels") Set<String> oldNodeLabels, @Context HttpServletRequest hsr) throws Exception {
        this.init();
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        if (callerUGI == null) {
            String msg = "Unable to obtain user name, user not authenticated for post to .../remove-node-labels";
            throw new AuthorizationException(msg);
        }
        if (!this.rm.getRMContext().getNodeLabelManager().checkAccess(callerUGI)) {
            String msg = "User " + callerUGI.getShortUserName() + " not authorized" + " for post to .../remove-node-labels ";
            throw new AuthorizationException(msg);
        }
        try {
            this.rm.getRMContext().getNodeLabelManager().removeFromClusterNodeLabels(new HashSet<String>(oldNodeLabels));
        }
        catch (IOException e) {
            throw new BadRequestException((Throwable)e);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/nodes/{nodeId}/get-labels")
    @Produces(value={"application/json", "application/xml"})
    public NodeLabelsInfo getLabelsOnNode(@Context HttpServletRequest hsr, @PathParam(value="nodeId") String nodeId) throws IOException {
        this.init();
        NodeId nid = ConverterUtils.toNodeIdWithDefaultPort((String)nodeId);
        ArrayList<NodeLabel> labels = new ArrayList<NodeLabel>(this.rm.getRMContext().getNodeLabelManager().getLabelsInfoByNode(nid));
        return new NodeLabelsInfo((List<NodeLabel>)labels);
    }

    protected Response killApp(RMApp app, UserGroupInformation callerUGI, HttpServletRequest hsr, final String diagnostic) throws IOException, InterruptedException {
        if (app == null) {
            throw new IllegalArgumentException("app cannot be null");
        }
        String userName = callerUGI.getUserName();
        final ApplicationId appid = app.getApplicationId();
        KillApplicationResponse resp = null;
        try {
            resp = (KillApplicationResponse)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<KillApplicationResponse>(){

                @Override
                public KillApplicationResponse run() throws IOException, YarnException {
                    KillApplicationRequest req = KillApplicationRequest.newInstance((ApplicationId)appid);
                    if (diagnostic != null) {
                        req.setDiagnostics(diagnostic);
                    }
                    return RMWebServices.this.rm.getClientRMService().forceKillApplication(req);
                }
            });
        }
        catch (UndeclaredThrowableException ue) {
            if (ue.getCause() instanceof YarnException) {
                YarnException ye = (YarnException)ue.getCause();
                if (ye.getCause() instanceof AccessControlException) {
                    String appId = app.getApplicationId().toString();
                    String msg = "Unauthorized attempt to kill appid " + appId + " by remote user " + userName;
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)msg).build();
                }
                throw ue;
            }
            throw ue;
        }
        AppState ret = new AppState();
        ret.setState(app.getState().toString());
        if (!resp.getIsKillCompleted()) {
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)ret).header("Location", (Object)hsr.getRequestURL()).build();
        }
        RMAuditLogger.logSuccess(userName, "Kill Application Request", "RMWebService", app.getApplicationId());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)ret).build();
    }

    @GET
    @Path(value="/apps/{appid}/priority")
    @Produces(value={"application/json", "application/xml"})
    public AppPriority getAppPriority(@Context HttpServletRequest hsr, @PathParam(value="appid") String appId) throws AuthorizationException {
        this.init();
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        String userName = "UNKNOWN-USER";
        if (callerUGI != null) {
            userName = callerUGI.getUserName();
        }
        RMApp app = null;
        try {
            app = this.getRMAppForAppId(appId);
        }
        catch (NotFoundException e) {
            RMAuditLogger.logFailure(userName, "Get Application Priority", "UNKNOWN", "RMWebService", "Trying to get priority of an absent application " + appId);
            throw e;
        }
        AppPriority ret = new AppPriority();
        ret.setPriority(app.getApplicationSubmissionContext().getPriority().getPriority());
        return ret;
    }

    @PUT
    @Path(value="/apps/{appid}/priority")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    public Response updateApplicationPriority(AppPriority targetPriority, @Context HttpServletRequest hsr, @PathParam(value="appid") String appId) throws AuthorizationException, YarnException, InterruptedException, IOException {
        this.init();
        if (targetPriority == null) {
            throw new YarnException("Target Priority cannot be null");
        }
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        if (callerUGI == null) {
            throw new AuthorizationException("Unable to obtain user name, user not authenticated");
        }
        if (UserGroupInformation.isSecurityEnabled() && this.isStaticUser(callerUGI)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"The default static user cannot carry out this operation.").build();
        }
        String userName = callerUGI.getUserName();
        RMApp app = null;
        try {
            app = this.getRMAppForAppId(appId);
        }
        catch (NotFoundException e) {
            RMAuditLogger.logFailure(userName, "Update Application Priority Request", "UNKNOWN", "RMWebService", "Trying to update priority an absent application " + appId);
            throw e;
        }
        Priority priority = app.getApplicationSubmissionContext().getPriority();
        if (priority == null || priority.getPriority() != targetPriority.getPriority()) {
            return this.modifyApplicationPriority(app, callerUGI, targetPriority.getPriority());
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)targetPriority).build();
    }

    private Response modifyApplicationPriority(final RMApp app, UserGroupInformation callerUGI, final int appPriority) throws IOException, InterruptedException {
        String userName = callerUGI.getUserName();
        try {
            callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException, YarnException {
                    Priority priority = Priority.newInstance((int)appPriority);
                    UpdateApplicationPriorityRequest request = UpdateApplicationPriorityRequest.newInstance((ApplicationId)app.getApplicationId(), (Priority)priority);
                    RMWebServices.this.rm.getClientRMService().updateApplicationPriority(request);
                    return null;
                }
            });
        }
        catch (UndeclaredThrowableException ue) {
            if (ue.getCause() instanceof YarnException) {
                YarnException ye = (YarnException)ue.getCause();
                if (ye.getCause() instanceof AccessControlException) {
                    String appId = app.getApplicationId().toString();
                    String msg = "Unauthorized attempt to change priority of appid " + appId + " by remote user " + userName;
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)msg).build();
                }
                if (ye.getMessage().startsWith("Application in") && ye.getMessage().endsWith("state cannot be update priority.")) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ye.getMessage()).build();
                }
                throw ue;
            }
            throw ue;
        }
        AppPriority ret = new AppPriority(app.getApplicationSubmissionContext().getPriority().getPriority());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)ret).build();
    }

    @GET
    @Path(value="/apps/{appid}/queue")
    @Produces(value={"application/json", "application/xml"})
    public AppQueue getAppQueue(@Context HttpServletRequest hsr, @PathParam(value="appid") String appId) throws AuthorizationException {
        this.init();
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        String userName = "UNKNOWN-USER";
        if (callerUGI != null) {
            userName = callerUGI.getUserName();
        }
        RMApp app = null;
        try {
            app = this.getRMAppForAppId(appId);
        }
        catch (NotFoundException e) {
            RMAuditLogger.logFailure(userName, "Get Application Queue", "UNKNOWN", "RMWebService", "Trying to get queue of an absent application " + appId);
            throw e;
        }
        AppQueue ret = new AppQueue();
        ret.setQueue(app.getQueue());
        return ret;
    }

    @PUT
    @Path(value="/apps/{appid}/queue")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    public Response updateAppQueue(AppQueue targetQueue, @Context HttpServletRequest hsr, @PathParam(value="appid") String appId) throws AuthorizationException, YarnException, InterruptedException, IOException {
        this.init();
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        if (callerUGI == null) {
            String msg = "Unable to obtain user name, user not authenticated";
            throw new AuthorizationException(msg);
        }
        if (UserGroupInformation.isSecurityEnabled() && this.isStaticUser(callerUGI)) {
            String msg = "The default static user cannot carry out this operation.";
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)msg).build();
        }
        String userName = callerUGI.getUserName();
        RMApp app = null;
        try {
            app = this.getRMAppForAppId(appId);
        }
        catch (NotFoundException e) {
            RMAuditLogger.logFailure(userName, "Move Application Request", "UNKNOWN", "RMWebService", "Trying to move an absent application " + appId);
            throw e;
        }
        if (!app.getQueue().equals(targetQueue.getQueue())) {
            return this.moveApp(app, callerUGI, targetQueue.getQueue());
        }
        AppQueue ret = new AppQueue();
        ret.setQueue(app.getQueue());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)ret).build();
    }

    protected Response moveApp(RMApp app, UserGroupInformation callerUGI, String targetQueue) throws IOException, InterruptedException {
        if (app == null) {
            throw new IllegalArgumentException("app cannot be null");
        }
        String userName = callerUGI.getUserName();
        final ApplicationId appid = app.getApplicationId();
        final String reqTargetQueue = targetQueue;
        try {
            callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException, YarnException {
                    MoveApplicationAcrossQueuesRequest req = MoveApplicationAcrossQueuesRequest.newInstance((ApplicationId)appid, (String)reqTargetQueue);
                    RMWebServices.this.rm.getClientRMService().moveApplicationAcrossQueues(req);
                    return null;
                }
            });
        }
        catch (UndeclaredThrowableException ue) {
            if (ue.getCause() instanceof YarnException) {
                YarnException ye = (YarnException)ue.getCause();
                if (ye.getCause() instanceof AccessControlException) {
                    String appId = app.getApplicationId().toString();
                    String msg = "Unauthorized attempt to move appid " + appId + " by remote user " + userName;
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)msg).build();
                }
                if (ye.getMessage().startsWith("App in") && ye.getMessage().endsWith("state cannot be moved.")) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ye.getMessage()).build();
                }
                throw ue;
            }
            throw ue;
        }
        AppQueue ret = new AppQueue();
        ret.setQueue(app.getQueue());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)ret).build();
    }

    private RMApp getRMAppForAppId(String appId) {
        ApplicationId id = WebAppUtils.parseApplicationId((RecordFactory)recordFactory, (String)appId);
        RMApp app = (RMApp)this.rm.getRMContext().getRMApps().get(id);
        if (app == null) {
            throw new NotFoundException("app with id: " + appId + " not found");
        }
        return app;
    }

    private UserGroupInformation getCallerUserGroupInformation(HttpServletRequest hsr, boolean usePrincipal) {
        String remoteUser = hsr.getRemoteUser();
        if (usePrincipal) {
            Principal princ = hsr.getUserPrincipal();
            remoteUser = princ == null ? null : princ.getName();
        }
        UserGroupInformation callerUGI = null;
        if (remoteUser != null) {
            callerUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
        }
        return callerUGI;
    }

    private boolean isStaticUser(UserGroupInformation callerUGI) {
        String staticUser = this.conf.get("hadoop.http.staticuser.user", "dr.who");
        return staticUser.equals(callerUGI.getUserName());
    }

    @POST
    @Path(value="/apps/new-application")
    @Produces(value={"application/json", "application/xml"})
    public Response createNewApplication(@Context HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        this.init();
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        if (callerUGI == null) {
            throw new AuthorizationException("Unable to obtain user name, user not authenticated");
        }
        if (UserGroupInformation.isSecurityEnabled() && this.isStaticUser(callerUGI)) {
            String msg = "The default static user cannot carry out this operation.";
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)msg).build();
        }
        NewApplication appId = this.createNewApplication();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)appId).build();
    }

    @POST
    @Path(value="/apps")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    public Response submitApplication(ApplicationSubmissionContextInfo newApp, @Context HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        this.init();
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        if (callerUGI == null) {
            throw new AuthorizationException("Unable to obtain user name, user not authenticated");
        }
        if (UserGroupInformation.isSecurityEnabled() && this.isStaticUser(callerUGI)) {
            String msg = "The default static user cannot carry out this operation.";
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)msg).build();
        }
        ApplicationSubmissionContext appContext = this.createAppSubmissionContext(newApp);
        final SubmitApplicationRequest req = SubmitApplicationRequest.newInstance((ApplicationSubmissionContext)appContext);
        try {
            callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<SubmitApplicationResponse>(){

                @Override
                public SubmitApplicationResponse run() throws IOException, YarnException {
                    return RMWebServices.this.rm.getClientRMService().submitApplication(req);
                }
            });
        }
        catch (UndeclaredThrowableException ue) {
            if (ue.getCause() instanceof YarnException) {
                throw new BadRequestException(ue.getCause().getMessage());
            }
            LOG.info((Object)"Submit app request failed", (Throwable)ue);
            throw ue;
        }
        String url = hsr.getRequestURL() + "/" + newApp.getApplicationId();
        return Response.status((Response.Status)Response.Status.ACCEPTED).header("Location", (Object)url).build();
    }

    private NewApplication createNewApplication() {
        GetNewApplicationResponse resp;
        GetNewApplicationRequest req = (GetNewApplicationRequest)recordFactory.newRecordInstance(GetNewApplicationRequest.class);
        try {
            resp = this.rm.getClientRMService().getNewApplication(req);
        }
        catch (YarnException e) {
            String msg = "Unable to create new app from RM web service";
            LOG.error((Object)msg, (Throwable)e);
            throw new YarnRuntimeException(msg, (Throwable)e);
        }
        NewApplication appId = new NewApplication(resp.getApplicationId().toString(), new ResourceInfo(resp.getMaximumResourceCapability()));
        return appId;
    }

    protected ApplicationSubmissionContext createAppSubmissionContext(ApplicationSubmissionContextInfo newApp) throws IOException {
        ApplicationId appid;
        String error = "Could not parse application id " + newApp.getApplicationId();
        try {
            appid = ApplicationId.fromString((String)newApp.getApplicationId());
        }
        catch (Exception e) {
            throw new BadRequestException(error);
        }
        ApplicationSubmissionContext appContext = ApplicationSubmissionContext.newInstance((ApplicationId)appid, (String)newApp.getApplicationName(), (String)newApp.getQueue(), (Priority)Priority.newInstance((int)newApp.getPriority()), (ContainerLaunchContext)this.createContainerLaunchContext(newApp), (boolean)newApp.getUnmanagedAM(), (boolean)newApp.getCancelTokensWhenComplete(), (int)newApp.getMaxAppAttempts(), (Resource)this.createAppSubmissionContextResource(newApp), (String)newApp.getApplicationType(), (boolean)newApp.getKeepContainersAcrossApplicationAttempts(), (String)newApp.getAppNodeLabelExpression(), (String)newApp.getAMContainerNodeLabelExpression());
        appContext.setApplicationTags(newApp.getApplicationTags());
        return appContext;
    }

    protected Resource createAppSubmissionContextResource(ApplicationSubmissionContextInfo newApp) throws BadRequestException {
        if (newApp.getResource().getvCores() > this.rm.getConfig().getInt("yarn.scheduler.maximum-allocation-vcores", 4)) {
            String msg = "Requested more cores than configured max";
            throw new BadRequestException(msg);
        }
        if (newApp.getResource().getMemorySize() > (long)this.rm.getConfig().getInt("yarn.scheduler.maximum-allocation-mb", 8192)) {
            String msg = "Requested more memory than configured max";
            throw new BadRequestException(msg);
        }
        Resource r = Resource.newInstance((long)newApp.getResource().getMemorySize(), (int)newApp.getResource().getvCores());
        return r;
    }

    protected ContainerLaunchContext createContainerLaunchContext(ApplicationSubmissionContextInfo newApp) throws BadRequestException, IOException {
        HashMap<String, ByteBuffer> hmap = new HashMap<String, ByteBuffer>();
        for (Map.Entry<String, String> entry : newApp.getContainerLaunchContextInfo().getAuxillaryServiceData().entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            Base64 decoder = new Base64(0, null, true);
            byte[] data = decoder.decode(entry.getValue());
            hmap.put(entry.getKey(), ByteBuffer.wrap(data));
        }
        HashMap<String, LocalResource> hlr = new HashMap<String, LocalResource>();
        for (Map.Entry<String, LocalResourceInfo> entry : newApp.getContainerLaunchContextInfo().getResources().entrySet()) {
            LocalResourceInfo l = entry.getValue();
            LocalResource lr = LocalResource.newInstance((URL)URL.fromURI((URI)l.getUrl()), (LocalResourceType)l.getType(), (LocalResourceVisibility)l.getVisibility(), (long)l.getSize(), (long)l.getTimestamp());
            hlr.put(entry.getKey(), lr);
        }
        DataOutputBuffer out = new DataOutputBuffer();
        Credentials cs = this.createCredentials(newApp.getContainerLaunchContextInfo().getCredentials());
        cs.writeTokenStorageToStream((DataOutputStream)out);
        ByteBuffer tokens = ByteBuffer.wrap(out.getData());
        ContainerLaunchContext ctx = ContainerLaunchContext.newInstance(hlr, newApp.getContainerLaunchContextInfo().getEnvironment(), newApp.getContainerLaunchContextInfo().getCommands(), hmap, (ByteBuffer)tokens, newApp.getContainerLaunchContextInfo().getAcls());
        return ctx;
    }

    private Credentials createCredentials(CredentialsInfo credentials) {
        Credentials ret = new Credentials();
        try {
            Text alias;
            for (Map.Entry<String, String> entry : credentials.getTokens().entrySet()) {
                alias = new Text(entry.getKey());
                Token token = new Token();
                token.decodeFromUrlString(entry.getValue());
                ret.addToken(alias, token);
            }
            for (Map.Entry<String, String> entry : credentials.getSecrets().entrySet()) {
                alias = new Text(entry.getKey());
                Base64 decoder = new Base64(0, null, true);
                byte[] secret = decoder.decode(entry.getValue());
                ret.addSecretKey(alias, secret);
            }
        }
        catch (IOException ie) {
            throw new BadRequestException("Could not parse credentials data; exception message = " + ie.getMessage());
        }
        return ret;
    }

    private UserGroupInformation createKerberosUserGroupInformation(HttpServletRequest hsr) throws AuthorizationException, YarnException {
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        if (callerUGI == null) {
            String msg = "Unable to obtain user name, user not authenticated";
            throw new AuthorizationException(msg);
        }
        String authType = hsr.getAuthType();
        if (!"kerberos".equalsIgnoreCase(authType)) {
            String msg = "Delegation token operations can only be carried out on a Kerberos authenticated channel. Expected auth type is kerberos, got type " + authType;
            throw new YarnException(msg);
        }
        if (hsr.getAttribute("hadoop.security.delegation-token.ugi") != null) {
            String msg = "Delegation token operations cannot be carried out using delegation token authentication.";
            throw new YarnException(msg);
        }
        callerUGI.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.KERBEROS);
        return callerUGI;
    }

    @POST
    @Path(value="/delegation-token")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    public Response postDelegationToken(DelegationToken tokenData, @Context HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException, Exception {
        UserGroupInformation callerUGI;
        this.init();
        try {
            callerUGI = this.createKerberosUserGroupInformation(hsr);
        }
        catch (YarnException ye) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ye.getMessage()).build();
        }
        return this.createDelegationToken(tokenData, hsr, callerUGI);
    }

    @POST
    @Path(value="/delegation-token/expiration")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    public Response postDelegationTokenExpiration(@Context HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException, Exception {
        UserGroupInformation callerUGI;
        this.init();
        try {
            callerUGI = this.createKerberosUserGroupInformation(hsr);
        }
        catch (YarnException ye) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ye.getMessage()).build();
        }
        DelegationToken requestToken = new DelegationToken();
        requestToken.setToken(this.extractToken(hsr).encodeToUrlString());
        return this.renewDelegationToken(requestToken, hsr, callerUGI);
    }

    private Response createDelegationToken(DelegationToken tokenData, HttpServletRequest hsr, UserGroupInformation callerUGI) throws AuthorizationException, IOException, InterruptedException, Exception {
        GetDelegationTokenResponse resp;
        final String renewer = tokenData.getRenewer();
        try {
            resp = (GetDelegationTokenResponse)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<GetDelegationTokenResponse>(){

                @Override
                public GetDelegationTokenResponse run() throws IOException, YarnException {
                    GetDelegationTokenRequest createReq = GetDelegationTokenRequest.newInstance((String)renewer);
                    return RMWebServices.this.rm.getClientRMService().getDelegationToken(createReq);
                }
            });
        }
        catch (Exception e) {
            LOG.info((Object)"Create delegation token request failed", (Throwable)e);
            throw e;
        }
        Token tk = new Token(resp.getRMDelegationToken().getIdentifier().array(), resp.getRMDelegationToken().getPassword().array(), new Text(resp.getRMDelegationToken().getKind()), new Text(resp.getRMDelegationToken().getService()));
        RMDelegationTokenIdentifier identifier = (RMDelegationTokenIdentifier)tk.decodeIdentifier();
        long currentExpiration = this.rm.getRMContext().getRMDelegationTokenSecretManager().getRenewDate(identifier);
        DelegationToken respToken = new DelegationToken(tk.encodeToUrlString(), renewer, identifier.getOwner().toString(), tk.getKind().toString(), currentExpiration, identifier.getMaxDate());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)respToken).build();
    }

    private Response renewDelegationToken(DelegationToken tokenData, HttpServletRequest hsr, UserGroupInformation callerUGI) throws AuthorizationException, IOException, InterruptedException, Exception {
        RenewDelegationTokenResponse resp;
        Token<RMDelegationTokenIdentifier> token = this.extractToken(tokenData.getToken());
        org.apache.hadoop.yarn.api.records.Token dToken = BuilderUtils.newDelegationToken((byte[])token.getIdentifier(), (String)token.getKind().toString(), (byte[])token.getPassword(), (String)token.getService().toString());
        final RenewDelegationTokenRequest req = RenewDelegationTokenRequest.newInstance((org.apache.hadoop.yarn.api.records.Token)dToken);
        try {
            resp = (RenewDelegationTokenResponse)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<RenewDelegationTokenResponse>(){

                @Override
                public RenewDelegationTokenResponse run() throws IOException, YarnException {
                    return RMWebServices.this.rm.getClientRMService().renewDelegationToken(req);
                }
            });
        }
        catch (UndeclaredThrowableException ue) {
            if (ue.getCause() instanceof YarnException) {
                if (ue.getCause().getCause() instanceof SecretManager.InvalidToken) {
                    throw new BadRequestException(ue.getCause().getCause().getMessage());
                }
                if (ue.getCause().getCause() instanceof org.apache.hadoop.security.AccessControlException) {
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ue.getCause().getCause().getMessage()).build();
                }
                LOG.info((Object)"Renew delegation token request failed", (Throwable)ue);
                throw ue;
            }
            LOG.info((Object)"Renew delegation token request failed", (Throwable)ue);
            throw ue;
        }
        catch (Exception e) {
            LOG.info((Object)"Renew delegation token request failed", (Throwable)e);
            throw e;
        }
        long renewTime = resp.getNextExpirationTime();
        DelegationToken respToken = new DelegationToken();
        respToken.setNextExpirationTime(renewTime);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)respToken).build();
    }

    @DELETE
    @Path(value="/delegation-token")
    @Produces(value={"application/json", "application/xml"})
    public Response cancelDelegationToken(@Context HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException, Exception {
        UserGroupInformation callerUGI;
        this.init();
        try {
            callerUGI = this.createKerberosUserGroupInformation(hsr);
        }
        catch (YarnException ye) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ye.getMessage()).build();
        }
        Token<RMDelegationTokenIdentifier> token = this.extractToken(hsr);
        org.apache.hadoop.yarn.api.records.Token dToken = BuilderUtils.newDelegationToken((byte[])token.getIdentifier(), (String)token.getKind().toString(), (byte[])token.getPassword(), (String)token.getService().toString());
        final CancelDelegationTokenRequest req = CancelDelegationTokenRequest.newInstance((org.apache.hadoop.yarn.api.records.Token)dToken);
        try {
            callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<CancelDelegationTokenResponse>(){

                @Override
                public CancelDelegationTokenResponse run() throws IOException, YarnException {
                    return RMWebServices.this.rm.getClientRMService().cancelDelegationToken(req);
                }
            });
        }
        catch (UndeclaredThrowableException ue) {
            if (ue.getCause() instanceof YarnException) {
                if (ue.getCause().getCause() instanceof SecretManager.InvalidToken) {
                    throw new BadRequestException(ue.getCause().getCause().getMessage());
                }
                if (ue.getCause().getCause() instanceof org.apache.hadoop.security.AccessControlException) {
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ue.getCause().getCause().getMessage()).build();
                }
                LOG.info((Object)"Renew delegation token request failed", (Throwable)ue);
                throw ue;
            }
            LOG.info((Object)"Renew delegation token request failed", (Throwable)ue);
            throw ue;
        }
        catch (Exception e) {
            LOG.info((Object)"Renew delegation token request failed", (Throwable)e);
            throw e;
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    private Token<RMDelegationTokenIdentifier> extractToken(HttpServletRequest request) {
        String encodedToken = request.getHeader(DELEGATION_TOKEN_HEADER);
        if (encodedToken == null) {
            String msg = "Header 'Hadoop-YARN-RM-Delegation-Token' containing encoded token not found";
            throw new BadRequestException(msg);
        }
        return this.extractToken(encodedToken);
    }

    private Token<RMDelegationTokenIdentifier> extractToken(String encodedToken) {
        Token token = new Token();
        try {
            token.decodeFromUrlString(encodedToken);
        }
        catch (Exception ie) {
            String msg = "Could not decode encoded token";
            throw new BadRequestException(msg);
        }
        return token;
    }

    @POST
    @Path(value="/reservation/new-reservation")
    @Produces(value={"application/json", "application/xml"})
    public Response createNewReservation(@Context HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        this.init();
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        if (callerUGI == null) {
            throw new AuthorizationException("Unable to obtain user name, user not authenticated");
        }
        if (UserGroupInformation.isSecurityEnabled() && this.isStaticUser(callerUGI)) {
            String msg = "The default static user cannot carry out this operation.";
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)msg).build();
        }
        NewReservation reservationId = this.createNewReservation();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)reservationId).build();
    }

    private NewReservation createNewReservation() throws IOException {
        GetNewReservationResponse resp;
        GetNewReservationRequest req = (GetNewReservationRequest)recordFactory.newRecordInstance(GetNewReservationRequest.class);
        try {
            resp = this.rm.getClientRMService().getNewReservation(req);
        }
        catch (YarnException e) {
            String msg = "Unable to create new reservation from RM web service";
            LOG.error((Object)msg, (Throwable)e);
            throw new YarnRuntimeException(msg, (Throwable)e);
        }
        NewReservation reservationId = new NewReservation(resp.getReservationId().toString());
        return reservationId;
    }

    @POST
    @Path(value="/reservation/submit")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    public Response submitReservation(ReservationSubmissionRequestInfo resContext, @Context HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        this.init();
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        if (callerUGI == null) {
            throw new AuthorizationException("Unable to obtain user name, user not authenticated");
        }
        if (UserGroupInformation.isSecurityEnabled() && this.isStaticUser(callerUGI)) {
            String msg = "The default static user cannot carry out this operation.";
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)msg).build();
        }
        final ReservationSubmissionRequest reservation = this.createReservationSubmissionRequest(resContext);
        try {
            callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ReservationSubmissionResponse>(){

                @Override
                public ReservationSubmissionResponse run() throws IOException, YarnException {
                    return RMWebServices.this.rm.getClientRMService().submitReservation(reservation);
                }
            });
        }
        catch (UndeclaredThrowableException ue) {
            if (ue.getCause() instanceof YarnException) {
                throw new BadRequestException(ue.getCause().getMessage());
            }
            LOG.info((Object)"Submit reservation request failed", (Throwable)ue);
            throw ue;
        }
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    private ReservationSubmissionRequest createReservationSubmissionRequest(ReservationSubmissionRequestInfo resContext) throws IOException {
        if (resContext == null) {
            throw new BadRequestException("Input ReservationSubmissionContext should not be null");
        }
        ReservationDefinitionInfo resInfo = resContext.getReservationDefinition();
        if (resInfo == null) {
            throw new BadRequestException("Input ReservationDefinition should not be null");
        }
        ReservationRequestsInfo resReqsInfo = resInfo.getReservationRequests();
        if (resReqsInfo == null || resReqsInfo.getReservationRequest() == null || resReqsInfo.getReservationRequest().size() == 0) {
            throw new BadRequestException("The ReservationDefinition should contain at least one ReservationRequest");
        }
        ReservationRequestInterpreter[] values = ReservationRequestInterpreter.values();
        ReservationRequestInterpreter resInt = values[resReqsInfo.getReservationRequestsInterpreter()];
        ArrayList<ReservationRequest> list = new ArrayList<ReservationRequest>();
        for (ReservationRequestInfo resReqInfo : resReqsInfo.getReservationRequest()) {
            ResourceInfo rInfo = resReqInfo.getCapability();
            Resource capability = Resource.newInstance((long)rInfo.getMemorySize(), (int)rInfo.getvCores());
            int numContainers = resReqInfo.getNumContainers();
            int minConcurrency = resReqInfo.getMinConcurrency();
            long duration = resReqInfo.getDuration();
            ReservationRequest rr = ReservationRequest.newInstance((Resource)capability, (int)numContainers, (int)minConcurrency, (long)duration);
            list.add(rr);
        }
        ReservationRequests reqs = ReservationRequests.newInstance(list, (ReservationRequestInterpreter)resInt);
        ReservationDefinition rDef = ReservationDefinition.newInstance((long)resInfo.getArrival(), (long)resInfo.getDeadline(), (ReservationRequests)reqs, (String)resInfo.getReservationName());
        ReservationId reservationId = ReservationId.parseReservationId((String)resContext.getReservationId());
        ReservationSubmissionRequest request = ReservationSubmissionRequest.newInstance((ReservationDefinition)rDef, (String)resContext.getQueue(), (ReservationId)reservationId);
        return request;
    }

    @POST
    @Path(value="/reservation/update")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    public Response updateReservation(ReservationUpdateRequestInfo resContext, @Context HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        ReservationUpdateResponseInfo resRespInfo;
        this.init();
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        if (callerUGI == null) {
            throw new AuthorizationException("Unable to obtain user name, user not authenticated");
        }
        if (UserGroupInformation.isSecurityEnabled() && this.isStaticUser(callerUGI)) {
            String msg = "The default static user cannot carry out this operation.";
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)msg).build();
        }
        final ReservationUpdateRequest reservation = this.createReservationUpdateRequest(resContext);
        try {
            resRespInfo = (ReservationUpdateResponseInfo)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ReservationUpdateResponseInfo>(){

                @Override
                public ReservationUpdateResponseInfo run() throws IOException, YarnException {
                    RMWebServices.this.rm.getClientRMService().updateReservation(reservation);
                    return new ReservationUpdateResponseInfo();
                }
            });
        }
        catch (UndeclaredThrowableException ue) {
            if (ue.getCause() instanceof YarnException) {
                throw new BadRequestException(ue.getCause().getMessage());
            }
            LOG.info((Object)"Update reservation request failed", (Throwable)ue);
            throw ue;
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)resRespInfo).build();
    }

    private ReservationUpdateRequest createReservationUpdateRequest(ReservationUpdateRequestInfo resContext) throws IOException {
        if (resContext == null) {
            throw new BadRequestException("Input ReservationSubmissionContext should not be null");
        }
        ReservationDefinitionInfo resInfo = resContext.getReservationDefinition();
        if (resInfo == null) {
            throw new BadRequestException("Input ReservationDefinition should not be null");
        }
        ReservationRequestsInfo resReqsInfo = resInfo.getReservationRequests();
        if (resReqsInfo == null || resReqsInfo.getReservationRequest() == null || resReqsInfo.getReservationRequest().size() == 0) {
            throw new BadRequestException("The ReservationDefinition should contain at least one ReservationRequest");
        }
        if (resContext.getReservationId() == null) {
            throw new BadRequestException("Update operations must specify an existing ReservaitonId");
        }
        ReservationRequestInterpreter[] values = ReservationRequestInterpreter.values();
        ReservationRequestInterpreter resInt = values[resReqsInfo.getReservationRequestsInterpreter()];
        ArrayList<ReservationRequest> list = new ArrayList<ReservationRequest>();
        for (ReservationRequestInfo resReqInfo : resReqsInfo.getReservationRequest()) {
            ResourceInfo rInfo = resReqInfo.getCapability();
            Resource capability = Resource.newInstance((long)rInfo.getMemorySize(), (int)rInfo.getvCores());
            int numContainers = resReqInfo.getNumContainers();
            int minConcurrency = resReqInfo.getMinConcurrency();
            long duration = resReqInfo.getDuration();
            ReservationRequest rr = ReservationRequest.newInstance((Resource)capability, (int)numContainers, (int)minConcurrency, (long)duration);
            list.add(rr);
        }
        ReservationRequests reqs = ReservationRequests.newInstance(list, (ReservationRequestInterpreter)resInt);
        ReservationDefinition rDef = ReservationDefinition.newInstance((long)resInfo.getArrival(), (long)resInfo.getDeadline(), (ReservationRequests)reqs, (String)resInfo.getReservationName());
        ReservationUpdateRequest request = ReservationUpdateRequest.newInstance((ReservationDefinition)rDef, (ReservationId)ReservationId.parseReservationId((String)resContext.getReservationId()));
        return request;
    }

    @POST
    @Path(value="/reservation/delete")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    public Response deleteReservation(ReservationDeleteRequestInfo resContext, @Context HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        ReservationDeleteResponseInfo resRespInfo;
        this.init();
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        if (callerUGI == null) {
            throw new AuthorizationException("Unable to obtain user name, user not authenticated");
        }
        if (UserGroupInformation.isSecurityEnabled() && this.isStaticUser(callerUGI)) {
            String msg = "The default static user cannot carry out this operation.";
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)msg).build();
        }
        final ReservationDeleteRequest reservation = this.createReservationDeleteRequest(resContext);
        try {
            resRespInfo = (ReservationDeleteResponseInfo)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ReservationDeleteResponseInfo>(){

                @Override
                public ReservationDeleteResponseInfo run() throws IOException, YarnException {
                    RMWebServices.this.rm.getClientRMService().deleteReservation(reservation);
                    return new ReservationDeleteResponseInfo();
                }
            });
        }
        catch (UndeclaredThrowableException ue) {
            if (ue.getCause() instanceof YarnException) {
                throw new BadRequestException(ue.getCause().getMessage());
            }
            LOG.info((Object)"Update reservation request failed", (Throwable)ue);
            throw ue;
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)resRespInfo).build();
    }

    private ReservationDeleteRequest createReservationDeleteRequest(ReservationDeleteRequestInfo resContext) throws IOException {
        ReservationDeleteRequest request = ReservationDeleteRequest.newInstance((ReservationId)ReservationId.parseReservationId((String)resContext.getReservationId()));
        return request;
    }

    @GET
    @Path(value="/reservation/list")
    @Produces(value={"application/json", "application/xml"})
    public Response listReservation(@QueryParam(value="queue") @DefaultValue(value="default") String queue, @QueryParam(value="reservation-id") @DefaultValue(value="") String reservationId, @QueryParam(value="start-time") @DefaultValue(value="0") long startTime, @QueryParam(value="end-time") @DefaultValue(value="-1") long endTime, @QueryParam(value="include-resource-allocations") @DefaultValue(value="false") boolean includeResourceAllocations, @Context HttpServletRequest hsr) throws Exception {
        ReservationListResponse resRespInfo;
        this.init();
        final ReservationListRequest request = ReservationListRequest.newInstance((String)queue, (String)reservationId, (long)startTime, (long)endTime, (boolean)includeResourceAllocations);
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        if (callerUGI == null) {
            throw new AuthorizationException("Unable to obtain user name, user not authenticated");
        }
        if (UserGroupInformation.isSecurityEnabled() && this.isStaticUser(callerUGI)) {
            String msg = "The default static user cannot carry out this operation.";
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)msg).build();
        }
        try {
            resRespInfo = (ReservationListResponse)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ReservationListResponse>(){

                @Override
                public ReservationListResponse run() throws IOException, YarnException {
                    return RMWebServices.this.rm.getClientRMService().listReservations(request);
                }
            });
        }
        catch (UndeclaredThrowableException ue) {
            if (ue.getCause() instanceof YarnException) {
                throw new BadRequestException(ue.getCause().getMessage());
            }
            LOG.info((Object)"List reservation request failed", (Throwable)ue);
            throw ue;
        }
        ReservationListInfo resResponse = new ReservationListInfo(resRespInfo, includeResourceAllocations);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)resResponse).build();
    }
}

