/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;

@Metrics(context="yarn")
public class FSQueueMetrics
extends QueueMetrics {
    @Metric(value={"Fair share of memory in MB"})
    MutableGaugeLong fairShareMB;
    @Metric(value={"Fair share of CPU in vcores"})
    MutableGaugeLong fairShareVCores;
    @Metric(value={"Steady fair share of memory in MB"})
    MutableGaugeLong steadyFairShareMB;
    @Metric(value={"Steady fair share of CPU in vcores"})
    MutableGaugeLong steadyFairShareVCores;
    @Metric(value={"Minimum share of memory in MB"})
    MutableGaugeLong minShareMB;
    @Metric(value={"Minimum share of CPU in vcores"})
    MutableGaugeLong minShareVCores;
    @Metric(value={"Maximum share of memory in MB"})
    MutableGaugeLong maxShareMB;
    @Metric(value={"Maximum share of CPU in vcores"})
    MutableGaugeLong maxShareVCores;

    FSQueueMetrics(MetricsSystem ms, String queueName, Queue parent, boolean enableUserMetrics, Configuration conf) {
        super(ms, queueName, parent, enableUserMetrics, conf);
    }

    public void setFairShare(Resource resource) {
        this.fairShareMB.set(resource.getMemorySize());
        this.fairShareVCores.set((long)resource.getVirtualCores());
    }

    public long getFairShareMB() {
        return this.fairShareMB.value();
    }

    public long getFairShareVirtualCores() {
        return this.fairShareVCores.value();
    }

    public void setSteadyFairShare(Resource resource) {
        this.steadyFairShareMB.set(resource.getMemorySize());
        this.steadyFairShareVCores.set((long)resource.getVirtualCores());
    }

    public long getSteadyFairShareMB() {
        return this.steadyFairShareMB.value();
    }

    public long getSteadyFairShareVCores() {
        return this.steadyFairShareVCores.value();
    }

    public void setMinShare(Resource resource) {
        this.minShareMB.set(resource.getMemorySize());
        this.minShareVCores.set((long)resource.getVirtualCores());
    }

    public long getMinShareMB() {
        return this.minShareMB.value();
    }

    public long getMinShareVirtualCores() {
        return this.minShareVCores.value();
    }

    public void setMaxShare(Resource resource) {
        this.maxShareMB.set(resource.getMemorySize());
        this.maxShareVCores.set((long)resource.getVirtualCores());
    }

    public long getMaxShareMB() {
        return this.maxShareMB.value();
    }

    public long getMaxShareVirtualCores() {
        return this.maxShareVCores.value();
    }

    public static synchronized FSQueueMetrics forQueue(String queueName, Queue parent, boolean enableUserMetrics, Configuration conf) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        QueueMetrics metrics = (QueueMetrics)queueMetrics.get(queueName);
        if (metrics == null) {
            metrics = new FSQueueMetrics(ms, queueName, parent, enableUserMetrics, conf).tag(QUEUE_INFO, queueName);
            if (ms != null) {
                metrics = (QueueMetrics)ms.register(FSQueueMetrics.sourceName(queueName).toString(), "Metrics for queue: " + queueName, (Object)metrics);
            }
            queueMetrics.put(queueName, metrics);
        }
        return (FSQueueMetrics)metrics;
    }
}

