/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.registry.client.binding.RegistryPathUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainerLaunch;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerModule;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.LinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.LinuxContainerRuntimeConstants;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerClient;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerCommandExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerInspectCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerKillCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerRmCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerRunCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerStopCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerVolumeCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.DockerCommandPlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.ResourcePlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerExecutionException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerRuntimeContext;
import org.apache.hadoop.yarn.util.DockerClientConfigHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DockerLinuxContainerRuntime
implements LinuxContainerRuntime {
    private static final Logger LOG = LoggerFactory.getLogger(DockerLinuxContainerRuntime.class);
    public static final String DOCKER_IMAGE_PATTERN = "^(([a-zA-Z0-9.-]+)(:\\d+)?/)?([a-z0-9_./-]+)(:[\\w.-]+)?$";
    private static final Pattern dockerImagePattern = Pattern.compile("^(([a-zA-Z0-9.-]+)(:\\d+)?/)?([a-z0-9_./-]+)(:[\\w.-]+)?$");
    public static final String HOSTNAME_PATTERN = "^[a-zA-Z0-9][a-zA-Z0-9_.-]+$";
    private static final Pattern hostnamePattern = Pattern.compile("^[a-zA-Z0-9][a-zA-Z0-9_.-]+$");
    private static final Pattern USER_MOUNT_PATTERN = Pattern.compile("(?<=^|,)([^:\\x00]+):([^:\\x00]+):([a-z]+)");
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_IMAGE = "YARN_CONTAINER_RUNTIME_DOCKER_IMAGE";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_IMAGE_FILE = "YARN_CONTAINER_RUNTIME_DOCKER_IMAGE_FILE";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_RUN_OVERRIDE_DISABLE = "YARN_CONTAINER_RUNTIME_DOCKER_RUN_OVERRIDE_DISABLE";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_NETWORK = "YARN_CONTAINER_RUNTIME_DOCKER_CONTAINER_NETWORK";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_PID_NAMESPACE = "YARN_CONTAINER_RUNTIME_DOCKER_CONTAINER_PID_NAMESPACE";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_HOSTNAME = "YARN_CONTAINER_RUNTIME_DOCKER_CONTAINER_HOSTNAME";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_RUN_PRIVILEGED_CONTAINER = "YARN_CONTAINER_RUNTIME_DOCKER_RUN_PRIVILEGED_CONTAINER";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_RUN_ENABLE_USER_REMAPPING = "YARN_CONTAINER_RUNTIME_DOCKER_RUN_ENABLE_USER_REMAPPING";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_LOCAL_RESOURCE_MOUNTS = "YARN_CONTAINER_RUNTIME_DOCKER_LOCAL_RESOURCE_MOUNTS";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_MOUNTS = "YARN_CONTAINER_RUNTIME_DOCKER_MOUNTS";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_DELAYED_REMOVAL = "YARN_CONTAINER_RUNTIME_DOCKER_DELAYED_REMOVAL";
    private Configuration conf;
    private Context nmContext;
    private DockerClient dockerClient;
    private PrivilegedOperationExecutor privilegedOperationExecutor;
    private Set<String> allowedNetworks = new HashSet<String>();
    private String defaultNetwork;
    private CGroupsHandler cGroupsHandler;
    private AccessControlList privilegedContainersAcl;
    private boolean enableUserReMapping;
    private int userRemappingUidThreshold;
    private int userRemappingGidThreshold;
    private Set<String> capabilities;
    private boolean delayedRemovalAllowed;

    public static boolean isDockerContainerRequested(Map<String, String> env) {
        if (env == null) {
            return false;
        }
        String type = env.get("YARN_CONTAINER_RUNTIME_TYPE");
        return type != null && type.equals("docker");
    }

    public DockerLinuxContainerRuntime(PrivilegedOperationExecutor privilegedOperationExecutor) {
        this(privilegedOperationExecutor, ResourceHandlerModule.getCGroupsHandler());
    }

    @VisibleForTesting
    public DockerLinuxContainerRuntime(PrivilegedOperationExecutor privilegedOperationExecutor, CGroupsHandler cGroupsHandler) {
        this.privilegedOperationExecutor = privilegedOperationExecutor;
        if (cGroupsHandler == null) {
            LOG.info("cGroupsHandler is null - cgroups not in use.");
        } else {
            this.cGroupsHandler = cGroupsHandler;
        }
    }

    @Override
    public void initialize(Configuration conf, Context nmContext) throws ContainerExecutionException {
        this.nmContext = nmContext;
        this.conf = conf;
        this.dockerClient = new DockerClient(conf);
        this.allowedNetworks.clear();
        this.allowedNetworks.addAll(Arrays.asList(conf.getTrimmedStrings("yarn.nodemanager.runtime.linux.docker.allowed-container-networks", YarnConfiguration.DEFAULT_NM_DOCKER_ALLOWED_CONTAINER_NETWORKS)));
        this.defaultNetwork = conf.getTrimmed("yarn.nodemanager.runtime.linux.docker.default-container-network", "host");
        if (!this.allowedNetworks.contains(this.defaultNetwork)) {
            String message = "Default network: " + this.defaultNetwork + " is not in the set of allowed networks: " + this.allowedNetworks;
            if (LOG.isWarnEnabled()) {
                LOG.warn(message + ". Please check configuration");
            }
            throw new ContainerExecutionException(message);
        }
        this.privilegedContainersAcl = new AccessControlList(conf.getTrimmed("yarn.nodemanager.runtime.linux.docker.privileged-containers.acl", ""));
        this.enableUserReMapping = conf.getBoolean("yarn.nodemanager.runtime.linux.docker.enable-userremapping.allowed", true);
        this.userRemappingUidThreshold = conf.getInt("yarn.nodemanager.runtime.linux.docker.userremapping-uid-threshold", 1);
        this.userRemappingGidThreshold = conf.getInt("yarn.nodemanager.runtime.linux.docker.userremapping-gid-threshold", 1);
        this.capabilities = this.getDockerCapabilitiesFromConf();
        this.delayedRemovalAllowed = conf.getBoolean("yarn.nodemanager.runtime.linux.docker.delayed-removal.allowed", false);
    }

    private Set<String> getDockerCapabilitiesFromConf() throws ContainerExecutionException {
        Set<String> caps = new HashSet<String>(Arrays.asList(this.conf.getTrimmedStrings("yarn.nodemanager.runtime.linux.docker.capabilities", YarnConfiguration.DEFAULT_NM_DOCKER_CONTAINER_CAPABILITIES)));
        if (caps.contains("none") || caps.contains("NONE")) {
            if (caps.size() > 1) {
                String msg = "Mixing capabilities with the none keyword is not supported";
                throw new ContainerExecutionException(msg);
            }
            caps = Collections.emptySet();
        }
        return caps;
    }

    public Set<String> getCapabilities() {
        return this.capabilities;
    }

    private String runDockerVolumeCommand(DockerVolumeCommand dockerVolumeCommand, Container container) throws ContainerExecutionException {
        try {
            String commandFile = this.dockerClient.writeCommandToTempFile(dockerVolumeCommand, container.getContainerId().toString());
            PrivilegedOperation privOp = new PrivilegedOperation(PrivilegedOperation.OperationType.RUN_DOCKER_CMD);
            privOp.appendArgs(commandFile);
            String output = this.privilegedOperationExecutor.executePrivilegedOperation(null, privOp, null, null, true, false);
            LOG.info("ContainerId=" + container.getContainerId() + ", docker volume output for " + dockerVolumeCommand + ": " + output);
            return output;
        }
        catch (ContainerExecutionException e) {
            LOG.error("Error when writing command to temp file, command=" + dockerVolumeCommand, (Throwable)((Object)e));
            throw e;
        }
        catch (PrivilegedOperationException e) {
            LOG.error("Error when executing command, command=" + dockerVolumeCommand, (Throwable)((Object)e));
            throw new ContainerExecutionException((Throwable)((Object)e));
        }
    }

    @Override
    public void prepareContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        Container container = ctx.getContainer();
        if (this.nmContext != null && this.nmContext.getResourcePluginManager().getNameToPlugins() != null) {
            for (ResourcePlugin plugin : this.nmContext.getResourcePluginManager().getNameToPlugins().values()) {
                DockerVolumeCommand dockerVolumeCommand;
                DockerCommandPlugin dockerCommandPlugin = plugin.getDockerCommandPluginInstance();
                if (dockerCommandPlugin == null || (dockerVolumeCommand = dockerCommandPlugin.getCreateDockerVolumeCommand(ctx.getContainer())) == null) continue;
                this.runDockerVolumeCommand(dockerVolumeCommand, container);
                if (!dockerVolumeCommand.getSubCommand().equals("create")) continue;
                this.checkDockerVolumeCreated(dockerVolumeCommand, container);
            }
        }
    }

    private void checkDockerVolumeCreated(DockerVolumeCommand dockerVolumeCreationCommand, Container container) throws ContainerExecutionException {
        DockerVolumeCommand dockerVolumeInspectCommand = new DockerVolumeCommand("ls");
        String output = this.runDockerVolumeCommand(dockerVolumeInspectCommand, container);
        String volumeName = dockerVolumeCreationCommand.getVolumeName();
        String driverName = dockerVolumeCreationCommand.getDriverName();
        if (driverName == null) {
            driverName = "local";
        }
        for (String line : output.split("\n")) {
            if (!(line = line.trim()).contains(volumeName) || !line.contains(driverName)) continue;
            LOG.info("Docker volume-name=" + volumeName + " driver-name=" + driverName + " already exists for container=" + container.getContainerId() + ", continue...");
            return;
        }
        String message = " Couldn't find volume=" + volumeName + " driver=" + driverName + " for container=" + container.getContainerId() + ", please check error message in log to understand why this happens.";
        LOG.error(message);
        if (LOG.isDebugEnabled()) {
            LOG.debug("All docker volumes in the system, command=" + dockerVolumeInspectCommand.toString());
        }
        throw new ContainerExecutionException(message);
    }

    private void validateContainerNetworkType(String network) throws ContainerExecutionException {
        if (this.allowedNetworks.contains(network)) {
            return;
        }
        String msg = "Disallowed network:  '" + network + "' specified. Allowed networks: are " + this.allowedNetworks.toString();
        throw new ContainerExecutionException(msg);
    }

    private boolean allowHostPidNamespace(Container container) throws ContainerExecutionException {
        Map environment = container.getLaunchContext().getEnvironment();
        String pidNamespace = (String)environment.get(ENV_DOCKER_CONTAINER_PID_NAMESPACE);
        if (pidNamespace == null) {
            return false;
        }
        if (!pidNamespace.equalsIgnoreCase("host")) {
            LOG.warn("NOT requesting PID namespace. Value of YARN_CONTAINER_RUNTIME_DOCKER_CONTAINER_PID_NAMESPACEis invalid: " + pidNamespace);
            return false;
        }
        boolean hostPidNamespaceEnabled = this.conf.getBoolean("yarn.nodemanager.runtime.linux.docker.host-pid-namespace.allowed", false);
        if (!hostPidNamespaceEnabled) {
            String message = "Host pid namespace being requested but this is not enabled on this cluster";
            LOG.warn(message);
            throw new ContainerExecutionException(message);
        }
        return true;
    }

    public static void validateHostname(String hostname) throws ContainerExecutionException {
        if (hostname != null && !hostname.isEmpty() && !hostnamePattern.matcher(hostname).matches()) {
            throw new ContainerExecutionException("Hostname '" + hostname + "' doesn't match docker hostname pattern");
        }
    }

    private void setHostname(DockerRunCommand runCommand, String containerIdStr, String name) throws ContainerExecutionException {
        if (name == null || name.isEmpty()) {
            name = RegistryPathUtils.encodeYarnID((String)containerIdStr);
            String domain = this.conf.get("hadoop.registry.dns.domain-name");
            if (domain != null) {
                name = name + "." + domain;
            }
            DockerLinuxContainerRuntime.validateHostname(name);
        }
        LOG.info("setting hostname in container to: " + name);
        runCommand.setHostname(name);
    }

    @VisibleForTesting
    protected void addCGroupParentIfRequired(String resourcesOptions, String containerIdStr, DockerRunCommand runCommand) {
        if (this.cGroupsHandler == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("cGroupsHandler is null. cgroups are not in use. nothing to do.");
            }
            return;
        }
        if (resourcesOptions.equals("cgroups=none")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("no resource restrictions specified. not using docker's cgroup options");
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("using docker's cgroups options");
            }
            String cGroupPath = "/" + this.cGroupsHandler.getRelativePathForCGroup(containerIdStr);
            if (LOG.isDebugEnabled()) {
                LOG.debug("using cgroup parent: " + cGroupPath);
            }
            runCommand.setCGroupParent(cGroupPath);
        }
    }

    private boolean allowPrivilegedContainerExecution(Container container) throws ContainerExecutionException {
        Map environment = container.getLaunchContext().getEnvironment();
        String runPrivilegedContainerEnvVar = (String)environment.get(ENV_DOCKER_CONTAINER_RUN_PRIVILEGED_CONTAINER);
        if (runPrivilegedContainerEnvVar == null) {
            return false;
        }
        if (!runPrivilegedContainerEnvVar.equalsIgnoreCase("true")) {
            LOG.warn("NOT running a privileged container. Value of YARN_CONTAINER_RUNTIME_DOCKER_RUN_PRIVILEGED_CONTAINERis invalid: " + runPrivilegedContainerEnvVar);
            return false;
        }
        LOG.info("Privileged container requested for : " + container.getContainerId().toString());
        boolean privilegedContainersEnabledOnCluster = this.conf.getBoolean("yarn.nodemanager.runtime.linux.docker.privileged-containers.allowed", false);
        if (!privilegedContainersEnabledOnCluster) {
            String message = "Privileged container being requested but privileged containers are not enabled on this cluster";
            LOG.warn(message);
            throw new ContainerExecutionException(message);
        }
        String submittingUser = container.getUser();
        UserGroupInformation submitterUgi = UserGroupInformation.createRemoteUser((String)submittingUser);
        if (!this.privilegedContainersAcl.isUserAllowed(submitterUgi)) {
            String message = "Cannot launch privileged container. Submitting user (" + submittingUser + ") fails ACL check.";
            LOG.warn(message);
            throw new ContainerExecutionException(message);
        }
        LOG.info("All checks pass. Launching privileged container for : " + container.getContainerId().toString());
        return true;
    }

    @VisibleForTesting
    protected String validateMount(String mount, Map<Path, List<String>> localizedResources) throws ContainerExecutionException {
        for (Map.Entry<Path, List<String>> resource : localizedResources.entrySet()) {
            if (!resource.getValue().contains(mount)) continue;
            java.nio.file.Path path = Paths.get(resource.getKey().toString(), new String[0]);
            if (!path.isAbsolute()) {
                throw new ContainerExecutionException("Mount must be absolute: " + mount);
            }
            if (Files.isSymbolicLink(path)) {
                throw new ContainerExecutionException("Mount cannot be a symlink: " + mount);
            }
            return path.toString();
        }
        throw new ContainerExecutionException("Mount must be a localized resource: " + mount);
    }

    private String getUserIdInfo(String userName) throws ContainerExecutionException {
        String id = "";
        Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(new String[]{"id", "-u", userName});
        try {
            shexec.execute();
            id = shexec.getOutput().replaceAll("[^0-9]", "");
        }
        catch (Exception e) {
            throw new ContainerExecutionException(e);
        }
        return id;
    }

    private String[] getGroupIdInfo(String userName) throws ContainerExecutionException {
        String[] id = null;
        Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(new String[]{"id", "-G", userName});
        try {
            shexec.execute();
            id = shexec.getOutput().replace("\n", "").split(" ");
        }
        catch (Exception e) {
            throw new ContainerExecutionException(e);
        }
        return id;
    }

    @Override
    public void launchContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        String mounts;
        String runAsUser;
        Container container = ctx.getContainer();
        Map environment = container.getLaunchContext().getEnvironment();
        String imageName = (String)environment.get(ENV_DOCKER_CONTAINER_IMAGE);
        String network = (String)environment.get(ENV_DOCKER_CONTAINER_NETWORK);
        String hostname = (String)environment.get(ENV_DOCKER_CONTAINER_HOSTNAME);
        if (network == null || network.isEmpty()) {
            network = this.defaultNetwork;
        }
        this.validateContainerNetworkType(network);
        DockerLinuxContainerRuntime.validateHostname(hostname);
        DockerLinuxContainerRuntime.validateImageName(imageName);
        String containerIdStr = container.getContainerId().toString();
        String dockerRunAsUser = runAsUser = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.RUN_AS_USER);
        Path containerWorkDir = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_WORK_DIR);
        String[] groups = null;
        if (this.enableUserReMapping) {
            String uid = this.getUserIdInfo(runAsUser);
            groups = this.getGroupIdInfo(runAsUser);
            String gid = groups[0];
            if (Integer.parseInt(uid) < this.userRemappingUidThreshold) {
                String message = "uid: " + uid + " below threshold: " + this.userRemappingUidThreshold;
                throw new ContainerExecutionException(message);
            }
            for (int i = 0; i < groups.length; ++i) {
                String group = groups[i];
                if (Integer.parseInt(group) >= this.userRemappingGidThreshold) continue;
                String message = "gid: " + group + " below threshold: " + this.userRemappingGidThreshold;
                throw new ContainerExecutionException(message);
            }
            dockerRunAsUser = uid + ":" + gid;
        }
        List filecacheDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.FILECACHE_DIRS);
        List containerLogDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_LOG_DIRS);
        List userFilecacheDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.USER_FILECACHE_DIRS);
        List applicationLocalDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.APPLICATION_LOCAL_DIRS);
        Map localizedResources = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.LOCALIZED_RESOURCES);
        DockerRunCommand runCommand = new DockerRunCommand(containerIdStr, dockerRunAsUser, imageName).detachOnRun().setContainerWorkDir(containerWorkDir.toString()).setNetworkType(network);
        if (!network.equalsIgnoreCase("host") || this.conf.getBoolean("hadoop.registry.dns.enabled", false)) {
            this.setHostname(runCommand, containerIdStr, hostname);
        }
        runCommand.setCapabilities(this.capabilities);
        runCommand.addAllReadWriteMountLocations(containerLogDirs);
        runCommand.addAllReadWriteMountLocations(applicationLocalDirs);
        runCommand.addAllReadOnlyMountLocations(filecacheDirs);
        runCommand.addAllReadOnlyMountLocations(userFilecacheDirs);
        if (environment.containsKey(ENV_DOCKER_CONTAINER_LOCAL_RESOURCE_MOUNTS) && !(mounts = (String)environment.get(ENV_DOCKER_CONTAINER_LOCAL_RESOURCE_MOUNTS)).isEmpty()) {
            for (String mount : StringUtils.split((String)mounts)) {
                String[] dir = StringUtils.split((String)mount, (char)':');
                if (dir.length != 2) {
                    throw new ContainerExecutionException("Invalid mount : " + mount);
                }
                String src = this.validateMount(dir[0], localizedResources);
                String dst = dir[1];
                runCommand.addReadOnlyMountLocation(src, dst, true);
            }
        }
        if (environment.containsKey(ENV_DOCKER_CONTAINER_MOUNTS)) {
            Matcher parsedMounts = USER_MOUNT_PATTERN.matcher((CharSequence)environment.get(ENV_DOCKER_CONTAINER_MOUNTS));
            if (!parsedMounts.find()) {
                throw new ContainerExecutionException("Unable to parse user supplied mount list: " + (String)environment.get(ENV_DOCKER_CONTAINER_MOUNTS));
            }
            parsedMounts.reset();
            while (parsedMounts.find()) {
                String src = parsedMounts.group(1);
                String dst = parsedMounts.group(2);
                String mode = parsedMounts.group(3);
                if (!mode.equals("ro") && !mode.equals("rw")) {
                    throw new ContainerExecutionException("Invalid mount mode requested for mount: " + parsedMounts.group());
                }
                if (mode.equals("ro")) {
                    runCommand.addReadOnlyMountLocation(src, dst);
                    continue;
                }
                runCommand.addReadWriteMountLocation(src, dst);
            }
        }
        if (this.allowHostPidNamespace(container)) {
            runCommand.setPidNamespace("host");
        }
        if (this.allowPrivilegedContainerExecution(container)) {
            runCommand.setPrivileged();
        }
        this.addDockerClientConfigToRunCommand(ctx, runCommand);
        String resourcesOpts = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.RESOURCES_OPTIONS);
        this.addCGroupParentIfRequired(resourcesOpts, containerIdStr, runCommand);
        String disableOverride = (String)environment.get(ENV_DOCKER_CONTAINER_RUN_OVERRIDE_DISABLE);
        if (disableOverride != null && disableOverride.equals("true")) {
            LOG.info("command override disabled");
        } else {
            ArrayList<String> overrideCommands = new ArrayList<String>();
            Path launchDst = new Path(containerWorkDir, ContainerLaunch.CONTAINER_SCRIPT);
            overrideCommands.add("bash");
            overrideCommands.add(launchDst.toUri().getPath());
            runCommand.setOverrideCommandWithArgs(overrideCommands);
        }
        if (this.enableUserReMapping) {
            runCommand.groupAdd(groups);
        }
        if (this.nmContext != null && this.nmContext.getResourcePluginManager().getNameToPlugins() != null) {
            for (ResourcePlugin plugin : this.nmContext.getResourcePluginManager().getNameToPlugins().values()) {
                DockerCommandPlugin dockerCommandPlugin = plugin.getDockerCommandPluginInstance();
                if (dockerCommandPlugin == null) continue;
                dockerCommandPlugin.updateDockerRunCommand(runCommand, container);
            }
        }
        String commandFile = this.dockerClient.writeCommandToTempFile(runCommand, containerIdStr);
        PrivilegedOperation launchOp = this.buildLaunchOp(ctx, commandFile, runCommand);
        try {
            this.privilegedOperationExecutor.executePrivilegedOperation(null, launchOp, null, null, false, false);
        }
        catch (PrivilegedOperationException e) {
            LOG.warn("Launch container failed. Exception: ", (Throwable)((Object)e));
            LOG.info("Docker command used: " + runCommand);
            throw new ContainerExecutionException("Launch container failed", e.getExitCode(), e.getOutput(), e.getErrorOutput());
        }
    }

    @Override
    public void signalContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        ContainerExecutor.Signal signal = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.SIGNAL);
        String containerId = ctx.getContainer().getContainerId().toString();
        Map env = ctx.getContainer().getLaunchContext().getEnvironment();
        try {
            if (ContainerExecutor.Signal.NULL.equals((Object)signal)) {
                this.executeLivelinessCheck(ctx);
            } else if (ContainerExecutor.Signal.KILL.equals((Object)signal) || ContainerExecutor.Signal.TERM.equals((Object)signal)) {
                this.handleContainerStop(containerId, env);
            } else {
                this.handleContainerKill(containerId, env, signal);
            }
        }
        catch (ContainerExecutionException e) {
            LOG.warn("Signal docker container failed. Exception: ", (Throwable)((Object)e));
            throw new ContainerExecutionException("Signal docker container failed", e.getExitCode(), e.getOutput(), e.getErrorOutput());
        }
    }

    @Override
    public void reapContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        this.handleContainerRemove(ctx.getContainer().getContainerId().toString(), ctx.getContainer().getLaunchContext().getEnvironment());
        if (this.nmContext != null && this.nmContext.getResourcePluginManager().getNameToPlugins() != null) {
            for (ResourcePlugin plugin : this.nmContext.getResourcePluginManager().getNameToPlugins().values()) {
                DockerVolumeCommand dockerVolumeCommand;
                DockerCommandPlugin dockerCommandPlugin = plugin.getDockerCommandPluginInstance();
                if (dockerCommandPlugin == null || (dockerVolumeCommand = dockerCommandPlugin.getCleanupDockerVolumesCommand(ctx.getContainer())) == null) continue;
                this.runDockerVolumeCommand(dockerVolumeCommand, ctx.getContainer());
            }
        }
    }

    @Override
    public String[] getIpAndHost(Container container) {
        String containerId = container.getContainerId().toString();
        DockerInspectCommand inspectCommand = new DockerInspectCommand(containerId).getIpAndHost();
        try {
            String commandFile = this.dockerClient.writeCommandToTempFile(inspectCommand, containerId);
            PrivilegedOperation privOp = new PrivilegedOperation(PrivilegedOperation.OperationType.RUN_DOCKER_CMD);
            privOp.appendArgs(commandFile);
            String output = this.privilegedOperationExecutor.executePrivilegedOperation(null, privOp, null, null, true, false);
            LOG.info("Docker inspect output for " + containerId + ": " + output);
            output = output.replaceAll("['\"]", "");
            int index = output.lastIndexOf(44);
            if (index == -1) {
                LOG.error("Incorrect format for ip and host");
                return null;
            }
            String ips = output.substring(0, index).trim();
            String host = output.substring(index + 1).trim();
            if (ips.equals("")) {
                String network;
                try {
                    network = (String)container.getLaunchContext().getEnvironment().get(ENV_DOCKER_CONTAINER_NETWORK);
                    if (network == null || network.isEmpty()) {
                        network = this.defaultNetwork;
                    }
                }
                catch (NullPointerException e) {
                    network = this.defaultNetwork;
                }
                boolean useHostNetwork = network.equalsIgnoreCase("host");
                if (useHostNetwork) {
                    try {
                        InetAddress address = InetAddress.getLocalHost();
                        ips = address.getHostAddress();
                    }
                    catch (UnknownHostException e) {
                        LOG.error("Can not determine IP for container:" + containerId);
                    }
                }
            }
            String[] ipAndHost = new String[]{ips, host};
            return ipAndHost;
        }
        catch (ContainerExecutionException e) {
            LOG.error("Error when writing command to temp file", (Throwable)((Object)e));
        }
        catch (PrivilegedOperationException e) {
            LOG.error("Error when executing command.", (Throwable)((Object)e));
        }
        return null;
    }

    private PrivilegedOperation buildLaunchOp(ContainerRuntimeContext ctx, String commandFile, DockerRunCommand runCommand) {
        String runAsUser = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.RUN_AS_USER);
        String containerIdStr = ctx.getContainer().getContainerId().toString();
        Path nmPrivateContainerScriptPath = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.NM_PRIVATE_CONTAINER_SCRIPT_PATH);
        Path containerWorkDir = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_WORK_DIR);
        List localDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.LOCAL_DIRS);
        List logDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.LOG_DIRS);
        String resourcesOpts = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.RESOURCES_OPTIONS);
        PrivilegedOperation launchOp = new PrivilegedOperation(PrivilegedOperation.OperationType.LAUNCH_DOCKER_CONTAINER);
        launchOp.appendArgs(runAsUser, ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.USER), Integer.toString(PrivilegedOperation.RunAsUserCommand.LAUNCH_DOCKER_CONTAINER.getValue()), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.APPID), containerIdStr, containerWorkDir.toString(), nmPrivateContainerScriptPath.toUri().getPath(), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.NM_PRIVATE_TOKENS_PATH).toUri().getPath(), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.PID_FILE_PATH).toString(), StringUtils.join((char)'%', (Iterable)localDirs), StringUtils.join((char)'%', (Iterable)logDirs), commandFile, resourcesOpts);
        String tcCommandFile = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.TC_COMMAND_FILE);
        if (tcCommandFile != null) {
            launchOp.appendArgs(tcCommandFile);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Launching container with cmd: " + runCommand);
        }
        return launchOp;
    }

    public static void validateImageName(String imageName) throws ContainerExecutionException {
        if (imageName == null || imageName.isEmpty()) {
            throw new ContainerExecutionException("YARN_CONTAINER_RUNTIME_DOCKER_IMAGE not set!");
        }
        if (!dockerImagePattern.matcher(imageName).matches()) {
            throw new ContainerExecutionException("Image name '" + imageName + "' doesn't match docker image name pattern");
        }
    }

    private void executeLivelinessCheck(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        PrivilegedOperation signalOp = new PrivilegedOperation(PrivilegedOperation.OperationType.SIGNAL_CONTAINER);
        signalOp.appendArgs(ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.RUN_AS_USER), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.USER), Integer.toString(PrivilegedOperation.RunAsUserCommand.SIGNAL_CONTAINER.getValue()), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.PID), Integer.toString(ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.SIGNAL).getValue()));
        signalOp.disableFailureLogging();
        try {
            this.privilegedOperationExecutor.executePrivilegedOperation(null, signalOp, null, ctx.getContainer().getLaunchContext().getEnvironment(), false, false);
        }
        catch (PrivilegedOperationException e) {
            String msg = "Liveliness check failed for PID: " + ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.PID) + ". Container may have already completed.";
            throw new ContainerExecutionException(msg, e.getExitCode(), e.getOutput(), e.getErrorOutput());
        }
    }

    private void handleContainerStop(String containerId, Map<String, String> env) throws ContainerExecutionException {
        DockerCommandExecutor.DockerContainerStatus containerStatus = DockerCommandExecutor.getContainerStatus(containerId, this.conf, this.privilegedOperationExecutor);
        if (DockerCommandExecutor.isStoppable(containerStatus)) {
            DockerStopCommand dockerStopCommand = new DockerStopCommand(containerId);
            DockerCommandExecutor.executeDockerCommand(dockerStopCommand, containerId, env, this.conf, this.privilegedOperationExecutor, false);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Container status is " + containerStatus.getName() + ", skipping stop - " + containerId);
        }
    }

    private void handleContainerKill(String containerId, Map<String, String> env, ContainerExecutor.Signal signal) throws ContainerExecutionException {
        DockerCommandExecutor.DockerContainerStatus containerStatus = DockerCommandExecutor.getContainerStatus(containerId, this.conf, this.privilegedOperationExecutor);
        if (DockerCommandExecutor.isKillable(containerStatus)) {
            DockerKillCommand dockerKillCommand = new DockerKillCommand(containerId).setSignal(signal.name());
            DockerCommandExecutor.executeDockerCommand(dockerKillCommand, containerId, env, this.conf, this.privilegedOperationExecutor, false);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Container status is " + containerStatus.getName() + ", skipping kill - " + containerId);
        }
    }

    private void handleContainerRemove(String containerId, Map<String, String> env) throws ContainerExecutionException {
        String delayedRemoval = env.get(ENV_DOCKER_CONTAINER_DELAYED_REMOVAL);
        if (this.delayedRemovalAllowed && delayedRemoval != null && delayedRemoval.equalsIgnoreCase("true")) {
            LOG.info("Delayed removal requested and allowed, skipping removal - " + containerId);
        } else {
            DockerCommandExecutor.DockerContainerStatus containerStatus = DockerCommandExecutor.getContainerStatus(containerId, this.conf, this.privilegedOperationExecutor);
            if (DockerCommandExecutor.isRemovable(containerStatus)) {
                DockerRmCommand dockerRmCommand = new DockerRmCommand(containerId);
                DockerCommandExecutor.executeDockerCommand(dockerRmCommand, containerId, env, this.conf, this.privilegedOperationExecutor, false);
            }
        }
    }

    private void addDockerClientConfigToRunCommand(ContainerRuntimeContext ctx, DockerRunCommand dockerRunCommand) throws ContainerExecutionException {
        ByteBuffer tokens = ctx.getContainer().getLaunchContext().getTokens();
        if (tokens != null) {
            tokens.rewind();
            if (tokens.hasRemaining()) {
                Credentials credentials;
                try {
                    credentials = DockerClientConfigHandler.getCredentialsFromTokensByteBuffer((ByteBuffer)tokens);
                }
                catch (IOException e) {
                    throw new ContainerExecutionException("Unable to read tokens.");
                }
                if (credentials.numberOfTokens() > 0) {
                    Path nmPrivateDir = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.NM_PRIVATE_CONTAINER_SCRIPT_PATH).getParent();
                    File dockerConfigPath = new File(nmPrivateDir + "/config.json");
                    try {
                        DockerClientConfigHandler.writeDockerCredentialsToPath((File)dockerConfigPath, (Credentials)credentials);
                    }
                    catch (IOException e) {
                        throw new ContainerExecutionException("Unable to write Docker client credentials to " + dockerConfigPath);
                    }
                    dockerRunCommand.setClientConfigDir(dockerConfigPath.getParent());
                }
            }
        }
    }
}

