/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsBlkioResourceHandlerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsCpuResourceHandlerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandlerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsMemoryResourceHandlerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CpuResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.DiskResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.MemoryResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.NetworkPacketTaggingHandlerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.OutboundBandwidthResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerChain;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.TrafficControlBandwidthHandlerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.TrafficController;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.numa.NumaResourceHandlerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.ResourcePlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.ResourcePluginManager;
import org.apache.hadoop.yarn.server.nodemanager.util.CgroupsLCEResourcesHandler;
import org.apache.hadoop.yarn.server.nodemanager.util.DefaultLCEResourcesHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ResourceHandlerModule {
    static final Logger LOG = LoggerFactory.getLogger(ResourceHandlerModule.class);
    private static volatile ResourceHandlerChain resourceHandlerChain;
    private static volatile TrafficControlBandwidthHandlerImpl trafficControlBandwidthHandler;
    private static volatile NetworkPacketTaggingHandlerImpl networkPacketTaggingHandlerImpl;
    private static volatile CGroupsHandler cGroupsHandler;
    private static volatile CGroupsBlkioResourceHandlerImpl cGroupsBlkioResourceHandler;
    private static volatile CGroupsMemoryResourceHandlerImpl cGroupsMemoryResourceHandler;
    private static volatile CGroupsCpuResourceHandlerImpl cGroupsCpuResourceHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CGroupsHandler getInitializedCGroupsHandler(Configuration conf) throws ResourceHandlerException {
        if (cGroupsHandler != null) return cGroupsHandler;
        Class<CGroupsHandler> clazz = CGroupsHandler.class;
        synchronized (CGroupsHandler.class) {
            if (cGroupsHandler != null) return cGroupsHandler;
            cGroupsHandler = new CGroupsHandlerImpl(conf, PrivilegedOperationExecutor.getInstance(conf));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cGroupsHandler;
        }
    }

    public static CGroupsHandler getCGroupsHandler() {
        return cGroupsHandler;
    }

    public static NetworkPacketTaggingHandlerImpl getNetworkResourceHandler() {
        return networkPacketTaggingHandlerImpl;
    }

    public static DiskResourceHandler getDiskResourceHandler() {
        return cGroupsBlkioResourceHandler;
    }

    public static MemoryResourceHandler getMemoryResourceHandler() {
        return cGroupsMemoryResourceHandler;
    }

    public static CpuResourceHandler getCpuResourceHandler() {
        return cGroupsCpuResourceHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CGroupsCpuResourceHandlerImpl initCGroupsCpuResourceHandler(Configuration conf) throws ResourceHandlerException {
        boolean cgroupsCpuEnabled = conf.getBoolean("yarn.nodemanager.resource.cpu.enabled", false);
        boolean cgroupsLCEResourcesHandlerEnabled = conf.getClass("yarn.nodemanager.linux-container-executor.resources-handler.class", DefaultLCEResourcesHandler.class).equals(CgroupsLCEResourcesHandler.class);
        if (!cgroupsCpuEnabled && !cgroupsLCEResourcesHandlerEnabled || cGroupsCpuResourceHandler != null) return null;
        Class<CpuResourceHandler> clazz = CpuResourceHandler.class;
        synchronized (CpuResourceHandler.class) {
            if (cGroupsCpuResourceHandler != null) return null;
            LOG.debug("Creating new cgroups cpu handler");
            cGroupsCpuResourceHandler = new CGroupsCpuResourceHandlerImpl(ResourceHandlerModule.getInitializedCGroupsHandler(conf));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return cGroupsCpuResourceHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TrafficControlBandwidthHandlerImpl getTrafficControlBandwidthHandler(Configuration conf) throws ResourceHandlerException {
        if (!conf.getBoolean("yarn.nodemanager.resource.network.enabled", false)) return null;
        if (trafficControlBandwidthHandler != null) return trafficControlBandwidthHandler;
        Class<OutboundBandwidthResourceHandler> clazz = OutboundBandwidthResourceHandler.class;
        synchronized (OutboundBandwidthResourceHandler.class) {
            if (trafficControlBandwidthHandler != null) return trafficControlBandwidthHandler;
            LOG.info("Creating new traffic control bandwidth handler.");
            trafficControlBandwidthHandler = new TrafficControlBandwidthHandlerImpl(PrivilegedOperationExecutor.getInstance(conf), ResourceHandlerModule.getInitializedCGroupsHandler(conf), new TrafficController(conf, PrivilegedOperationExecutor.getInstance(conf)));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return trafficControlBandwidthHandler;
        }
    }

    public static ResourceHandler initNetworkResourceHandler(Configuration conf) throws ResourceHandlerException {
        boolean useNetworkTagHandler = conf.getBoolean("yarn.nodemanager.network-tagging-handler.enabled", false);
        if (useNetworkTagHandler) {
            LOG.info("Using network-tagging-handler.");
            return ResourceHandlerModule.getNetworkTaggingHandler(conf);
        }
        LOG.info("Using traffic control bandwidth handler");
        return ResourceHandlerModule.getTrafficControlBandwidthHandler(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResourceHandler getNetworkTaggingHandler(Configuration conf) throws ResourceHandlerException {
        if (networkPacketTaggingHandlerImpl != null) return networkPacketTaggingHandlerImpl;
        Class<OutboundBandwidthResourceHandler> clazz = OutboundBandwidthResourceHandler.class;
        synchronized (OutboundBandwidthResourceHandler.class) {
            if (networkPacketTaggingHandlerImpl != null) return networkPacketTaggingHandlerImpl;
            LOG.info("Creating new network-tagging-handler.");
            networkPacketTaggingHandlerImpl = new NetworkPacketTaggingHandlerImpl(PrivilegedOperationExecutor.getInstance(conf), ResourceHandlerModule.getInitializedCGroupsHandler(conf));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return networkPacketTaggingHandlerImpl;
        }
    }

    public static OutboundBandwidthResourceHandler initOutboundBandwidthResourceHandler(Configuration conf) throws ResourceHandlerException {
        return ResourceHandlerModule.getTrafficControlBandwidthHandler(conf);
    }

    public static DiskResourceHandler initDiskResourceHandler(Configuration conf) throws ResourceHandlerException {
        if (conf.getBoolean("yarn.nodemanager.resource.disk.enabled", false)) {
            return ResourceHandlerModule.getCgroupsBlkioResourceHandler(conf);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CGroupsBlkioResourceHandlerImpl getCgroupsBlkioResourceHandler(Configuration conf) throws ResourceHandlerException {
        if (cGroupsBlkioResourceHandler != null) return cGroupsBlkioResourceHandler;
        Class<DiskResourceHandler> clazz = DiskResourceHandler.class;
        synchronized (DiskResourceHandler.class) {
            if (cGroupsBlkioResourceHandler != null) return cGroupsBlkioResourceHandler;
            LOG.debug("Creating new cgroups blkio handler");
            cGroupsBlkioResourceHandler = new CGroupsBlkioResourceHandlerImpl(ResourceHandlerModule.getInitializedCGroupsHandler(conf));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cGroupsBlkioResourceHandler;
        }
    }

    public static MemoryResourceHandler initMemoryResourceHandler(Configuration conf) throws ResourceHandlerException {
        if (conf.getBoolean("yarn.nodemanager.resource.memory.enabled", false)) {
            return ResourceHandlerModule.getCgroupsMemoryResourceHandler(conf);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CGroupsMemoryResourceHandlerImpl getCgroupsMemoryResourceHandler(Configuration conf) throws ResourceHandlerException {
        if (cGroupsMemoryResourceHandler != null) return cGroupsMemoryResourceHandler;
        Class<MemoryResourceHandler> clazz = MemoryResourceHandler.class;
        synchronized (MemoryResourceHandler.class) {
            if (cGroupsMemoryResourceHandler != null) return cGroupsMemoryResourceHandler;
            cGroupsMemoryResourceHandler = new CGroupsMemoryResourceHandlerImpl(ResourceHandlerModule.getInitializedCGroupsHandler(conf));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cGroupsMemoryResourceHandler;
        }
    }

    private static ResourceHandler getNumaResourceHandler(Configuration conf, Context nmContext) {
        if (YarnConfiguration.numaAwarenessEnabled((Configuration)conf)) {
            return new NumaResourceHandlerImpl(conf, nmContext);
        }
        return null;
    }

    private static void addHandlerIfNotNull(List<ResourceHandler> handlerList, ResourceHandler handler) {
        if (handler != null) {
            handlerList.add(handler);
        }
    }

    private static void initializeConfiguredResourceHandlerChain(Configuration conf, Context nmContext) throws ResourceHandlerException {
        ArrayList<ResourceHandler> handlerList = new ArrayList<ResourceHandler>();
        ResourceHandlerModule.addHandlerIfNotNull(handlerList, ResourceHandlerModule.initNetworkResourceHandler(conf));
        ResourceHandlerModule.addHandlerIfNotNull(handlerList, ResourceHandlerModule.initDiskResourceHandler(conf));
        ResourceHandlerModule.addHandlerIfNotNull(handlerList, ResourceHandlerModule.initMemoryResourceHandler(conf));
        ResourceHandlerModule.addHandlerIfNotNull(handlerList, ResourceHandlerModule.initCGroupsCpuResourceHandler(conf));
        ResourceHandlerModule.addHandlerIfNotNull(handlerList, ResourceHandlerModule.getNumaResourceHandler(conf, nmContext));
        ResourceHandlerModule.addHandlersFromConfiguredResourcePlugins(handlerList, conf, nmContext);
        resourceHandlerChain = new ResourceHandlerChain(handlerList);
    }

    private static void addHandlersFromConfiguredResourcePlugins(List<ResourceHandler> handlerList, Configuration conf, Context nmContext) throws ResourceHandlerException {
        Map<String, ResourcePlugin> pluginMap;
        ResourcePluginManager pluginManager = nmContext.getResourcePluginManager();
        if (pluginManager != null && (pluginMap = pluginManager.getNameToPlugins()) != null) {
            for (ResourcePlugin plugin : pluginMap.values()) {
                ResourceHandlerModule.addHandlerIfNotNull(handlerList, plugin.createResourceHandler(nmContext, ResourceHandlerModule.getInitializedCGroupsHandler(conf), PrivilegedOperationExecutor.getInstance(conf)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static ResourceHandlerChain getConfiguredResourceHandlerChain(Configuration conf, Context nmContext) throws ResourceHandlerException {
        if (resourceHandlerChain == null) {
            Class<ResourceHandlerModule> clazz = ResourceHandlerModule.class;
            // MONITORENTER : org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerModule.class
            if (resourceHandlerChain == null) {
                ResourceHandlerModule.initializeConfiguredResourceHandlerChain(conf, nmContext);
            }
            // MONITOREXIT : clazz
        }
        if (resourceHandlerChain.getResourceHandlerList().size() == 0) return null;
        return resourceHandlerChain;
    }

    @VisibleForTesting
    static void nullifyResourceHandlerChain() throws ResourceHandlerException {
        resourceHandlerChain = null;
    }

    public static Map<String, Set<String>> parseConfiguredCGroupPath(String cgroupMountPath) throws IOException {
        File cgroupDir = new File(cgroupMountPath);
        File[] list = cgroupDir.listFiles();
        if (list == null) {
            throw new IOException("Empty cgroup mount directory specified: " + cgroupMountPath);
        }
        HashMap<String, Set<String>> pathSubsystemMappings = new HashMap<String, Set<String>>();
        Set<String> validCGroups = CGroupsHandler.CGroupController.getValidCGroups();
        for (File candidate : list) {
            HashSet<String> cgroupList = new HashSet<String>(Arrays.asList(candidate.getName().split(",")));
            cgroupList.retainAll(validCGroups);
            if (cgroupList.isEmpty()) continue;
            if (candidate.isDirectory()) {
                pathSubsystemMappings.put(candidate.getAbsolutePath(), cgroupList);
                continue;
            }
            LOG.warn("The following cgroup is not a directory " + candidate.getAbsolutePath());
        }
        return pathSubsystemMappings;
    }
}

