/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.container;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ContainerRetryContext;
import org.apache.hadoop.yarn.api.records.ContainerRetryPolicy;
import org.apache.hadoop.yarn.util.Clock;

@InterfaceStability.Unstable
public class SlidingWindowRetryPolicy {
    private Clock clock;

    public SlidingWindowRetryPolicy(Clock clock) {
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
    }

    public boolean shouldRetry(RetryContext retryContext, int errorCode) {
        ContainerRetryContext containerRC = retryContext.containerRetryContext;
        Preconditions.checkNotNull((Object)containerRC, (Object)"container retry context null");
        ContainerRetryPolicy retryPolicy = containerRC.getRetryPolicy();
        if (retryPolicy == ContainerRetryPolicy.RETRY_ON_ALL_ERRORS || retryPolicy == ContainerRetryPolicy.RETRY_ON_SPECIFIC_ERROR_CODES && containerRC.getErrorCodes() != null && containerRC.getErrorCodes().contains(errorCode)) {
            if (containerRC.getMaxRetries() == -1) {
                return true;
            }
            int pendingRetries = this.calculatePendingRetries(retryContext);
            this.updateRetryContext(retryContext, pendingRetries);
            return pendingRetries > 0;
        }
        return false;
    }

    private int calculatePendingRetries(RetryContext retryContext) {
        ContainerRetryContext containerRC = retryContext.containerRetryContext;
        if (containerRC.getFailuresValidityInterval() > 0L) {
            long restartTime;
            Iterator<Long> iterator = retryContext.getRestartTimes().iterator();
            long currentTime = this.clock.getTime();
            while (iterator.hasNext() && currentTime - (restartTime = iterator.next().longValue()) > containerRC.getFailuresValidityInterval()) {
                iterator.remove();
            }
            return containerRC.getMaxRetries() - retryContext.getRestartTimes().size();
        }
        return retryContext.getRemainingRetries();
    }

    private void updateRetryContext(RetryContext retryContext, int pendingRetries) {
        retryContext.setRemainingRetries(pendingRetries - 1);
        if (retryContext.containerRetryContext.getFailuresValidityInterval() > 0L) {
            retryContext.getRestartTimes().add(this.clock.getTime());
        }
    }

    public void setClock(Clock clock) {
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
    }

    static class RetryContext {
        private final ContainerRetryContext containerRetryContext;
        private List<Long> restartTimes = new ArrayList<Long>();
        private int remainingRetries;

        RetryContext(ContainerRetryContext containerRetryContext) {
            this.containerRetryContext = (ContainerRetryContext)Preconditions.checkNotNull((Object)containerRetryContext);
            this.remainingRetries = containerRetryContext.getMaxRetries();
        }

        ContainerRetryContext getContainerRetryContext() {
            return this.containerRetryContext;
        }

        int getRemainingRetries() {
            return this.remainingRetries;
        }

        void setRemainingRetries(int remainingRetries) {
            this.remainingRetries = remainingRetries;
        }

        List<Long> getRestartTimes() {
            return this.restartTimes;
        }

        void setRestartTimes(List<Long> restartTimes) {
            if (restartTimes != null) {
                this.restartTimes.clear();
                this.restartTimes.addAll(restartTimes);
            }
        }
    }
}

