/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.amrmproxy;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.AMRMProxyApplicationContext;

public class AMRMProxyApplicationContextImpl
implements AMRMProxyApplicationContext {
    private final Configuration conf;
    private final Context nmContext;
    private final ApplicationAttemptId applicationAttemptId;
    private final String user;
    private Integer localTokenKeyId;
    private Token<AMRMTokenIdentifier> amrmToken;
    private Token<AMRMTokenIdentifier> localToken;

    public AMRMProxyApplicationContextImpl(Context nmContext, Configuration conf, ApplicationAttemptId applicationAttemptId, String user, Token<AMRMTokenIdentifier> amrmToken, Token<AMRMTokenIdentifier> localToken) {
        this.nmContext = nmContext;
        this.conf = conf;
        this.applicationAttemptId = applicationAttemptId;
        this.user = user;
        this.amrmToken = amrmToken;
        this.localToken = localToken;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public ApplicationAttemptId getApplicationAttemptId() {
        return this.applicationAttemptId;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public synchronized Token<AMRMTokenIdentifier> getAMRMToken() {
        return this.amrmToken;
    }

    public synchronized void setAMRMToken(Token<AMRMTokenIdentifier> amrmToken) {
        this.amrmToken = amrmToken;
    }

    @Override
    public synchronized Token<AMRMTokenIdentifier> getLocalAMRMToken() {
        return this.localToken;
    }

    public synchronized void setLocalAMRMToken(Token<AMRMTokenIdentifier> localToken) {
        this.localToken = localToken;
        this.localTokenKeyId = null;
    }

    @InterfaceAudience.Private
    public synchronized int getLocalAMRMTokenKeyId() {
        Integer keyId = this.localTokenKeyId;
        if (keyId == null) {
            try {
                if (this.localToken == null) {
                    throw new YarnRuntimeException("Missing AMRM token for " + this.applicationAttemptId);
                }
                this.localTokenKeyId = keyId = Integer.valueOf(((AMRMTokenIdentifier)this.amrmToken.decodeIdentifier()).getKeyId());
            }
            catch (IOException e) {
                throw new YarnRuntimeException("AMRM token decode error for " + this.applicationAttemptId, (Throwable)e);
            }
        }
        return keyId;
    }

    @Override
    public Context getNMCotext() {
        return this.nmContext;
    }
}

