/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.NodeHealthScriptRunner;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;

public class NodeHealthCheckerService
extends CompositeService {
    private NodeHealthScriptRunner nodeHealthScriptRunner;
    private LocalDirsHandlerService dirsHandler;
    static final String SEPARATOR = ";";

    public NodeHealthCheckerService(NodeHealthScriptRunner scriptRunner, LocalDirsHandlerService dirHandlerService) {
        super(NodeHealthCheckerService.class.getName());
        this.nodeHealthScriptRunner = scriptRunner;
        this.dirsHandler = dirHandlerService;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        if (this.nodeHealthScriptRunner != null) {
            this.addService((Service)this.nodeHealthScriptRunner);
        }
        this.addService((Service)this.dirsHandler);
        super.serviceInit(conf);
    }

    String getHealthReport() {
        String scriptReport;
        String string = scriptReport = this.nodeHealthScriptRunner == null ? "" : this.nodeHealthScriptRunner.getHealthReport();
        if (scriptReport.equals("")) {
            return this.dirsHandler.getDisksHealthReport(false);
        }
        return scriptReport.concat(SEPARATOR + this.dirsHandler.getDisksHealthReport(false));
    }

    boolean isHealthy() {
        boolean scriptHealthStatus = this.nodeHealthScriptRunner == null ? true : this.nodeHealthScriptRunner.isHealthy();
        return scriptHealthStatus && this.dirsHandler.areDisksHealthy();
    }

    long getLastHealthReportTime() {
        long diskCheckTime = this.dirsHandler.getLastDisksCheckTime();
        long lastReportTime = this.nodeHealthScriptRunner == null ? diskCheckTime : Math.max(this.nodeHealthScriptRunner.getLastReportedTime(), diskCheckTime);
        return lastReportTime;
    }

    public LocalDirsHandlerService getDiskHandler() {
        return this.dirsHandler;
    }

    NodeHealthScriptRunner getNodeHealthScriptRunner() {
        return this.nodeHealthScriptRunner;
    }
}

