/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.security;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.token.delegation.web.KerberosDelegationTokenAuthenticationHandler;
import org.apache.hadoop.security.token.delegation.web.PseudoDelegationTokenAuthenticationHandler;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.timeline.security.TimelineAuthenticationFilter;

public class TimelineAuthenticationFilterInitializer
extends FilterInitializer {
    public static final String PREFIX = "yarn.timeline-service.http-authentication.";
    private static final String SIGNATURE_SECRET_FILE = "signature.secret.file";
    @VisibleForTesting
    Map<String, String> filterConfig;

    public void initFilter(FilterContainer container, Configuration conf) {
        String authType;
        String value;
        String name;
        this.filterConfig = new HashMap<String, String>();
        this.filterConfig.put("cookie.path", "/");
        for (Map.Entry entry : conf) {
            name = (String)entry.getKey();
            if (!name.startsWith("hadoop.proxyuser")) continue;
            value = conf.get(name);
            name = name.substring("hadoop.".length());
            this.filterConfig.put(name, value);
        }
        for (Map.Entry entry : conf) {
            name = (String)entry.getKey();
            if (!name.startsWith(PREFIX)) continue;
            value = conf.get(name);
            name = name.substring(PREFIX.length());
            this.filterConfig.put(name, value);
        }
        String signatureSecretFile = this.filterConfig.get(SIGNATURE_SECRET_FILE);
        if (signatureSecretFile != null) {
            FileReader reader = null;
            try {
                StringBuilder secret = new StringBuilder();
                reader = new FileReader(signatureSecretFile);
                int c = ((Reader)reader).read();
                while (c > -1) {
                    secret.append((char)c);
                    c = ((Reader)reader).read();
                }
                this.filterConfig.put("signature.secret", secret.toString());
            }
            catch (IOException ex) {
                try {
                    throw new RuntimeException("Could not read HTTP signature secret file: " + signatureSecretFile);
                }
                catch (Throwable throwable) {
                    IOUtils.closeStream(reader);
                    throw throwable;
                }
            }
            IOUtils.closeStream((Closeable)reader);
        }
        if ((authType = this.filterConfig.get("type")).equals("simple")) {
            this.filterConfig.put("type", PseudoDelegationTokenAuthenticationHandler.class.getName());
        } else if (authType.equals("kerberos")) {
            this.filterConfig.put("type", KerberosDelegationTokenAuthenticationHandler.class.getName());
            String bindAddress = conf.get("bind.address");
            String principal = this.filterConfig.get("kerberos.principal");
            if (principal != null) {
                try {
                    principal = SecurityUtil.getServerPrincipal((String)principal, (String)bindAddress);
                }
                catch (IOException ex) {
                    throw new RuntimeException("Could not resolve Kerberos principal name: " + ex.toString(), ex);
                }
                this.filterConfig.put("kerberos.principal", principal);
            }
        }
        this.filterConfig.put("delegation-token.token-kind", TimelineDelegationTokenIdentifier.KIND_NAME.toString());
        container.addGlobalFilter("Timeline Authentication Filter", TimelineAuthenticationFilter.class.getName(), this.filterConfig);
    }
}

