/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.mapred.IFileInputStream;
import org.apache.hadoop.mapred.IFileOutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestIFileStreams {
    @Test
    public void testIFileStream() throws Exception {
        int DLEN = 100;
        DataOutputBuffer dob = new DataOutputBuffer(104);
        IFileOutputStream ifos = new IFileOutputStream((OutputStream)dob);
        for (int i = 0; i < 100; ++i) {
            ifos.write(i);
        }
        ifos.close();
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(dob.getData(), 104);
        IFileInputStream ifis = new IFileInputStream((InputStream)dib, 104L, new Configuration());
        for (int i = 0; i < 100; ++i) {
            Assert.assertEquals((long)i, (long)ifis.read());
        }
        ifis.close();
    }

    @Test
    public void testBadIFileStream() throws Exception {
        int i;
        int DLEN = 100;
        DataOutputBuffer dob = new DataOutputBuffer(104);
        IFileOutputStream ifos = new IFileOutputStream((OutputStream)dob);
        for (int i2 = 0; i2 < 100; ++i2) {
            ifos.write(i2);
        }
        ifos.close();
        DataInputBuffer dib = new DataInputBuffer();
        byte[] b = dob.getData();
        b[17] = (byte)(b[17] + 1);
        dib.reset(b, 104);
        IFileInputStream ifis = new IFileInputStream((InputStream)dib, 104L, new Configuration());
        try {
            for (i = 0; i < 100; ++i) {
                if (17 == i) {
                    Assert.assertEquals((long)18L, (long)ifis.read());
                    continue;
                }
                Assert.assertEquals((long)i, (long)ifis.read());
            }
            ifis.close();
        }
        catch (ChecksumException e) {
            Assert.assertEquals((String)"Unexpected bad checksum", (long)99L, (long)i);
            return;
        }
        Assert.fail((String)"Did not detect bad data in checksum");
    }

    @Test
    public void testBadLength() throws Exception {
        int DLEN = 100;
        DataOutputBuffer dob = new DataOutputBuffer(104);
        IFileOutputStream ifos = new IFileOutputStream((OutputStream)dob);
        for (int i = 0; i < 100; ++i) {
            ifos.write(i);
        }
        ifos.close();
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(dob.getData(), 104);
        IFileInputStream ifis = new IFileInputStream((InputStream)dib, 100L, new Configuration());
        int i = 0;
        try {
            while (i < 92) {
                Assert.assertEquals((long)i++, (long)ifis.read());
            }
            ifis.close();
        }
        catch (ChecksumException e) {
            Assert.assertEquals((String)"Checksum before close", (long)i, (long)92L);
            return;
        }
        Assert.fail((String)"Did not detect bad data in checksum");
    }

    @Test
    public void testCloseStreamOnException() throws Exception {
        OutputStream outputStream = (OutputStream)Mockito.mock(OutputStream.class);
        IFileOutputStream ifos = new IFileOutputStream(outputStream);
        ((OutputStream)Mockito.doThrow((Throwable)new IOException("Dummy Exception")).when((Object)outputStream)).flush();
        try {
            ifos.close();
            Assert.fail((String)"IOException is not thrown");
        }
        catch (IOException ioe) {
            Assert.assertEquals((Object)"Dummy Exception", (Object)ioe.getMessage());
        }
        ((OutputStream)Mockito.verify((Object)outputStream)).close();
    }
}

