/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.net.InetAddress;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ipc.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HSAuditLogger {
    private static final Logger LOG = LoggerFactory.getLogger(HSAuditLogger.class);

    public static void logSuccess(String user, String operation, String target) {
        if (LOG.isInfoEnabled()) {
            LOG.info(HSAuditLogger.createSuccessLog(user, operation, target));
        }
    }

    static String createSuccessLog(String user, String operation, String target) {
        StringBuilder b = new StringBuilder();
        HSAuditLogger.start(Keys.USER, user, b);
        HSAuditLogger.addRemoteIP(b);
        HSAuditLogger.add(Keys.OPERATION, operation, b);
        HSAuditLogger.add(Keys.TARGET, target, b);
        HSAuditLogger.add(Keys.RESULT, "SUCCESS", b);
        return b.toString();
    }

    static void addRemoteIP(StringBuilder b) {
        InetAddress ip = Server.getRemoteIp();
        if (ip != null) {
            HSAuditLogger.add(Keys.IP, ip.getHostAddress(), b);
        }
    }

    static void add(Keys key, String value, StringBuilder b) {
        b.append('\t').append(key.name()).append("=").append(value);
    }

    static void start(Keys key, String value, StringBuilder b) {
        b.append(key.name()).append("=").append(value);
    }

    public static void logFailure(String user, String operation, String perm, String target, String description) {
        if (LOG.isWarnEnabled()) {
            LOG.warn(HSAuditLogger.createFailureLog(user, operation, perm, target, description));
        }
    }

    static String createFailureLog(String user, String operation, String perm, String target, String description) {
        StringBuilder b = new StringBuilder();
        HSAuditLogger.start(Keys.USER, user, b);
        HSAuditLogger.addRemoteIP(b);
        HSAuditLogger.add(Keys.OPERATION, operation, b);
        HSAuditLogger.add(Keys.TARGET, target, b);
        HSAuditLogger.add(Keys.RESULT, "FAILURE", b);
        HSAuditLogger.add(Keys.DESCRIPTION, description, b);
        HSAuditLogger.add(Keys.PERMISSIONS, perm, b);
        return b.toString();
    }

    public static class AuditConstants {
        static final String SUCCESS = "SUCCESS";
        static final String FAILURE = "FAILURE";
        static final String KEY_VAL_SEPARATOR = "=";
        static final char PAIR_SEPARATOR = '\t';
        public static final String UNAUTHORIZED_USER = "Unauthorized user";
    }

    static enum Keys {
        USER,
        OPERATION,
        TARGET,
        RESULT,
        IP,
        PERMISSIONS,
        DESCRIPTION;

    }
}

