/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.MapReduceChildJVM;
import org.apache.hadoop.mapred.ShuffleHandler;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptContextImpl;
import org.apache.hadoop.mapred.WrappedJvmID;
import org.apache.hadoop.mapred.WrappedProgressSplitsBlock;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobCounter;
import org.apache.hadoop.mapreduce.MRJobConfig;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.jobhistory.MapAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.ReduceAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.v2.api.records.Avataar;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.Locality;
import org.apache.hadoop.mapreduce.v2.api.records.Phase;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import org.apache.hadoop.mapreduce.v2.app.commit.CommitterTaskAbortEvent;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttemptStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobCounterUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobTaskAttemptFetchFailureEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptContainerAssignedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptContainerLaunchedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptFailEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptKillEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptRecoverEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptStatusUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptTooManyFetchFailureEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskTAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskTAttemptFailedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskTAttemptKilledEvent;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncher;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncherEvent;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerRemoteLaunchEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocatorEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerRequestEvent;
import org.apache.hadoop.mapreduce.v2.app.speculate.SpeculatorEvent;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringInterner;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.state.InvalidStateTransitionException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.RackResolver;
import org.apache.hadoop.yarn.util.UnitsConversionUtil;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TaskAttemptImpl
implements TaskAttempt,
EventHandler<TaskAttemptEvent> {
    static final Counters EMPTY_COUNTERS = new Counters();
    private static final Logger LOG = LoggerFactory.getLogger(TaskAttemptImpl.class);
    private static final long MEMORY_SPLITS_RESOLUTION = 1024L;
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    protected final JobConf conf;
    protected final Path jobFile;
    protected final int partition;
    protected EventHandler eventHandler;
    private final TaskAttemptId attemptId;
    private final Clock clock;
    private final JobID oldJobId;
    private final TaskAttemptListener taskAttemptListener;
    private final Resource resourceCapability;
    protected Set<String> dataLocalHosts;
    protected Set<String> dataLocalRacks;
    private final List<String> diagnostics = new ArrayList<String>();
    private final Lock readLock;
    private final Lock writeLock;
    private final AppContext appContext;
    private Credentials credentials;
    private Token<JobTokenIdentifier> jobToken;
    private static AtomicBoolean initialClasspathFlag = new AtomicBoolean();
    private static String initialClasspath = null;
    private static String initialAppClasspath = null;
    private static Object commonContainerSpecLock = new Object();
    private static ContainerLaunchContext commonContainerSpec = null;
    private static final Object classpathLock = new Object();
    private long launchTime;
    private long finishTime;
    private WrappedProgressSplitsBlock progressSplitBlock;
    private int shufflePort = -1;
    private String trackerName;
    private int httpPort;
    private Locality locality;
    private Avataar avataar;
    private boolean rescheduleNextAttempt = false;
    private boolean failFast = false;
    private static final CleanupContainerTransition CLEANUP_CONTAINER_TRANSITION = new CleanupContainerTransition();
    private static final MoveContainerToSucceededFinishingTransition SUCCEEDED_FINISHING_TRANSITION = new MoveContainerToSucceededFinishingTransition();
    private static final MoveContainerToFailedFinishingTransition FAILED_FINISHING_TRANSITION = new MoveContainerToFailedFinishingTransition();
    private static final ExitFinishingOnTimeoutTransition FINISHING_ON_TIMEOUT_TRANSITION = new ExitFinishingOnTimeoutTransition();
    private static final FinalizeFailedTransition FINALIZE_FAILED_TRANSITION = new FinalizeFailedTransition();
    private static final DiagnosticInformationUpdater DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION = new DiagnosticInformationUpdater();
    private static final EnumSet<TaskAttemptEventType> FAILED_KILLED_STATE_IGNORED_EVENTS = EnumSet.of(TaskAttemptEventType.TA_KILL, new TaskAttemptEventType[]{TaskAttemptEventType.TA_ASSIGNED, TaskAttemptEventType.TA_CONTAINER_COMPLETED, TaskAttemptEventType.TA_UPDATE, TaskAttemptEventType.TA_CONTAINER_LAUNCHED, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED, TaskAttemptEventType.TA_CONTAINER_CLEANED, TaskAttemptEventType.TA_COMMIT_PENDING, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_FAILMSG_BY_CLIENT, TaskAttemptEventType.TA_TIMED_OUT, TaskAttemptEventType.TA_TOO_MANY_FETCH_FAILURE});
    private static final StateMachineFactory<TaskAttemptImpl, TaskAttemptStateInternal, TaskAttemptEventType, TaskAttemptEvent> stateMachineFactory = new StateMachineFactory((Enum)TaskAttemptStateInternal.NEW).addTransition((Enum)TaskAttemptStateInternal.NEW, (Enum)TaskAttemptStateInternal.UNASSIGNED, (Enum)TaskAttemptEventType.TA_SCHEDULE, (SingleArcTransition)new RequestContainerTransition(false)).addTransition((Enum)TaskAttemptStateInternal.NEW, (Enum)TaskAttemptStateInternal.UNASSIGNED, (Enum)TaskAttemptEventType.TA_RESCHEDULE, (SingleArcTransition)new RequestContainerTransition(true)).addTransition((Enum)TaskAttemptStateInternal.NEW, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_KILL, (SingleArcTransition)new KilledTransition()).addTransition((Enum)TaskAttemptStateInternal.NEW, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_FAILMSG_BY_CLIENT, (SingleArcTransition)new FailedTransition()).addTransition((Enum)TaskAttemptStateInternal.NEW, EnumSet.of(TaskAttemptStateInternal.FAILED, TaskAttemptStateInternal.KILLED, TaskAttemptStateInternal.SUCCEEDED), (Enum)TaskAttemptEventType.TA_RECOVER, (MultipleArcTransition)new RecoverTransition()).addTransition((Enum)TaskAttemptStateInternal.NEW, (Enum)TaskAttemptStateInternal.NEW, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.UNASSIGNED, (Enum)TaskAttemptStateInternal.ASSIGNED, (Enum)TaskAttemptEventType.TA_ASSIGNED, (SingleArcTransition)new ContainerAssignedTransition()).addTransition((Enum)TaskAttemptStateInternal.UNASSIGNED, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_KILL, (SingleArcTransition)new DeallocateContainerTransition(TaskAttemptStateInternal.KILLED, true)).addTransition((Enum)TaskAttemptStateInternal.UNASSIGNED, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_FAILMSG_BY_CLIENT, (SingleArcTransition)new DeallocateContainerTransition(TaskAttemptStateInternal.FAILED, true)).addTransition((Enum)TaskAttemptStateInternal.UNASSIGNED, (Enum)TaskAttemptStateInternal.UNASSIGNED, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.ASSIGNED, (Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptEventType.TA_CONTAINER_LAUNCHED, (SingleArcTransition)new LaunchedContainerTransition()).addTransition((Enum)TaskAttemptStateInternal.ASSIGNED, (Enum)TaskAttemptStateInternal.ASSIGNED, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.ASSIGNED, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED, (SingleArcTransition)new DeallocateContainerTransition(TaskAttemptStateInternal.FAILED, false)).addTransition((Enum)TaskAttemptStateInternal.ASSIGNED, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_CONTAINER_COMPLETED, (SingleArcTransition)FINALIZE_FAILED_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.ASSIGNED, (Enum)TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_KILL, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.ASSIGNED, (Enum)TaskAttemptStateInternal.FAIL_FINISHING_CONTAINER, (Enum)TaskAttemptEventType.TA_FAILMSG, (SingleArcTransition)FAILED_FINISHING_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.ASSIGNED, (Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_FAILMSG_BY_CLIENT, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptEventType.TA_UPDATE, (SingleArcTransition)new StatusUpdater()).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.SUCCESS_FINISHING_CONTAINER, (Enum)TaskAttemptEventType.TA_DONE, (SingleArcTransition)SUCCEEDED_FINISHING_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptEventType.TA_COMMIT_PENDING, (SingleArcTransition)new CommitPendingTransition()).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.FAIL_FINISHING_CONTAINER, (Enum)TaskAttemptEventType.TA_FAILMSG, (SingleArcTransition)FAILED_FINISHING_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_FAILMSG_BY_CLIENT, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_CONTAINER_COMPLETED, (SingleArcTransition)FINALIZE_FAILED_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_TIMED_OUT, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_CONTAINER_CLEANED, (SingleArcTransition)new KilledTransition()).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_KILL, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_PREEMPTED, (SingleArcTransition)new PreemptedTransition()).addTransition((Enum)TaskAttemptStateInternal.SUCCESS_FINISHING_CONTAINER, (Enum)TaskAttemptStateInternal.SUCCEEDED, (Enum)TaskAttemptEventType.TA_CONTAINER_COMPLETED, (SingleArcTransition)new ExitFinishingOnContainerCompletedTransition()).addTransition((Enum)TaskAttemptStateInternal.SUCCESS_FINISHING_CONTAINER, (Enum)TaskAttemptStateInternal.SUCCEEDED, (Enum)TaskAttemptEventType.TA_CONTAINER_CLEANED, (SingleArcTransition)new ExitFinishingOnContainerCleanedupTransition()).addTransition((Enum)TaskAttemptStateInternal.SUCCESS_FINISHING_CONTAINER, EnumSet.of(TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP), (Enum)TaskAttemptEventType.TA_KILL, (MultipleArcTransition)new KilledAfterSucceededFinishingTransition()).addTransition((Enum)TaskAttemptStateInternal.SUCCESS_FINISHING_CONTAINER, (Enum)TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_TIMED_OUT, (SingleArcTransition)FINISHING_ON_TIMEOUT_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.SUCCESS_FINISHING_CONTAINER, (Enum)TaskAttemptStateInternal.SUCCESS_FINISHING_CONTAINER, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.SUCCESS_FINISHING_CONTAINER, (Enum)TaskAttemptStateInternal.SUCCESS_FINISHING_CONTAINER, EnumSet.of(TaskAttemptEventType.TA_UPDATE, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_COMMIT_PENDING, TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_FAILMSG_BY_CLIENT)).addTransition((Enum)TaskAttemptStateInternal.FAIL_FINISHING_CONTAINER, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_CONTAINER_COMPLETED, (SingleArcTransition)new ExitFinishingOnContainerCompletedTransition()).addTransition((Enum)TaskAttemptStateInternal.FAIL_FINISHING_CONTAINER, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_CONTAINER_CLEANED, (SingleArcTransition)new ExitFinishingOnContainerCleanedupTransition()).addTransition((Enum)TaskAttemptStateInternal.FAIL_FINISHING_CONTAINER, (Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_TIMED_OUT, (SingleArcTransition)FINISHING_ON_TIMEOUT_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.FAIL_FINISHING_CONTAINER, (Enum)TaskAttemptStateInternal.FAIL_FINISHING_CONTAINER, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.FAIL_FINISHING_CONTAINER, (Enum)TaskAttemptStateInternal.FAIL_FINISHING_CONTAINER, EnumSet.of(TaskAttemptEventType.TA_KILL, new TaskAttemptEventType[]{TaskAttemptEventType.TA_UPDATE, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_COMMIT_PENDING, TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_FAILMSG_BY_CLIENT})).addTransition((Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptEventType.TA_UPDATE, (SingleArcTransition)new StatusUpdater()).addTransition((Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptStateInternal.SUCCESS_FINISHING_CONTAINER, (Enum)TaskAttemptEventType.TA_DONE, (SingleArcTransition)SUCCEEDED_FINISHING_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_KILL, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_CONTAINER_CLEANED, (SingleArcTransition)new KilledTransition()).addTransition((Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptStateInternal.FAIL_FINISHING_CONTAINER, (Enum)TaskAttemptEventType.TA_FAILMSG, (SingleArcTransition)FAILED_FINISHING_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_FAILMSG_BY_CLIENT, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_CONTAINER_COMPLETED, (SingleArcTransition)FINALIZE_FAILED_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_TIMED_OUT, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptEventType.TA_COMMIT_PENDING).addTransition((Enum)TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, (Enum)TaskAttemptStateInternal.SUCCEEDED, (Enum)TaskAttemptEventType.TA_CONTAINER_CLEANED).addTransition((Enum)TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, (Enum)TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, (Enum)TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, EnumSet.of(TaskAttemptEventType.TA_KILL, TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_FAILMSG_BY_CLIENT, TaskAttemptEventType.TA_TIMED_OUT, TaskAttemptEventType.TA_CONTAINER_COMPLETED)).addTransition((Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptStateInternal.FAIL_TASK_CLEANUP, (Enum)TaskAttemptEventType.TA_CONTAINER_CLEANED, (SingleArcTransition)new TaskCleanupTransition()).addTransition((Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, EnumSet.of(TaskAttemptEventType.TA_KILL, new TaskAttemptEventType[]{TaskAttemptEventType.TA_CONTAINER_COMPLETED, TaskAttemptEventType.TA_UPDATE, TaskAttemptEventType.TA_COMMIT_PENDING, TaskAttemptEventType.TA_CONTAINER_LAUNCHED, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_FAILMSG_BY_CLIENT, TaskAttemptEventType.TA_TIMED_OUT})).addTransition((Enum)TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, (Enum)TaskAttemptStateInternal.KILL_TASK_CLEANUP, (Enum)TaskAttemptEventType.TA_CONTAINER_CLEANED, (SingleArcTransition)new TaskCleanupTransition()).addTransition((Enum)TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, (Enum)TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, (Enum)TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, EnumSet.of(TaskAttemptEventType.TA_KILL, new TaskAttemptEventType[]{TaskAttemptEventType.TA_CONTAINER_COMPLETED, TaskAttemptEventType.TA_UPDATE, TaskAttemptEventType.TA_COMMIT_PENDING, TaskAttemptEventType.TA_CONTAINER_LAUNCHED, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_FAILMSG_BY_CLIENT, TaskAttemptEventType.TA_TIMED_OUT})).addTransition((Enum)TaskAttemptStateInternal.FAIL_TASK_CLEANUP, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_CLEANUP_DONE, (SingleArcTransition)new FailedTransition()).addTransition((Enum)TaskAttemptStateInternal.FAIL_TASK_CLEANUP, (Enum)TaskAttemptStateInternal.FAIL_TASK_CLEANUP, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.FAIL_TASK_CLEANUP, (Enum)TaskAttemptStateInternal.FAIL_TASK_CLEANUP, EnumSet.of(TaskAttemptEventType.TA_KILL, new TaskAttemptEventType[]{TaskAttemptEventType.TA_CONTAINER_COMPLETED, TaskAttemptEventType.TA_UPDATE, TaskAttemptEventType.TA_COMMIT_PENDING, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_FAILMSG_BY_CLIENT, TaskAttemptEventType.TA_CONTAINER_CLEANED, TaskAttemptEventType.TA_CONTAINER_LAUNCHED, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED})).addTransition((Enum)TaskAttemptStateInternal.KILL_TASK_CLEANUP, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_CLEANUP_DONE, (SingleArcTransition)new KilledTransition()).addTransition((Enum)TaskAttemptStateInternal.KILL_TASK_CLEANUP, (Enum)TaskAttemptStateInternal.KILL_TASK_CLEANUP, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.KILL_TASK_CLEANUP, (Enum)TaskAttemptStateInternal.KILL_TASK_CLEANUP, EnumSet.of(TaskAttemptEventType.TA_KILL, new TaskAttemptEventType[]{TaskAttemptEventType.TA_CONTAINER_COMPLETED, TaskAttemptEventType.TA_UPDATE, TaskAttemptEventType.TA_COMMIT_PENDING, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_FAILMSG_BY_CLIENT, TaskAttemptEventType.TA_CONTAINER_CLEANED, TaskAttemptEventType.TA_PREEMPTED, TaskAttemptEventType.TA_CONTAINER_LAUNCHED, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED})).addTransition((Enum)TaskAttemptStateInternal.SUCCEEDED, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_TOO_MANY_FETCH_FAILURE, (SingleArcTransition)new TooManyFetchFailureTransition()).addTransition((Enum)TaskAttemptStateInternal.SUCCEEDED, EnumSet.of(TaskAttemptStateInternal.SUCCEEDED, TaskAttemptStateInternal.KILLED), (Enum)TaskAttemptEventType.TA_KILL, (MultipleArcTransition)new KilledAfterSuccessTransition()).addTransition((Enum)TaskAttemptStateInternal.SUCCEEDED, (Enum)TaskAttemptStateInternal.SUCCEEDED, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.SUCCEEDED, (Enum)TaskAttemptStateInternal.SUCCEEDED, EnumSet.of(TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_FAILMSG_BY_CLIENT, TaskAttemptEventType.TA_TIMED_OUT, TaskAttemptEventType.TA_CONTAINER_CLEANED, TaskAttemptEventType.TA_CONTAINER_COMPLETED)).addTransition((Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptStateInternal.FAILED, FAILED_KILLED_STATE_IGNORED_EVENTS).addTransition((Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptStateInternal.KILLED, FAILED_KILLED_STATE_IGNORED_EVENTS).installTopology();
    private final StateMachine<TaskAttemptStateInternal, TaskAttemptEventType, TaskAttemptEvent> stateMachine;
    @VisibleForTesting
    public Container container;
    private String nodeRackName;
    private WrappedJvmID jvmID;
    private Task remoteTask;
    private TaskAttemptStatusUpdateEvent.TaskAttemptStatus reportedStatus;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Pattern ipPattern = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");

    public TaskAttemptImpl(TaskId taskId, int i, EventHandler eventHandler, TaskAttemptListener taskAttemptListener, Path jobFile, int partition, JobConf conf, String[] dataLocalHosts, Token<JobTokenIdentifier> jobToken, Credentials credentials, Clock clock, AppContext appContext) {
        this.oldJobId = TypeConverter.fromYarn((JobId)taskId.getJobId());
        this.conf = conf;
        this.clock = clock;
        this.attemptId = (TaskAttemptId)recordFactory.newRecordInstance(TaskAttemptId.class);
        this.attemptId.setTaskId(taskId);
        this.attemptId.setId(i);
        this.taskAttemptListener = taskAttemptListener;
        this.appContext = appContext;
        this.reportedStatus = new TaskAttemptStatusUpdateEvent.TaskAttemptStatus();
        this.initTaskAttemptStatus(this.reportedStatus);
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        this.credentials = credentials;
        this.jobToken = jobToken;
        this.eventHandler = eventHandler;
        this.jobFile = jobFile;
        this.partition = partition;
        this.resourceCapability = (Resource)recordFactory.newRecordInstance(Resource.class);
        this.populateResourceCapability(taskId.getTaskType());
        this.dataLocalHosts = this.resolveHosts(dataLocalHosts);
        RackResolver.init((Configuration)conf);
        this.dataLocalRacks = new HashSet<String>();
        for (String host : this.dataLocalHosts) {
            this.dataLocalRacks.add(RackResolver.resolve((String)host).getNetworkLocation());
        }
        this.locality = Locality.OFF_SWITCH;
        this.avataar = Avataar.VIRGIN;
        this.stateMachine = stateMachineFactory.make((Object)this);
    }

    private void populateResourceCapability(TaskType taskType) {
        String resourceTypePrefix = this.getResourceTypePrefix(taskType);
        boolean memorySet = false;
        boolean cpuVcoresSet = false;
        if (resourceTypePrefix != null) {
            List resourceRequests = ResourceUtils.getRequestedResourcesFromConfig((Configuration)this.conf, (String)resourceTypePrefix);
            for (ResourceInformation resourceRequest : resourceRequests) {
                String resourceName = resourceRequest.getName();
                if ("memory".equals(resourceName) || "memory-mb".equals(resourceName)) {
                    if (memorySet) {
                        throw new IllegalArgumentException("Only one of the following keys can be specified for a single job: memory-mb, memory");
                    }
                    String units = StringUtils.isEmpty((String)resourceRequest.getUnits()) ? ResourceUtils.getDefaultUnit((String)"memory-mb") : resourceRequest.getUnits();
                    this.resourceCapability.setMemorySize(UnitsConversionUtil.convert((String)units, (String)"Mi", (long)resourceRequest.getValue()));
                    memorySet = true;
                    String memoryKey = this.getMemoryKey(taskType);
                    if (memoryKey == null || this.conf.get(memoryKey) == null) continue;
                    LOG.warn("Configuration " + resourceTypePrefix + resourceName + "=" + resourceRequest.getValue() + resourceRequest.getUnits() + " is overriding the " + memoryKey + "=" + this.conf.get(memoryKey) + " configuration");
                    continue;
                }
                if ("vcores".equals(resourceName)) {
                    this.resourceCapability.setVirtualCores((int)UnitsConversionUtil.convert((String)resourceRequest.getUnits(), (String)"", (long)resourceRequest.getValue()));
                    cpuVcoresSet = true;
                    String cpuKey = this.getCpuVcoresKey(taskType);
                    if (cpuKey == null || this.conf.get(cpuKey) == null) continue;
                    LOG.warn("Configuration " + resourceTypePrefix + "vcores" + "=" + resourceRequest.getValue() + resourceRequest.getUnits() + " is overriding the " + cpuKey + "=" + this.conf.get(cpuKey) + " configuration");
                    continue;
                }
                ResourceInformation resourceInformation = this.resourceCapability.getResourceInformation(resourceName);
                resourceInformation.setUnits(resourceRequest.getUnits());
                resourceInformation.setValue(resourceRequest.getValue());
                this.resourceCapability.setResourceInformation(resourceName, resourceInformation);
            }
        }
        if (!memorySet) {
            this.resourceCapability.setMemorySize((long)this.getMemoryRequired(this.conf, taskType));
        }
        if (!cpuVcoresSet) {
            this.resourceCapability.setVirtualCores(this.getCpuRequired((Configuration)this.conf, taskType));
        }
    }

    private String getCpuVcoresKey(TaskType taskType) {
        switch (taskType) {
            case MAP: {
                return "mapreduce.map.cpu.vcores";
            }
            case REDUCE: {
                return "mapreduce.reduce.cpu.vcores";
            }
        }
        return null;
    }

    private String getMemoryKey(TaskType taskType) {
        switch (taskType) {
            case MAP: {
                return "mapreduce.map.memory.mb";
            }
            case REDUCE: {
                return "mapreduce.reduce.memory.mb";
            }
        }
        return null;
    }

    private Integer getCpuVcoreDefault(TaskType taskType) {
        switch (taskType) {
            case MAP: {
                return 1;
            }
            case REDUCE: {
                return 1;
            }
        }
        return null;
    }

    private int getMemoryRequired(JobConf conf, TaskType taskType) {
        return conf.getMemoryRequired(TypeConverter.fromYarn((TaskType)taskType));
    }

    private int getCpuRequired(Configuration conf, TaskType taskType) {
        int vcores = 1;
        String cpuVcoreKey = this.getCpuVcoresKey(taskType);
        if (cpuVcoreKey != null) {
            Integer defaultCpuVcores = this.getCpuVcoreDefault(taskType);
            if (null == defaultCpuVcores) {
                defaultCpuVcores = vcores;
            }
            vcores = conf.getInt(cpuVcoreKey, defaultCpuVcores.intValue());
        }
        return vcores;
    }

    private String getResourceTypePrefix(TaskType taskType) {
        switch (taskType) {
            case MAP: {
                return "mapreduce.map.resource.";
            }
            case REDUCE: {
                return "mapreduce.reduce.resource.";
            }
        }
        LOG.info("TaskType " + taskType + " does not support custom resource types - this support can be added in " + this.getClass().getSimpleName());
        return null;
    }

    private static LocalResource createLocalResource(FileSystem fc, Path file, String fileSymlink, LocalResourceType type, LocalResourceVisibility visibility) throws IOException {
        FileStatus fstat = fc.getFileStatus(file);
        Path qualifiedPath = fc.resolvePath(fstat.getPath());
        URI uriWithFragment = null;
        boolean useFragment = fileSymlink != null && !fileSymlink.equals("");
        try {
            uriWithFragment = useFragment ? new URI(qualifiedPath.toUri() + "#" + fileSymlink) : qualifiedPath.toUri();
        }
        catch (URISyntaxException e) {
            throw new IOException("Error parsing local resource path. Path was not able to be converted to a URI: " + qualifiedPath, e);
        }
        URL resourceURL = URL.fromURI((URI)uriWithFragment);
        long resourceSize = fstat.getLen();
        long resourceModificationTime = fstat.getModificationTime();
        return LocalResource.newInstance((URL)resourceURL, (LocalResourceType)type, (LocalResourceVisibility)visibility, (long)resourceSize, (long)resourceModificationTime, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getInitialClasspath(Configuration conf) throws IOException {
        Object object = classpathLock;
        synchronized (object) {
            if (initialClasspathFlag.get()) {
                return initialClasspath;
            }
            HashMap env = new HashMap();
            MRApps.setClasspath(env, (Configuration)conf);
            initialClasspath = (String)env.get(ApplicationConstants.Environment.CLASSPATH.name());
            initialAppClasspath = (String)env.get(ApplicationConstants.Environment.APP_CLASSPATH.name());
            initialClasspathFlag.set(true);
            return initialClasspath;
        }
    }

    private static ContainerLaunchContext createCommonContainerLaunchContext(Map<ApplicationAccessType, String> applicationACLs, Configuration conf, Token<JobTokenIdentifier> jobToken, JobID oldJobId, Credentials credentials) {
        Map<String, String> environment;
        HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
        HashMap<String, ByteBuffer> serviceData = new HashMap<String, ByteBuffer>();
        ByteBuffer taskCredentialsBuffer = ByteBuffer.wrap(new byte[0]);
        try {
            TaskAttemptImpl.configureJobJar(conf, localResources);
            TaskAttemptImpl.configureJobConf(conf, localResources, oldJobId);
            MRApps.setupDistributedCache((Configuration)conf, localResources);
            taskCredentialsBuffer = TaskAttemptImpl.configureTokens(jobToken, credentials, serviceData);
            TaskAttemptImpl.addExternalShuffleProviders(conf, serviceData);
            environment = TaskAttemptImpl.configureEnv(conf);
        }
        catch (IOException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
        ContainerLaunchContext container = ContainerLaunchContext.newInstance(localResources, environment, null, serviceData, (ByteBuffer)taskCredentialsBuffer, applicationACLs);
        return container;
    }

    private static Map<String, String> configureEnv(Configuration conf) throws IOException {
        HashMap<String, String> environment = new HashMap<String, String>();
        MRApps.addToEnvironment(environment, (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)TaskAttemptImpl.getInitialClasspath(conf), (Configuration)conf);
        if (initialAppClasspath != null) {
            MRApps.addToEnvironment(environment, (String)ApplicationConstants.Environment.APP_CLASSPATH.name(), (String)initialAppClasspath, (Configuration)conf);
        }
        environment.put(ApplicationConstants.Environment.SHELL.name(), conf.get("mapreduce.admin.user.shell", "/bin/bash"));
        MRApps.addToEnvironment(environment, (String)ApplicationConstants.Environment.LD_LIBRARY_PATH.name(), (String)MRApps.crossPlatformifyMREnv((Configuration)conf, (ApplicationConstants.Environment)ApplicationConstants.Environment.PWD), (Configuration)conf);
        MRApps.setEnvFromInputString(environment, (String)conf.get("mapreduce.admin.user.env", MRJobConfig.DEFAULT_MAPRED_ADMIN_USER_ENV), (Configuration)conf);
        return environment;
    }

    private static void configureJobJar(Configuration conf, Map<String, LocalResource> localResources) throws IOException {
        String jobJar = conf.get("mapreduce.job.jar");
        if (jobJar != null) {
            Path jobJarPath = new Path(jobJar);
            FileSystem jobJarFs = FileSystem.get((URI)jobJarPath.toUri(), (Configuration)conf);
            Path remoteJobJar = jobJarPath.makeQualified(jobJarFs.getUri(), jobJarFs.getWorkingDirectory());
            LocalResourceVisibility jobJarViz = conf.getBoolean("mapreduce.job.jobjar.visibility", false) ? LocalResourceVisibility.PUBLIC : LocalResourceVisibility.APPLICATION;
            LocalResource rc = TaskAttemptImpl.createLocalResource(jobJarFs, remoteJobJar, "job.jar", LocalResourceType.PATTERN, jobJarViz);
            String pattern = conf.getPattern("mapreduce.job.jar.unpack.pattern", JobConf.UNPACK_JAR_PATTERN_DEFAULT).pattern();
            rc.setPattern(pattern);
            localResources.put("job.jar", rc);
            LOG.info("The job-jar file on the remote FS is " + remoteJobJar.toUri().toASCIIString());
        } else {
            LOG.info("Job jar is not present. Not adding any jar to the list of resources.");
        }
    }

    private static void configureJobConf(Configuration conf, Map<String, LocalResource> localResources, JobID oldJobId) throws IOException {
        Path path = MRApps.getStagingAreaDir((Configuration)conf, (String)UserGroupInformation.getCurrentUser().getShortUserName());
        Path remoteJobSubmitDir = new Path(path, oldJobId.toString());
        Path remoteJobConfPath = new Path(remoteJobSubmitDir, "job.xml");
        FileSystem remoteFS = FileSystem.get((Configuration)conf);
        localResources.put("job.xml", TaskAttemptImpl.createLocalResource(remoteFS, remoteJobConfPath, null, LocalResourceType.FILE, LocalResourceVisibility.APPLICATION));
        LOG.info("The job-conf file on the remote FS is " + remoteJobConfPath.toUri().toASCIIString());
    }

    private static ByteBuffer configureTokens(Token<JobTokenIdentifier> jobToken, Credentials credentials, Map<String, ByteBuffer> serviceData) throws IOException {
        LOG.info("Adding #" + credentials.numberOfTokens() + " tokens and #" + credentials.numberOfSecretKeys() + " secret keys for NM use for launching container");
        Credentials taskCredentials = new Credentials(credentials);
        TokenCache.setJobToken(jobToken, (Credentials)taskCredentials);
        DataOutputBuffer containerTokens_dob = new DataOutputBuffer();
        LOG.info("Size of containertokens_dob is " + taskCredentials.numberOfTokens());
        taskCredentials.writeTokenStorageToStream((DataOutputStream)containerTokens_dob);
        ByteBuffer taskCredentialsBuffer = ByteBuffer.wrap(containerTokens_dob.getData(), 0, containerTokens_dob.getLength());
        LOG.info("Putting shuffle token in serviceData");
        byte[] shuffleSecret = TokenCache.getShuffleSecretKey((Credentials)credentials);
        if (shuffleSecret == null) {
            LOG.warn("Cannot locate shuffle secret in credentials. Using job token as shuffle secret.");
            shuffleSecret = jobToken.getPassword();
        }
        Token shuffleToken = new Token(jobToken.getIdentifier(), shuffleSecret, jobToken.getKind(), jobToken.getService());
        serviceData.put("mapreduce_shuffle", ShuffleHandler.serializeServiceData((Token)shuffleToken));
        return taskCredentialsBuffer;
    }

    private static void addExternalShuffleProviders(Configuration conf, Map<String, ByteBuffer> serviceData) {
        Collection shuffleProviders = conf.getStringCollection("mapreduce.job.shuffle.provider.services");
        if (!shuffleProviders.isEmpty()) {
            Collection auxNames = conf.getStringCollection("yarn.nodemanager.aux-services");
            for (String shuffleProvider : shuffleProviders) {
                if (shuffleProvider.equals("mapreduce_shuffle")) continue;
                if (auxNames.contains(shuffleProvider)) {
                    LOG.info("Adding ShuffleProvider Service: " + shuffleProvider + " to serviceData");
                    serviceData.put(shuffleProvider, ByteBuffer.allocate(0));
                    continue;
                }
                throw new YarnRuntimeException("ShuffleProvider Service: " + shuffleProvider + " was NOT found in the list of aux-services that are available in this NM. You may need to specify this ShuffleProvider as an aux-service in your yarn-site.xml");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ContainerLaunchContext createContainerLaunchContext(Map<ApplicationAccessType, String> applicationACLs, Configuration conf, Token<JobTokenIdentifier> jobToken, Task remoteTask, JobID oldJobId, WrappedJvmID jvmID, TaskAttemptListener taskAttemptListener, Credentials credentials) {
        Object object = commonContainerSpecLock;
        synchronized (object) {
            if (commonContainerSpec == null) {
                commonContainerSpec = TaskAttemptImpl.createCommonContainerLaunchContext(applicationACLs, conf, jobToken, oldJobId, credentials);
            }
        }
        boolean userClassesTakesPrecedence = conf.getBoolean("mapreduce.job.user.classpath.first", false);
        Map env = commonContainerSpec.getEnvironment();
        HashMap<String, String> myEnv = new HashMap<String, String>(env.size());
        myEnv.putAll(env);
        if (userClassesTakesPrecedence) {
            myEnv.put(ApplicationConstants.Environment.CLASSPATH_PREPEND_DISTCACHE.name(), "true");
        }
        MapReduceChildJVM.setVMEnv(myEnv, remoteTask);
        List<String> commands = MapReduceChildJVM.getVMCommand(taskAttemptListener.getAddress(), remoteTask, jvmID);
        HashMap myServiceData = new HashMap();
        for (Map.Entry entry : commonContainerSpec.getServiceData().entrySet()) {
            myServiceData.put(entry.getKey(), ((ByteBuffer)entry.getValue()).duplicate());
        }
        ContainerLaunchContext container = ContainerLaunchContext.newInstance((Map)commonContainerSpec.getLocalResources(), myEnv, commands, myServiceData, (ByteBuffer)commonContainerSpec.getTokens().duplicate(), applicationACLs);
        return container;
    }

    @Override
    public ContainerId getAssignedContainerID() {
        this.readLock.lock();
        try {
            ContainerId containerId = this.container == null ? null : this.container.getId();
            return containerId;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getAssignedContainerMgrAddress() {
        this.readLock.lock();
        try {
            String string = this.container == null ? null : StringInterner.weakIntern((String)this.container.getNodeId().toString());
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getLaunchTime() {
        this.readLock.lock();
        try {
            long l = this.launchTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getFinishTime() {
        this.readLock.lock();
        try {
            long l = this.finishTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getShuffleFinishTime() {
        this.readLock.lock();
        try {
            long l = this.reportedStatus.shuffleFinishTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getSortFinishTime() {
        this.readLock.lock();
        try {
            long l = this.reportedStatus.sortFinishTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int getShufflePort() {
        this.readLock.lock();
        try {
            int n = this.shufflePort;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public NodeId getNodeId() {
        this.readLock.lock();
        try {
            NodeId nodeId = this.container == null ? null : this.container.getNodeId();
            return nodeId;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getNodeHttpAddress() {
        this.readLock.lock();
        try {
            String string = this.container == null ? null : this.container.getNodeHttpAddress();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getNodeRackName() {
        this.readLock.lock();
        try {
            String string = this.nodeRackName;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected abstract Task createRemoteTask();

    @Override
    public TaskAttemptId getID() {
        return this.attemptId;
    }

    @Override
    public boolean isFinished() {
        this.readLock.lock();
        try {
            boolean bl = this.getInternalState() == TaskAttemptStateInternal.SUCCEEDED || this.getInternalState() == TaskAttemptStateInternal.FAILED || this.getInternalState() == TaskAttemptStateInternal.KILLED;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public TaskAttemptReport getReport() {
        TaskAttemptReport result = (TaskAttemptReport)recordFactory.newRecordInstance(TaskAttemptReport.class);
        this.readLock.lock();
        try {
            result.setTaskAttemptId(this.attemptId);
            result.setTaskAttemptState(this.getState());
            result.setProgress(this.reportedStatus.progress);
            result.setStartTime(this.launchTime);
            result.setFinishTime(this.finishTime);
            result.setShuffleFinishTime(this.reportedStatus.shuffleFinishTime);
            result.setDiagnosticInfo(org.apache.hadoop.util.StringUtils.join((CharSequence)LINE_SEPARATOR, this.getDiagnostics()));
            result.setPhase(this.reportedStatus.phase);
            result.setStateString(this.reportedStatus.stateString);
            result.setCounters(TypeConverter.toYarn((Counters)this.getCounters()));
            result.setContainerId(this.getAssignedContainerID());
            result.setNodeManagerHost(this.trackerName);
            result.setNodeManagerHttpPort(this.httpPort);
            if (this.container != null) {
                result.setNodeManagerPort(this.container.getNodeId().getPort());
            }
            TaskAttemptReport taskAttemptReport = result;
            return taskAttemptReport;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<String> getDiagnostics() {
        ArrayList<String> result = new ArrayList<String>();
        this.readLock.lock();
        try {
            result.addAll(this.diagnostics);
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Counters getCounters() {
        this.readLock.lock();
        try {
            Counters counters = this.reportedStatus.counters;
            if (counters == null) {
                counters = EMPTY_COUNTERS;
            }
            Counters counters2 = counters;
            return counters2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public float getProgress() {
        this.readLock.lock();
        try {
            float f = this.reportedStatus.progress;
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Phase getPhase() {
        this.readLock.lock();
        try {
            Phase phase = this.reportedStatus.phase;
            return phase;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public TaskAttemptState getState() {
        this.readLock.lock();
        try {
            TaskAttemptState taskAttemptState = TaskAttemptImpl.getExternalState((TaskAttemptStateInternal)this.stateMachine.getCurrentState());
            return taskAttemptState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(TaskAttemptEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing " + event.getTaskAttemptID() + " of type " + event.getType());
        }
        this.writeLock.lock();
        try {
            TaskAttemptStateInternal oldState = this.getInternalState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitionException e) {
                LOG.error("Can't handle this event at current state for " + this.attemptId, (Throwable)e);
                this.eventHandler.handle((Event)new JobDiagnosticsUpdateEvent(this.attemptId.getTaskId().getJobId(), "Invalid event " + event.getType() + " on TaskAttempt " + this.attemptId));
                this.eventHandler.handle((Event)new JobEvent(this.attemptId.getTaskId().getJobId(), JobEventType.INTERNAL_ERROR));
            }
            if (oldState != this.getInternalState()) {
                if (this.getInternalState() == TaskAttemptStateInternal.FAILED) {
                    String nodeId = null == this.container ? "Not-assigned" : this.container.getNodeId().toString();
                    LOG.info(this.attemptId + " transitioned from state " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getInternalState()) + ", event type is " + event.getType() + " and nodeId=" + nodeId);
                } else {
                    LOG.info(this.attemptId + " TaskAttempt Transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getInternalState()));
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @VisibleForTesting
    public TaskAttemptStateInternal getInternalState() {
        this.readLock.lock();
        try {
            TaskAttemptStateInternal taskAttemptStateInternal = (TaskAttemptStateInternal)this.stateMachine.getCurrentState();
            return taskAttemptStateInternal;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Locality getLocality() {
        return this.locality;
    }

    public void setLocality(Locality locality) {
        this.locality = locality;
    }

    public Avataar getAvataar() {
        return this.avataar;
    }

    public void setAvataar(Avataar avataar) {
        this.avataar = avataar;
    }

    public void setTaskFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public boolean isTaskFailFast() {
        return this.failFast;
    }

    public TaskAttemptStateInternal recover(JobHistoryParser.TaskAttemptInfo taInfo, OutputCommitter committer, boolean recoverOutput) {
        TaskAttemptUnsuccessfulCompletionEvent tauce;
        TaskAttemptStateInternal attemptState;
        ContainerId containerId = taInfo.getContainerId();
        NodeId containerNodeId = NodeId.fromString((String)(taInfo.getHostname() + ":" + taInfo.getPort()));
        String nodeHttpAddress = StringInterner.weakIntern((String)(taInfo.getHostname() + ":" + taInfo.getHttpPort()));
        this.container = Container.newInstance((ContainerId)containerId, (NodeId)containerNodeId, (String)nodeHttpAddress, null, null, null);
        this.computeRackAndLocality();
        this.launchTime = taInfo.getStartTime();
        this.finishTime = taInfo.getFinishTime() != -1L ? taInfo.getFinishTime() : this.clock.getTime();
        this.shufflePort = taInfo.getShufflePort();
        this.trackerName = taInfo.getHostname();
        this.httpPort = taInfo.getHttpPort();
        this.sendLaunchedEvents();
        this.reportedStatus.id = this.attemptId;
        this.reportedStatus.progress = 1.0f;
        this.reportedStatus.counters = taInfo.getCounters();
        this.reportedStatus.stateString = taInfo.getState();
        this.reportedStatus.phase = Phase.CLEANUP;
        this.reportedStatus.mapFinishTime = taInfo.getMapFinishTime();
        this.reportedStatus.shuffleFinishTime = taInfo.getShuffleFinishTime();
        this.reportedStatus.sortFinishTime = taInfo.getSortFinishTime();
        this.addDiagnosticInfo(taInfo.getError());
        boolean needToClean = false;
        String recoveredState = taInfo.getTaskStatus();
        if (recoverOutput && TaskAttemptState.SUCCEEDED.toString().equals(recoveredState)) {
            TaskAttemptContextImpl tac = new TaskAttemptContextImpl(this.conf, TypeConverter.fromYarn((TaskAttemptId)this.attemptId));
            try {
                committer.recoverTask((TaskAttemptContext)tac);
                LOG.info("Recovered output from task attempt " + this.attemptId);
            }
            catch (Exception e) {
                LOG.error("Unable to recover task attempt " + this.attemptId, (Throwable)e);
                LOG.info("Task attempt " + this.attemptId + " will be recovered as KILLED");
                recoveredState = TaskAttemptState.KILLED.toString();
                needToClean = true;
            }
        }
        if (TaskAttemptState.SUCCEEDED.toString().equals(recoveredState)) {
            attemptState = TaskAttemptStateInternal.SUCCEEDED;
            this.reportedStatus.taskState = TaskAttemptState.SUCCEEDED;
            this.eventHandler.handle((Event)TaskAttemptImpl.createJobCounterUpdateEventTASucceeded(this));
            this.logAttemptFinishedEvent(attemptState);
        } else if (TaskAttemptState.FAILED.toString().equals(recoveredState)) {
            attemptState = TaskAttemptStateInternal.FAILED;
            this.reportedStatus.taskState = TaskAttemptState.FAILED;
            this.eventHandler.handle((Event)TaskAttemptImpl.createJobCounterUpdateEventTAFailed(this, false));
            tauce = TaskAttemptImpl.createTaskAttemptUnsuccessfulCompletionEvent(this, TaskAttemptStateInternal.FAILED);
            this.eventHandler.handle((Event)new JobHistoryEvent(this.attemptId.getTaskId().getJobId(), (HistoryEvent)tauce));
        } else {
            if (!TaskAttemptState.KILLED.toString().equals(recoveredState)) {
                if (String.valueOf(recoveredState).isEmpty()) {
                    LOG.info("TaskAttempt" + this.attemptId + " had not completed, recovering as KILLED");
                } else {
                    LOG.warn("TaskAttempt " + this.attemptId + " found in unexpected state " + recoveredState + ", recovering as KILLED");
                }
                this.addDiagnosticInfo("Killed during application recovery");
                needToClean = true;
            }
            attemptState = TaskAttemptStateInternal.KILLED;
            this.reportedStatus.taskState = TaskAttemptState.KILLED;
            this.eventHandler.handle((Event)TaskAttemptImpl.createJobCounterUpdateEventTAKilled(this, false));
            tauce = TaskAttemptImpl.createTaskAttemptUnsuccessfulCompletionEvent(this, TaskAttemptStateInternal.KILLED);
            this.eventHandler.handle((Event)new JobHistoryEvent(this.attemptId.getTaskId().getJobId(), (HistoryEvent)tauce));
        }
        if (needToClean) {
            TaskAttemptContextImpl tac = new TaskAttemptContextImpl(this.conf, TypeConverter.fromYarn((TaskAttemptId)this.attemptId));
            try {
                committer.abortTask((TaskAttemptContext)tac);
            }
            catch (Exception e) {
                LOG.warn("Task cleanup failed for attempt " + this.attemptId, (Throwable)e);
            }
        }
        return attemptState;
    }

    protected static TaskAttemptState getExternalState(TaskAttemptStateInternal smState) {
        switch (smState) {
            case ASSIGNED: 
            case UNASSIGNED: {
                return TaskAttemptState.STARTING;
            }
            case COMMIT_PENDING: {
                return TaskAttemptState.COMMIT_PENDING;
            }
            case FAIL_CONTAINER_CLEANUP: 
            case FAIL_TASK_CLEANUP: 
            case FAIL_FINISHING_CONTAINER: 
            case FAILED: {
                return TaskAttemptState.FAILED;
            }
            case KILL_CONTAINER_CLEANUP: 
            case KILL_TASK_CLEANUP: 
            case KILLED: {
                return TaskAttemptState.KILLED;
            }
            case RUNNING: {
                return TaskAttemptState.RUNNING;
            }
            case NEW: {
                return TaskAttemptState.NEW;
            }
            case SUCCESS_CONTAINER_CLEANUP: 
            case SUCCESS_FINISHING_CONTAINER: 
            case SUCCEEDED: {
                return TaskAttemptState.SUCCEEDED;
            }
        }
        throw new YarnRuntimeException("Attempt to convert invalid stateMachineTaskAttemptState to externalTaskAttemptState: " + (Object)((Object)smState));
    }

    boolean isContainerAssigned() {
        return this.container != null;
    }

    private boolean getRescheduleNextAttempt() {
        return this.rescheduleNextAttempt;
    }

    private void setRescheduleNextAttempt(boolean reschedule) {
        this.rescheduleNextAttempt = reschedule;
    }

    private void setFinishTime() {
        if (this.launchTime != 0L) {
            this.finishTime = this.clock.getTime();
        }
    }

    private void computeRackAndLocality() {
        String cHost;
        NodeId containerNodeId = this.container.getNodeId();
        this.nodeRackName = RackResolver.resolve((String)containerNodeId.getHost()).getNetworkLocation();
        this.locality = Locality.OFF_SWITCH;
        if (this.dataLocalHosts.size() > 0 && this.dataLocalHosts.contains(cHost = this.resolveHost(containerNodeId.getHost()))) {
            this.locality = Locality.NODE_LOCAL;
        }
        if (this.locality == Locality.OFF_SWITCH && this.dataLocalRacks.contains(this.nodeRackName)) {
            this.locality = Locality.RACK_LOCAL;
        }
    }

    private static void updateMillisCounters(JobCounterUpdateEvent jce, TaskAttemptImpl taskAttempt) {
        if (null == taskAttempt.container || null == taskAttempt.container.getResource()) {
            return;
        }
        long duration = taskAttempt.getFinishTime() - taskAttempt.getLaunchTime();
        Resource allocatedResource = taskAttempt.container.getResource();
        int mbAllocated = (int)allocatedResource.getMemorySize();
        int vcoresAllocated = allocatedResource.getVirtualCores();
        int minSlotMemSize = taskAttempt.conf.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        int simSlotsAllocated = minSlotMemSize == 0 ? 0 : (int)Math.ceil((float)mbAllocated / (float)minSlotMemSize);
        TaskType taskType = taskAttempt.getID().getTaskId().getTaskType();
        if (taskType == TaskType.MAP) {
            jce.addCounterUpdate((Enum<?>)JobCounter.SLOTS_MILLIS_MAPS, (long)simSlotsAllocated * duration);
            jce.addCounterUpdate((Enum<?>)JobCounter.MB_MILLIS_MAPS, duration * (long)mbAllocated);
            jce.addCounterUpdate((Enum<?>)JobCounter.VCORES_MILLIS_MAPS, duration * (long)vcoresAllocated);
            jce.addCounterUpdate((Enum<?>)JobCounter.MILLIS_MAPS, duration);
        } else {
            jce.addCounterUpdate((Enum<?>)JobCounter.SLOTS_MILLIS_REDUCES, (long)simSlotsAllocated * duration);
            jce.addCounterUpdate((Enum<?>)JobCounter.MB_MILLIS_REDUCES, duration * (long)mbAllocated);
            jce.addCounterUpdate((Enum<?>)JobCounter.VCORES_MILLIS_REDUCES, duration * (long)vcoresAllocated);
            jce.addCounterUpdate((Enum<?>)JobCounter.MILLIS_REDUCES, duration);
        }
    }

    private static JobCounterUpdateEvent createJobCounterUpdateEventTASucceeded(TaskAttemptImpl taskAttempt) {
        TaskId taskId = taskAttempt.attemptId.getTaskId();
        JobCounterUpdateEvent jce = new JobCounterUpdateEvent(taskId.getJobId());
        TaskAttemptImpl.updateMillisCounters(jce, taskAttempt);
        return jce;
    }

    private static JobCounterUpdateEvent createJobCounterUpdateEventTAFailed(TaskAttemptImpl taskAttempt, boolean taskAlreadyCompleted) {
        TaskType taskType = taskAttempt.getID().getTaskId().getTaskType();
        JobCounterUpdateEvent jce = new JobCounterUpdateEvent(taskAttempt.getID().getTaskId().getJobId());
        if (taskType == TaskType.MAP) {
            jce.addCounterUpdate((Enum<?>)JobCounter.NUM_FAILED_MAPS, 1L);
        } else {
            jce.addCounterUpdate((Enum<?>)JobCounter.NUM_FAILED_REDUCES, 1L);
        }
        if (!taskAlreadyCompleted) {
            TaskAttemptImpl.updateMillisCounters(jce, taskAttempt);
        }
        return jce;
    }

    private static JobCounterUpdateEvent createJobCounterUpdateEventTAKilled(TaskAttemptImpl taskAttempt, boolean taskAlreadyCompleted) {
        TaskType taskType = taskAttempt.getID().getTaskId().getTaskType();
        JobCounterUpdateEvent jce = new JobCounterUpdateEvent(taskAttempt.getID().getTaskId().getJobId());
        if (taskType == TaskType.MAP) {
            jce.addCounterUpdate((Enum<?>)JobCounter.NUM_KILLED_MAPS, 1L);
        } else {
            jce.addCounterUpdate((Enum<?>)JobCounter.NUM_KILLED_REDUCES, 1L);
        }
        if (!taskAlreadyCompleted) {
            TaskAttemptImpl.updateMillisCounters(jce, taskAttempt);
        }
        return jce;
    }

    private static TaskAttemptUnsuccessfulCompletionEvent createTaskAttemptUnsuccessfulCompletionEvent(TaskAttemptImpl taskAttempt, TaskAttemptStateInternal attemptState) {
        TaskAttemptUnsuccessfulCompletionEvent tauce = new TaskAttemptUnsuccessfulCompletionEvent((TaskAttemptID)TypeConverter.fromYarn((TaskAttemptId)taskAttempt.attemptId), TypeConverter.fromYarn((TaskType)taskAttempt.attemptId.getTaskId().getTaskType()), attemptState.toString(), taskAttempt.finishTime, taskAttempt.container == null ? "UNKNOWN" : taskAttempt.container.getNodeId().getHost(), taskAttempt.container == null ? -1 : taskAttempt.container.getNodeId().getPort(), taskAttempt.nodeRackName == null ? "UNKNOWN" : taskAttempt.nodeRackName, org.apache.hadoop.util.StringUtils.join((CharSequence)LINE_SEPARATOR, taskAttempt.getDiagnostics()), taskAttempt.getCounters(), taskAttempt.getProgressSplitBlock().burst(), taskAttempt.launchTime);
        return tauce;
    }

    private static void sendJHStartEventForAssignedFailTask(TaskAttemptImpl taskAttempt) {
        if (null == taskAttempt.container) {
            return;
        }
        taskAttempt.launchTime = taskAttempt.clock.getTime();
        InetSocketAddress nodeHttpInetAddr = NetUtils.createSocketAddr((String)taskAttempt.container.getNodeHttpAddress());
        taskAttempt.trackerName = nodeHttpInetAddr.getHostName();
        taskAttempt.httpPort = nodeHttpInetAddr.getPort();
        taskAttempt.sendLaunchedEvents();
    }

    private void sendLaunchedEvents() {
        JobCounterUpdateEvent jce = new JobCounterUpdateEvent(this.attemptId.getTaskId().getJobId());
        jce.addCounterUpdate((Enum<?>)(this.attemptId.getTaskId().getTaskType() == TaskType.MAP ? JobCounter.TOTAL_LAUNCHED_MAPS : JobCounter.TOTAL_LAUNCHED_REDUCES), 1L);
        this.eventHandler.handle((Event)jce);
        LOG.info("TaskAttempt: [" + this.attemptId + "] using containerId: [" + this.container.getId() + " on NM: [" + StringInterner.weakIntern((String)this.container.getNodeId().toString()) + "]");
        TaskAttemptStartedEvent tase = new TaskAttemptStartedEvent((TaskAttemptID)TypeConverter.fromYarn((TaskAttemptId)this.attemptId), TypeConverter.fromYarn((TaskType)this.attemptId.getTaskId().getTaskType()), this.launchTime, this.trackerName, this.httpPort, this.shufflePort, this.container.getId(), this.locality.toString(), this.avataar.toString());
        this.eventHandler.handle((Event)new JobHistoryEvent(this.attemptId.getTaskId().getJobId(), (HistoryEvent)tase));
    }

    private WrappedProgressSplitsBlock getProgressSplitBlock() {
        this.readLock.lock();
        try {
            if (this.progressSplitBlock == null) {
                this.progressSplitBlock = new WrappedProgressSplitsBlock(this.conf.getInt("yarn.app.mapreduce.am.num-progress-splits", 12));
            }
            WrappedProgressSplitsBlock wrappedProgressSplitsBlock = this.progressSplitBlock;
            return wrappedProgressSplitsBlock;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void updateProgressSplits() {
        double newProgress = this.reportedStatus.progress;
        newProgress = Math.max(Math.min(newProgress, 1.0), 0.0);
        Counters counters = this.reportedStatus.counters;
        if (counters == null) {
            return;
        }
        WrappedProgressSplitsBlock splitsBlock = this.getProgressSplitBlock();
        if (splitsBlock != null) {
            Counter physicalBytes;
            Counter virtualBytes;
            Counter cpuCounter;
            long now = this.clock.getTime();
            long start = this.getLaunchTime();
            if (start != 0L && now - start <= Integer.MAX_VALUE) {
                splitsBlock.getProgressWallclockTime().extend(newProgress, (int)(now - start));
            }
            if ((cpuCounter = counters.findCounter((Enum)TaskCounter.CPU_MILLISECONDS)) != null && cpuCounter.getValue() <= Integer.MAX_VALUE) {
                splitsBlock.getProgressCPUTime().extend(newProgress, (int)cpuCounter.getValue());
            }
            if ((virtualBytes = counters.findCounter((Enum)TaskCounter.VIRTUAL_MEMORY_BYTES)) != null) {
                splitsBlock.getProgressVirtualMemoryKbytes().extend(newProgress, (int)(virtualBytes.getValue() / 1024L));
            }
            if ((physicalBytes = counters.findCounter((Enum)TaskCounter.PHYSICAL_MEMORY_BYTES)) != null) {
                splitsBlock.getProgressPhysicalMemoryKbytes().extend(newProgress, (int)(physicalBytes.getValue() / 1024L));
            }
        }
    }

    private static void finalizeProgress(TaskAttemptImpl taskAttempt) {
        taskAttempt.taskAttemptListener.unregister(taskAttempt.attemptId, taskAttempt.jvmID);
        taskAttempt.reportedStatus.progress = 1.0f;
        taskAttempt.updateProgressSplits();
    }

    protected Set<String> resolveHosts(String[] src) {
        HashSet<String> result = new HashSet<String>();
        if (src != null) {
            for (int i = 0; i < src.length; ++i) {
                if (src[i] == null) continue;
                if (this.isIP(src[i])) {
                    result.add(this.resolveHost(src[i]));
                    continue;
                }
                result.add(src[i]);
            }
        }
        return result;
    }

    protected String resolveHost(String src) {
        String result = src;
        try {
            InetAddress addr = InetAddress.getByName(src);
            result = addr.getHostName();
        }
        catch (UnknownHostException e) {
            LOG.warn("Failed to resolve address: " + src + ". Continuing to use the same.");
        }
        return result;
    }

    protected boolean isIP(String src) {
        return ipPattern.matcher(src).matches();
    }

    private static void sendContainerCompleted(TaskAttemptImpl taskAttempt) {
        taskAttempt.eventHandler.handle((Event)new ContainerLauncherEvent(taskAttempt.attemptId, taskAttempt.container.getId(), StringInterner.weakIntern((String)taskAttempt.container.getNodeId().toString()), taskAttempt.container.getContainerToken(), ContainerLauncher.EventType.CONTAINER_COMPLETED));
    }

    private void logAttemptFinishedEvent(TaskAttemptStateInternal state) {
        int containerNodePort;
        if (this.getLaunchTime() == 0L) {
            return;
        }
        String containerHostName = this.container == null ? "UNKNOWN" : this.container.getNodeId().getHost();
        int n = containerNodePort = this.container == null ? -1 : this.container.getNodeId().getPort();
        if (this.attemptId.getTaskId().getTaskType() == TaskType.MAP) {
            MapAttemptFinishedEvent mfe = new MapAttemptFinishedEvent((TaskAttemptID)TypeConverter.fromYarn((TaskAttemptId)this.attemptId), TypeConverter.fromYarn((TaskType)this.attemptId.getTaskId().getTaskType()), state.toString(), this.reportedStatus.mapFinishTime, this.finishTime, containerHostName, containerNodePort, this.nodeRackName == null ? "UNKNOWN" : this.nodeRackName, this.reportedStatus.stateString, this.getCounters(), this.getProgressSplitBlock().burst(), this.launchTime);
            this.eventHandler.handle((Event)new JobHistoryEvent(this.attemptId.getTaskId().getJobId(), (HistoryEvent)mfe));
        } else {
            ReduceAttemptFinishedEvent rfe = new ReduceAttemptFinishedEvent((TaskAttemptID)TypeConverter.fromYarn((TaskAttemptId)this.attemptId), TypeConverter.fromYarn((TaskType)this.attemptId.getTaskId().getTaskType()), state.toString(), this.reportedStatus.shuffleFinishTime, this.reportedStatus.sortFinishTime, this.finishTime, containerHostName, containerNodePort, this.nodeRackName == null ? "UNKNOWN" : this.nodeRackName, this.reportedStatus.stateString, this.getCounters(), this.getProgressSplitBlock().burst(), this.launchTime);
            this.eventHandler.handle((Event)new JobHistoryEvent(this.attemptId.getTaskId().getJobId(), (HistoryEvent)rfe));
        }
    }

    private static void sendContainerCleanup(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
        if (event instanceof TaskAttemptKillEvent) {
            taskAttempt.addDiagnosticInfo(((TaskAttemptKillEvent)event).getMessage());
        }
        taskAttempt.eventHandler.handle((Event)new ContainerLauncherEvent(taskAttempt.attemptId, taskAttempt.container.getId(), StringInterner.weakIntern((String)taskAttempt.container.getNodeId().toString()), taskAttempt.container.getContainerToken(), ContainerLauncher.EventType.CONTAINER_REMOTE_CLEANUP, event.getType() == TaskAttemptEventType.TA_TIMED_OUT));
    }

    private static void notifyTaskAttemptFailed(TaskAttemptImpl taskAttempt, boolean fastFail) {
        if (taskAttempt.getLaunchTime() == 0L) {
            TaskAttemptImpl.sendJHStartEventForAssignedFailTask(taskAttempt);
        }
        taskAttempt.setFinishTime();
        taskAttempt.eventHandler.handle((Event)TaskAttemptImpl.createJobCounterUpdateEventTAFailed(taskAttempt, false));
        TaskAttemptUnsuccessfulCompletionEvent tauce = TaskAttemptImpl.createTaskAttemptUnsuccessfulCompletionEvent(taskAttempt, TaskAttemptStateInternal.FAILED);
        taskAttempt.eventHandler.handle((Event)new JobHistoryEvent(taskAttempt.attemptId.getTaskId().getJobId(), (HistoryEvent)tauce));
        taskAttempt.eventHandler.handle((Event)new TaskTAttemptFailedEvent(taskAttempt.attemptId, fastFail));
    }

    private void addDiagnosticInfo(String diag) {
        if (diag != null && !diag.equals("")) {
            this.diagnostics.add(diag);
        }
    }

    private void initTaskAttemptStatus(TaskAttemptStatusUpdateEvent.TaskAttemptStatus result) {
        Counters counters;
        result.progress = 0.0f;
        result.phase = Phase.STARTING;
        result.stateString = "NEW";
        result.taskState = TaskAttemptState.NEW;
        result.counters = counters = EMPTY_COUNTERS;
    }

    private static class DiagnosticInformationUpdater
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private DiagnosticInformationUpdater() {
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            TaskAttemptDiagnosticsUpdateEvent diagEvent = (TaskAttemptDiagnosticsUpdateEvent)event;
            LOG.info("Diagnostics report from " + taskAttempt.attemptId + ": " + diagEvent.getDiagnosticInfo());
            taskAttempt.addDiagnosticInfo(diagEvent.getDiagnosticInfo());
        }
    }

    private static class StatusUpdater
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private StatusUpdater() {
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            TaskAttemptStatusUpdateEvent statusEvent = (TaskAttemptStatusUpdateEvent)event;
            AtomicReference<TaskAttemptStatusUpdateEvent.TaskAttemptStatus> taskAttemptStatusRef = statusEvent.getTaskAttemptStatusRef();
            TaskAttemptStatusUpdateEvent.TaskAttemptStatus newReportedStatus = taskAttemptStatusRef.getAndSet(null);
            taskAttempt.reportedStatus = newReportedStatus;
            ((TaskAttemptImpl)taskAttempt).reportedStatus.taskState = taskAttempt.getState();
            taskAttempt.eventHandler.handle((Event)new SpeculatorEvent(taskAttempt.reportedStatus, taskAttempt.clock.getTime()));
            taskAttempt.updateProgressSplits();
            if (((TaskAttemptImpl)taskAttempt).reportedStatus.fetchFailedMaps != null && ((TaskAttemptImpl)taskAttempt).reportedStatus.fetchFailedMaps.size() > 0) {
                String hostname = taskAttempt.container == null ? "UNKNOWN" : taskAttempt.container.getNodeId().getHost();
                taskAttempt.eventHandler.handle((Event)new JobTaskAttemptFetchFailureEvent(taskAttempt.attemptId, ((TaskAttemptImpl)taskAttempt).reportedStatus.fetchFailedMaps, hostname));
            }
        }
    }

    private static class MoveContainerToFailedFinishingTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private MoveContainerToFailedFinishingTransition() {
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            TaskAttemptImpl.finalizeProgress(taskAttempt);
            taskAttempt.appContext.getTaskAttemptFinishingMonitor().register(taskAttempt.attemptId);
            TaskAttemptImpl.notifyTaskAttemptFailed(taskAttempt, false);
        }
    }

    private static class MoveContainerToSucceededFinishingTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private MoveContainerToSucceededFinishingTransition() {
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            TaskAttemptImpl.finalizeProgress(taskAttempt);
            taskAttempt.appContext.getTaskAttemptFinishingMonitor().register(taskAttempt.attemptId);
            taskAttempt.setFinishTime();
            taskAttempt.eventHandler.handle((Event)TaskAttemptImpl.createJobCounterUpdateEventTASucceeded(taskAttempt));
            taskAttempt.logAttemptFinishedEvent(TaskAttemptStateInternal.SUCCEEDED);
            taskAttempt.eventHandler.handle((Event)new TaskTAttemptEvent(taskAttempt.attemptId, TaskEventType.T_ATTEMPT_SUCCEEDED));
            taskAttempt.eventHandler.handle((Event)new SpeculatorEvent(taskAttempt.reportedStatus, taskAttempt.clock.getTime()));
        }
    }

    private static class CleanupContainerTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private CleanupContainerTransition() {
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            TaskAttemptImpl.finalizeProgress(taskAttempt);
            TaskAttemptImpl.sendContainerCleanup(taskAttempt, event);
            if (event instanceof TaskAttemptKillEvent) {
                taskAttempt.setRescheduleNextAttempt(((TaskAttemptKillEvent)event).getRescheduleAttempt());
            } else if (event instanceof TaskAttemptFailEvent) {
                taskAttempt.setTaskFailFast(((TaskAttemptFailEvent)event).isFastFail());
            }
        }
    }

    private static class ExitFinishingOnTimeoutTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private ExitFinishingOnTimeoutTransition() {
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            taskAttempt.appContext.getTaskAttemptFinishingMonitor().unregister(taskAttempt.attemptId);
            String msg = "Task attempt " + taskAttempt.getID() + " is done from TaskUmbilicalProtocol's point of view. However, it stays in finishing state for too long";
            LOG.warn(msg);
            taskAttempt.addDiagnosticInfo(msg);
            TaskAttemptImpl.sendContainerCleanup(taskAttempt, event);
        }
    }

    private static class PreemptedTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private PreemptedTransition() {
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            taskAttempt.setFinishTime();
            taskAttempt.taskAttemptListener.unregister(taskAttempt.attemptId, taskAttempt.jvmID);
            taskAttempt.eventHandler.handle((Event)new ContainerLauncherEvent(taskAttempt.attemptId, taskAttempt.getAssignedContainerID(), taskAttempt.getAssignedContainerMgrAddress(), taskAttempt.container.getContainerToken(), ContainerLauncher.EventType.CONTAINER_REMOTE_CLEANUP, false));
            taskAttempt.eventHandler.handle((Event)new TaskTAttemptKilledEvent(taskAttempt.attemptId, false));
        }
    }

    private static class KilledTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private KilledTransition() {
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            if (taskAttempt.getLaunchTime() == 0L) {
                TaskAttemptImpl.sendJHStartEventForAssignedFailTask(taskAttempt);
            }
            taskAttempt.setFinishTime();
            taskAttempt.eventHandler.handle((Event)TaskAttemptImpl.createJobCounterUpdateEventTAKilled(taskAttempt, false));
            TaskAttemptUnsuccessfulCompletionEvent tauce = TaskAttemptImpl.createTaskAttemptUnsuccessfulCompletionEvent(taskAttempt, TaskAttemptStateInternal.KILLED);
            taskAttempt.eventHandler.handle((Event)new JobHistoryEvent(taskAttempt.attemptId.getTaskId().getJobId(), (HistoryEvent)tauce));
            if (event instanceof TaskAttemptKillEvent) {
                taskAttempt.addDiagnosticInfo(((TaskAttemptKillEvent)event).getMessage());
            }
            taskAttempt.eventHandler.handle((Event)new TaskTAttemptKilledEvent(taskAttempt.attemptId, taskAttempt.getRescheduleNextAttempt()));
        }
    }

    private static class KilledAfterSucceededFinishingTransition
    implements MultipleArcTransition<TaskAttemptImpl, TaskAttemptEvent, TaskAttemptStateInternal> {
        private KilledAfterSucceededFinishingTransition() {
        }

        public TaskAttemptStateInternal transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            taskAttempt.appContext.getTaskAttemptFinishingMonitor().unregister(taskAttempt.attemptId);
            TaskAttemptImpl.sendContainerCleanup(taskAttempt, event);
            if (taskAttempt.getID().getTaskId().getTaskType() == TaskType.REDUCE) {
                LOG.info("Ignoring killed event for successful reduce task attempt" + taskAttempt.getID().toString());
                return TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP;
            }
            if (event instanceof TaskAttemptKillEvent) {
                taskAttempt.setRescheduleNextAttempt(((TaskAttemptKillEvent)event).getRescheduleAttempt());
            }
            return TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP;
        }
    }

    private static class KilledAfterSuccessTransition
    implements MultipleArcTransition<TaskAttemptImpl, TaskAttemptEvent, TaskAttemptStateInternal> {
        private KilledAfterSuccessTransition() {
        }

        public TaskAttemptStateInternal transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            if (taskAttempt.getID().getTaskId().getTaskType() == TaskType.REDUCE) {
                LOG.info("Ignoring killed event for successful reduce task attempt" + taskAttempt.getID().toString());
                return TaskAttemptStateInternal.SUCCEEDED;
            }
            if (event instanceof TaskAttemptKillEvent) {
                TaskAttemptKillEvent msgEvent = (TaskAttemptKillEvent)event;
                taskAttempt.addDiagnosticInfo(msgEvent.getMessage());
            }
            assert (taskAttempt.getFinishTime() != 0L);
            assert (taskAttempt.getLaunchTime() != 0L);
            taskAttempt.eventHandler.handle((Event)TaskAttemptImpl.createJobCounterUpdateEventTAKilled(taskAttempt, true));
            TaskAttemptUnsuccessfulCompletionEvent tauce = TaskAttemptImpl.createTaskAttemptUnsuccessfulCompletionEvent(taskAttempt, TaskAttemptStateInternal.KILLED);
            taskAttempt.eventHandler.handle((Event)new JobHistoryEvent(taskAttempt.attemptId.getTaskId().getJobId(), (HistoryEvent)tauce));
            boolean rescheduleNextTaskAttempt = false;
            if (event instanceof TaskAttemptKillEvent) {
                rescheduleNextTaskAttempt = ((TaskAttemptKillEvent)event).getRescheduleAttempt();
            }
            taskAttempt.eventHandler.handle((Event)new TaskTAttemptKilledEvent(taskAttempt.attemptId, rescheduleNextTaskAttempt));
            return TaskAttemptStateInternal.KILLED;
        }
    }

    private static class TooManyFetchFailureTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private TooManyFetchFailureTransition() {
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            TaskAttemptTooManyFetchFailureEvent fetchFailureEvent = (TaskAttemptTooManyFetchFailureEvent)event;
            Preconditions.checkArgument((taskAttempt.getID().getTaskId().getTaskType() == TaskType.MAP ? 1 : 0) != 0);
            taskAttempt.addDiagnosticInfo("Too many fetch failures. Failing the attempt. Last failure reported by " + fetchFailureEvent.getReduceId() + " from host " + fetchFailureEvent.getReduceHost());
            if (taskAttempt.getLaunchTime() != 0L) {
                taskAttempt.eventHandler.handle((Event)TaskAttemptImpl.createJobCounterUpdateEventTAFailed(taskAttempt, true));
                TaskAttemptUnsuccessfulCompletionEvent tauce = TaskAttemptImpl.createTaskAttemptUnsuccessfulCompletionEvent(taskAttempt, TaskAttemptStateInternal.FAILED);
                taskAttempt.eventHandler.handle((Event)new JobHistoryEvent(taskAttempt.attemptId.getTaskId().getJobId(), (HistoryEvent)tauce));
            } else {
                LOG.debug("Not generating HistoryFinish event since start event not generated for taskAttempt: " + taskAttempt.getID());
            }
            taskAttempt.eventHandler.handle((Event)new TaskTAttemptFailedEvent(taskAttempt.attemptId));
        }
    }

    private static class RecoverTransition
    implements MultipleArcTransition<TaskAttemptImpl, TaskAttemptEvent, TaskAttemptStateInternal> {
        private RecoverTransition() {
        }

        public TaskAttemptStateInternal transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            TaskAttemptRecoverEvent tare = (TaskAttemptRecoverEvent)event;
            return taskAttempt.recover(tare.getTaskAttemptInfo(), tare.getCommitter(), tare.getRecoverOutput());
        }
    }

    private static class FinalizeFailedTransition
    extends FailedTransition {
        private FinalizeFailedTransition() {
        }

        @Override
        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            TaskAttemptImpl.finalizeProgress(taskAttempt);
            TaskAttemptImpl.sendContainerCompleted(taskAttempt);
            super.transition(taskAttempt, event);
        }
    }

    private static class FailedTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private FailedTransition() {
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            taskAttempt.setFinishTime();
            TaskAttemptImpl.notifyTaskAttemptFailed(taskAttempt, taskAttempt.isTaskFailFast());
        }
    }

    private static class ExitFinishingOnContainerCleanedupTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private ExitFinishingOnContainerCleanedupTransition() {
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            taskAttempt.appContext.getTaskAttemptFinishingMonitor().unregister(taskAttempt.attemptId);
        }
    }

    private static class ExitFinishingOnContainerCompletedTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private ExitFinishingOnContainerCompletedTransition() {
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            taskAttempt.appContext.getTaskAttemptFinishingMonitor().unregister(taskAttempt.attemptId);
            TaskAttemptImpl.sendContainerCompleted(taskAttempt);
        }
    }

    private static class TaskCleanupTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private TaskCleanupTransition() {
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            TaskAttemptContextImpl taskContext = new TaskAttemptContextImpl(taskAttempt.conf, TypeConverter.fromYarn((TaskAttemptId)taskAttempt.attemptId));
            taskAttempt.eventHandler.handle((Event)new CommitterTaskAbortEvent(taskAttempt.attemptId, (TaskAttemptContext)taskContext));
        }
    }

    private static class CommitPendingTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private CommitPendingTransition() {
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            taskAttempt.eventHandler.handle((Event)new TaskTAttemptEvent(taskAttempt.attemptId, TaskEventType.T_ATTEMPT_COMMIT_PENDING));
        }
    }

    private static class LaunchedContainerTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private LaunchedContainerTransition() {
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent evnt) {
            TaskAttemptContainerLaunchedEvent event = (TaskAttemptContainerLaunchedEvent)evnt;
            taskAttempt.launchTime = taskAttempt.clock.getTime();
            taskAttempt.shufflePort = event.getShufflePort();
            taskAttempt.taskAttemptListener.registerLaunchedTask(taskAttempt.attemptId, taskAttempt.jvmID);
            InetSocketAddress nodeHttpInetAddr = NetUtils.createSocketAddr((String)taskAttempt.container.getNodeHttpAddress());
            taskAttempt.trackerName = nodeHttpInetAddr.getHostName();
            taskAttempt.httpPort = nodeHttpInetAddr.getPort();
            taskAttempt.sendLaunchedEvents();
            taskAttempt.eventHandler.handle((Event)new SpeculatorEvent(taskAttempt.attemptId, true, taskAttempt.clock.getTime()));
            taskAttempt.remoteTask = null;
            taskAttempt.eventHandler.handle((Event)new TaskTAttemptEvent(taskAttempt.attemptId, TaskEventType.T_ATTEMPT_LAUNCHED));
        }
    }

    private static class DeallocateContainerTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private final TaskAttemptStateInternal finalState;
        private final boolean withdrawsContainerRequest;

        DeallocateContainerTransition(TaskAttemptStateInternal finalState, boolean withdrawsContainerRequest) {
            this.finalState = finalState;
            this.withdrawsContainerRequest = withdrawsContainerRequest;
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            if (taskAttempt.getLaunchTime() == 0L) {
                TaskAttemptImpl.sendJHStartEventForAssignedFailTask(taskAttempt);
            }
            taskAttempt.setFinishTime();
            if (event instanceof TaskAttemptKillEvent) {
                taskAttempt.addDiagnosticInfo(((TaskAttemptKillEvent)event).getMessage());
            }
            taskAttempt.eventHandler.handle((Event)new ContainerAllocatorEvent(taskAttempt.attemptId, ContainerAllocator.EventType.CONTAINER_DEALLOCATE));
            if (this.withdrawsContainerRequest) {
                taskAttempt.eventHandler.handle((Event)new SpeculatorEvent(taskAttempt.getID().getTaskId(), -1));
            }
            switch (this.finalState) {
                case FAILED: {
                    boolean fastFail = false;
                    if (event instanceof TaskAttemptFailEvent) {
                        fastFail = ((TaskAttemptFailEvent)event).isFastFail();
                    }
                    taskAttempt.eventHandler.handle((Event)new TaskTAttemptFailedEvent(taskAttempt.attemptId, fastFail));
                    break;
                }
                case KILLED: {
                    taskAttempt.eventHandler.handle((Event)new TaskTAttemptKilledEvent(taskAttempt.attemptId, false));
                    break;
                }
                default: {
                    LOG.error("Task final state is not FAILED or KILLED: " + (Object)((Object)this.finalState));
                }
            }
            TaskAttemptUnsuccessfulCompletionEvent tauce = TaskAttemptImpl.createTaskAttemptUnsuccessfulCompletionEvent(taskAttempt, this.finalState);
            if (this.finalState == TaskAttemptStateInternal.FAILED) {
                taskAttempt.eventHandler.handle((Event)TaskAttemptImpl.createJobCounterUpdateEventTAFailed(taskAttempt, false));
            } else if (this.finalState == TaskAttemptStateInternal.KILLED) {
                taskAttempt.eventHandler.handle((Event)TaskAttemptImpl.createJobCounterUpdateEventTAKilled(taskAttempt, false));
            }
            taskAttempt.eventHandler.handle((Event)new JobHistoryEvent(taskAttempt.attemptId.getTaskId().getJobId(), (HistoryEvent)tauce));
        }
    }

    private static class ContainerAssignedTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private ContainerAssignedTransition() {
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            Container container;
            TaskAttemptContainerAssignedEvent cEvent = (TaskAttemptContainerAssignedEvent)event;
            taskAttempt.container = container = cEvent.getContainer();
            taskAttempt.remoteTask = taskAttempt.createRemoteTask();
            taskAttempt.jvmID = new WrappedJvmID(taskAttempt.remoteTask.getTaskID().getJobID(), taskAttempt.remoteTask.isMapTask(), taskAttempt.container.getId().getContainerId());
            taskAttempt.taskAttemptListener.registerPendingTask(taskAttempt.remoteTask, taskAttempt.jvmID);
            taskAttempt.computeRackAndLocality();
            ContainerLaunchContext launchContext = TaskAttemptImpl.createContainerLaunchContext(cEvent.getApplicationACLs(), (Configuration)taskAttempt.conf, (Token<JobTokenIdentifier>)taskAttempt.jobToken, taskAttempt.remoteTask, taskAttempt.oldJobId, taskAttempt.jvmID, taskAttempt.taskAttemptListener, taskAttempt.credentials);
            taskAttempt.eventHandler.handle((Event)new ContainerRemoteLaunchEvent(taskAttempt.attemptId, launchContext, container, taskAttempt.remoteTask));
            taskAttempt.eventHandler.handle((Event)new SpeculatorEvent(taskAttempt.getID().getTaskId(), -1));
        }
    }

    static class RequestContainerTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private final boolean rescheduled;

        public RequestContainerTransition(boolean rescheduled) {
            this.rescheduled = rescheduled;
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            taskAttempt.eventHandler.handle((Event)new SpeculatorEvent(taskAttempt.getID().getTaskId(), 1));
            if (this.rescheduled) {
                taskAttempt.eventHandler.handle((Event)ContainerRequestEvent.createContainerRequestEventForFailedContainer(taskAttempt.attemptId, taskAttempt.resourceCapability));
            } else {
                taskAttempt.eventHandler.handle((Event)new ContainerRequestEvent(taskAttempt.attemptId, taskAttempt.resourceCapability, taskAttempt.dataLocalHosts.toArray(new String[taskAttempt.dataLocalHosts.size()]), taskAttempt.dataLocalRacks.toArray(new String[taskAttempt.dataLocalRacks.size()])));
            }
        }
    }
}

