/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockType;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockIdManager;
import org.apache.hadoop.hdfs.server.blockmanagement.CorruptReplicasMap;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.junit.Assert;
import org.junit.Test;

public class TestCorruptReplicaInfo {
    private static final Log LOG = LogFactory.getLog(TestCorruptReplicaInfo.class);
    private final Map<Long, Block> replicaMap = new HashMap<Long, Block>();
    private final Map<Long, Block> stripedBlocksMap = new HashMap<Long, Block>();

    private Block getReplica(Long blockId) {
        if (!this.replicaMap.containsKey(blockId)) {
            this.replicaMap.put(blockId, new Block(blockId.longValue(), 0L, 0L));
        }
        return this.replicaMap.get(blockId);
    }

    private Block getReplica(int blkId) {
        return this.getReplica(Long.valueOf(blkId));
    }

    private Block getStripedBlock(int blkId) {
        Long stripedBlockId = Long.MIN_VALUE + (long)blkId;
        Assert.assertTrue((boolean)BlockIdManager.isStripedBlockID((long)stripedBlockId));
        if (!this.stripedBlocksMap.containsKey(stripedBlockId)) {
            this.stripedBlocksMap.put(stripedBlockId, new Block(stripedBlockId.longValue(), 1024L, 0L));
        }
        return this.stripedBlocksMap.get(stripedBlockId);
    }

    private void verifyCorruptBlocksCount(CorruptReplicasMap corruptReplicasMap, long expectedReplicaCount, long expectedStripedBlockCount) {
        long totalExpectedCorruptBlocks = expectedReplicaCount + expectedStripedBlockCount;
        Assert.assertEquals((String)"Unexpected total corrupt blocks count!", (long)totalExpectedCorruptBlocks, (long)corruptReplicasMap.size());
        Assert.assertEquals((String)"Unexpected replica blocks count!", (long)expectedReplicaCount, (long)corruptReplicasMap.getCorruptBlocks());
        Assert.assertEquals((String)"Unexpected striped blocks count!", (long)expectedStripedBlockCount, (long)corruptReplicasMap.getCorruptECBlockGroups());
    }

    @Test
    public void testCorruptReplicaInfo() throws IOException, InterruptedException {
        CorruptReplicasMap crm = new CorruptReplicasMap();
        Assert.assertEquals((String)"Total number of corrupt blocks must initially be 0!", (long)0L, (long)crm.size());
        Assert.assertEquals((String)"Number of corrupt replicas must initially be 0!", (long)0L, (long)crm.getCorruptBlocks());
        Assert.assertEquals((String)"Number of corrupt striped block groups must initially be 0!", (long)0L, (long)crm.getCorruptECBlockGroups());
        Assert.assertNull((String)"Param n cannot be less than 0", (Object)crm.getCorruptBlockIdsForTesting(BlockType.CONTIGUOUS, -1, null));
        Assert.assertNull((String)"Param n cannot be greater than 100", (Object)crm.getCorruptBlockIdsForTesting(BlockType.CONTIGUOUS, 101, null));
        long[] l = crm.getCorruptBlockIdsForTesting(BlockType.CONTIGUOUS, 0, null);
        Assert.assertNotNull((String)"n = 0 must return non-null", (Object)l);
        Assert.assertEquals((String)"n = 0 must return an empty list", (long)0L, (long)l.length);
        int blockCount = 140;
        long[] replicaIds = new long[140];
        long[] stripedIds = new long[140];
        for (int i = 0; i < 140; ++i) {
            replicaIds[i] = this.getReplica(i).getBlockId();
            stripedIds[i] = this.getStripedBlock(i).getBlockId();
        }
        DatanodeDescriptor dn1 = DFSTestUtil.getLocalDatanodeDescriptor();
        DatanodeDescriptor dn2 = DFSTestUtil.getLocalDatanodeDescriptor();
        TestCorruptReplicaInfo.addToCorruptReplicasMap(crm, this.getReplica(0), dn1);
        this.verifyCorruptBlocksCount(crm, 1L, 0L);
        TestCorruptReplicaInfo.addToCorruptReplicasMap(crm, this.getReplica(1), dn1);
        this.verifyCorruptBlocksCount(crm, 2L, 0L);
        TestCorruptReplicaInfo.addToCorruptReplicasMap(crm, this.getReplica(1), dn2);
        this.verifyCorruptBlocksCount(crm, 2L, 0L);
        TestCorruptReplicaInfo.addToCorruptReplicasMap(crm, this.getStripedBlock(0), dn1);
        this.verifyCorruptBlocksCount(crm, 2L, 1L);
        TestCorruptReplicaInfo.addToCorruptReplicasMap(crm, this.getStripedBlock(1), dn1);
        this.verifyCorruptBlocksCount(crm, 2L, 2L);
        TestCorruptReplicaInfo.addToCorruptReplicasMap(crm, this.getStripedBlock(1), dn2);
        this.verifyCorruptBlocksCount(crm, 2L, 2L);
        crm.removeFromCorruptReplicasMap(this.getReplica(1));
        this.verifyCorruptBlocksCount(crm, 1L, 2L);
        crm.removeFromCorruptReplicasMap(this.getReplica(0));
        this.verifyCorruptBlocksCount(crm, 0L, 2L);
        crm.removeFromCorruptReplicasMap(this.getStripedBlock(1));
        this.verifyCorruptBlocksCount(crm, 0L, 1L);
        crm.removeFromCorruptReplicasMap(this.getStripedBlock(0));
        this.verifyCorruptBlocksCount(crm, 0L, 0L);
        for (int blockId = 0; blockId < 140; ++blockId) {
            TestCorruptReplicaInfo.addToCorruptReplicasMap(crm, this.getReplica(blockId), dn1);
            TestCorruptReplicaInfo.addToCorruptReplicasMap(crm, this.getStripedBlock(blockId), dn1);
        }
        Assert.assertEquals((String)"Number of corrupt blocks not returning correctly", (long)280L, (long)crm.size());
        Assert.assertTrue((String)"First five corrupt replica blocks ids are not right!", (boolean)Arrays.equals(Arrays.copyOfRange(replicaIds, 0, 5), crm.getCorruptBlockIdsForTesting(BlockType.CONTIGUOUS, 5, null)));
        Assert.assertTrue((String)"First five corrupt striped blocks ids are not right!", (boolean)Arrays.equals(Arrays.copyOfRange(stripedIds, 0, 5), crm.getCorruptBlockIdsForTesting(BlockType.STRIPED, 5, null)));
        Assert.assertTrue((String)"10 replica blocks after 7 not returned correctly!", (boolean)Arrays.equals(Arrays.copyOfRange(replicaIds, 7, 17), crm.getCorruptBlockIdsForTesting(BlockType.CONTIGUOUS, 10, Long.valueOf(7L))));
        Assert.assertTrue((String)"10 striped blocks after 7 not returned correctly!", (boolean)Arrays.equals(Arrays.copyOfRange(stripedIds, 7, 17), crm.getCorruptBlockIdsForTesting(BlockType.STRIPED, 10, Long.valueOf(this.getStripedBlock(7).getBlockId()))));
    }

    private static void addToCorruptReplicasMap(CorruptReplicasMap crm, Block blk, DatanodeDescriptor dn) {
        crm.addToCorruptReplicasMap(blk, dn, "TEST", CorruptReplicasMap.Reason.NONE);
    }
}

