/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.client;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.qjournal.MiniJournalCluster;
import org.apache.hadoop.hdfs.qjournal.client.AsyncLogger;
import org.apache.hadoop.hdfs.qjournal.client.IPCLoggerChannel;
import org.apache.hadoop.hdfs.qjournal.client.QuorumJournalManager;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestEpochsAreUnique {
    private static final Log LOG = LogFactory.getLog(TestEpochsAreUnique.class);
    private static final String JID = "testEpochsAreUnique-jid";
    private static final NamespaceInfo FAKE_NSINFO = new NamespaceInfo(12345, "mycluster", "my-bp", 0L);
    private final Random r = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleThreaded() throws IOException {
        Configuration conf = new Configuration();
        MiniJournalCluster cluster = new MiniJournalCluster.Builder(conf).build();
        cluster.waitActive();
        URI uri = cluster.getQuorumJournalURI(JID);
        try (QuorumJournalManager qjm = new QuorumJournalManager(conf, uri, FAKE_NSINFO);){
            qjm.format(FAKE_NSINFO);
        }
        try {
            for (int i = 0; i < 5; ++i) {
                qjm = new QuorumJournalManager(conf, uri, FAKE_NSINFO);
                try {
                    qjm.createNewUniqueEpoch();
                    Assert.assertEquals((long)(i + 1), (long)qjm.getLoggerSetForTests().getEpoch());
                    continue;
                }
                finally {
                    qjm.close();
                }
            }
            long prevEpoch = 5L;
            for (int i = 0; i < 20; ++i) {
                long newEpoch = -1L;
                while (true) {
                    qjm = new QuorumJournalManager(conf, uri, FAKE_NSINFO, (AsyncLogger.Factory)new FaultyLoggerFactory());
                    try {
                        qjm.createNewUniqueEpoch();
                        newEpoch = qjm.getLoggerSetForTests().getEpoch();
                        break;
                    }
                    catch (IOException iOException) {}
                    continue;
                    finally {
                        qjm.close();
                        continue;
                    }
                    break;
                }
                LOG.info((Object)("Created epoch " + newEpoch));
                Assert.assertTrue((String)("New epoch " + newEpoch + " should be greater than previous " + prevEpoch), (newEpoch > prevEpoch ? 1 : 0) != 0);
                prevEpoch = newEpoch;
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    private class SometimesFaulty<T>
    implements Answer<ListenableFuture<T>> {
        private final float faultProbability;

        public SometimesFaulty(float faultProbability) {
            this.faultProbability = faultProbability;
        }

        public ListenableFuture<T> answer(InvocationOnMock invocation) throws Throwable {
            if (TestEpochsAreUnique.this.r.nextFloat() < this.faultProbability) {
                return Futures.immediateFailedFuture((Throwable)new IOException("Injected fault"));
            }
            return (ListenableFuture)invocation.callRealMethod();
        }
    }

    private class FaultyLoggerFactory
    implements AsyncLogger.Factory {
        private FaultyLoggerFactory() {
        }

        public AsyncLogger createLogger(Configuration conf, NamespaceInfo nsInfo, String journalId, String nameServiceId, InetSocketAddress addr) {
            AsyncLogger ch = IPCLoggerChannel.FACTORY.createLogger(conf, nsInfo, journalId, nameServiceId, addr);
            AsyncLogger spy = (AsyncLogger)Mockito.spy((Object)ch);
            ((AsyncLogger)Mockito.doAnswer(new SometimesFaulty(0.1f)).when((Object)spy)).getJournalState();
            ((AsyncLogger)Mockito.doAnswer(new SometimesFaulty(0.4f)).when((Object)spy)).newEpoch(Mockito.anyLong());
            return spy;
        }
    }
}

