/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.TestWebHdfsFileContextMainOperations;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public class TestSWebHdfsFileContextMainOperations
extends TestWebHdfsFileContextMainOperations {
    private static MiniDFSCluster cluster;
    private static Path defaultWorkingDirectory;
    private static String keystoresDir;
    private static String sslConfDir;
    protected static URI webhdfsUrl;
    private static final HdfsConfiguration CONF;
    private static final String BASEDIR;
    protected static int numBlocks;
    protected static final byte[] data;

    @BeforeClass
    public static void clusterSetupAtBeginning() throws IOException, LoginException, URISyntaxException {
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
        keystoresDir = new File(BASEDIR).getAbsolutePath();
        try {
            sslConfDir = KeyStoreTestUtil.getClasspathDir(TestSWebHdfsFileContextMainOperations.class);
            KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfDir, (Configuration)CONF, (boolean)false);
            CONF.set("dfs.client.https.keystore.resource", KeyStoreTestUtil.getClientSSLConfigFileName());
            CONF.set("dfs.https.server.keystore.resource", KeyStoreTestUtil.getServerSSLConfigFileName());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        CONF.set("dfs.http.policy", "HTTPS_ONLY");
        CONF.set("dfs.namenode.https-address", "localhost:0");
        CONF.set("dfs.datanode.https.address", "localhost:0");
        CONF.set("hadoop.ssl.hostname.verifier", "DEFAULT_AND_LOCALHOST");
        cluster = new MiniDFSCluster.Builder((Configuration)CONF).numDataNodes(2).build();
        cluster.waitClusterUp();
        webhdfsUrl = new URI("swebhdfs://" + cluster.getConfiguration(0).get("dfs.namenode.https-address"));
        fc = FileContext.getFileContext((URI)webhdfsUrl, (Configuration)CONF);
        defaultWorkingDirectory = fc.makeQualified(new Path("/user/" + UserGroupInformation.getCurrentUser().getShortUserName()));
        fc.mkdir(defaultWorkingDirectory, FileContext.DEFAULT_PERM, true);
    }

    @Override
    protected FileContextTestHelper createFileContextHelper() {
        return new FileContextTestHelper("/tmp/TestSWebHdfsFileContextMainOperations");
    }

    @Override
    public URI getWebhdfsUrl() {
        return webhdfsUrl;
    }

    @AfterClass
    public static void ClusterShutdownAtEnd() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
        FileUtil.fullyDelete((File)new File(BASEDIR));
        KeyStoreTestUtil.cleanupSSLConfig((String)keystoresDir, (String)sslConfDir);
    }

    static {
        CONF = new HdfsConfiguration();
        BASEDIR = System.getProperty("test.build.dir", "target/test-dir") + "/" + TestSWebHdfsFileContextMainOperations.class.getSimpleName();
        numBlocks = 2;
        data = FileContextTestHelper.getFileData((int)numBlocks, (long)FileContextTestHelper.getDefaultBlockSize());
    }
}

