/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.tools.CopyFilter;
import org.apache.hadoop.tools.CopyListing;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.DiffInfo;
import org.apache.hadoop.tools.DistCpContext;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.DistCpSync;
import org.apache.hadoop.tools.util.DistCpUtils;
import org.apache.hadoop.tools.util.ProducerConsumer;
import org.apache.hadoop.tools.util.WorkReport;
import org.apache.hadoop.tools.util.WorkRequest;
import org.apache.hadoop.tools.util.WorkRequestProcessor;

public class SimpleCopyListing
extends CopyListing {
    private static final Log LOG = LogFactory.getLog(SimpleCopyListing.class);
    public static final int DEFAULT_FILE_STATUS_SIZE = 1000;
    public static final boolean DEFAULT_RANDOMIZE_FILE_LISTING = true;
    private long totalPaths = 0L;
    private long totalDirs = 0L;
    private long totalBytesToCopy = 0L;
    private int numListstatusThreads = 1;
    private final int fileStatusLimit;
    private final boolean randomizeFileListing;
    private final int maxRetries = 3;
    private CopyFilter copyFilter;
    private DistCpSync distCpSync;
    private final Random rnd = new Random();

    protected SimpleCopyListing(Configuration configuration, Credentials credentials) {
        super(configuration, credentials);
        this.numListstatusThreads = this.getConf().getInt("distcp.liststatus.threads", 1);
        this.fileStatusLimit = Math.max(1, this.getConf().getInt("distcp.simplelisting.file.status.size", 1000));
        this.randomizeFileListing = this.getConf().getBoolean("distcp.simplelisting.randomize.files", true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("numListstatusThreads=" + this.numListstatusThreads + ", fileStatusLimit=" + this.fileStatusLimit + ", randomizeFileListing=" + this.randomizeFileListing));
        }
        this.copyFilter = CopyFilter.getCopyFilter(this.getConf());
        this.copyFilter.initialize();
    }

    @VisibleForTesting
    protected SimpleCopyListing(Configuration configuration, Credentials credentials, int numListstatusThreads, int fileStatusLimit, boolean randomizeFileListing) {
        super(configuration, credentials);
        this.numListstatusThreads = numListstatusThreads;
        this.fileStatusLimit = Math.max(1, fileStatusLimit);
        this.randomizeFileListing = randomizeFileListing;
    }

    protected SimpleCopyListing(Configuration configuration, Credentials credentials, DistCpSync distCpSync) {
        this(configuration, credentials);
        this.distCpSync = distCpSync;
    }

    @Override
    protected void validatePaths(DistCpContext context) throws IOException, CopyListing.InvalidInputException {
        Credentials credentials;
        Path targetPath = context.getTargetPath();
        FileSystem targetFS = targetPath.getFileSystem(this.getConf());
        boolean targetExists = false;
        boolean targetIsFile = false;
        try {
            targetIsFile = targetFS.getFileStatus(targetPath).isFile();
            targetExists = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        targetPath = targetFS.makeQualified(targetPath);
        boolean targetIsReservedRaw = Path.getPathWithoutSchemeAndAuthority((Path)targetPath).toString().startsWith("/.reserved/raw");
        if (targetIsFile) {
            if (context.getSourcePaths().size() > 1) {
                throw new CopyListing.InvalidInputException("Multiple source being copied to a file: " + targetPath);
            }
            Path srcPath = context.getSourcePaths().get(0);
            FileSystem sourceFS = srcPath.getFileSystem(this.getConf());
            if (!sourceFS.isFile(srcPath)) {
                throw new CopyListing.InvalidInputException("Cannot copy " + srcPath + ", which is not a file to " + targetPath);
            }
        }
        if (context.shouldAtomicCommit() && targetExists) {
            throw new CopyListing.InvalidInputException("Target path for atomic-commit already exists: " + targetPath + ". Cannot atomic-commit to pre-existing target-path.");
        }
        for (Path path : context.getSourcePaths()) {
            FileSystem fs = path.getFileSystem(this.getConf());
            if (!fs.exists(path)) {
                throw new CopyListing.InvalidInputException(path + " doesn't exist");
            }
            if (Path.getPathWithoutSchemeAndAuthority((Path)path).toString().startsWith("/.reserved/raw")) {
                if (targetIsReservedRaw) continue;
                String msg = "The source path '" + path + "' starts with " + "/.reserved/raw" + " but the target path '" + targetPath + "' does not. Either all or none of the paths must have this prefix.";
                throw new CopyListing.InvalidInputException(msg);
            }
            if (!targetIsReservedRaw) continue;
            String msg = "The target path '" + targetPath + "' starts with " + "/.reserved/raw" + " but the source path '" + path + "' does not. Either all or none of the paths must have this prefix.";
            throw new CopyListing.InvalidInputException(msg);
        }
        if (targetIsReservedRaw) {
            context.setPreserveRawXattrs(true);
            this.getConf().setBoolean("distcp.preserve.rawxattrs", true);
        }
        if ((credentials = this.getCredentials()) != null) {
            Path[] inputPaths = context.getSourcePaths().toArray(new Path[1]);
            TokenCache.obtainTokensForNamenodes((Credentials)credentials, (Path[])inputPaths, (Configuration)this.getConf());
        }
    }

    @Override
    protected void doBuildListing(Path pathToListingFile, DistCpContext context) throws IOException {
        if (context.shouldUseSnapshotDiff()) {
            this.doBuildListingWithSnapshotDiff(this.getWriter(pathToListingFile), context);
        } else {
            this.doBuildListing(this.getWriter(pathToListingFile), context);
        }
    }

    private Path getPathWithSchemeAndAuthority(Path path) throws IOException {
        String authority;
        FileSystem fs = path.getFileSystem(this.getConf());
        String scheme = path.toUri().getScheme();
        if (scheme == null) {
            scheme = fs.getUri().getScheme();
        }
        if ((authority = path.toUri().getAuthority()) == null) {
            authority = fs.getUri().getAuthority();
        }
        return new Path(scheme, authority, this.makeQualified(path).toUri().getPath());
    }

    private void addToFileListing(SequenceFile.Writer fileListWriter, Path sourceRoot, Path path, DistCpContext context) throws IOException {
        sourceRoot = this.getPathWithSchemeAndAuthority(sourceRoot);
        path = this.getPathWithSchemeAndAuthority(path);
        path = this.makeQualified(path);
        FileSystem sourceFS = sourceRoot.getFileSystem(this.getConf());
        FileStatus fileStatus = sourceFS.getFileStatus(path);
        boolean preserveAcls = context.shouldPreserve(DistCpOptions.FileAttribute.ACL);
        boolean preserveXAttrs = context.shouldPreserve(DistCpOptions.FileAttribute.XATTR);
        boolean preserveRawXAttrs = context.shouldPreserveRawXattrs();
        LinkedList<CopyListingFileStatus> fileCopyListingStatus = DistCpUtils.toCopyListingFileStatus(sourceFS, fileStatus, preserveAcls, preserveXAttrs, preserveRawXAttrs, context.getBlocksPerChunk());
        this.writeToFileListingRoot(fileListWriter, fileCopyListingStatus, sourceRoot, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void doBuildListingWithSnapshotDiff(SequenceFile.Writer fileListWriter, DistCpContext context) throws IOException {
        ArrayList<DiffInfo> diffList = this.distCpSync.prepareDiffListForCopyListing();
        Path sourceRoot = context.getSourcePaths().get(0);
        FileSystem sourceFS = sourceRoot.getFileSystem(this.getConf());
        try {
            ArrayList fileStatuses = Lists.newArrayList();
            for (DiffInfo diff : diffList) {
                diff.setTarget(new Path(context.getSourcePaths().get(0), diff.getTarget()));
                if (diff.getType() == SnapshotDiffReport.DiffType.MODIFY) {
                    this.addToFileListing(fileListWriter, sourceRoot, diff.getTarget(), context);
                    continue;
                }
                if (diff.getType() != SnapshotDiffReport.DiffType.CREATE) continue;
                this.addToFileListing(fileListWriter, sourceRoot, diff.getTarget(), context);
                FileStatus sourceStatus = sourceFS.getFileStatus(diff.getTarget());
                if (!sourceStatus.isDirectory()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding source dir for traverse: " + sourceStatus.getPath()));
                }
                HashSet<String> excludeList = this.distCpSync.getTraverseExcludeList(diff.getSource(), context.getSourcePaths().get(0));
                ArrayList<FileStatus> sourceDirs = new ArrayList<FileStatus>();
                sourceDirs.add(sourceStatus);
                this.traverseDirectory(fileListWriter, sourceFS, sourceDirs, sourceRoot, context, excludeList, fileStatuses);
            }
            if (this.randomizeFileListing) {
                this.writeToFileListing(fileStatuses, fileListWriter);
            }
            fileListWriter.close();
            fileListWriter = null;
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{fileListWriter});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{fileListWriter});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void doBuildListing(SequenceFile.Writer fileListWriter, DistCpContext context) throws IOException {
        if (context.getNumListstatusThreads() > 0) {
            this.numListstatusThreads = context.getNumListstatusThreads();
        }
        try {
            ArrayList statusList = Lists.newArrayList();
            for (Path path : context.getSourcePaths()) {
                boolean explore;
                FileSystem sourceFS = path.getFileSystem(this.getConf());
                boolean preserveAcls = context.shouldPreserve(DistCpOptions.FileAttribute.ACL);
                boolean preserveXAttrs = context.shouldPreserve(DistCpOptions.FileAttribute.XATTR);
                boolean preserveRawXAttrs = context.shouldPreserveRawXattrs();
                path = this.makeQualified(path);
                FileStatus rootStatus = sourceFS.getFileStatus(path);
                Path sourcePathRoot = this.computeSourceRootPath(rootStatus, context);
                FileStatus[] sourceFiles = sourceFS.listStatus(path);
                boolean bl = explore = sourceFiles != null && sourceFiles.length > 0;
                if (!explore || rootStatus.isDirectory()) {
                    LinkedList<CopyListingFileStatus> rootCopyListingStatus = DistCpUtils.toCopyListingFileStatus(sourceFS, rootStatus, preserveAcls, preserveXAttrs, preserveRawXAttrs, context.getBlocksPerChunk());
                    this.writeToFileListingRoot(fileListWriter, rootCopyListingStatus, sourcePathRoot, context);
                }
                if (!explore) continue;
                ArrayList<FileStatus> sourceDirs = new ArrayList<FileStatus>();
                for (FileStatus sourceStatus : sourceFiles) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Recording source-path: " + sourceStatus.getPath() + " for copy."));
                    }
                    LinkedList<CopyListingFileStatus> sourceCopyListingStatus = DistCpUtils.toCopyListingFileStatus(sourceFS, sourceStatus, preserveAcls && sourceStatus.isDirectory(), preserveXAttrs && sourceStatus.isDirectory(), preserveRawXAttrs && sourceStatus.isDirectory(), context.getBlocksPerChunk());
                    for (CopyListingFileStatus fs : sourceCopyListingStatus) {
                        if (this.randomizeFileListing) {
                            this.addToFileListing(statusList, new FileStatusInfo(fs, sourcePathRoot), fileListWriter);
                            continue;
                        }
                        this.writeToFileListing(fileListWriter, fs, sourcePathRoot);
                    }
                    if (!sourceStatus.isDirectory()) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Adding source dir for traverse: " + sourceStatus.getPath()));
                    }
                    sourceDirs.add(sourceStatus);
                }
                this.traverseDirectory(fileListWriter, sourceFS, sourceDirs, sourcePathRoot, context, null, statusList);
            }
            if (this.randomizeFileListing) {
                this.writeToFileListing(statusList, fileListWriter);
            }
            fileListWriter.close();
            this.printStats();
            LOG.info((Object)"Build file listing completed.");
            fileListWriter = null;
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{fileListWriter});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{fileListWriter});
    }

    private void addToFileListing(List<FileStatusInfo> fileStatusInfoList, FileStatusInfo statusInfo, SequenceFile.Writer fileListWriter) throws IOException {
        fileStatusInfoList.add(statusInfo);
        if (fileStatusInfoList.size() > this.fileStatusLimit) {
            this.writeToFileListing(fileStatusInfoList, fileListWriter);
        }
    }

    @VisibleForTesting
    void setSeedForRandomListing(long seed) {
        this.rnd.setSeed(seed);
    }

    private void writeToFileListing(List<FileStatusInfo> fileStatusInfoList, SequenceFile.Writer fileListWriter) throws IOException {
        Collections.shuffle(fileStatusInfoList, this.rnd);
        for (FileStatusInfo fileStatusInfo : fileStatusInfoList) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding " + fileStatusInfo.fileStatus.getPath()));
            }
            this.writeToFileListing(fileListWriter, fileStatusInfo.fileStatus, fileStatusInfo.sourceRootPath);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Number of paths written to fileListing=" + fileStatusInfoList.size()));
        }
        fileStatusInfoList.clear();
    }

    private Path computeSourceRootPath(FileStatus sourceStatus, DistCpContext context) throws IOException {
        boolean specialHandling;
        boolean solitaryFile;
        Path target = context.getTargetPath();
        FileSystem targetFS = target.getFileSystem(this.getConf());
        boolean targetPathExists = context.isTargetPathExists();
        boolean bl = solitaryFile = context.getSourcePaths().size() == 1 && !sourceStatus.isDirectory();
        if (solitaryFile) {
            if (!targetPathExists || targetFS.isFile(target)) {
                return sourceStatus.getPath();
            }
            return sourceStatus.getPath().getParent();
        }
        boolean bl2 = specialHandling = context.getSourcePaths().size() == 1 && !targetPathExists || context.shouldSyncFolder() || context.shouldOverwrite();
        if (specialHandling && sourceStatus.isDirectory() || sourceStatus.getPath().isRoot()) {
            return sourceStatus.getPath();
        }
        return sourceStatus.getPath().getParent();
    }

    protected boolean shouldCopy(Path path) {
        return this.copyFilter.shouldCopy(path);
    }

    @Override
    protected long getBytesToCopy() {
        return this.totalBytesToCopy;
    }

    @Override
    protected long getNumberOfPaths() {
        return this.totalPaths;
    }

    private Path makeQualified(Path path) throws IOException {
        FileSystem fs = path.getFileSystem(this.getConf());
        return path.makeQualified(fs.getUri(), fs.getWorkingDirectory());
    }

    private SequenceFile.Writer getWriter(Path pathToListFile) throws IOException {
        FileSystem fs = pathToListFile.getFileSystem(this.getConf());
        fs.delete(pathToListFile, false);
        return SequenceFile.createWriter((Configuration)this.getConf(), (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)pathToListFile), SequenceFile.Writer.keyClass(Text.class), SequenceFile.Writer.valueClass(CopyListingFileStatus.class), SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.NONE)});
    }

    private void printStats() {
        LOG.info((Object)("Paths (files+dirs) cnt = " + this.totalPaths + "; dirCnt = " + this.totalDirs));
    }

    private void maybePrintStats() {
        if (this.totalPaths % 100000L == 0L) {
            this.printStats();
        }
    }

    private void traverseDirectory(SequenceFile.Writer fileListWriter, FileSystem sourceFS, ArrayList<FileStatus> sourceDirs, Path sourcePathRoot, DistCpContext context, HashSet<String> excludeList, List<FileStatusInfo> fileStatuses) throws IOException {
        boolean preserveAcls = context.shouldPreserve(DistCpOptions.FileAttribute.ACL);
        boolean preserveXAttrs = context.shouldPreserve(DistCpOptions.FileAttribute.XATTR);
        boolean preserveRawXattrs = context.shouldPreserveRawXattrs();
        assert (this.numListstatusThreads > 0);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Starting thread pool of " + this.numListstatusThreads + " listStatus workers."));
        }
        ProducerConsumer<FileStatus, FileStatus[]> workers = new ProducerConsumer<FileStatus, FileStatus[]>(this.numListstatusThreads);
        for (int i = 0; i < this.numListstatusThreads; ++i) {
            workers.addWorker(new FileStatusProcessor(sourcePathRoot.getFileSystem(this.getConf()), excludeList));
        }
        for (FileStatus status : sourceDirs) {
            workers.put(new WorkRequest<FileStatus>(status, 0));
        }
        while (workers.hasWork()) {
            try {
                WorkReport workResult = workers.take();
                int retry = workResult.getRetry();
                for (FileStatus child : (FileStatus[])workResult.getItem()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Recording source-path: " + child.getPath() + " for copy."));
                    }
                    if (workResult.getSuccess()) {
                        LinkedList<CopyListingFileStatus> childCopyListingStatus = DistCpUtils.toCopyListingFileStatus(sourceFS, child, preserveAcls && child.isDirectory(), preserveXAttrs && child.isDirectory(), preserveRawXattrs && child.isDirectory(), context.getBlocksPerChunk());
                        for (CopyListingFileStatus fs : childCopyListingStatus) {
                            if (this.randomizeFileListing) {
                                this.addToFileListing(fileStatuses, new FileStatusInfo(fs, sourcePathRoot), fileListWriter);
                                continue;
                            }
                            this.writeToFileListing(fileListWriter, fs, sourcePathRoot);
                        }
                    }
                    if (retry < 3) {
                        if (!child.isDirectory()) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Traversing into source dir: " + child.getPath()));
                        }
                        workers.put(new WorkRequest<FileStatus>(child, retry));
                        continue;
                    }
                    LOG.error((Object)("Giving up on " + child.getPath() + " after " + retry + " retries."));
                }
            }
            catch (InterruptedException ie) {
                LOG.error((Object)"Could not get item from childQueue. Retrying...");
            }
        }
        workers.shutdown();
    }

    private void writeToFileListingRoot(SequenceFile.Writer fileListWriter, LinkedList<CopyListingFileStatus> fileStatus, Path sourcePathRoot, DistCpContext context) throws IOException {
        boolean syncOrOverwrite = context.shouldSyncFolder() || context.shouldOverwrite();
        for (CopyListingFileStatus fs : fileStatus) {
            if (fs.getPath().equals((Object)sourcePathRoot) && fs.isDirectory() && syncOrOverwrite) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Skip " + fs.getPath()));
                }
                return;
            }
            this.writeToFileListing(fileListWriter, fs, sourcePathRoot);
        }
    }

    private void writeToFileListing(SequenceFile.Writer fileListWriter, CopyListingFileStatus fileStatus, Path sourcePathRoot) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("REL PATH: " + DistCpUtils.getRelativePath(sourcePathRoot, fileStatus.getPath()) + ", FULL PATH: " + fileStatus.getPath()));
        }
        if (!this.shouldCopy(fileStatus.getPath())) {
            return;
        }
        fileListWriter.append((Writable)new Text(DistCpUtils.getRelativePath(sourcePathRoot, fileStatus.getPath())), (Writable)fileStatus);
        fileListWriter.sync();
        if (!fileStatus.isDirectory()) {
            this.totalBytesToCopy += fileStatus.getSizeToCopy();
        } else {
            ++this.totalDirs;
        }
        ++this.totalPaths;
        this.maybePrintStats();
    }

    private static class FileStatusProcessor
    implements WorkRequestProcessor<FileStatus, FileStatus[]> {
        private FileSystem fileSystem;
        private HashSet<String> excludeList;

        public FileStatusProcessor(FileSystem fileSystem, HashSet<String> excludeList) {
            this.fileSystem = fileSystem;
            this.excludeList = excludeList;
        }

        private FileStatus[] getFileStatus(Path path) throws IOException {
            FileStatus[] fileStatuses = this.fileSystem.listStatus(path);
            if (this.excludeList != null && this.excludeList.size() > 0) {
                ArrayList<FileStatus> fileStatusList = new ArrayList<FileStatus>();
                for (FileStatus status : fileStatuses) {
                    if (this.excludeList.contains(status.getPath().toUri().getPath())) continue;
                    fileStatusList.add(status);
                }
                fileStatuses = fileStatusList.toArray(new FileStatus[fileStatusList.size()]);
            }
            return fileStatuses;
        }

        @Override
        public WorkReport<FileStatus[]> processItem(WorkRequest<FileStatus> workRequest) {
            FileStatus parent = workRequest.getItem();
            int retry = workRequest.getRetry();
            WorkReport<FileStatus[]> result = null;
            try {
                if (retry > 0) {
                    int sleepSeconds = 2;
                    for (int i = 1; i < retry; ++i) {
                        sleepSeconds *= 2;
                    }
                    try {
                        Thread.sleep(1000 * sleepSeconds);
                    }
                    catch (InterruptedException ie) {
                        LOG.debug((Object)"Interrupted while sleeping in exponential backoff.");
                    }
                }
                result = new WorkReport<FileStatus[]>(this.getFileStatus(parent.getPath()), retry, true);
            }
            catch (FileNotFoundException fnf) {
                LOG.error((Object)("FileNotFoundException exception in listStatus: " + fnf.getMessage()));
                result = new WorkReport<FileStatus[]>(new FileStatus[0], retry, true, fnf);
            }
            catch (Exception e) {
                LOG.error((Object)"Exception in listStatus. Will send for retry.");
                FileStatus[] parentList = new FileStatus[]{parent};
                result = new WorkReport<FileStatus[]>(parentList, retry + 1, false, e);
            }
            return result;
        }
    }

    private static class FileStatusInfo {
        private CopyListingFileStatus fileStatus;
        private Path sourceRootPath;

        FileStatusInfo(CopyListingFileStatus fileStatus, Path sourceRootPath) {
            this.fileStatus = fileStatus;
            this.sourceRootPath = sourceRootPath;
        }
    }
}

