/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import junit.textui.TestRunner;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.PlatformName;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestConfiguration {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private static final double DOUBLE_DELTA = (double)1.0E-9f;
    private Configuration conf;
    static final String CONFIG = new File("./test-config-TestConfiguration.xml").getAbsolutePath();
    static final String CONFIG2 = new File("./test-config2-TestConfiguration.xml").getAbsolutePath();
    static final String CONFIG_CORE = new File("./core-site.xml").getAbsolutePath();
    static final String CONFIG_FOR_ENUM = new File("./test-config-enum-TestConfiguration.xml").getAbsolutePath();
    static final String CONFIG_FOR_URI = new File("./test-config-uri-TestConfiguration.xml").toURI().toString();
    private static final String CONFIG_MULTI_BYTE = new File("./test-config-multi-byte-TestConfiguration.xml").getAbsolutePath();
    private static final String CONFIG_MULTI_BYTE_SAVED = new File("./test-config-multi-byte-saved-TestConfiguration.xml").getAbsolutePath();
    static final Random RAN = new Random();
    static final String XMLHEADER = PlatformName.IBM_JAVA ? "<?xml version=\"1.0\" encoding=\"UTF-8\"?><configuration>" : "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><configuration>";
    public static final String ESCAPED = "&apos;&#39;&#0039;&#x27;";
    private static final String SENSITIVE_CONFIG_KEYS = "hadoop.security.sensitive-config-keys";
    private BufferedWriter out;
    ArrayList<Prop> props = new ArrayList();

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
    }

    @After
    public void tearDown() throws Exception {
        if (this.out != null) {
            this.out.close();
        }
        new File(CONFIG).delete();
        new File(CONFIG2).delete();
        new File(CONFIG_FOR_ENUM).delete();
        new File(new URI(CONFIG_FOR_URI)).delete();
        new File(CONFIG_MULTI_BYTE).delete();
        new File(CONFIG_MULTI_BYTE_SAVED).delete();
        new File(CONFIG_CORE).delete();
    }

    private void startConfig() throws IOException {
        this.out.write("<?xml version=\"1.0\"?>\n");
        this.out.write("<configuration>\n");
    }

    private void writeHeader() throws IOException {
        this.out.write("<?xml version=\"1.0\"?>\n");
    }

    private void writeHeader(String encoding) throws IOException {
        this.out.write("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\n");
    }

    private void writeConfiguration() throws IOException {
        this.out.write("<configuration>\n");
    }

    private void endConfig() throws IOException {
        this.out.write("</configuration>\n");
        this.out.flush();
        this.out.close();
    }

    private void startInclude(String filename) throws IOException {
        this.out.write("<xi:include href=\"" + filename + "\" xmlns:xi=\"http://www.w3.org/2001/XInclude\"  >\n ");
    }

    private void endInclude() throws IOException {
        this.out.write("</xi:include>\n ");
    }

    private void startFallback() throws IOException {
        this.out.write("<xi:fallback>\n ");
    }

    private void endFallback() throws IOException {
        this.out.write("</xi:fallback>\n ");
    }

    private void declareEntity(String root, String entity, String value) throws IOException {
        this.out.write("<!DOCTYPE " + root + " [\n<!ENTITY " + entity + " \"" + value + "\">\n]>");
    }

    private void declareSystemEntity(String root, String entity, String value) throws IOException {
        this.out.write("<!DOCTYPE " + root + " [\n<!ENTITY " + entity + " SYSTEM \"" + value + "\">\n]>");
    }

    @Test
    public void testInputStreamResource() throws Exception {
        StringWriter writer = new StringWriter();
        this.out = new BufferedWriter(writer);
        this.startConfig();
        this.declareProperty("prop", "A", "A");
        this.endConfig();
        InputStream in1 = (InputStream)Mockito.spy((Object)new ByteArrayInputStream(writer.toString().getBytes()));
        Configuration conf = new Configuration(false);
        conf.addResource(in1);
        Assert.assertEquals((Object)"A", (Object)conf.get("prop"));
        ((InputStream)Mockito.verify((Object)in1, (VerificationMode)Mockito.times((int)1))).close();
        ByteArrayInputStream in2 = new ByteArrayInputStream(writer.toString().getBytes());
        conf.addResource((InputStream)in2);
        Assert.assertEquals((Object)"A", (Object)conf.get("prop"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFinalWarnings() throws Exception {
        StringWriter writer = new StringWriter();
        this.out = new BufferedWriter(writer);
        this.startConfig();
        this.declareProperty("prop", "A", "A", true);
        this.endConfig();
        byte[] bytes = writer.toString().getBytes();
        ByteArrayInputStream in1 = new ByteArrayInputStream(bytes);
        writer = new StringWriter();
        this.out = new BufferedWriter(writer);
        this.startConfig();
        this.declareProperty("prop", "BB", "BB", true);
        this.endConfig();
        byte[] bytes2 = writer.toString().getBytes();
        ByteArrayInputStream in2 = new ByteArrayInputStream(bytes2);
        TestAppender appender = new TestAppender();
        Logger logger = Logger.getRootLogger();
        logger.addAppender((Appender)appender);
        try {
            this.conf.addResource((InputStream)in1);
            this.conf.addResource((InputStream)in2);
            Assert.assertEquals((String)"should see the first value", (Object)"A", (Object)this.conf.get("prop"));
            List<LoggingEvent> events = appender.getLog();
            Assert.assertEquals((String)"overriding a final parameter should cause logging", (long)1L, (long)events.size());
            LoggingEvent loggingEvent = events.get(0);
            String renderedMessage = loggingEvent.getRenderedMessage();
            Assert.assertTrue((String)("did not see expected string inside message " + renderedMessage), (boolean)renderedMessage.contains("an attempt to override final parameter: prop;  Ignoring."));
        }
        finally {
            logger.removeAppender((Appender)appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoFinalWarnings() throws Exception {
        StringWriter writer = new StringWriter();
        this.out = new BufferedWriter(writer);
        this.startConfig();
        this.declareProperty("prop", "A", "A", true);
        this.endConfig();
        byte[] bytes = writer.toString().getBytes();
        ByteArrayInputStream in1 = new ByteArrayInputStream(bytes);
        ByteArrayInputStream in2 = new ByteArrayInputStream(bytes);
        TestAppender appender = new TestAppender();
        Logger logger = Logger.getRootLogger();
        logger.addAppender((Appender)appender);
        try {
            this.conf.addResource((InputStream)in1);
            this.conf.addResource((InputStream)in2);
            Assert.assertEquals((Object)"A", (Object)this.conf.get("prop"));
            List<LoggingEvent> events = appender.getLog();
            for (LoggingEvent loggingEvent : events) {
                System.out.println("Event = " + loggingEvent.getRenderedMessage());
            }
            Assert.assertTrue((String)"adding same resource twice should not cause logging", (boolean)events.isEmpty());
        }
        finally {
            logger.removeAppender((Appender)appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFinalWarningsMultiple() throws Exception {
        StringWriter writer = new StringWriter();
        this.out = new BufferedWriter(writer);
        this.startConfig();
        this.declareProperty("prop", "A", "A", true);
        this.declareProperty("prop", "A", "A", true);
        this.endConfig();
        byte[] bytes = writer.toString().getBytes();
        ByteArrayInputStream in1 = new ByteArrayInputStream(bytes);
        TestAppender appender = new TestAppender();
        Logger logger = Logger.getRootLogger();
        logger.addAppender((Appender)appender);
        try {
            this.conf.addResource((InputStream)in1);
            Assert.assertEquals((String)"should see the value", (Object)"A", (Object)this.conf.get("prop"));
            List<LoggingEvent> events = appender.getLog();
            for (LoggingEvent loggingEvent : events) {
                System.out.println("Event = " + loggingEvent.getRenderedMessage());
            }
            Assert.assertTrue((String)"adding same resource twice should not cause logging", (boolean)events.isEmpty());
        }
        finally {
            logger.removeAppender((Appender)appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFinalWarningsMultipleOverride() throws Exception {
        StringWriter writer = new StringWriter();
        this.out = new BufferedWriter(writer);
        this.startConfig();
        this.declareProperty("prop", "A", "A", true);
        this.declareProperty("prop", "BB", "BB", true);
        this.endConfig();
        byte[] bytes = writer.toString().getBytes();
        ByteArrayInputStream in1 = new ByteArrayInputStream(bytes);
        TestAppender appender = new TestAppender();
        Logger logger = Logger.getRootLogger();
        logger.addAppender((Appender)appender);
        try {
            this.conf.addResource((InputStream)in1);
            Assert.assertEquals((String)"should see the value", (Object)"A", (Object)this.conf.get("prop"));
            List<LoggingEvent> events = appender.getLog();
            Assert.assertEquals((String)"overriding a final parameter should cause logging", (long)1L, (long)events.size());
            LoggingEvent loggingEvent = events.get(0);
            String renderedMessage = loggingEvent.getRenderedMessage();
            Assert.assertTrue((String)("did not see expected string inside message " + renderedMessage), (boolean)renderedMessage.contains("an attempt to override final parameter: prop;  Ignoring."));
        }
        finally {
            logger.removeAppender((Appender)appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiByteCharacters() throws IOException {
        String priorDefaultEncoding = System.getProperty("file.encoding");
        try {
            System.setProperty("file.encoding", "US-ASCII");
            String name = "multi_byte_\u611b_name";
            String value = "multi_byte_\u0641_value";
            this.out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(CONFIG_MULTI_BYTE), "UTF-8"));
            this.startConfig();
            this.declareProperty(name, value, value);
            this.endConfig();
            Configuration conf = new Configuration(false);
            conf.addResource(new Path(CONFIG_MULTI_BYTE));
            Assert.assertEquals((Object)value, (Object)conf.get(name));
            try (FileOutputStream fos = new FileOutputStream(CONFIG_MULTI_BYTE_SAVED);){
                conf.writeXml((OutputStream)fos);
            }
            conf = new Configuration(false);
            conf.addResource(new Path(CONFIG_MULTI_BYTE_SAVED));
            Assert.assertEquals((Object)value, (Object)conf.get(name));
        }
        finally {
            System.setProperty("file.encoding", priorDefaultEncoding);
        }
    }

    @Test
    public void testVariableSubstitution() throws IOException {
        Configuration mock = (Configuration)Mockito.spy((Object)this.conf);
        Mockito.when((Object)mock.getProperty("user.name")).thenReturn((Object)"hadoop_user");
        Mockito.when((Object)mock.getenv("FILE_NAME")).thenReturn((Object)"hello");
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.declareProperty("my.int", "${intvar}", "42");
        this.declareProperty("intvar", "42", "42");
        this.declareProperty("my.base", "/tmp/${user.name}", "/tmp/hadoop_user");
        this.declareProperty("my.file", "${env.FILE_NAME}", "hello");
        this.declareProperty("my.suffix", ".txt", ".txt");
        this.declareProperty("my.relfile", "${my.file}${my.suffix}", "hello.txt");
        this.declareProperty("my.fullfile", "${my.base}/${my.file}${my.suffix}", "/tmp/hadoop_user/hello.txt");
        this.declareProperty("my.failsexpand", "a${my.undefvar}b", "a${my.undefvar}b");
        this.declareProperty("my.user.group", "${user.name} ${user.name}", "hadoop_user hadoop_user");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        mock.addResource(fileResource);
        for (Prop p : this.props) {
            System.out.println("p=" + p.name);
            String gotVal = mock.get(p.name);
            String gotRawVal = mock.getRaw(p.name);
            TestConfiguration.assertEq(p.val, gotRawVal);
            TestConfiguration.assertEq(p.expectEval, gotVal);
        }
        Assert.assertTrue((mock.getInt("intvar", -1) == 42 ? 1 : 0) != 0);
        Assert.assertTrue((mock.getInt("my.int", -1) == 42 ? 1 : 0) != 0);
    }

    @Test
    public void testEnvDefault() throws IOException {
        Configuration mock = (Configuration)Mockito.spy((Object)this.conf);
        Mockito.when((Object)mock.getenv("NULL_VALUE")).thenReturn(null);
        Mockito.when((Object)mock.getenv("EMPTY_VALUE")).thenReturn((Object)"");
        Mockito.when((Object)mock.getenv("SOME_VALUE")).thenReturn((Object)"some value");
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.declareProperty("null1", "${env.NULL_VALUE}", "${env.NULL_VALUE}");
        this.declareProperty("null2", "${env.NULL_VALUE-a}", "a");
        this.declareProperty("null3", "${env.NULL_VALUE:-b}", "b");
        this.declareProperty("empty1", "${env.EMPTY_VALUE}", "");
        this.declareProperty("empty2", "${env.EMPTY_VALUE-c}", "");
        this.declareProperty("empty3", "${env.EMPTY_VALUE:-d}", "d");
        this.declareProperty("some1", "${env.SOME_VALUE}", "some value");
        this.declareProperty("some2", "${env.SOME_VALUE-e}", "some value");
        this.declareProperty("some3", "${env.SOME_VALUE:-f}", "some value");
        this.declareProperty("edge1", "${env.NULL_VALUE-g-h}", "g-h");
        this.declareProperty("edge2", "${env.NULL_VALUE:-i:-j}", "i:-j");
        this.declareProperty("edge3", "${env.NULL_VALUE-}", "");
        this.declareProperty("edge4", "${env.NULL_VALUE:-}", "");
        this.declareProperty("edge5", "${env.NULL_VALUE:}", "${env.NULL_VALUE:}");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        mock.addResource(fileResource);
        for (Prop p : this.props) {
            System.out.println("p=" + p.name);
            String gotVal = mock.get(p.name);
            String gotRawVal = mock.getRaw(p.name);
            TestConfiguration.assertEq(p.val, gotRawVal);
            TestConfiguration.assertEq(p.expectEval, gotVal);
        }
    }

    @Test
    public void testFinalParam() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.declareProperty("my.var", "", "", true);
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        Configuration conf1 = new Configuration();
        conf1.addResource(fileResource);
        Assert.assertNull((String)"my var is not null", (Object)conf1.get("my.var"));
        this.out = new BufferedWriter(new FileWriter(CONFIG2));
        this.startConfig();
        this.declareProperty("my.var", "myval", "myval", false);
        this.endConfig();
        fileResource = new Path(CONFIG2);
        Configuration conf2 = new Configuration(conf1);
        conf2.addResource(fileResource);
        Assert.assertNull((String)"my var is not final", (Object)conf2.get("my.var"));
    }

    @Test
    public void testCompactFormat() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendCompactFormatProperty("a", "b");
        this.appendCompactFormatProperty("c", "d", true);
        this.appendCompactFormatProperty("e", "f", false, "g");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        Configuration conf = new Configuration(false);
        conf.addResource(fileResource);
        Assert.assertEquals((Object)"b", (Object)conf.get("a"));
        Assert.assertEquals((Object)"d", (Object)conf.get("c"));
        Set s = conf.getFinalParameters();
        Assert.assertEquals((long)1L, (long)s.size());
        Assert.assertTrue((boolean)s.contains("c"));
        Assert.assertEquals((Object)"f", (Object)conf.get("e"));
        String[] sources = conf.getPropertySources("e");
        Assert.assertEquals((long)2L, (long)sources.length);
        Assert.assertEquals((Object)"g", (Object)sources[0]);
        Assert.assertEquals((Object)fileResource.toString(), (Object)sources[1]);
    }

    public static void assertEq(Object a, Object b) {
        System.out.println("assertEq: " + a + ", " + b);
        Assert.assertEquals((Object)a, (Object)b);
    }

    void declareProperty(String name, String val, String expectEval) throws IOException {
        this.declareProperty(name, val, expectEval, false);
    }

    void declareProperty(String name, String val, String expectEval, boolean isFinal) throws IOException {
        this.appendProperty(name, val, isFinal, new String[0]);
        Prop p = new Prop();
        p.name = name;
        p.val = val;
        p.expectEval = expectEval;
        this.props.add(p);
    }

    void appendProperty(String name, String val) throws IOException {
        this.appendProperty(name, val, false, new String[0]);
    }

    void appendProperty(String name, String val, boolean isFinal, String ... sources) throws IOException {
        this.out.write("<property>");
        this.out.write("<name>");
        this.out.write(name);
        this.out.write("</name>");
        this.out.write("<value>");
        this.out.write(val);
        this.out.write("</value>");
        if (isFinal) {
            this.out.write("<final>true</final>");
        }
        for (String s : sources) {
            this.out.write("<source>");
            this.out.write(s);
            this.out.write("</source>");
        }
        this.out.write("</property>\n");
    }

    private void appendPropertyByTag(String name, String val, String tags, String ... sources) throws IOException {
        this.appendPropertyByTag(name, val, false, tags, sources);
    }

    private void appendPropertyByTag(String name, String val, boolean isFinal, String tag, String ... sources) throws IOException {
        this.out.write("<property>");
        this.out.write("<name>");
        this.out.write(name);
        this.out.write("</name>");
        this.out.write("<value>");
        this.out.write(val);
        this.out.write("</value>");
        if (isFinal) {
            this.out.write("<final>true</final>");
        }
        for (String s : sources) {
            this.out.write("<source>");
            this.out.write(s);
            this.out.write("</source>");
        }
        this.out.write("<tag>");
        this.out.write(tag);
        this.out.write("</tag>");
        this.out.write("</property>\n");
    }

    void appendCompactFormatProperty(String name, String val) throws IOException {
        this.appendCompactFormatProperty(name, val, false);
    }

    void appendCompactFormatProperty(String name, String val, boolean isFinal) throws IOException {
        this.appendCompactFormatProperty(name, val, isFinal, null);
    }

    void appendCompactFormatProperty(String name, String val, boolean isFinal, String source) throws IOException {
        this.out.write("<property ");
        this.out.write("name=\"");
        this.out.write(name);
        this.out.write("\" ");
        this.out.write("value=\"");
        this.out.write(val);
        this.out.write("\" ");
        if (isFinal) {
            this.out.write("final=\"true\" ");
        }
        if (source != null) {
            this.out.write("source=\"");
            this.out.write(source);
            this.out.write("\" ");
        }
        this.out.write("/>\n");
    }

    @Test
    public void testOverlay() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("a", "b");
        this.appendProperty("b", "c");
        this.appendProperty("d", "e");
        this.appendProperty("e", "f", true, new String[0]);
        this.endConfig();
        this.out = new BufferedWriter(new FileWriter(CONFIG2));
        this.startConfig();
        this.appendProperty("a", "b");
        this.appendProperty("b", "d");
        this.appendProperty("e", "e");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        this.conf.set("c", "d");
        this.conf.set("a", "d");
        Configuration clone = new Configuration(this.conf);
        clone.addResource(new Path(CONFIG2));
        Assert.assertEquals((Object)clone.get("a"), (Object)"d");
        Assert.assertEquals((Object)clone.get("b"), (Object)"d");
        Assert.assertEquals((Object)clone.get("c"), (Object)"d");
        Assert.assertEquals((Object)clone.get("d"), (Object)"e");
        Assert.assertEquals((Object)clone.get("e"), (Object)"f");
    }

    @Test
    public void testCommentsInValue() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("my.comment", "this <!--comment here--> contains a comment");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        Assert.assertEquals((Object)"this  contains a comment", (Object)this.conf.get("my.comment"));
    }

    @Test
    public void testEscapedCharactersInValue() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("my.comment", ESCAPED);
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        Assert.assertEquals((Object)"''''", (Object)this.conf.get("my.comment"));
    }

    @Test
    public void testTrim() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        String[] whitespaces = new String[]{"", " ", "\n", "\t"};
        String[] name = new String[100];
        for (int i = 0; i < name.length; ++i) {
            name[i] = "foo" + i;
            StringBuilder prefix = new StringBuilder();
            StringBuilder postfix = new StringBuilder();
            for (int j = 0; j < 3; ++j) {
                prefix.append(whitespaces[RAN.nextInt(whitespaces.length)]);
                postfix.append(whitespaces[RAN.nextInt(whitespaces.length)]);
            }
            this.appendProperty(prefix + name[i] + postfix, name[i] + ".value");
        }
        this.endConfig();
        this.conf.addResource(new Path(CONFIG));
        for (String n : name) {
            Assert.assertEquals((Object)(n + ".value"), (Object)this.conf.get(n));
        }
    }

    @Test
    public void testGetLocalPath() throws IOException {
        int i;
        Configuration conf = new Configuration();
        Object[] dirs = new String[]{"a", "b", "c"};
        for (i = 0; i < dirs.length; ++i) {
            dirs[i] = new Path(GenericTestUtils.getTempPath((String)dirs[i])).toString();
        }
        conf.set("dirs", StringUtils.join((Object[])dirs, (String)","));
        for (i = 0; i < 1000; ++i) {
            String localPath = conf.getLocalPath("dirs", "dir" + i).toString();
            Assert.assertTrue((String)("Path doesn't end in specified dir: " + localPath), (boolean)localPath.endsWith("dir" + i));
            Assert.assertFalse((String)("Path has internal whitespace: " + localPath), (boolean)localPath.contains(" "));
        }
    }

    @Test
    public void testGetFile() throws IOException {
        int i;
        Configuration conf = new Configuration();
        Object[] dirs = new String[]{"a", "b", "c"};
        for (i = 0; i < dirs.length; ++i) {
            dirs[i] = new Path(GenericTestUtils.getTempPath((String)dirs[i])).toString();
        }
        conf.set("dirs", StringUtils.join((Object[])dirs, (String)","));
        for (i = 0; i < 1000; ++i) {
            String localPath = conf.getFile("dirs", "dir" + i).toString();
            Assert.assertTrue((String)("Path doesn't end in specified dir: " + localPath), (boolean)localPath.endsWith("dir" + i));
            Assert.assertFalse((String)("Path has internal whitespace: " + localPath), (boolean)localPath.contains(" "));
        }
    }

    @Test
    public void testToString() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        String expectedOutput = "Configuration: core-default.xml, core-site.xml, " + fileResource.toString();
        Assert.assertEquals((Object)expectedOutput, (Object)this.conf.toString());
    }

    @Test
    public void testWriteXml() throws IOException {
        Configuration conf = new Configuration();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        conf.writeXml((OutputStream)baos);
        String result = baos.toString();
        Assert.assertTrue((String)"Result has proper header", (boolean)result.startsWith(XMLHEADER));
        Assert.assertTrue((String)"Result has proper footer", (boolean)result.endsWith("</configuration>"));
    }

    @Test
    public void testIncludes() throws Exception {
        this.tearDown();
        System.out.println("XXX testIncludes");
        this.out = new BufferedWriter(new FileWriter(CONFIG2));
        this.startConfig();
        this.appendProperty("a", "b");
        this.appendProperty("c", "d");
        this.endConfig();
        File fileUri = new File(new URI(CONFIG_FOR_URI));
        this.out = new BufferedWriter(new FileWriter(fileUri));
        this.startConfig();
        this.appendProperty("e", "f");
        this.appendProperty("g", "h");
        this.endConfig();
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.startInclude(CONFIG2);
        this.endInclude();
        this.startInclude(CONFIG_FOR_URI);
        this.endInclude();
        this.appendProperty("i", "j");
        this.appendProperty("k", "l");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        Assert.assertEquals((Object)this.conf.get("a"), (Object)"b");
        Assert.assertEquals((Object)this.conf.get("c"), (Object)"d");
        Assert.assertEquals((Object)this.conf.get("e"), (Object)"f");
        Assert.assertEquals((Object)this.conf.get("g"), (Object)"h");
        Assert.assertEquals((Object)this.conf.get("i"), (Object)"j");
        Assert.assertEquals((Object)this.conf.get("k"), (Object)"l");
        this.tearDown();
    }

    @Test
    public void testCharsetInDocumentEncoding() throws Exception {
        this.tearDown();
        this.out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(CONFIG), StandardCharsets.ISO_8859_1));
        this.writeHeader(StandardCharsets.ISO_8859_1.displayName());
        this.writeConfiguration();
        this.appendProperty("a", "b");
        this.appendProperty("c", "M\u00fcller");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        Assert.assertEquals((Object)this.conf.get("a"), (Object)"b");
        Assert.assertEquals((Object)this.conf.get("c"), (Object)"M\u00fcller");
        this.tearDown();
    }

    @Test
    public void testEntityReference() throws Exception {
        this.tearDown();
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.writeHeader();
        this.declareEntity("configuration", "d", "d");
        this.writeConfiguration();
        this.appendProperty("a", "b");
        this.appendProperty("c", "&d;");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        Assert.assertEquals((Object)this.conf.get("a"), (Object)"b");
        Assert.assertEquals((Object)this.conf.get("c"), (Object)"d");
        this.tearDown();
    }

    @Test
    public void testSystemEntityReference() throws Exception {
        this.tearDown();
        this.out = new BufferedWriter(new FileWriter(CONFIG2));
        this.out.write("d");
        this.out.close();
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.writeHeader();
        this.declareSystemEntity("configuration", "d", new Path(CONFIG2).toUri().toString());
        this.writeConfiguration();
        this.appendProperty("a", "b");
        this.appendProperty("c", "&d;");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        Assert.assertEquals((Object)this.conf.get("a"), (Object)"b");
        Assert.assertEquals((Object)this.conf.get("c"), (Object)"d");
        this.tearDown();
    }

    @Test
    public void testIncludesWithFallback() throws Exception {
        this.tearDown();
        this.out = new BufferedWriter(new FileWriter(CONFIG2));
        this.startConfig();
        this.appendProperty("a", "b");
        this.appendProperty("c", "d");
        this.endConfig();
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.startInclude(CONFIG2);
        this.startFallback();
        this.appendProperty("a", "b.fallback");
        this.appendProperty("c", "d.fallback", true, new String[0]);
        this.endFallback();
        this.endInclude();
        this.appendProperty("e", "f");
        this.appendProperty("g", "h");
        this.startInclude("MissingConfig.xml");
        this.startFallback();
        this.appendProperty("i", "j.fallback");
        this.appendProperty("k", "l.fallback", true, new String[0]);
        this.endFallback();
        this.endInclude();
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        Assert.assertEquals((Object)"b", (Object)this.conf.get("a"));
        Assert.assertEquals((Object)"d", (Object)this.conf.get("c"));
        Assert.assertEquals((Object)"f", (Object)this.conf.get("e"));
        Assert.assertEquals((Object)"h", (Object)this.conf.get("g"));
        Assert.assertEquals((Object)"j.fallback", (Object)this.conf.get("i"));
        Assert.assertEquals((Object)"l.fallback", (Object)this.conf.get("k"));
        this.tearDown();
    }

    @Test
    public void testRelativeIncludes() throws Exception {
        this.tearDown();
        String relConfig = new File("./tmp/test-config.xml").getAbsolutePath();
        String relConfig2 = new File("./tmp/test-config2.xml").getAbsolutePath();
        new File(new File(relConfig).getParent()).mkdirs();
        this.out = new BufferedWriter(new FileWriter(relConfig2));
        this.startConfig();
        this.appendProperty("a", "b");
        this.endConfig();
        this.out = new BufferedWriter(new FileWriter(relConfig));
        this.startConfig();
        this.startInclude(new File(relConfig2).getName());
        this.endInclude();
        this.appendProperty("c", "d");
        this.endConfig();
        Path fileResource = new Path(relConfig);
        this.conf.addResource(fileResource);
        Assert.assertEquals((Object)this.conf.get("a"), (Object)"b");
        Assert.assertEquals((Object)this.conf.get("c"), (Object)"d");
        new File(relConfig).delete();
        new File(relConfig2).delete();
        new File(new File(relConfig).getParent()).delete();
    }

    @Test
    public void testIntegerRanges() {
        Configuration conf = new Configuration();
        conf.set("first", "-100");
        conf.set("second", "4-6,9-10,27");
        conf.set("third", "34-");
        Configuration.IntegerRanges range = conf.getRange("first", null);
        System.out.println("first = " + range);
        Assert.assertEquals((Object)true, (Object)range.isIncluded(0));
        Assert.assertEquals((Object)true, (Object)range.isIncluded(1));
        Assert.assertEquals((Object)true, (Object)range.isIncluded(100));
        Assert.assertEquals((Object)false, (Object)range.isIncluded(101));
        range = conf.getRange("second", null);
        System.out.println("second = " + range);
        Assert.assertEquals((Object)false, (Object)range.isIncluded(3));
        Assert.assertEquals((Object)true, (Object)range.isIncluded(4));
        Assert.assertEquals((Object)true, (Object)range.isIncluded(6));
        Assert.assertEquals((Object)false, (Object)range.isIncluded(7));
        Assert.assertEquals((Object)false, (Object)range.isIncluded(8));
        Assert.assertEquals((Object)true, (Object)range.isIncluded(9));
        Assert.assertEquals((Object)true, (Object)range.isIncluded(10));
        Assert.assertEquals((Object)false, (Object)range.isIncluded(11));
        Assert.assertEquals((Object)false, (Object)range.isIncluded(26));
        Assert.assertEquals((Object)true, (Object)range.isIncluded(27));
        Assert.assertEquals((Object)false, (Object)range.isIncluded(28));
        range = conf.getRange("third", null);
        System.out.println("third = " + range);
        Assert.assertEquals((Object)false, (Object)range.isIncluded(33));
        Assert.assertEquals((Object)true, (Object)range.isIncluded(34));
        Assert.assertEquals((Object)true, (Object)range.isIncluded(100000000));
    }

    @Test
    public void testGetRangeIterator() throws Exception {
        Configuration config = new Configuration(false);
        Configuration.IntegerRanges ranges = config.getRange("Test", "");
        Assert.assertFalse((String)"Empty range has values", (boolean)ranges.iterator().hasNext());
        ranges = config.getRange("Test", "5");
        HashSet<Integer> expected = new HashSet<Integer>(Arrays.asList(5));
        HashSet<Integer> found = new HashSet<Integer>();
        for (Integer i : ranges) {
            found.add(i);
        }
        Assert.assertEquals(expected, found);
        ranges = config.getRange("Test", "5-10,13-14");
        expected = new HashSet<Integer>(Arrays.asList(5, 6, 7, 8, 9, 10, 13, 14));
        found = new HashSet();
        for (Integer i : ranges) {
            found.add(i);
        }
        Assert.assertEquals(expected, found);
        ranges = config.getRange("Test", "8-12, 5- 7");
        expected = new HashSet<Integer>(Arrays.asList(5, 6, 7, 8, 9, 10, 11, 12));
        found = new HashSet();
        for (Integer i : ranges) {
            found.add(i);
        }
        Assert.assertEquals(expected, found);
    }

    @Test
    public void testHexValues() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.hex1", "0x10");
        this.appendProperty("test.hex2", "0xF");
        this.appendProperty("test.hex3", "-0x10");
        this.appendProperty("test.hex4", "-0x10xyz");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        Assert.assertEquals((long)16L, (long)this.conf.getInt("test.hex1", 0));
        Assert.assertEquals((long)16L, (long)this.conf.getLong("test.hex1", 0L));
        Assert.assertEquals((long)15L, (long)this.conf.getInt("test.hex2", 0));
        Assert.assertEquals((long)15L, (long)this.conf.getLong("test.hex2", 0L));
        Assert.assertEquals((long)-16L, (long)this.conf.getInt("test.hex3", 0));
        Assert.assertEquals((long)-16L, (long)this.conf.getLong("test.hex3", 0L));
        try {
            this.conf.getLong("test.hex4", 0L);
            Assert.fail((String)"Property had invalid long value, but was read successfully.");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.conf.getInt("test.hex4", 0);
            Assert.fail((String)"Property had invalid int value, but was read successfully.");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testIntegerValues() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.int1", "20");
        this.appendProperty("test.int2", "020");
        this.appendProperty("test.int3", "-20");
        this.appendProperty("test.int4", " -20 ");
        this.appendProperty("test.int5", " -20xyz ");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        Assert.assertEquals((long)20L, (long)this.conf.getInt("test.int1", 0));
        Assert.assertEquals((long)20L, (long)this.conf.getLong("test.int1", 0L));
        Assert.assertEquals((long)20L, (long)this.conf.getLongBytes("test.int1", 0L));
        Assert.assertEquals((long)20L, (long)this.conf.getInt("test.int2", 0));
        Assert.assertEquals((long)20L, (long)this.conf.getLong("test.int2", 0L));
        Assert.assertEquals((long)20L, (long)this.conf.getLongBytes("test.int2", 0L));
        Assert.assertEquals((long)-20L, (long)this.conf.getInt("test.int3", 0));
        Assert.assertEquals((long)-20L, (long)this.conf.getLong("test.int3", 0L));
        Assert.assertEquals((long)-20L, (long)this.conf.getLongBytes("test.int3", 0L));
        Assert.assertEquals((long)-20L, (long)this.conf.getInt("test.int4", 0));
        Assert.assertEquals((long)-20L, (long)this.conf.getLong("test.int4", 0L));
        Assert.assertEquals((long)-20L, (long)this.conf.getLongBytes("test.int4", 0L));
        try {
            this.conf.getInt("test.int5", 0);
            Assert.fail((String)"Property had invalid int value, but was read successfully.");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testHumanReadableValues() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.humanReadableValue1", "1m");
        this.appendProperty("test.humanReadableValue2", "1M");
        this.appendProperty("test.humanReadableValue5", "1MBCDE");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        Assert.assertEquals((long)0x100000L, (long)this.conf.getLongBytes("test.humanReadableValue1", 0L));
        Assert.assertEquals((long)0x100000L, (long)this.conf.getLongBytes("test.humanReadableValue2", 0L));
        try {
            this.conf.getLongBytes("test.humanReadableValue5", 0L);
            Assert.fail((String)"Property had invalid human readable value, but was read successfully.");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testBooleanValues() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.bool1", "true");
        this.appendProperty("test.bool2", "false");
        this.appendProperty("test.bool3", "  true ");
        this.appendProperty("test.bool4", " false ");
        this.appendProperty("test.bool5", "foo");
        this.appendProperty("test.bool6", "TRUE");
        this.appendProperty("test.bool7", "FALSE");
        this.appendProperty("test.bool8", "");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        Assert.assertEquals((Object)true, (Object)this.conf.getBoolean("test.bool1", false));
        Assert.assertEquals((Object)false, (Object)this.conf.getBoolean("test.bool2", true));
        Assert.assertEquals((Object)true, (Object)this.conf.getBoolean("test.bool3", false));
        Assert.assertEquals((Object)false, (Object)this.conf.getBoolean("test.bool4", true));
        Assert.assertEquals((Object)true, (Object)this.conf.getBoolean("test.bool5", true));
        Assert.assertEquals((Object)true, (Object)this.conf.getBoolean("test.bool6", false));
        Assert.assertEquals((Object)false, (Object)this.conf.getBoolean("test.bool7", true));
        Assert.assertEquals((Object)false, (Object)this.conf.getBoolean("test.bool8", false));
    }

    @Test
    public void testFloatValues() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.float1", "3.1415");
        this.appendProperty("test.float2", "003.1415");
        this.appendProperty("test.float3", "-3.1415");
        this.appendProperty("test.float4", " -3.1415 ");
        this.appendProperty("test.float5", "xyz-3.1415xyz");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        Assert.assertEquals((double)3.1415f, (double)this.conf.getFloat("test.float1", 0.0f), (double)1.0E-9f);
        Assert.assertEquals((double)3.1415f, (double)this.conf.getFloat("test.float2", 0.0f), (double)1.0E-9f);
        Assert.assertEquals((double)-3.1415f, (double)this.conf.getFloat("test.float3", 0.0f), (double)1.0E-9f);
        Assert.assertEquals((double)-3.1415f, (double)this.conf.getFloat("test.float4", 0.0f), (double)1.0E-9f);
        try {
            this.conf.getFloat("test.float5", 0.0f);
            Assert.fail((String)"Property had invalid float value, but was read successfully.");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testDoubleValues() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.double1", "3.1415");
        this.appendProperty("test.double2", "003.1415");
        this.appendProperty("test.double3", "-3.1415");
        this.appendProperty("test.double4", " -3.1415 ");
        this.appendProperty("test.double5", "xyz-3.1415xyz");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        Assert.assertEquals((double)3.1415, (double)this.conf.getDouble("test.double1", 0.0), (double)1.0E-9f);
        Assert.assertEquals((double)3.1415, (double)this.conf.getDouble("test.double2", 0.0), (double)1.0E-9f);
        Assert.assertEquals((double)-3.1415, (double)this.conf.getDouble("test.double3", 0.0), (double)1.0E-9f);
        Assert.assertEquals((double)-3.1415, (double)this.conf.getDouble("test.double4", 0.0), (double)1.0E-9f);
        try {
            this.conf.getDouble("test.double5", 0.0);
            Assert.fail((String)"Property had invalid double value, but was read successfully.");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testGetClass() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.class1", "java.lang.Integer");
        this.appendProperty("test.class2", " java.lang.Integer ");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        Assert.assertEquals((Object)"java.lang.Integer", (Object)this.conf.getClass("test.class1", null).getCanonicalName());
        Assert.assertEquals((Object)"java.lang.Integer", (Object)this.conf.getClass("test.class2", null).getCanonicalName());
    }

    @Test
    public void testGetClasses() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.classes1", "java.lang.Integer,java.lang.String");
        this.appendProperty("test.classes2", " java.lang.Integer , java.lang.String ");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        Object[] expectedNames = new String[]{"java.lang.Integer", "java.lang.String"};
        Class[] defaultClasses = new Class[]{};
        Class[] classes1 = this.conf.getClasses("test.classes1", defaultClasses);
        Class[] classes2 = this.conf.getClasses("test.classes2", defaultClasses);
        Assert.assertArrayEquals((Object[])expectedNames, (Object[])TestConfiguration.extractClassNames(classes1));
        Assert.assertArrayEquals((Object[])expectedNames, (Object[])TestConfiguration.extractClassNames(classes2));
    }

    @Test
    public void testGetStringCollection() {
        Configuration c = new Configuration();
        c.set("x", " a, b\n,\nc ");
        Collection strs = c.getTrimmedStringCollection("x");
        Assert.assertEquals((long)3L, (long)strs.size());
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c"}, (Object[])strs.toArray(new String[0]));
        strs.add("z");
        strs = c.getStringCollection("does-not-exist");
        Assert.assertEquals((long)0L, (long)strs.size());
        strs.add("z");
    }

    @Test
    public void testGetTrimmedStringCollection() {
        Configuration c = new Configuration();
        c.set("x", "a, b, c");
        Collection strs = c.getStringCollection("x");
        Assert.assertEquals((long)3L, (long)strs.size());
        Assert.assertArrayEquals((Object[])new String[]{"a", " b", " c"}, (Object[])strs.toArray(new String[0]));
        strs.add("z");
        strs = c.getStringCollection("does-not-exist");
        Assert.assertEquals((long)0L, (long)strs.size());
        strs.add("z");
    }

    private static String[] extractClassNames(Class<?>[] classes) {
        String[] classNames = new String[classes.length];
        for (int i = 0; i < classNames.length; ++i) {
            classNames[i] = classes[i].getCanonicalName();
        }
        return classNames;
    }

    @Test
    public void testEnum() {
        Configuration conf = new Configuration();
        conf.setEnum("test.enum", (Enum)Dingo.FOO);
        Assert.assertSame((Object)((Object)Dingo.FOO), (Object)conf.getEnum("test.enum", (Enum)Dingo.BAR));
        Assert.assertSame((Object)((Object)Yak.FOO), (Object)conf.getEnum("test.enum", (Enum)Yak.RAB));
        conf.setEnum("test.enum", (Enum)Dingo.FOO);
        boolean fail = false;
        try {
            conf.setEnum("test.enum", (Enum)Dingo.BAR);
            conf.getEnum("test.enum", (Enum)Yak.FOO);
        }
        catch (IllegalArgumentException e) {
            fail = true;
        }
        Assert.assertTrue((boolean)fail);
    }

    @Test
    public void testEnumFromXml() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG_FOR_ENUM));
        this.startConfig();
        this.appendProperty("test.enum", " \t \n   FOO \t \n");
        this.appendProperty("test.enum2", " \t \n   Yak.FOO \t \n");
        this.endConfig();
        Configuration conf = new Configuration();
        Path fileResource = new Path(CONFIG_FOR_ENUM);
        conf.addResource(fileResource);
        Assert.assertSame((Object)((Object)Yak.FOO), (Object)conf.getEnum("test.enum", (Enum)Yak.FOO));
        boolean fail = false;
        try {
            conf.getEnum("test.enum2", (Enum)Yak.FOO);
        }
        catch (IllegalArgumentException e) {
            fail = true;
        }
        Assert.assertTrue((boolean)fail);
    }

    @Test
    public void testTimeDuration() {
        Configuration conf = new Configuration(false);
        conf.setTimeDuration("test.time.a", 7L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)"7s", (Object)conf.get("test.time.a"));
        Assert.assertEquals((long)0L, (long)conf.getTimeDuration("test.time.a", 30L, TimeUnit.MINUTES));
        Assert.assertEquals((long)7L, (long)conf.getTimeDuration("test.time.a", 30L, TimeUnit.SECONDS));
        Assert.assertEquals((long)7000L, (long)conf.getTimeDuration("test.time.a", 30L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)7000000L, (long)conf.getTimeDuration("test.time.a", 30L, TimeUnit.MICROSECONDS));
        Assert.assertEquals((long)7000000000L, (long)conf.getTimeDuration("test.time.a", 30L, TimeUnit.NANOSECONDS));
        conf.setTimeDuration("test.time.b", 1L, TimeUnit.DAYS);
        Assert.assertEquals((Object)"1d", (Object)conf.get("test.time.b"));
        Assert.assertEquals((long)1L, (long)conf.getTimeDuration("test.time.b", 1L, TimeUnit.DAYS));
        Assert.assertEquals((long)24L, (long)conf.getTimeDuration("test.time.b", 1L, TimeUnit.HOURS));
        Assert.assertEquals((long)TimeUnit.MINUTES.convert(1L, TimeUnit.DAYS), (long)conf.getTimeDuration("test.time.b", 1L, TimeUnit.MINUTES));
        Assert.assertEquals((long)30L, (long)conf.getTimeDuration("test.time.X", 30L, TimeUnit.SECONDS));
        conf.set("test.time.X", "30");
        Assert.assertEquals((long)30L, (long)conf.getTimeDuration("test.time.X", 40L, TimeUnit.SECONDS));
        Assert.assertEquals((long)10L, (long)conf.getTimeDuration("test.time.c", "10", TimeUnit.SECONDS));
        Assert.assertEquals((long)30L, (long)conf.getTimeDuration("test.time.c", "30s", TimeUnit.SECONDS));
        Assert.assertEquals((long)120L, (long)conf.getTimeDuration("test.time.c", "2m", TimeUnit.SECONDS));
        conf.set("test.time.c", "30");
        Assert.assertEquals((long)30L, (long)conf.getTimeDuration("test.time.c", "40s", TimeUnit.SECONDS));
        conf.set("test.time.d", "30S");
        Assert.assertEquals((long)30L, (long)conf.getTimeDuration("test.time.d", 40L, TimeUnit.SECONDS));
        for (Configuration.ParsedTimeDuration ptd : Configuration.ParsedTimeDuration.values()) {
            conf.setTimeDuration("test.time.unit", 1L, ptd.unit());
            Assert.assertEquals((Object)(1 + ptd.suffix()), (Object)conf.get("test.time.unit"));
            Assert.assertEquals((long)1L, (long)conf.getTimeDuration("test.time.unit", 2L, ptd.unit()));
        }
    }

    @Test
    public void testStorageUnit() {
        String key = "valid.key";
        String nonKey = "not.a.key";
        Configuration conf = new Configuration(false);
        conf.setStorageSize("valid.key", 10.0, StorageUnit.MB);
        Assert.assertThat((Object)conf.getStorageSize("valid.key", "1GB", StorageUnit.MB), (Matcher)Is.is((Object)10.0));
        Assert.assertThat((Object)conf.getStorageSize("not.a.key", "1GB", StorageUnit.MB), (Matcher)Is.is((Object)1024.0));
        conf.setStorageSize("valid.key", 1024.0, StorageUnit.BYTES);
        Assert.assertThat((Object)conf.getStorageSize("valid.key", 100.0, StorageUnit.KB), (Matcher)Is.is((Object)1.0));
        Assert.assertThat((Object)conf.getStorageSize("not.a.key", 100.0, StorageUnit.KB), (Matcher)Is.is((Object)100.0));
        conf.setStrings("valid.key", new String[]{"1TB"});
        Assert.assertThat((Object)conf.getStorageSize("valid.key", "1PB", StorageUnit.GB), (Matcher)Is.is((Object)1024.0));
        conf.setStrings("valid.key", new String[]{"1bytes"});
        Assert.assertThat((Object)conf.getStorageSize("valid.key", "1PB", StorageUnit.KB), (Matcher)Is.is((Object)0.001));
        conf.setStrings("valid.key", new String[]{"2048b"});
        Assert.assertThat((Object)conf.getStorageSize("valid.key", "1PB", StorageUnit.KB), (Matcher)Is.is((Object)2.0));
        conf.setStrings("valid.key", new String[]{"64 GB"});
        Assert.assertThat((Object)conf.getStorageSize("valid.key", "1PB", StorageUnit.GB), (Matcher)Is.is((Object)64.0));
        conf.setStrings("valid.key", new String[]{"1T"});
        Assert.assertThat((Object)conf.getStorageSize("valid.key", "1GB", StorageUnit.TB), (Matcher)Is.is((Object)1.0));
        conf.setStrings("valid.key", new String[]{"1k"});
        Assert.assertThat((Object)conf.getStorageSize("valid.key", "1GB", StorageUnit.KB), (Matcher)Is.is((Object)1.0));
        conf.setStrings("valid.key", new String[]{"10m"});
        Assert.assertThat((Object)conf.getStorageSize("valid.key", "1GB", StorageUnit.MB), (Matcher)Is.is((Object)10.0));
        conf.setStrings("valid.key", new String[]{"100"});
        this.thrown.expect(IllegalArgumentException.class);
        conf.getStorageSize("valid.key", "1PB", StorageUnit.GB);
        conf.setStrings("valid.key", new String[]{"1HB"});
        this.thrown.expect(IllegalArgumentException.class);
        conf.getStorageSize("valid.key", "1PB", StorageUnit.GB);
        conf.setStrings("valid.key", new String[]{"HadoopGB"});
        this.thrown.expect(IllegalArgumentException.class);
        conf.getStorageSize("valid.key", "1PB", StorageUnit.GB);
    }

    @Test
    public void testTimeDurationWarning() {
        String[] convDAYS;
        String warnFormat = "Possible loss of precision converting %s to %s for test.time.warn";
        final ArrayList warnchk = new ArrayList();
        Configuration wconf = new Configuration(false){

            void logDeprecation(String message) {
                warnchk.add(message);
            }
        };
        for (String s : convDAYS = new String[]{"23h", "30m", "40s", "10us", "40000ms"}) {
            wconf.set("test.time.warn", s);
            Assert.assertEquals((long)0L, (long)wconf.getTimeDuration("test.time.warn", 1L, TimeUnit.DAYS));
        }
        for (int i = 0; i < convDAYS.length; ++i) {
            String wchk = String.format("Possible loss of precision converting %s to %s for test.time.warn", convDAYS[i], "DAYS");
            Assert.assertEquals((Object)wchk, warnchk.get(i));
        }
        warnchk.clear();
        wconf.setTimeDuration("test.time.warn", 1441L, TimeUnit.MINUTES);
        Assert.assertEquals((long)1L, (long)wconf.getTimeDuration("test.time.warn", 0L, TimeUnit.DAYS));
        Assert.assertEquals((long)24L, (long)wconf.getTimeDuration("test.time.warn", 0L, TimeUnit.HOURS));
        String dchk = String.format("Possible loss of precision converting %s to %s for test.time.warn", "1441m", "DAYS");
        Assert.assertEquals((Object)dchk, warnchk.get(0));
        String hchk = String.format("Possible loss of precision converting %s to %s for test.time.warn", "1441m", "HOURS");
        Assert.assertEquals((Object)hchk, warnchk.get(1));
        Assert.assertEquals((long)1441L, (long)wconf.getTimeDuration("test.time.warn", 0L, TimeUnit.MINUTES));
        Assert.assertEquals((long)2L, (long)warnchk.size());
        Assert.assertEquals((long)86460L, (long)wconf.getTimeDuration("test.time.warn", 0L, TimeUnit.SECONDS));
        Assert.assertEquals((long)2L, (long)warnchk.size());
    }

    @Test
    public void testPattern() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.pattern1", "");
        this.appendProperty("test.pattern2", "(");
        this.appendProperty("test.pattern3", "a+b");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        Pattern defaultPattern = Pattern.compile("x+");
        Assert.assertEquals((Object)defaultPattern.pattern(), (Object)this.conf.getPattern("xxxxx", defaultPattern).pattern());
        Assert.assertNull((Object)this.conf.getPattern("test.pattern1", null));
        Assert.assertEquals((Object)defaultPattern.pattern(), (Object)this.conf.getPattern("test.pattern1", defaultPattern).pattern());
        Assert.assertEquals((Object)defaultPattern.pattern(), (Object)this.conf.getPattern("test.pattern2", defaultPattern).pattern());
        Assert.assertEquals((Object)"a+b", (Object)this.conf.getPattern("test.pattern3", defaultPattern).pattern());
    }

    @Test
    public void testPropertySource() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.foo", "bar");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        this.conf.set("fs.defaultFS", "value");
        String[] sources = this.conf.getPropertySources("test.foo");
        Assert.assertEquals((long)1L, (long)sources.length);
        Assert.assertEquals((String)"Resource string returned for a file-loaded property must be a proper absolute path", (Object)fileResource, (Object)new Path(sources[0]));
        Assert.assertArrayEquals((String)"Resource string returned for a set() property must be \"programmatically\"", (Object[])new String[]{"programmatically"}, (Object[])this.conf.getPropertySources("fs.defaultFS"));
        Assert.assertArrayEquals((String)"Resource string returned for an unset property must be null", null, (Object[])this.conf.getPropertySources("fs.defaultFoo"));
    }

    @Test
    public void testMultiplePropertySource() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.foo", "bar", false, "a", "b", "c");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        String[] sources = this.conf.getPropertySources("test.foo");
        Assert.assertEquals((long)4L, (long)sources.length);
        Assert.assertEquals((Object)"a", (Object)sources[0]);
        Assert.assertEquals((Object)"b", (Object)sources[1]);
        Assert.assertEquals((Object)"c", (Object)sources[2]);
        Assert.assertEquals((String)"Resource string returned for a file-loaded property must be a proper absolute path", (Object)fileResource, (Object)new Path(sources[3]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSocketAddress() {
        Configuration conf = new Configuration();
        String defaultAddr = "host:1";
        int defaultPort = 2;
        InetSocketAddress addr = null;
        addr = conf.getSocketAddr("myAddress", "host:1", 2);
        Assert.assertEquals((Object)"host:1", (Object)NetUtils.getHostPortString((InetSocketAddress)addr));
        conf.set("myAddress", "host2");
        addr = conf.getSocketAddr("myAddress", "host:1", 2);
        Assert.assertEquals((Object)"host2:2", (Object)NetUtils.getHostPortString((InetSocketAddress)addr));
        conf.set("myAddress", "host2:3");
        addr = conf.getSocketAddr("myAddress", "host:1", 2);
        Assert.assertEquals((Object)"host2:3", (Object)NetUtils.getHostPortString((InetSocketAddress)addr));
        conf.set("myAddress", " \n \t    host4:5     \t \n   ");
        addr = conf.getSocketAddr("myAddress", "host:1", 2);
        Assert.assertEquals((Object)"host4:5", (Object)NetUtils.getHostPortString((InetSocketAddress)addr));
        boolean threwException = false;
        conf.set("myAddress", "bad:-port");
        try {
            addr = conf.getSocketAddr("myAddress", "host:1", 2);
        }
        catch (IllegalArgumentException iae) {
            threwException = true;
            Assert.assertEquals((Object)"Does not contain a valid host:port authority: bad:-port (configuration property 'myAddress')", (Object)iae.getMessage());
        }
        finally {
            Assert.assertTrue((boolean)threwException);
        }
    }

    @Test
    public void testSetSocketAddress() {
        Configuration conf = new Configuration();
        NetUtils.addStaticResolution((String)"host", (String)"127.0.0.1");
        String defaultAddr = "host:1";
        InetSocketAddress addr = NetUtils.createSocketAddr((String)"host:1");
        conf.setSocketAddr("myAddress", addr);
        Assert.assertEquals((Object)"host:1", (Object)NetUtils.getHostPortString((InetSocketAddress)addr));
    }

    @Test
    public void testUpdateSocketAddress() throws IOException {
        InetSocketAddress addr = NetUtils.createSocketAddrForHost((String)"host", (int)1);
        InetSocketAddress connectAddr = this.conf.updateConnectAddr("myAddress", addr);
        Assert.assertEquals((Object)connectAddr.getHostName(), (Object)addr.getHostName());
        addr = new InetSocketAddress(1);
        connectAddr = this.conf.updateConnectAddr("myAddress", addr);
        Assert.assertEquals((Object)connectAddr.getHostName(), (Object)InetAddress.getLocalHost().getHostName());
    }

    @Test
    public void testReload() throws IOException {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.key1", "final-value1", true, new String[0]);
        this.appendProperty("test.key2", "value2");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        this.out = new BufferedWriter(new FileWriter(CONFIG2));
        this.startConfig();
        this.appendProperty("test.key1", "value1");
        this.appendProperty("test.key3", "value3");
        this.endConfig();
        Path fileResource1 = new Path(CONFIG2);
        this.conf.addResource(fileResource1);
        this.conf.set("test.key3", "value4");
        this.conf.set("test.key4", "value5");
        Assert.assertEquals((Object)"final-value1", (Object)this.conf.get("test.key1"));
        Assert.assertEquals((Object)"value2", (Object)this.conf.get("test.key2"));
        Assert.assertEquals((Object)"value4", (Object)this.conf.get("test.key3"));
        Assert.assertEquals((Object)"value5", (Object)this.conf.get("test.key4"));
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.key1", "final-value1");
        this.appendProperty("test.key3", "final-value3", true, new String[0]);
        this.endConfig();
        this.conf.reloadConfiguration();
        Assert.assertEquals((Object)"value1", (Object)this.conf.get("test.key1"));
        Assert.assertEquals((Object)"value4", (Object)this.conf.get("test.key3"));
        Assert.assertEquals(null, (Object)this.conf.get("test.key2"));
        Assert.assertEquals((Object)"value5", (Object)this.conf.get("test.key4"));
    }

    @Test
    public void testSize() {
        Configuration conf = new Configuration(false);
        conf.set("a", "A");
        conf.set("b", "B");
        Assert.assertEquals((long)2L, (long)conf.size());
    }

    @Test
    public void testClear() {
        Configuration conf = new Configuration(false);
        conf.set("a", "A");
        conf.set("b", "B");
        conf.clear();
        Assert.assertEquals((long)0L, (long)conf.size());
        Assert.assertFalse((boolean)conf.iterator().hasNext());
    }

    @Test
    public void testClassLoader() {
        Configuration conf = new Configuration(false);
        conf.setQuietMode(false);
        conf.setClassLoader((ClassLoader)new Fake_ClassLoader());
        Configuration other = new Configuration(conf);
        Assert.assertTrue((boolean)(other.getClassLoader() instanceof Fake_ClassLoader));
    }

    private Configuration getActualConf(String xmlStr) {
        Configuration ac = new Configuration(false);
        ByteArrayInputStream in = new ByteArrayInputStream(xmlStr.getBytes());
        ac.addResource((InputStream)in);
        return ac;
    }

    @Test
    public void testGetSetTrimmedNames() throws IOException {
        Configuration conf = new Configuration(false);
        conf.set(" name", "value");
        Assert.assertEquals((Object)"value", (Object)conf.get("name"));
        Assert.assertEquals((Object)"value", (Object)conf.get(" name"));
        Assert.assertEquals((Object)"value", (Object)conf.getRaw("  name  "));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDumpProperty() throws IOException {
        StringWriter outWriter = new StringWriter();
        ObjectMapper mapper = new ObjectMapper();
        String jsonStr = null;
        String xmlStr = null;
        try {
            Configuration testConf = new Configuration(false);
            this.out = new BufferedWriter(new FileWriter(CONFIG));
            this.startConfig();
            this.appendProperty("test.key1", "value1");
            this.appendProperty("test.key2", "value2", true, new String[0]);
            this.appendProperty("test.key3", "value3");
            this.endConfig();
            Path fileResource = new Path(CONFIG);
            testConf.addResource(fileResource);
            this.out.close();
            outWriter = new StringWriter();
            Configuration.dumpConfiguration((Configuration)testConf, (String)"test.key2", (Writer)outWriter);
            jsonStr = outWriter.toString();
            outWriter.close();
            mapper = new ObjectMapper();
            SingleJsonConfiguration jconf1 = (SingleJsonConfiguration)mapper.readValue(jsonStr, SingleJsonConfiguration.class);
            JsonProperty jp1 = jconf1.getProperty();
            Assert.assertEquals((Object)"test.key2", (Object)jp1.getKey());
            Assert.assertEquals((Object)"value2", (Object)jp1.getValue());
            Assert.assertEquals((Object)true, (Object)jp1.isFinal);
            Assert.assertEquals((Object)fileResource.toString(), (Object)jp1.getResource());
            outWriter = new StringWriter();
            testConf.writeXml("test.key2", (Writer)outWriter);
            xmlStr = outWriter.toString();
            outWriter.close();
            Configuration actualConf1 = this.getActualConf(xmlStr);
            Assert.assertEquals((long)1L, (long)actualConf1.size());
            Assert.assertEquals((Object)"value2", (Object)actualConf1.get("test.key2"));
            Assert.assertTrue((boolean)actualConf1.getFinalParameters().contains("test.key2"));
            Assert.assertEquals((Object)fileResource.toString(), (Object)actualConf1.getPropertySources("test.key2")[0]);
            try {
                outWriter = new StringWriter();
                Configuration.dumpConfiguration((Configuration)testConf, (String)"test.unknown.key", (Writer)outWriter);
                outWriter.close();
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
                Assert.assertTrue((e.getMessage().contains("test.unknown.key") && e.getMessage().contains("not found") ? 1 : 0) != 0);
            }
            try {
                outWriter = new StringWriter();
                testConf.writeXml("test.unknown.key", (Writer)outWriter);
                outWriter.close();
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
                Assert.assertTrue((e.getMessage().contains("test.unknown.key") && e.getMessage().contains("not found") ? 1 : 0) != 0);
            }
            outWriter = new StringWriter();
            Configuration.dumpConfiguration((Configuration)testConf, null, (Writer)outWriter);
            jsonStr = outWriter.toString();
            mapper = new ObjectMapper();
            JsonConfiguration jconf3 = (JsonConfiguration)mapper.readValue(jsonStr, JsonConfiguration.class);
            Assert.assertEquals((long)3L, (long)jconf3.getProperties().length);
            outWriter = new StringWriter();
            testConf.writeXml(null, (Writer)outWriter);
            xmlStr = outWriter.toString();
            outWriter.close();
            Configuration actualConf3 = this.getActualConf(xmlStr);
            Assert.assertEquals((long)3L, (long)actualConf3.size());
            Assert.assertTrue((actualConf3.getProps().containsKey("test.key1") && actualConf3.getProps().containsKey("test.key2") && actualConf3.getProps().containsKey("test.key3") ? 1 : 0) != 0);
            outWriter = new StringWriter();
            Configuration.dumpConfiguration((Configuration)testConf, (String)"", (Writer)outWriter);
            jsonStr = outWriter.toString();
            mapper = new ObjectMapper();
            JsonConfiguration jconf4 = (JsonConfiguration)mapper.readValue(jsonStr, JsonConfiguration.class);
            Assert.assertEquals((long)3L, (long)jconf4.getProperties().length);
            outWriter = new StringWriter();
            testConf.writeXml("", (Writer)outWriter);
            xmlStr = outWriter.toString();
            outWriter.close();
            Configuration actualConf4 = this.getActualConf(xmlStr);
            Assert.assertEquals((long)3L, (long)actualConf4.size());
            Assert.assertTrue((actualConf4.getProps().containsKey("test.key1") && actualConf4.getProps().containsKey("test.key2") && actualConf4.getProps().containsKey("test.key3") ? 1 : 0) != 0);
        }
        finally {
            if (outWriter != null) {
                outWriter.close();
            }
            if (this.out != null) {
                this.out.close();
            }
        }
    }

    @Test
    public void testDumpConfiguration() throws IOException {
        StringWriter outWriter = new StringWriter();
        Configuration.dumpConfiguration((Configuration)this.conf, (Writer)outWriter);
        String jsonStr = outWriter.toString();
        ObjectMapper mapper = new ObjectMapper();
        JsonConfiguration jconf = (JsonConfiguration)mapper.readValue(jsonStr, JsonConfiguration.class);
        int defaultLength = jconf.getProperties().length;
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.key1", "value1");
        this.appendProperty("test.key2", "value2", true, new String[0]);
        this.appendProperty("test.key3", "value3");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        this.out.close();
        outWriter = new StringWriter();
        Configuration.dumpConfiguration((Configuration)this.conf, (Writer)outWriter);
        jsonStr = outWriter.toString();
        mapper = new ObjectMapper();
        jconf = (JsonConfiguration)mapper.readValue(jsonStr, JsonConfiguration.class);
        int length = jconf.getProperties().length;
        Assert.assertEquals((long)length, (long)(defaultLength + 3));
        this.out = new BufferedWriter(new FileWriter(CONFIG2));
        this.startConfig();
        this.appendProperty("test.key1", "newValue1");
        this.appendProperty("test.key2", "newValue2");
        this.endConfig();
        Path fileResource1 = new Path(CONFIG2);
        this.conf.addResource(fileResource1);
        this.out.close();
        outWriter = new StringWriter();
        Configuration.dumpConfiguration((Configuration)this.conf, (Writer)outWriter);
        jsonStr = outWriter.toString();
        mapper = new ObjectMapper();
        jconf = (JsonConfiguration)mapper.readValue(jsonStr, JsonConfiguration.class);
        HashMap<String, JsonProperty> confDump = new HashMap<String, JsonProperty>();
        for (JsonProperty prop : jconf.getProperties()) {
            confDump.put(prop.getKey(), prop);
        }
        Assert.assertEquals((Object)"newValue1", (Object)((JsonProperty)confDump.get("test.key1")).getValue());
        Assert.assertEquals((Object)false, (Object)((JsonProperty)confDump.get("test.key1")).getIsFinal());
        Assert.assertEquals((Object)fileResource1.toString(), (Object)((JsonProperty)confDump.get("test.key1")).getResource());
        Assert.assertEquals((Object)"value2", (Object)((JsonProperty)confDump.get("test.key2")).getValue());
        Assert.assertEquals((Object)true, (Object)((JsonProperty)confDump.get("test.key2")).getIsFinal());
        Assert.assertEquals((Object)fileResource.toString(), (Object)((JsonProperty)confDump.get("test.key2")).getResource());
        Assert.assertEquals((Object)"value3", (Object)((JsonProperty)confDump.get("test.key3")).getValue());
        Assert.assertEquals((Object)false, (Object)((JsonProperty)confDump.get("test.key3")).getIsFinal());
        Assert.assertEquals((Object)fileResource.toString(), (Object)((JsonProperty)confDump.get("test.key3")).getResource());
        this.conf.set("test.key4", "value4");
        this.conf.set("test.key5", "value5");
        this.conf.set("test.key6", "${test.key5}");
        outWriter = new StringWriter();
        Configuration.dumpConfiguration((Configuration)this.conf, (Writer)outWriter);
        jsonStr = outWriter.toString();
        mapper = new ObjectMapper();
        jconf = (JsonConfiguration)mapper.readValue(jsonStr, JsonConfiguration.class);
        confDump = new HashMap();
        for (JsonProperty prop : jconf.getProperties()) {
            confDump.put(prop.getKey(), prop);
        }
        Assert.assertEquals((Object)"value5", (Object)((JsonProperty)confDump.get("test.key6")).getValue());
        Assert.assertEquals((Object)"programmatically", (Object)((JsonProperty)confDump.get("test.key4")).getResource());
        outWriter.close();
    }

    @Test
    public void testDumpConfiguratioWithoutDefaults() throws IOException {
        Configuration config = new Configuration(false);
        StringWriter outWriter = new StringWriter();
        Configuration.dumpConfiguration((Configuration)config, (Writer)outWriter);
        String jsonStr = outWriter.toString();
        ObjectMapper mapper = new ObjectMapper();
        JsonConfiguration jconf = (JsonConfiguration)mapper.readValue(jsonStr, JsonConfiguration.class);
        Assert.assertEquals((long)0L, (long)jconf.getProperties().length);
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.key1", "value1");
        this.appendProperty("test.key2", "value2", true, new String[0]);
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        config.addResource(fileResource);
        this.out.close();
        outWriter = new StringWriter();
        Configuration.dumpConfiguration((Configuration)config, (Writer)outWriter);
        jsonStr = outWriter.toString();
        mapper = new ObjectMapper();
        jconf = (JsonConfiguration)mapper.readValue(jsonStr, JsonConfiguration.class);
        HashMap<String, JsonProperty> confDump = new HashMap<String, JsonProperty>();
        for (JsonProperty prop : jconf.getProperties()) {
            confDump.put(prop.getKey(), prop);
        }
        Assert.assertEquals((long)2L, (long)jconf.getProperties().length);
        Assert.assertEquals((Object)((JsonProperty)confDump.get("test.key1")).getValue(), (Object)"value1");
        Assert.assertEquals((Object)((JsonProperty)confDump.get("test.key2")).getValue(), (Object)"value2");
        Assert.assertEquals((Object)false, (Object)((JsonProperty)confDump.get("test.key1")).getIsFinal());
        Assert.assertEquals((Object)true, (Object)((JsonProperty)confDump.get("test.key2")).getIsFinal());
        for (JsonProperty prop : jconf.getProperties()) {
            Assert.assertEquals((Object)fileResource.toString(), (Object)prop.getResource());
        }
    }

    @Test
    public void testDumpSensitiveProperty() throws IOException {
        String myPassword = "ThisIsMyPassword";
        Configuration testConf = new Configuration(false);
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.password", "ThisIsMyPassword");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        testConf.addResource(fileResource);
        try (StringWriter outWriter = new StringWriter();){
            testConf.set(SENSITIVE_CONFIG_KEYS, "password$");
            Configuration.dumpConfiguration((Configuration)testConf, (String)"test.password", (Writer)outWriter);
            Assert.assertFalse((boolean)outWriter.toString().contains("ThisIsMyPassword"));
        }
    }

    @Test
    public void testDumpSensitiveConfiguration() throws IOException {
        String myPassword = "ThisIsMyPassword";
        Configuration testConf = new Configuration(false);
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("test.password", "ThisIsMyPassword");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        testConf.addResource(fileResource);
        try (StringWriter outWriter = new StringWriter();){
            testConf.set(SENSITIVE_CONFIG_KEYS, "password$");
            Configuration.dumpConfiguration((Configuration)testConf, (Writer)outWriter);
            Assert.assertFalse((boolean)outWriter.toString().contains("ThisIsMyPassword"));
        }
    }

    @Test
    public void testGetValByRegex() {
        Configuration conf = new Configuration();
        String key1 = "t.abc.key1";
        String key2 = "t.abc.key2";
        String key3 = "tt.abc.key3";
        String key4 = "t.abc.ey3";
        conf.set(key1, "value1");
        conf.set(key2, "value2");
        conf.set(key3, "value3");
        conf.set(key4, "value3");
        Map res = conf.getValByRegex("^t\\..*\\.key\\d");
        Assert.assertTrue((String)("Conf didn't get key " + key1), (boolean)res.containsKey(key1));
        Assert.assertTrue((String)("Conf didn't get key " + key2), (boolean)res.containsKey(key2));
        Assert.assertTrue((String)("Picked out wrong key " + key3), (!res.containsKey(key3) ? 1 : 0) != 0);
        Assert.assertTrue((String)("Picked out wrong key " + key4), (!res.containsKey(key4) ? 1 : 0) != 0);
    }

    @Test
    public void testGetClassesShouldReturnDefaultValue() throws Exception {
        Configuration config = new Configuration();
        Class[] classes = config.getClasses("testClassName", new Class[]{Configuration.class});
        Assert.assertEquals((String)("Not returning expected number of classes. Number of returned classes =" + classes.length), (long)1L, (long)classes.length);
        Assert.assertEquals((String)"Not returning the default class Name", Configuration.class, (Object)classes[0]);
    }

    @Test
    public void testGetClassesShouldReturnEmptyArray() throws Exception {
        Configuration config = new Configuration();
        config.set("testClassName", "");
        Class[] classes = config.getClasses("testClassName", new Class[]{Configuration.class});
        Assert.assertEquals((String)("Not returning expected number of classes. Number of returned classes =" + classes.length), (long)0L, (long)classes.length);
    }

    @Test
    public void testSettingValueNull() throws Exception {
        Configuration config = new Configuration();
        try {
            config.set("testClassName", null);
            Assert.fail((String)"Should throw an IllegalArgumentException exception ");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
            Assert.assertEquals((Object)e.getMessage(), (Object)"The value of property testClassName must not be null");
        }
    }

    @Test
    public void testSettingKeyNull() throws Exception {
        Configuration config = new Configuration();
        try {
            config.set(null, "test");
            Assert.fail((String)"Should throw an IllegalArgumentException exception ");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
            Assert.assertEquals((Object)e.getMessage(), (Object)"Property name must not be null");
        }
    }

    @Test
    public void testInvalidSubstitution() {
        Configuration configuration = new Configuration(false);
        String key = "test.random.key";
        for (String keyExpression : Arrays.asList("${test.random.key}", "foo${test.random.key}", "foo${test.random.key}bar", "${test.random.key}bar")) {
            configuration.set("test.random.key", keyExpression);
            Assert.assertEquals((String)"Unexpected value", (Object)keyExpression, (Object)configuration.get("test.random.key"));
        }
    }

    @Test
    public void testIncompleteSubbing() {
        Configuration configuration = new Configuration(false);
        String key = "test.random.key";
        for (String keyExpression : Arrays.asList("{}", "${}", "{" + key, "${" + key, "foo${" + key, "foo${" + key + "bar", "foo{" + key + "}bar", "${" + key + "bar")) {
            configuration.set(key, keyExpression);
            String value = configuration.get(key);
            Assert.assertTrue((String)("Unexpected value " + value), (boolean)value.equals(keyExpression));
        }
    }

    @Test
    public void testBoolean() {
        boolean value = true;
        Configuration configuration = new Configuration();
        configuration.setBoolean("value", value);
        Assert.assertEquals((Object)value, (Object)configuration.getBoolean("value", false));
    }

    @Test
    public void testBooleanIfUnset() {
        boolean value = true;
        Configuration configuration = new Configuration();
        configuration.setBooleanIfUnset("value", value);
        Assert.assertEquals((Object)value, (Object)configuration.getBoolean("value", false));
        configuration.setBooleanIfUnset("value", false);
        Assert.assertEquals((Object)value, (Object)configuration.getBoolean("value", false));
    }

    @Test
    public void testFloat() {
        float value = 1.0f;
        Configuration configuration = new Configuration();
        configuration.setFloat("value", value);
        Assert.assertEquals((double)value, (double)configuration.getFloat("value", 0.0f), (double)1.0E-9f);
    }

    @Test
    public void testDouble() {
        double value = 1.0;
        Configuration configuration = new Configuration();
        configuration.setDouble("value", value);
        Assert.assertEquals((double)value, (double)configuration.getDouble("value", 0.0), (double)1.0E-9f);
    }

    @Test
    public void testInt() {
        int value = 1;
        Configuration configuration = new Configuration();
        configuration.setInt("value", value);
        Assert.assertEquals((long)value, (long)configuration.getInt("value", 0));
    }

    @Test
    public void testLong() {
        long value = 1L;
        Configuration configuration = new Configuration();
        configuration.setLong("value", value);
        Assert.assertEquals((long)value, (long)configuration.getLong("value", 0L));
    }

    @Test
    public void testStrings() {
        String[] strings = new String[]{"FOO", "BAR"};
        Configuration configuration = new Configuration();
        configuration.setStrings("strings", strings);
        String[] returnStrings = configuration.getStrings("strings");
        for (int i = 0; i < returnStrings.length; ++i) {
            Assert.assertEquals((Object)strings[i], (Object)returnStrings[i]);
        }
    }

    @Test
    public void testSetPattern() {
        Pattern testPattern = Pattern.compile("a+b");
        Configuration configuration = new Configuration();
        configuration.setPattern("testPattern", testPattern);
        Assert.assertEquals((Object)testPattern.pattern(), (Object)configuration.getPattern("testPattern", Pattern.compile("")).pattern());
    }

    @Test
    public void testGetClassByNameOrNull() throws Exception {
        Configuration config = new Configuration();
        Class clazz = config.getClassByNameOrNull("java.lang.Object");
        Assert.assertNotNull((Object)clazz);
    }

    @Test
    public void testGetFinalParameters() throws Exception {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.declareProperty("my.var", "x", "x", true);
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        Configuration conf = new Configuration();
        Set finalParameters = conf.getFinalParameters();
        Assert.assertFalse((String)"my.var already exists", (boolean)finalParameters.contains("my.var"));
        conf.addResource(fileResource);
        Assert.assertEquals((String)"my.var is undefined", (Object)"x", (Object)conf.get("my.var"));
        Assert.assertFalse((String)"finalparams not copied", (boolean)finalParameters.contains("my.var"));
        finalParameters = conf.getFinalParameters();
        Assert.assertTrue((String)"my.var is not final", (boolean)finalParameters.contains("my.var"));
    }

    @Test
    public void testConcurrentAccesses() throws Exception {
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.declareProperty("some.config", "xyz", "xyz", false);
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        Configuration conf = new Configuration();
        conf.addResource(fileResource);
        class ConfigModifyThread
        extends Thread {
            private final Configuration config;
            private final String prefix;

            public ConfigModifyThread(Configuration conf, String prefix) {
                this.config = conf;
                this.prefix = prefix;
            }

            @Override
            public void run() {
                for (int i = 0; i < 10000; ++i) {
                    this.config.set("some.config.value-" + this.prefix + i, "value");
                }
            }
        }
        ArrayList<ConfigModifyThread> threads = new ArrayList<ConfigModifyThread>();
        for (int i = 0; i < 100; ++i) {
            threads.add(new ConfigModifyThread(conf, String.valueOf(i)));
        }
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
    }

    @Test
    public void testNullValueProperties() throws Exception {
        Configuration conf = new Configuration();
        conf.setAllowNullValueProperties(true);
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("attr", "value", true, new String[0]);
        this.appendProperty("attr", "", true, new String[0]);
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        conf.addResource(fileResource);
        Assert.assertEquals((Object)"value", (Object)conf.get("attr"));
    }

    @Test
    public void testGetPasswordDeprecatedKeyStored() throws Exception {
        String oldKey = "test.password.old.key";
        String newKey = "test.password.new.key";
        String password = "MyPasswordForDeprecatedKey";
        File tmpDir = GenericTestUtils.getRandomizedTestDir();
        tmpDir.mkdirs();
        String ourUrl = new URI("localjceks", "file", new File(tmpDir, "test.jks").toURI().getPath(), null).toString();
        this.conf = new Configuration(false);
        this.conf.set("hadoop.security.credential.provider.path", ourUrl);
        CredentialProvider provider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)this.conf).get(0);
        provider.createCredentialEntry("test.password.old.key", "MyPasswordForDeprecatedKey".toCharArray());
        provider.flush();
        Configuration.addDeprecation((String)"test.password.old.key", (String)"test.password.new.key");
        Assert.assertThat((Object)this.conf.getPassword("test.password.new.key"), (Matcher)CoreMatchers.is((Object)"MyPasswordForDeprecatedKey".toCharArray()));
        Assert.assertThat((Object)this.conf.getPassword("test.password.old.key"), (Matcher)CoreMatchers.is((Object)"MyPasswordForDeprecatedKey".toCharArray()));
        FileUtil.fullyDelete((File)tmpDir);
    }

    @Test
    public void testGetPasswordByDeprecatedKey() throws Exception {
        String oldKey = "test.password.old.key";
        String newKey = "test.password.new.key";
        String password = "MyPasswordForDeprecatedKey";
        File tmpDir = GenericTestUtils.getRandomizedTestDir();
        tmpDir.mkdirs();
        String ourUrl = new URI("localjceks", "file", new File(tmpDir, "test.jks").toURI().getPath(), null).toString();
        this.conf = new Configuration(false);
        this.conf.set("hadoop.security.credential.provider.path", ourUrl);
        CredentialProvider provider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)this.conf).get(0);
        provider.createCredentialEntry("test.password.new.key", "MyPasswordForDeprecatedKey".toCharArray());
        provider.flush();
        Configuration.addDeprecation((String)"test.password.old.key", (String)"test.password.new.key");
        Assert.assertThat((Object)this.conf.getPassword("test.password.new.key"), (Matcher)CoreMatchers.is((Object)"MyPasswordForDeprecatedKey".toCharArray()));
        Assert.assertThat((Object)this.conf.getPassword("test.password.old.key"), (Matcher)CoreMatchers.is((Object)"MyPasswordForDeprecatedKey".toCharArray()));
        FileUtil.fullyDelete((File)tmpDir);
    }

    public void testGettingPropertiesWithPrefix() throws Exception {
        Configuration conf = new Configuration();
        for (int i = 0; i < 10; ++i) {
            conf.set("prefix.name" + i, "value");
        }
        conf.set("different.prefix.name", "value");
        Map props = conf.getPropsWithPrefix("prefix");
        Assert.assertEquals((long)props.size(), (long)10L);
        props = conf.getPropsWithPrefix("none");
        Assert.assertNotNull((Object)props.isEmpty());
        Assert.assertTrue((boolean)props.isEmpty());
    }

    public static void main(String[] argv) throws Exception {
        TestRunner.main((String[])new String[]{TestConfiguration.class.getName()});
    }

    @Test
    public void testGetAllPropertiesByTags() throws Exception {
        try {
            this.out = new BufferedWriter(new FileWriter(CONFIG_CORE));
            this.startConfig();
            this.appendProperty("hadoop.system.tags", "YARN,HDFS,NAMENODE");
            this.appendProperty("hadoop.custom.tags", "MYCUSTOMTAG");
            this.appendPropertyByTag("dfs.cblock.trace.io", "false", "YARN", new String[0]);
            this.appendPropertyByTag("dfs.replication", "1", "HDFS", new String[0]);
            this.appendPropertyByTag("dfs.namenode.logging.level", "INFO", "NAMENODE", new String[0]);
            this.appendPropertyByTag("dfs.random.key", "XYZ", "MYCUSTOMTAG", new String[0]);
            this.endConfig();
            Path fileResource = new Path(CONFIG_CORE);
            this.conf.addResource(fileResource);
            this.conf.getProps();
        }
        finally {
            this.out.close();
        }
        System.out.println(Files.readAllLines(Paths.get(CONFIG_CORE, new String[0])));
        ArrayList<String> tagList = new ArrayList<String>();
        tagList.add("YARN");
        tagList.add("HDFS");
        tagList.add("NAMENODE");
        Properties properties = this.conf.getAllPropertiesByTags(tagList);
        Object[] sources = this.conf.getPropertySources("dfs.replication");
        Assert.assertTrue((sources.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.toString(sources).contains("core-site.xml"));
        TestConfiguration.assertEq(3, properties.size());
        TestConfiguration.assertEq(true, properties.containsKey("dfs.namenode.logging.level"));
        TestConfiguration.assertEq(true, properties.containsKey("dfs.replication"));
        TestConfiguration.assertEq(true, properties.containsKey("dfs.cblock.trace.io"));
        TestConfiguration.assertEq(false, properties.containsKey("namenode.host"));
        properties = this.conf.getAllPropertiesByTag("DEBUG");
        TestConfiguration.assertEq(0, properties.size());
        TestConfiguration.assertEq(false, properties.containsKey("dfs.namenode.logging.level"));
        TestConfiguration.assertEq(true, this.conf.isPropertyTag("YARN"));
        TestConfiguration.assertEq(true, this.conf.isPropertyTag("HDFS"));
        TestConfiguration.assertEq(true, this.conf.isPropertyTag("NAMENODE"));
        TestConfiguration.assertEq(true, this.conf.isPropertyTag("MYCUSTOMTAG"));
        TestConfiguration.assertEq(false, this.conf.isPropertyTag("CMYCUSTOMTAG2"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidTags() throws Exception {
        PrintStream output = System.out;
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            System.setOut(new PrintStream(bytes));
            this.out = new BufferedWriter(new FileWriter(CONFIG));
            this.startConfig();
            this.appendPropertyByTag("dfs.cblock.trace.io", "false", "MYOWNTAG,TAG2", new String[0]);
            this.endConfig();
            Path fileResource = new Path(CONFIG);
            this.conf.addResource(fileResource);
            this.conf.getProps();
            ArrayList<String> tagList = new ArrayList<String>();
            tagList.add("REQUIRED");
            tagList.add("MYOWNTAG");
            tagList.add("TAG2");
            Properties properties = this.conf.getAllPropertiesByTags(tagList);
            TestConfiguration.assertEq(0, properties.size());
            Assert.assertFalse((boolean)properties.containsKey("dfs.cblock.trace.io"));
            Assert.assertFalse((boolean)bytes.toString().contains("Invalid tag "));
            Assert.assertFalse((boolean)bytes.toString().contains("Tag"));
        }
        finally {
            System.setOut(output);
        }
    }

    static class JsonProperty {
        String key;
        String value;
        boolean isFinal;
        String resource;

        JsonProperty() {
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean getIsFinal() {
            return this.isFinal;
        }

        public void setIsFinal(boolean isFinal) {
            this.isFinal = isFinal;
        }

        public String getResource() {
            return this.resource;
        }

        public void setResource(String resource) {
            this.resource = resource;
        }
    }

    static class SingleJsonConfiguration {
        private JsonProperty property;

        SingleJsonConfiguration() {
        }

        public JsonProperty getProperty() {
            return this.property;
        }

        public void setProperty(JsonProperty property) {
            this.property = property;
        }
    }

    static class JsonConfiguration {
        JsonProperty[] properties;

        JsonConfiguration() {
        }

        public JsonProperty[] getProperties() {
            return this.properties;
        }

        public void setProperties(JsonProperty[] properties) {
            this.properties = properties;
        }
    }

    public static class Fake_ClassLoader
    extends ClassLoader {
    }

    static enum Yak {
        RAB,
        FOO;

    }

    static enum Dingo {
        FOO,
        BAR;

    }

    static class Prop {
        String name;
        String val;
        String expectEval;

        Prop() {
        }
    }

    private static class TestAppender
    extends AppenderSkeleton {
        private final List<LoggingEvent> log = new ArrayList<LoggingEvent>();

        private TestAppender() {
        }

        public boolean requiresLayout() {
            return false;
        }

        protected void append(LoggingEvent loggingEvent) {
            this.log.add(loggingEvent);
        }

        public void close() {
        }

        public List<LoggingEvent> getLog() {
            return new ArrayList<LoggingEvent>(this.log);
        }
    }
}

