/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.rawcoder;

import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import org.apache.hadoop.io.erasurecode.rawcoder.ByteArrayEncodingState;
import org.apache.hadoop.io.erasurecode.rawcoder.ByteBufferEncodingState;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureEncoder;
import org.apache.hadoop.util.PerformanceAdvisory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
abstract class AbstractNativeRawEncoder
extends RawErasureEncoder {
    public static Logger LOG = LoggerFactory.getLogger(AbstractNativeRawEncoder.class);
    private long nativeCoder;

    public AbstractNativeRawEncoder(ErasureCoderOptions coderOptions) {
        super(coderOptions);
    }

    @Override
    protected void doEncode(ByteBufferEncodingState encodingState) {
        ByteBuffer buffer;
        int i;
        int[] inputOffsets = new int[encodingState.inputs.length];
        int[] outputOffsets = new int[encodingState.outputs.length];
        int dataLen = encodingState.inputs[0].remaining();
        for (i = 0; i < encodingState.inputs.length; ++i) {
            buffer = encodingState.inputs[i];
            inputOffsets[i] = buffer.position();
        }
        for (i = 0; i < encodingState.outputs.length; ++i) {
            buffer = encodingState.outputs[i];
            outputOffsets[i] = buffer.position();
        }
        this.performEncodeImpl(encodingState.inputs, inputOffsets, dataLen, encodingState.outputs, outputOffsets);
    }

    protected abstract void performEncodeImpl(ByteBuffer[] var1, int[] var2, int var3, ByteBuffer[] var4, int[] var5);

    @Override
    protected void doEncode(ByteArrayEncodingState encodingState) {
        PerformanceAdvisory.LOG.debug("convertToByteBufferState is invoked, not efficiently. Please use direct ByteBuffer inputs/outputs");
        ByteBufferEncodingState bbeState = encodingState.convertToByteBufferState();
        this.doEncode(bbeState);
        for (int i = 0; i < encodingState.outputs.length; ++i) {
            bbeState.outputs[i].get(encodingState.outputs[i], encodingState.outputOffsets[i], encodingState.encodeLength);
        }
    }

    @Override
    public boolean preferDirectBuffer() {
        return true;
    }
}

