/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import org.apache.hadoop.security.LdapGroupsMapping;
import org.junit.Before;
import org.mockito.Mockito;

public class TestLdapGroupsMappingBase {
    protected DirContext mockContext;
    protected LdapGroupsMapping mappingSpy = (LdapGroupsMapping)Mockito.spy((Object)new LdapGroupsMapping());
    protected NamingEnumeration mockUserNamingEnum = (NamingEnumeration)Mockito.mock(NamingEnumeration.class);
    protected NamingEnumeration mockGroupNamingEnum = (NamingEnumeration)Mockito.mock(NamingEnumeration.class);
    protected String[] testGroups = new String[]{"group1", "group2"};

    @Before
    public void setupMocksBase() throws NamingException {
        this.mockContext = (DirContext)Mockito.mock(DirContext.class);
        ((LdapGroupsMapping)Mockito.doReturn((Object)this.mockContext).when((Object)this.mappingSpy)).getDirContext();
        Mockito.when((Object)this.mockUserNamingEnum.hasMoreElements()).thenReturn((Object)true);
        SearchResult mockGroupResult = (SearchResult)Mockito.mock(SearchResult.class);
        Mockito.when((Object)this.mockGroupNamingEnum.hasMoreElements()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when(this.mockGroupNamingEnum.nextElement()).thenReturn((Object)mockGroupResult);
        BasicAttribute group1Attr = new BasicAttribute("cn");
        group1Attr.add(this.testGroups[0]);
        BasicAttributes group1Attrs = new BasicAttributes();
        group1Attrs.put(group1Attr);
        BasicAttribute group2Attr = new BasicAttribute("cn");
        group2Attr.add(this.testGroups[1]);
        BasicAttributes group2Attrs = new BasicAttributes();
        group2Attrs.put(group2Attr);
        Mockito.when((Object)mockGroupResult.getAttributes()).thenReturn((Object)group1Attrs, (Object[])new Attributes[]{group2Attrs});
    }
}

